/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.sax.SAXSource;

import org.dgpe.codice.common.caclib.DocumentReferenceType;
import org.dgpe.codice.maindoc.callfortenders.CallForTendersType;
import org.dgpe.codice.maindoc.contractawardnotice.ContractAwardNoticeType;
import org.dgpe.codice.maindoc.contractmodificationnotice.ContractModificationNoticeType;
import org.dgpe.codice.maindoc.contractnotice.ContractNoticeType;
import org.dgpe.codice.maindoc.pin.PriorInformationNoticeType;
import org.w3c.dom.Document;

import ext.place.codice.maindoc.cancelgeneraldocumentrequest.CancelGeneralContractDocumentRequestType;
import ext.place.codice.maindoc.cancelnoticerequest.CancelNoticeRequestType;

 

public class CODICESerializing {

	public static org.dgpe.codice.common.cbclib.ObjectFactory cbcFactory = null;
	// Se declaran los Marshallers y UnMarshallers de cada tipo de documento
	private static Marshaller cnMarshaller = null;
	private static Unmarshaller cnUnmarshaller = null;

	private static Marshaller canMarshaller = null;
	private static Unmarshaller canUnmarshaller = null;

	private static Marshaller pinMarshaller = null;
	private static Unmarshaller pinUnmarshaller = null;

	private static Marshaller cftMarshaller = null;
	private static Unmarshaller cftUnmarshaller = null;
	
	private static Marshaller cancelNoticeReqMarshaller = null;
	private static Unmarshaller cancelNoticeReqUnmarshaller = null;

	private static Marshaller cancelDocumentReqMarshaller = null;
	private static Unmarshaller cancelDocumentReqUnmarshaller = null;
	
	private static Marshaller cacMarshaller = null;
	private static Unmarshaller cacUnmarshaller = null;
	
	private static Marshaller cacPlaceExtMarshaller = null;
	private static Unmarshaller cacPlaceExtUnmarshaller = null;
	
	
	private static Marshaller contractModificationMarshaller = null;
	private static Unmarshaller contractModificatioUnmarshaller = null;

	// Se declaran los ObjectFactory para la creacin de tipos CODICE
	private static org.dgpe.codice.maindoc.contractnotice.ObjectFactory cnFactory = null;

	private static org.dgpe.codice.maindoc.contractawardnotice.ObjectFactory canFactory = null;

	private static org.dgpe.codice.maindoc.pin.ObjectFactory pinFactory = null;

	private static org.dgpe.codice.maindoc.callfortenders.ObjectFactory cftFactory = null;
	
	private static ext.place.codice.maindoc.cancelnoticerequest.ObjectFactory cancelNoticeFactory = null;
	
	
	private static ext.place.codice.maindoc.cancelgeneraldocumentrequest.ObjectFactory cancelDocumentFactory = null;
	
	private static org.dgpe.codice.maindoc.contractmodificationnotice.ObjectFactory contractModificationNoticeFactory = null;
	
	
    private static org.dgpe.codice.common.caclib.ObjectFactory cacFactory = null;
	
	private static ext.place.codice.common.caclib.ObjectFactory cacPlaceExtFactory = null;
	
	private static ext.place.codice.common.cbclib.ObjectFactory cbcPlaceExtFactory = null;


	
	// CODICESerializing es un SINGLETON
	private static CODICESerializing cs = new CODICESerializing();

	// Para la serializacin a Document
	private static DocumentBuilder db = null;
	


	static {

		try {
			
			cbcFactory = new org.dgpe.codice.common.cbclib.ObjectFactory();
			JAXBContext cbcContext = JAXBContext.newInstance("org.dgpe.codice.common.cbclib");
			
			// Se inicializan los Factory, Marshallers y UnMarshallers
			cnFactory = new org.dgpe.codice.maindoc.contractnotice.ObjectFactory();
			JAXBContext cnContext = JAXBContext.newInstance("org.dgpe.codice.maindoc.contractnotice");
			
			
			canFactory = new org.dgpe.codice.maindoc.contractawardnotice.ObjectFactory();
			JAXBContext canContext = JAXBContext.newInstance("org.dgpe.codice.maindoc.contractawardnotice");
			
			pinFactory = new org.dgpe.codice.maindoc.pin.ObjectFactory();
			JAXBContext pinContext = JAXBContext.newInstance("org.dgpe.codice.maindoc.pin");
			
			cftFactory = new org.dgpe.codice.maindoc.callfortenders.ObjectFactory();
			JAXBContext cftContext = JAXBContext.newInstance("org.dgpe.codice.maindoc.callfortenders");
			
			cacFactory = new org.dgpe.codice.common.caclib.ObjectFactory();
			JAXBContext cacContext = JAXBContext.newInstance("org.dgpe.codice.common.caclib");
			
			cancelNoticeFactory = new ext.place.codice.maindoc.cancelnoticerequest.ObjectFactory();
			JAXBContext cancelNoticeContext = JAXBContext.newInstance("ext.place.codice.maindoc.cancelnoticerequest");
			
			cancelDocumentFactory = new ext.place.codice.maindoc.cancelgeneraldocumentrequest.ObjectFactory();
			JAXBContext cancelDocumentContext = JAXBContext.newInstance("ext.place.codice.maindoc.cancelgeneraldocumentrequest");
			
			contractModificationNoticeFactory = new org.dgpe.codice.maindoc.contractmodificationnotice.ObjectFactory();
			JAXBContext contractModificationContext = JAXBContext.newInstance("org.dgpe.codice.maindoc.contractmodificationnotice");
			
			cacPlaceExtFactory = new ext.place.codice.common.caclib.ObjectFactory();
			JAXBContext cacPlaceExtContext = JAXBContext.newInstance("ext.place.codice.common.caclib");
			
			cbcPlaceExtFactory = new ext.place.codice.common.cbclib.ObjectFactory();
			JAXBContext cbcPlaceExtContext = JAXBContext.newInstance("ext.place.codice.common.cbclib");
			
			
			
			
			cnMarshaller = cnContext.createMarshaller();
			cnUnmarshaller = cnContext.createUnmarshaller();
			cnMarshaller.setProperty(cnMarshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
			
			canMarshaller = canContext.createMarshaller();
			canUnmarshaller = canContext.createUnmarshaller();
			canMarshaller.setProperty(canMarshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
			
			pinMarshaller = pinContext.createMarshaller();
			pinUnmarshaller = pinContext.createUnmarshaller();
			pinMarshaller.setProperty(pinMarshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
			
			cftMarshaller = cftContext.createMarshaller();
			cftUnmarshaller = cftContext.createUnmarshaller();
			cftMarshaller.setProperty(cftMarshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
			

			cacMarshaller = cacContext.createMarshaller();
			cacUnmarshaller = cacContext.createUnmarshaller();
			cacMarshaller.setProperty(cacMarshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
			
			cancelNoticeReqMarshaller = cancelNoticeContext.createMarshaller();
			cancelNoticeReqUnmarshaller = cancelNoticeContext.createUnmarshaller();
			cancelNoticeReqMarshaller.setProperty(cancelNoticeReqMarshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
			
			cancelDocumentReqMarshaller = cancelDocumentContext.createMarshaller();
			cancelDocumentReqUnmarshaller = cancelDocumentContext.createUnmarshaller();
			cancelDocumentReqMarshaller.setProperty(cancelDocumentReqMarshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);		

			cacPlaceExtMarshaller = cacPlaceExtContext.createMarshaller();
			cacPlaceExtUnmarshaller = cacPlaceExtContext.createUnmarshaller();
			cacPlaceExtMarshaller.setProperty(cacPlaceExtMarshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
			
			
			contractModificationMarshaller = contractModificationContext.createMarshaller();
			contractModificatioUnmarshaller = contractModificationContext.createUnmarshaller();
			contractModificationMarshaller.setProperty(contractModificationMarshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
			
		} catch (JAXBException e) {
			e.printStackTrace();
		}
		
		try {
			DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
			db = dbFactory.newDocumentBuilder();
		} catch (Exception ex) {
		}

		
	}

	public static CODICESerializing getInstance() {
		return cs;
	}

	/**
	 * Serializa el Anuncio Previo
	 * 
	 * @param pinnotice
	 *            Tipo CODICE
	 * @return OutputStream de tipo ByteArrayOutpurStream
	 */

	public OutputStream serializePriorInformationNotice(PriorInformationNoticeType pinnotice) throws Exception {
		ByteArrayOutputStream res = new ByteArrayOutputStream();

		try {
			 pinMarshaller.marshal( new JAXBElement(
					new QName("urn:dgpe:names:draft:codice:schema:xsd:PriorInformationNotice-2", "PriorInformationNotice")
					,PriorInformationNoticeType.class,pinnotice),res);
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}
	
	/**
	 * Serializa el Anuncio de Licitacion
	 * 
	 * @param contractnotice
	 *            Tipo CODICE
	 * @return OutputStream de tipo ByteArrayOutpurStream
	 */

	public OutputStream serializeContractNotice(ContractNoticeType contractnotice) throws Exception {
		ByteArrayOutputStream res = new ByteArrayOutputStream();

		try {
			cnMarshaller.marshal( new JAXBElement(
					new QName("urn:dgpe:names:draft:codice:schema:xsd:ContractNotice-2", "ContractNotice")
					,ContractNoticeType.class,contractnotice),res);
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}

	
	
	
	/**
	 * Serializa el Anuncio de Adjudicacion(Provisional, Definitiva y Adjudicacin)
	 * 
	 * @param contractawardnotice
	 *            Tipo CODICE
	 * @return OutputStream de tipo ByteArrayOutpurStream
	 */

	public OutputStream serializeContractAwardNotice(ContractAwardNoticeType contractawardnotice) throws Exception {
		ByteArrayOutputStream res = new ByteArrayOutputStream();
		try {
			 
			canMarshaller.marshal( new JAXBElement(
						new QName("urn:dgpe:names:draft:codice:schema:xsd:ContractAwardNotice-2", "ContractAwardNotice")
						,ContractAwardNoticeType.class,contractawardnotice),res);
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}
	
	
	public OutputStream serializeContractModificactionNotice(ContractModificationNoticeType contractModificaction) throws Exception {
		ByteArrayOutputStream res = new ByteArrayOutputStream();
		try {
			 
			contractModificationMarshaller.marshal( new JAXBElement(
					new QName("urn:dgpe:names:draft:codice:schema:xsd:ContractModificationNotice-2", "ContractModificationNotice")
						,ContractAwardNoticeType.class,contractModificaction),res);
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}


	
	
	

	/**
	 * Serializa el Documento de Pliegos
	 * 
	 * @param callForTenders
	 *            Tipo CODICE
	 * @return OutputStream de tipo ByteArrayOutpurStream
	 */

	public OutputStream serializeCallForTender(CallForTendersType callForTenders) throws Exception {
		ByteArrayOutputStream res = new ByteArrayOutputStream();

		try {
			 cftMarshaller.marshal( new JAXBElement(
					new QName("urn:dgpe:names:draft:codice:schema:xsd:CallforTenders-2", "CallForTenders")
					,CallForTendersType.class,callForTenders),res);
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}


	
    public OutputStream serialize_DocumentReferenceType(DocumentReferenceType dr) throws Exception {
		ByteArrayOutputStream res = new ByteArrayOutputStream();
 

		try {
		 
			cacMarshaller.marshal( new JAXBElement(
                    new QName("urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2", "DocumentReference")
                    ,DocumentReferenceType.class,dr),res);
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}
	
	/**
	 * Serializa la Anulacion de Anuncio
	 * 
	 * @param cancelNoticeRequest
	 *            Tipo CODICE
	 * @return OutputStream de tipo ByteArrayOutpurStream
	 */

	public OutputStream serializeCancelNoticeRequest(CancelNoticeRequestType cancelNoticeRequest) throws Exception {
		ByteArrayOutputStream res = new ByteArrayOutputStream();

		try {
			 cancelNoticeReqMarshaller.marshal( new JAXBElement(
					new QName("urn:codice-place-ext:names:draft:ubl:schema:xsd:CancelNoticeRequest", "CancelNoticeRequest")
					,CancelNoticeRequestType.class,cancelNoticeRequest),res);
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}
	
	
	/**
	 * Serializa la Anulacion de Documento General
	 * 
	 * @param cancelGeneralDocumentRequest
	 *            Tipo CODICE
	 * @return OutputStream de tipo ByteArrayOutpurStream
	 */
	public OutputStream serializeCancelGeneralDocumentRequest(CancelGeneralContractDocumentRequestType cancelGeneralDocumentRequest) throws Exception {
		ByteArrayOutputStream res = new ByteArrayOutputStream();

		try {
			 cancelDocumentReqMarshaller.marshal( new JAXBElement(
					new QName("urn:codice-place-ext:names:draft:ubl:schema:xsd:CancelGeneralDocumentRequest", "CancelGeneralContractDocumentRequest")
					,CancelGeneralContractDocumentRequestType.class,cancelGeneralDocumentRequest),res);
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}
	
	
	
	
	
	/**
	 * 
	 * @param docXML
	 * @return
	 * @throws Exception
	 */
	public ContractNoticeType deserializeContractNotice(InputStream docXML) throws Exception {

		ContractNoticeType res = null;

		try {
			res = (ContractNoticeType) ((JAXBElement)cnUnmarshaller.unmarshal(docXML)).getValue();
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}

	/**
	 * 
	 * @param docXML
	 * @return
	 * @throws Exception
	 */
	public ContractNoticeType deserializeContractNotice(SAXSource docXML) throws Exception {

		ContractNoticeType res = null;

		try {
			res = (ContractNoticeType) ((JAXBElement)cnUnmarshaller.unmarshal(docXML)).getValue();
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}

	/**
	 * 
	 * @param docXML
	 * @return
	 * @throws Exception
	 */
	public ContractAwardNoticeType deserializeContractAwardNotice(InputStream docXML) throws Exception {

		ContractAwardNoticeType res = null;

		try {
			res = (ContractAwardNoticeType) ((JAXBElement)canUnmarshaller.unmarshal(docXML)).getValue();
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}

	/**
	 * 
	 * @param docXML
	 * @return
	 * @throws Exception
	 */
	public ContractAwardNoticeType deserializeContractAwardNotice(SAXSource docXML) throws Exception {

		ContractAwardNoticeType res = null;

		try {
			res = (ContractAwardNoticeType) ((JAXBElement)canUnmarshaller.unmarshal(docXML)).getValue();
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}
	
	
	/**
	 * 
	 * @param docXML
	 * @return
	 * @throws Exception
	 */
	public ContractModificationNoticeType deserializeContractModificactionNotice(InputStream docXML) throws Exception {

		ContractModificationNoticeType mod = null;

		try {
			mod = (ContractModificationNoticeType) ((JAXBElement)contractModificatioUnmarshaller.unmarshal(docXML)).getValue();
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return mod;
	}

	/**
	 * 
	 * @param docXML
	 * @return
	 * @throws Exception
	 */
	public ContractModificationNoticeType deserializeContractModificactionNotice(SAXSource docXML) throws Exception {

		ContractModificationNoticeType mod = null;

		try {
			mod = (ContractModificationNoticeType) ((JAXBElement)contractModificatioUnmarshaller.unmarshal(docXML)).getValue();
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return mod;
	}
	

	/**
	 * 
	 * @param docXML
	 * @return
	 * @throws Exception
	 */
	public PriorInformationNoticeType deserializePriorInformationNotice(InputStream docXML) throws Exception {

		PriorInformationNoticeType res = null;

		try {		
			res = (PriorInformationNoticeType) ((JAXBElement)pinUnmarshaller.unmarshal(docXML)).getValue();
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}

	/**
	 * 
	 * @param docXML
	 * @return
	 * @throws Exception
	 */
	public PriorInformationNoticeType deserializePriorInformationNotice(SAXSource docXML) throws Exception {

		PriorInformationNoticeType res = null;

		try {
			res = (PriorInformationNoticeType) ((JAXBElement)pinUnmarshaller.unmarshal(docXML)).getValue();
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}

	/**
	 * 
	 * @param docXML
	 * @return
	 * @throws Exception
	 */
	public CallForTendersType deserializeCallforTenders(InputStream docXML) throws Exception {

		CallForTendersType res = null;

		try { 
			res = (CallForTendersType) ((JAXBElement)cftUnmarshaller.unmarshal(docXML)).getValue();
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}

	/**
	 * 
	 * @param docXML
	 * @return
	 * @throws Exception
	 */
	public CallForTendersType deserializeCallforTenders(SAXSource docXML) throws Exception {

		CallForTendersType res = null;

		try {
			res = (CallForTendersType) ((JAXBElement)cftUnmarshaller.unmarshal(docXML)).getValue();
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}

	/**
	 * 
	 * @param docXML
	 * @return
	 * @throws Exception
	 */
	public CancelNoticeRequestType deserializeCancelNoticeRequest(InputStream docXML) throws Exception {

		CancelNoticeRequestType res = null;

		try { 
			res = (CancelNoticeRequestType) ((JAXBElement)cancelNoticeReqUnmarshaller.unmarshal(docXML)).getValue();
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}

	/**
	 * 
	 * @param docXML
	 * @return
	 * @throws Exception
	 */
	public CancelNoticeRequestType deserializeCancelNoticeRequest(SAXSource docXML) throws Exception {

		CancelNoticeRequestType res = null;

		try {
			res = (CancelNoticeRequestType) ((JAXBElement)cancelNoticeReqUnmarshaller.unmarshal(docXML)).getValue();
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}

	
	
	/**
	 * 
	 * @param docXML
	 * @return
	 * @throws Exception
	 */
	public CancelGeneralContractDocumentRequestType deserializeCancelGeneralContractDocumentRequest(InputStream docXML) throws Exception {

		CancelGeneralContractDocumentRequestType res = null;

		try { 
			res = (CancelGeneralContractDocumentRequestType) ((JAXBElement)cancelDocumentReqUnmarshaller.unmarshal(docXML)).getValue();
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}

	/**
	 * 
	 * @param docXML
	 * @return
	 * @throws Exception
	 */
	public CancelGeneralContractDocumentRequestType deserializeCancelGeneralContractDocumentRequest(SAXSource docXML) throws Exception {

		CancelGeneralContractDocumentRequestType res = null;

		try {
			res = (CancelGeneralContractDocumentRequestType) ((JAXBElement)cancelDocumentReqUnmarshaller.unmarshal(docXML)).getValue();
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}

	
	
	
	/**
		 * Deserializa el cac de tipo DocumentReference
		 * 
		 * @param docXML
		 *            Tipo SAXSource con que contiene un DocumentReference
		 * @return DocumentReference
		 * @throws Exception
		 */
		public DocumentReferenceType deserializeDocumentReferenceType(SAXSource docXML) throws Exception {

			DocumentReferenceType res = null;

			try {
				res = (DocumentReferenceType) ((JAXBElement)cacUnmarshaller.unmarshal(docXML)).getValue();
			} catch (Exception e) {
				e.printStackTrace();
				throw (e);
			}

			return res;
		}


		/**
		 * Deserializa el cac de tipo DocumentReference
		 * 
		 * @param docXML
		 *            Tipo InputStream con que contiene un DocumentReference
		 * @return DocumentReference
		 * @throws Exception
		 */
		public DocumentReferenceType deserializeDocumentReferenceType(InputStream docXML) throws Exception {

			DocumentReferenceType res = null;

			try {
				res = (DocumentReferenceType) ((JAXBElement)cacUnmarshaller.unmarshal(docXML)).getValue();
			} catch (Exception e) {
				e.printStackTrace();
				throw (e);
			}

			return res;
		}
		
		
		/**
	 * Escribe en disco el documento serializado
	 * 
	 * @param out
	 *            ByteArrayOutputStream con el documento serializado
	 * @param filename
	 *            nombre del archivo resultante
	 */
	public void guardarDocumentoEnFileSystem(ByteArrayOutputStream out, String filename) {

		try {
			File f = new File(filename);
			FileOutputStream outFile = new FileOutputStream(f);
			outFile.write(out.toByteArray());
			outFile.close();
		} catch (IOException es) {
		}
	}

	/**
	 * Escribe en memoria el documento serializado
	 * 
	 * @param out
	 * @return
	 */

	public InputStream generarDocumentoEntrada(ByteArrayOutputStream out) {
		InputStream in = new ByteArrayInputStream(out.toByteArray());

		return in;
	}

	/**
	 * Conversor de ByteArrayInputStream a String
	 * 
	 * @param in
	 *            InputStream
	 * @return String
	 * @throws IOException
	 */
	public String inputStream2String(ByteArrayInputStream in) throws IOException {
		String line = null;

		BufferedReader buf = new BufferedReader(new InputStreamReader(in));
		StringBuffer buffer = new StringBuffer();
		while ((line = buf.readLine()) != null) {
			buffer.append(line);
		}

		buf.close();
		
		return buffer.toString();

	}

	public ByteArrayInputStream convetirAByteArrayInputStream(InputStream in) throws IOException {
		// lo pasamos a bytes
		ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
		int c;
		while ((c = in.read()) != -1) {
			byteArrayOutputStream.write((char) c);
		}

		return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
	}

	
	
	
	// Serializacin a tipo org.wc3.dom.Document
	
	/**
	 * Serializa el Anuncio de Licitacion a tipo Document
	 * 
	 * @param contractnotice
	 *            Tipo CODICE
	 * @return Document de tipo org.w3c.dom.Document
	 */

	public Document serializeContractNoticetoDocument(ContractNoticeType contractnotice) throws Exception {
		
		Document res = null;

		try {
			res = db.newDocument();
			cnMarshaller.marshal(contractnotice, res);
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}

	
	/**
	 * Serializa el Anuncio Previo a tipo Document
	 * 
	 * @param pinnotice
	 *            Tipo CODICE
	 * @return Document de tipo org.w3c.dom.Document
	 */

	public Document serializePriorInformationNoticetoDocument(PriorInformationNoticeType pinnotice) throws Exception {
		
		Document res = null;

		try {
			res = db.newDocument();
			pinMarshaller.marshal(pinnotice, res);
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}

	
	/**
	 * Serializa el Anuncio de Adjudicacin (provisional, definitiva, 
	 * adjudicacin, formalizacin a tipo Document
	 * 
	 * @param pinnotice
	 *            Tipo CODICE
	 * @return Document de tipo org.w3c.dom.Document
	 */

	public Document serializeContractAwardNoticetoDocument(ContractAwardNoticeType canotice) throws Exception {
		
		Document res = null;

		try {
			res = db.newDocument();
			canMarshaller.marshal(canotice, res);
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}
	
	
	/**
	 * Serializa el Anuncio de Adjudicacin (provisional, definitiva, 
	 * adjudicacin, formalizacin a tipo Document
	 * 
	 * @param pinnotice
	 *            Tipo CODICE
	 * @return Document de tipo org.w3c.dom.Document
	 */

	public Document serializeContractModificationNoticetoDocument(ContractModificationNoticeType cmnotice) throws Exception {
		
		Document res = null;

		try {
			res = db.newDocument();
			contractModificationMarshaller.marshal(cmnotice, res);
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}
	
	
	
	
	/**
	 * Serializa el Anuncio de Pliegos a tipo Document
	 * 
	 * @param cft
	 *            Tipo CODICE
	 * @return Document de tipo org.w3c.dom.Document
	 */

	public Document serializeCallForTenderstoDocument(CallForTendersType cft) throws Exception {
		
		Document res = null;

		try {
			res = db.newDocument();
			
			cftMarshaller.marshal( new JAXBElement(
                      new QName("urn:dgpe:names:draft:codice:schema:xsd:CallForTenders-2", "CallForTenders")
                      ,CallForTendersType.class,cft),res); 
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}
	
	/**
	 * Serializa la anulacion de anuncios a tipo Document
	 * 
	 * @param cancelNoticeReq
	 *            Tipo CODICE
	 * @return Document de tipo org.w3c.dom.Document
	 */

	public Document serializeCancelNoticeRequesttoDocument(CancelNoticeRequestType cancelNoticeReq) throws Exception {
		
		Document res = null;

		try {
			res = db.newDocument();
			
			cancelNoticeReqMarshaller.marshal( new JAXBElement(
                      new QName("urn:codice-place-ext:names:draft:ubl:schema:xsd:CancelNoticeRequest", "CancelNoticeRequest")
                      ,CancelNoticeRequestType.class,cancelNoticeReq),res); 
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}
	/**
	 * Serializa la anulacion de documentos a tipo Document
	 * 
	 * @param cancelDocumentReq
	 *            Tipo CODICE
	 * @return Document de tipo org.w3c.dom.Document
	 */

	public Document serializeCancelGeneralContractDocumentRequesttoDocument(CancelGeneralContractDocumentRequestType cancelDocumentReq) throws Exception {
		
		Document res = null;

		try {
			res = db.newDocument();
			
			cancelDocumentReqMarshaller.marshal( new JAXBElement(
                      new QName("urn:codice-place-ext:names:draft:ubl:schema:xsd:CancelGeneralDocumentRequest", "CancelGeneralContractDocumentRequest")
                      ,CancelGeneralContractDocumentRequestType.class,cancelDocumentReq),res); 
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}
	
	/**
	 * Serializa el cac de tipo DocumentReference
	 * 
	 * @param dr
	 *            Tipo DocumentReference
	 * @return Document de tipo org.w3c.dom.Document
	 */

	public Document serializeDocumentReferenceType(DocumentReferenceType dr) throws Exception {
		
		Document res = null;

		try {
			res = db.newDocument();
			cacMarshaller.marshal(dr, res);
		} catch (Exception e) {
			e.printStackTrace();
			throw (e);
		}

		return res;
	}
	
	
    /*
     * Getters y setters de las Factorias
     */
	public static org.dgpe.codice.common.caclib.ObjectFactory getCacFactory() {
		return cacFactory;
	}

	public static void setCacFactory(org.dgpe.codice.common.caclib.ObjectFactory cacFactory) {
		CODICESerializing.cacFactory = cacFactory;
	}

	public static org.dgpe.codice.maindoc.contractawardnotice.ObjectFactory getCanFactory() {
		return canFactory;
	}

	public static void setCanFactory(org.dgpe.codice.maindoc.contractawardnotice.ObjectFactory canFactory) {
		CODICESerializing.canFactory = canFactory;
	}

	public static org.dgpe.codice.maindoc.callfortenders.ObjectFactory getCftFactory() {
		return cftFactory;
	}

	public static void setCftFactory(org.dgpe.codice.maindoc.callfortenders.ObjectFactory cftFactory) {
		CODICESerializing.cftFactory = cftFactory;
	}

	
    public static org.dgpe.codice.maindoc.contractnotice.ObjectFactory getCnFactory() {
		return cnFactory;
	}

	public static void setCnFactory(org.dgpe.codice.maindoc.contractnotice.ObjectFactory cnFactory) {
		CODICESerializing.cnFactory = cnFactory;
	}

	public static org.dgpe.codice.maindoc.pin.ObjectFactory getPinFactory() {
		return pinFactory;
	}

	public static void setPinFactory(org.dgpe.codice.maindoc.pin.ObjectFactory pinFactory) {
		CODICESerializing.pinFactory = pinFactory;
	}


	
	public static org.dgpe.codice.common.cbclib.ObjectFactory getCbcFactory() {
		return cbcFactory;
	}

	public static void setCbcFactory(org.dgpe.codice.common.cbclib.ObjectFactory cbcFactory) {
		CODICESerializing.cbcFactory = cbcFactory;
	}
	
    public static ext.place.codice.maindoc.cancelnoticerequest.ObjectFactory getCancelNoticeFactory() {
		return cancelNoticeFactory;
	}	
    public static void setCancelNoticeFactory(
			ext.place.codice.maindoc.cancelnoticerequest.ObjectFactory cancelNoticeFactory) {
		CODICESerializing.cancelNoticeFactory = cancelNoticeFactory;
	}

	public static ext.place.codice.maindoc.cancelgeneraldocumentrequest.ObjectFactory getCancelDocumentFactory() {
		return cancelDocumentFactory;
	}
	public static void setCancelDocumentFactory(
			ext.place.codice.maindoc.cancelgeneraldocumentrequest.ObjectFactory cancelDocumentFactory) {
		CODICESerializing.cancelDocumentFactory = cancelDocumentFactory;
	}

	public static org.dgpe.codice.maindoc.contractmodificationnotice.ObjectFactory getContractModificationNoticeFactory() {
		return contractModificationNoticeFactory;
	}

	public static void setContractModificationNoticeFactory(
			org.dgpe.codice.maindoc.contractmodificationnotice.ObjectFactory contractModificationNoticeFactory) {
		CODICESerializing.contractModificationNoticeFactory = contractModificationNoticeFactory;
	}
	
	public static ext.place.codice.common.caclib.ObjectFactory getCacPlaceExtFactory() {
		return cacPlaceExtFactory;
	}
	public static void setCacPlaceExtFactory(
			ext.place.codice.common.caclib.ObjectFactory cacPlaceExtFactory) {
		CODICESerializing.cacPlaceExtFactory = cacPlaceExtFactory;
	}

	public static ext.place.codice.common.cbclib.ObjectFactory getCbcPlaceExtFactory() {
		return cbcPlaceExtFactory;
	}
	public static void setCbcPlaceExtFactory(
			ext.place.codice.common.cbclib.ObjectFactory cbcPlaceExtFactory) {
		CODICESerializing.cbcPlaceExtFactory = cbcPlaceExtFactory;
	}

	

	
	
}
