/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/

package es.dgpe.place.client.utils;

import java.io.ByteArrayOutputStream;
import java.util.List;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;

import org.dgpe.codice.common.caclib.DocumentReferenceType;
import org.dgpe.codice.common.cbclib.AgencyIDType;
import org.dgpe.codice.maindoc.callfortenders.CallForTendersType;
import org.dgpe.codice.maindoc.contractawardnotice.ContractAwardNoticeType;
import org.dgpe.codice.maindoc.contractmodificationnotice.ContractModificationNoticeType;
import org.dgpe.codice.maindoc.contractnotice.ContractNoticeType;
import org.dgpe.codice.maindoc.pin.PriorInformationNoticeType;

import es.contrataciondelestado.b2b.publicacion.PlacePublicationResult;
import es.contrataciondelestado.b2b.publicacion.Publication;
import es.contrataciondelestado.b2b.publicacion.Publications;
import es.contrataciondelestado.b2b.publicacion.ServicioPublicacionB2B;
import es.contrataciondelestado.b2b.publicacion.ServicioPublicacionB2BPortType;
import es.contrataciondelestado.b2b.servicios.ServicioPLACEB2BPortType;
import es.contrataciondelestado.b2b.servicios.ServicioPlaceB2B;
import es.contrataciondelestado.b2b.servicioscodice.PlaceValidationResult;
import es.contrataciondelestado.b2b.servicioscodice.PlaceVisualizationResult;
import es.contrataciondelestado.b2b.servicioscodice.ServicioCODICEB2B;
import es.contrataciondelestado.b2b.servicioscodice.ServiciosCODICE;
import es.contrataciondelestado.b2b.serviciosconsulta.PlaceAskResult;
import es.contrataciondelestado.b2b.serviciosconsulta.ServicioConsultaB2B;
import es.contrataciondelestado.b2b.serviciosconsulta.ServiciosConsulta;
import ext.place.codice.common.caclib.AdditionalPublicationRequestType;
import ext.place.codice.maindoc.cancelgeneraldocumentrequest.CancelGeneralContractDocumentRequestType;
import ext.place.codice.maindoc.cancelgeneraldocumentresponse.CancelGeneralContractDocumentResponseType;
import ext.place.codice.maindoc.cancelnoticerequest.CancelNoticeRequestType;
import ext.place.codice.maindoc.cancelnoticeresponse.CancelNoticeResponseType;
import ext.place.codice.maindoc.publishnotice.PublishNoticeType;
import ext.place.codice.maindoc.publishnoticeresponse.PublishNoticeResponseType;

public class ClienteLlamadas {
	private static String tipoDocumento = "";
	private static Object docSerializado = "";
	private static SOAPMessage mensajeEnviado;
	private static SOAPMessage mensajeRecibido;

	public static String getTipoDocumento() {
		return tipoDocumento;
	}

	public static void setTipoDocumento(String tipoDocumento) {
		ClienteLlamadas.tipoDocumento = tipoDocumento;
	}

	public static Object getDocSerializado() {
		return docSerializado;
	}

	public static void setDocSerializado(Object docSerializado) {
		ClienteLlamadas.docSerializado = docSerializado;
	}

	public static SOAPMessage getMensajeEnviado() {
		return mensajeEnviado;
	}

	public static void setMensajeEnviado(SOAPMessage msg) {
		mensajeEnviado = msg;
	}

	public static SOAPMessage getMensajeRecibido() {
		return mensajeRecibido;
	}

	public static void setMensajeRecibido(SOAPMessage msg) {
		mensajeRecibido = msg;
	}

	public ClienteLlamadas() {
		super();
	}

	private void inicializarConfiguracion() {
		System.setProperty("java.protocol.handler.pkgs", "javax.net.ssl");
		HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
		System.setProperty("javax.net.ssl.keyStorePassword",
				ConfigurationManager.leerPropiedadSecurity("keystore.password"));
		System.setProperty("javax.net.ssl.trustStore", ConfigurationManager.leerPropiedadSecurity("truststore.url"));
		System.setProperty("javax.net.ssl.trustStorePassword",
				ConfigurationManager.leerPropiedadSecurity("truststore.password"));
		SSLUtilities.trustAllHttpsCertificates();

		if (ConfigurationManager.leerPropiedadConnection("proxy.enabled").equalsIgnoreCase("true")) {
			System.setProperty("java.net.useSystemProxies", "true");
			System.setProperty("http.proxyHost", ConfigurationManager.leerPropiedadConnection("proxy.host"));
			System.setProperty("http.proxyPort", ConfigurationManager.leerPropiedadConnection("proxy.port"));
		}
	}

	public void llamarPIN(PriorInformationNoticeType pin, Publications pubs) {
		try {

			inicializarConfiguracion();

			ServicioPublicacionB2B servicio = new ServicioPublicacionB2B();

			ServicioPublicacionB2BPortType stub = (ServicioPublicacionB2BPortType) servicio.getPort(
					new QName("http://publicacion.b2b.contrataciondelestado.es", "ServicioPublicacionB2BPort"),
					ServicioPublicacionB2BPortType.class);

			javax.xml.ws.Binding binding = ((BindingProvider) stub).getBinding();

			List<Handler> handlerList = binding.getHandlerChain();
			FirmarServicioPublicacionHandler handler = new FirmarServicioPublicacionHandler();
			handlerList.add(handler);

			// Set the handlerList to handler chain

			binding.setHandlerChain(handlerList);

			//
			// Publications pubs =obtenerPublicacionesOficiales(TipoDocumento.PIN);
			//
			// if (pubs.getPublication()!=null && pubs.getPublication().size()==0){
			// pubs =new Publications();
			// }

			PlacePublicationResult result = stub.publishPriorInformationNotice(pin, pubs, null);
			System.out.println(result.getExpedientNumber());
		} catch (Exception ex) {
			System.out.println("Caught Exception: " + ex.getMessage());
			ex.printStackTrace();
		}

	}

	public void llamarCN(ContractNoticeType ca, Publications pubs) {
		try {

			inicializarConfiguracion();

			ServicioPublicacionB2B servicio = new ServicioPublicacionB2B();

			ServicioPublicacionB2BPortType stub = (ServicioPublicacionB2BPortType) servicio.getPort(
					new QName("http://publicacion.b2b.contrataciondelestado.es", "ServicioPublicacionB2BPort"),
					ServicioPublicacionB2BPortType.class);

			javax.xml.ws.Binding binding = ((BindingProvider) stub).getBinding();

			List<Handler> handlerList = binding.getHandlerChain();
			FirmarServicioPublicacionHandler handler = new FirmarServicioPublicacionHandler();
			handlerList.add(handler);

			// Set the handlerList to handler chain

			binding.setHandlerChain(handlerList);

			// Publications pubs =obtenerPublicacionesOficiales(TipoDocumento.CN);
			//
			// if (pubs.getPublication()!=null && pubs.getPublication().size()==0){
			// pubs =new Publications();
			// }

			PlacePublicationResult result = stub.publishContractNotice(ca, pubs, null);
			System.out.println(result.getExpedientNumber());
		} catch (Exception ex) {
			System.out.println("Caught Exception: " + ex.getMessage());
			ex.printStackTrace();
		}

	}

	public void llamarCD(CallForTendersType cft) {
		try {

			inicializarConfiguracion();

			ServicioPublicacionB2B servicio = new ServicioPublicacionB2B();

			ServicioPublicacionB2BPortType stub = (ServicioPublicacionB2BPortType) servicio.getPort(
					new QName("http://publicacion.b2b.contrataciondelestado.es", "ServicioPublicacionB2BPort"),
					ServicioPublicacionB2BPortType.class);

			SOAPBinding binding = (SOAPBinding) ((BindingProvider) stub).getBinding();

			int maxSizeMTOM = new Integer(ConfigurationManager.leerPropiedadConnection("maxSizeWithoutMTOM"))
					.intValue();
			ByteArrayOutputStream docXML = (ByteArrayOutputStream) CODICESerializing.getInstance()
					.serializeCallForTender((CallForTendersType) getDocSerializado());
			if (docXML.size() > maxSizeMTOM) {
				binding.setMTOMEnabled(true);
			}

			List<Handler> handlerList = binding.getHandlerChain();
			FirmarServicioPublicacionHandler handler = new FirmarServicioPublicacionHandler();
			handlerList.add(handler);

			// Set the handlerList to handler chain

			binding.setHandlerChain(handlerList);

			Publications pub = new Publications();

			PlacePublicationResult result = stub.publishCallForTenders(cft, null);
			System.out.println(result.getExpedientNumber());
		} catch (Exception ex) {
			System.out.println("Caught Exception: " + ex.getMessage());
			ex.printStackTrace();
		}

	}

	public void llamarCAN(ContractAwardNoticeType can, Publications pubs) {
		try {

			inicializarConfiguracion();

			ServicioPublicacionB2B servicio = new ServicioPublicacionB2B();

			ServicioPublicacionB2BPortType stub = (ServicioPublicacionB2BPortType) servicio.getPort(
					new QName("http://publicacion.b2b.contrataciondelestado.es", "ServicioPublicacionB2BPort"),
					ServicioPublicacionB2BPortType.class);

			javax.xml.ws.Binding binding = ((BindingProvider) stub).getBinding();

			List<Handler> handlerList = binding.getHandlerChain();
			FirmarServicioPublicacionHandler handler = new FirmarServicioPublicacionHandler();
			handlerList.add(handler);

			binding.setHandlerChain(handlerList);

			// TODO No vale si queremos publicacion oficiales en ATPV, Desiertos, Renuncias
			// y Desistimientos
			// Publications pubs=new Publications();
			// Publications pubs =obtenerPublicacionesOficiales(TipoDocumento.FORM);
			// if (pubs.getPublication()!=null && pubs.getPublication().size()==0){
			// pubs =new Publications();
			// }

			PlacePublicationResult result = stub.publishContractAwardNotice(can, pubs, null);

			System.out.println(result.getExpedientNumber());

		} catch (Exception ex) {

			System.out.println("Caught Exception: " + ex.getMessage());
			ex.printStackTrace();
		}

	}

	public void llamarModifiacionAnuncio(ContractModificationNoticeType contractModification, Publications pubs) {
		try {

			inicializarConfiguracion();

			ServicioPlaceB2B servicio = new ServicioPlaceB2B();

			ServicioPLACEB2BPortType stub = (ServicioPLACEB2BPortType) servicio
					.getPort(
							new QName("http://servicios.b2b.contrataciondelestado.es",
									"ServiciosPLACEB2B_ServicioPLACEB2BPortTypeHttpPort"),
							ServicioPLACEB2BPortType.class);

			javax.xml.ws.Binding binding = ((BindingProvider) stub).getBinding();

			List<Handler> handlerList = binding.getHandlerChain();
			FirmarServicioPublicacionHandler handler = new FirmarServicioPublicacionHandler();
			handlerList.add(handler);

			// Set the handlerList to handler chain

			binding.setHandlerChain(handlerList);

			PublishNoticeType publishNotice = new PublishNoticeType();		
			publishNotice.setContractModificationNotice(contractModification);

			// Se comprueba si se debe enviar al DOUE o ya se ha enviado al DOUE
			for (Publication pub : pubs.getPublication()) {
				if (pub.getPublishAgency().compareTo("DOUE") == 0) {
					if (!pub.isPublish()) {
						AdditionalPublicationRequestType additionalPublicationRequestType = new AdditionalPublicationRequestType();
						AgencyIDType agencyIDType = new AgencyIDType();
						agencyIDType.setValue("DOUE");
						additionalPublicationRequestType.setAgencyID(agencyIDType);
						publishNotice.getAdditionalPublicationRequest().add(additionalPublicationRequestType);
					} else {
						/*
						 * AdditionalPublicationDocumentReferenceType
						 * additionalPublicationDocumentReferenceType = new
						 * AdditionalPublicationDocumentReferenceType(); IDType idType = new IDType();
						 * idType.setValue("111/S 222-123456");
						 * additionalPublicationDocumentReferenceType.setID(idType);
						 * additionalPublicationDocumentReferenceType.
						 * 
						 * 
						 * 
						 * publishNotice.getAdditionalPublicationDocumentReference().add(ad)
						 */
					}

				}
			}

			PublishNoticeResponseType result = stub.publishNotice(publishNotice);

			System.out.println();
		} catch (Exception ex) {
			System.out.println("Caught Exception: " + ex.getMessage());
			ex.printStackTrace();
		}
	}

	public void llamarDOCGEN(String publicationId, String expedientNumber, String buyerProfileId,
			DocumentReferenceType doc) {
		try {

			inicializarConfiguracion();

			ServicioPublicacionB2B servicio = new ServicioPublicacionB2B();

			ServicioPublicacionB2BPortType stub = (ServicioPublicacionB2BPortType) servicio.getPort(
					new QName("http://publicacion.b2b.contrataciondelestado.es", "ServicioPublicacionB2BPort"),
					ServicioPublicacionB2BPortType.class);

			SOAPBinding binding = (SOAPBinding) ((BindingProvider) stub).getBinding();

			int maxSizeMTOM = new Integer(ConfigurationManager.leerPropiedadConnection("maxSizeWithoutMTOM"))
					.intValue();
			ByteArrayOutputStream docXML = (ByteArrayOutputStream) CODICESerializing.getInstance()
					.serialize_DocumentReferenceType((DocumentReferenceType) getDocSerializado());
			if (docXML.size() > maxSizeMTOM) {
				binding.setMTOMEnabled(true);
			}

			List<Handler> handlerList = binding.getHandlerChain();
			FirmarServicioPublicacionHandler handler = new FirmarServicioPublicacionHandler();
			handlerList.add(handler);

			binding.setHandlerChain(handlerList);

			Publications pub = new Publications();

			PlacePublicationResult result = stub.publishGeneralContractDocument(publicationId, expedientNumber,
					buyerProfileId, doc, null);
			System.out.println(result.getExpedientNumber());

		} catch (Exception ex) {

			System.out.println("Caught Exception: " + ex.getMessage());
			ex.printStackTrace();
		}

	}

	public void llamarConsultaExp(String expedientNumber, String buyerProfileId) {

		inicializarConfiguracion();

		ServicioConsultaB2B servicioConsulta = new ServicioConsultaB2B();

		ServiciosConsulta stub = (ServiciosConsulta) servicioConsulta.getPort(
				new QName("http://serviciosConsulta.b2b.contrataciondelestado.es", "ServicioConsultaB2BPort"),
				ServiciosConsulta.class);

		javax.xml.ws.Binding binding = ((BindingProvider) stub).getBinding();

		List<Handler> handlerList = binding.getHandlerChain();
		FirmarServicioPublicacionHandler handler = new FirmarServicioPublicacionHandler();
		handlerList.add(handler);

		binding.setHandlerChain(handlerList);

		PlaceAskResult result = stub.getExpedientStateFull(expedientNumber, buyerProfileId);

	}

	public void llamarConsultaBuyerProfile(String buyerProfileId) {

		inicializarConfiguracion();

		ServicioConsultaB2B servicioConsulta = new ServicioConsultaB2B();

		ServiciosConsulta stub = (ServiciosConsulta) servicioConsulta.getPort(
				new QName("http://serviciosConsulta.b2b.contrataciondelestado.es", "ServicioConsultaB2BPort"),
				ServiciosConsulta.class);

		javax.xml.ws.Binding binding = ((BindingProvider) stub).getBinding();

		List<Handler> handlerList = binding.getHandlerChain();
		FirmarServicioPublicacionHandler handler = new FirmarServicioPublicacionHandler();
		handlerList.add(handler);

		binding.setHandlerChain(handlerList);

		PlaceAskResult result = stub.getBuyerProfileData(buyerProfileId);

	}

	public void llamarUtilidadValidacion(int typeCodice) {

		inicializarConfiguracion();

		ServicioCODICEB2B servicioCODICE = new ServicioCODICEB2B();

		ServiciosCODICE stub = (ServiciosCODICE) servicioCODICE.getPort(
				new QName("http://serviciosCODICE.b2b.contrataciondelestado.es", "ServicioCODICEB2BPort"),
				ServiciosCODICE.class);

		javax.xml.ws.Binding binding = ((BindingProvider) stub).getBinding();

		List<Handler> handlerList = binding.getHandlerChain();
		FirmarServicioPublicacionHandler handler = new FirmarServicioPublicacionHandler();
		handlerList.add(handler);

		binding.setHandlerChain(handlerList);
		PlaceValidationResult result = null;
		switch (typeCodice) {
		case 1: // Anuncio Previo
			PriorInformationNoticeType pin = (PriorInformationNoticeType) this.getDocSerializado();
			result = stub.validateCODICE(pin, null, null, null, null, null);
			break;
		case 2: // Anuncio de licitacion
			ContractNoticeType cn = (ContractNoticeType) this.getDocSerializado();
			result = stub.validateCODICE(null, cn, null, null, null, null);
			break;
		case 3: // Pliego
			CallForTendersType cft = (CallForTendersType) this.getDocSerializado();
			result = stub.validateCODICE(null, null, null, cft, null, null);
			break;
		case 4: // Anuncio de Adjudicacion
			ContractAwardNoticeType can = (ContractAwardNoticeType) this.getDocSerializado();
			result = stub.validateCODICE(null, null, can, null, null, null);
			break;
		case 15: // Anuncio de Modificacin
			ContractModificationNoticeType mod = (ContractModificationNoticeType) this.getDocSerializado();
			result = stub.validateCODICE(null, null, null, null, mod, null);
			break;
		default:
			break;
		}

	}

	public void llamarUtilidadPrevisualizacion(int typeCodice) {

		inicializarConfiguracion();

		ServicioCODICEB2B servicioCODICE = new ServicioCODICEB2B();

		ServiciosCODICE stub = (ServiciosCODICE) servicioCODICE.getPort(
				new QName("http://serviciosCODICE.b2b.contrataciondelestado.es", "ServicioCODICEB2BPort"),
				ServiciosCODICE.class);

		javax.xml.ws.Binding binding = ((BindingProvider) stub).getBinding();

		List<Handler> handlerList = binding.getHandlerChain();
		FirmarServicioPublicacionHandler handler = new FirmarServicioPublicacionHandler();
		handlerList.add(handler);

		binding.setHandlerChain(handlerList);
		PlaceVisualizationResult result = null;

		switch (typeCodice) {
		case 1: // Anuncio Previo
			PriorInformationNoticeType pin = (PriorInformationNoticeType) this.getDocSerializado();
			result = stub.viewCODICE(pin, null, null, null, null, null, null, null);
			break;
		case 2: // Anuncio de licitacion
			ContractNoticeType cn = (ContractNoticeType) this.getDocSerializado();
			result = stub.viewCODICE(null, cn, null, null, null, null, null, null);
			break;
		case 3: // Pliego
			CallForTendersType cft = (CallForTendersType) this.getDocSerializado();
			result = stub.viewCODICE(null, null, null, cft, null, null, null, null);
			break;
		case 4: // Anuncio de Adjudicacion
			ContractAwardNoticeType can = (ContractAwardNoticeType) this.getDocSerializado();
			result = stub.viewCODICE(null, null, can, null, null, null, null, null);
			break;
		case 15: // Anuncio de Modificacin
			ContractModificationNoticeType mod = (ContractModificationNoticeType) this.getDocSerializado();
			result = stub.viewCODICE(null, null, null, null, null, null, mod, null);
			break;
		default:
			break;
		}

	}

	public void llamarAnulacionAnuncio(CancelNoticeRequestType cancelNoticeRequest) {
		try {

			inicializarConfiguracion();

			ServicioPlaceB2B servicio = new ServicioPlaceB2B();

			ServicioPLACEB2BPortType stub = (ServicioPLACEB2BPortType) servicio
					.getPort(
							new QName("http://servicios.b2b.contrataciondelestado.es",
									"ServiciosPLACEB2B_ServicioPLACEB2BPortTypeHttpPort"),
							ServicioPLACEB2BPortType.class);

			javax.xml.ws.Binding binding = ((BindingProvider) stub).getBinding();

			List<Handler> handlerList = binding.getHandlerChain();
			FirmarServicioPublicacionHandler handler = new FirmarServicioPublicacionHandler();
			handlerList.add(handler);

			// Set the handlerList to handler chain

			binding.setHandlerChain(handlerList);

			CancelNoticeResponseType result = stub.cancelNotice(cancelNoticeRequest);
			System.out.println();
		} catch (Exception ex) {
			System.out.println("Caught Exception: " + ex.getMessage());
			ex.printStackTrace();
		}
	}

	public void llamarAnulacionDocumento(
			CancelGeneralContractDocumentRequestType cancelGeneralContractDocumentRequest) {
		try {
			inicializarConfiguracion();

			ServicioPlaceB2B servicio = new ServicioPlaceB2B();

			ServicioPLACEB2BPortType stub = (ServicioPLACEB2BPortType) servicio
					.getPort(
							new QName("http://servicios.b2b.contrataciondelestado.es",
									"ServiciosPLACEB2B_ServicioPLACEB2BPortTypeHttpPort"),
							ServicioPLACEB2BPortType.class);

			javax.xml.ws.Binding binding = ((BindingProvider) stub).getBinding();

			List<Handler> handlerList = binding.getHandlerChain();
			FirmarServicioPublicacionHandler handler = new FirmarServicioPublicacionHandler();
			handlerList.add(handler);

			// Set the handlerList to handler chain

			binding.setHandlerChain(handlerList);

			CancelGeneralContractDocumentResponseType result = stub
					.cancelGeneralDocument(cancelGeneralContractDocumentRequest);
			System.out.println();
		} catch (Exception ex) {
			System.out.println("Caught Exception: " + ex.getMessage());
			ex.printStackTrace();
		}

	}

	public class MyHostnameVerifier implements HostnameVerifier {
		public boolean verify(String arg0, SSLSession arg1) {
			return true;
		}
	}

}
