/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.utils;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JComboBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import es.dgpe.place.client.constants.ConstantsGC;

public class ComboBoxUtils {

	private static ComboBoxUtils instance = null;
	private static File[] ficheros_gc = null;
	private static String mensajeGcOk = "mensajeGcOk";
	private static String mensajeGcFail = "mensajeGcFail";
	private static Map listComboBoxs=null; 
    
	
	
	public static void loadComboBoxFromConstant(JComboBox combo,String constant){
	String nombre=null;
	if (constant.lastIndexOf("/")==-1){
		nombre=constant.substring(constant.lastIndexOf(":")+1)+".gc";
	}else{
		nombre=constant.substring(constant.lastIndexOf("/")+1);
	}
	String values[]= ComboBoxUtils.getNamesFromComboBox(nombre);
	if (values==null){
		System.out.println("El combo '"+nombre+"' viene nulo");
	}else{
		for (int i=0;i<values.length;i++){
			combo.addItem(values[i]);
		}
	}
}
	
	//Carga el ComboBox permitiendo seleccionar el valor vacio
		public static void loadComboBoxNoObligatorioFromConstant(JComboBox combo,String constant)
		{
			combo.addItem("");
			//Cargo el combo sin el valor vacio
			loadComboBoxFromConstant(combo,constant);
			//Anyado el valor vacio y lo dejo seleccionado
			combo.setSelectedItem("");
		}
	
	public static String[] getNamesFromGc(){
		String[] resultado=null;
		if (ficheros_gc!=null){
			resultado=new String[ficheros_gc.length];
			for(int i=0;i<ficheros_gc.length;i++){
				resultado[i]=ficheros_gc[i].getName();
			}
		}
		return resultado;
	}
    public static Map getlistComboBox(){
    	Map resultado=null;
    	if (listComboBoxs!=null){
    		resultado=listComboBoxs;
    	}
    	return resultado;
    	
    }
    
    public static String[][] getComboBoxByConstant(String constant){
    	String[][] resultado=null;
    	String nombre=constant.substring(constant.lastIndexOf("/")+1);
    	if (listComboBoxs!=null&&nombre!=null){
    		resultado=(String[][])listComboBoxs.get(nombre);
    	}
    	return resultado;
    	
    }
    public static String[][] getComboBox(String name){
    	String[][] resultado=null;
    	String nombre=name.substring(name.lastIndexOf("/")+1);
    	if (listComboBoxs!=null){
    		resultado=(String[][])listComboBoxs.get(nombre);
    	}
    	return resultado;
    }
    
    public static String[] getNamesFromComboBox(String constant){
    	String[] resultado=null;
      	String nombre=constant.substring(constant.lastIndexOf("/")+1);
    	if (listComboBoxs!=null){
    		String[][] combo=(String[][])listComboBoxs.get(nombre);
    		if (combo!=null){
    			resultado=new String[combo.length];
    			for (int i=0;i<combo.length;i++){
    				resultado[i]=combo[i][0];
    			}
    		}
    	}
    	return resultado;
    }
    


    public static String[] getValuesFromComboBox(String constant){
    	String[] resultado=null;
    	String nombre=constant.substring(constant.lastIndexOf("/")+1);
    	if (listComboBoxs!=null){
    		String[][] combo=(String[][])listComboBoxs.get(nombre);
    		if (combo!=null){
    			resultado=new String[combo.length];
    			for (int i=0;i<combo.length;i++){
    				resultado[i]=combo[i][1];
    			}
    		}
    	}
    	return resultado;
    }
    
	public static ComboBoxUtils getInstance() {
		if (instance == null)
			instance = new ComboBoxUtils();
		return instance;
	}

    
    
	private ComboBoxUtils() {

		try {

			ficheros_gc = new File(ConfigurationManager.GC_PATH).listFiles();
			listComboBoxs=new HashMap();
			
			
			System.out.println(ConfigurationManager.leerPropiedad(mensajeGcOk)
					+ " desde la ruta " + ConfigurationManager.GC_PATH);
			for (int i=0;i<ficheros_gc.length;i++){
				String resultado[][]=loadComboBoxFromFile(ficheros_gc[i]);
				listComboBoxs.put(ficheros_gc[i].getName(), resultado);				
			}
		} catch (Exception e) {

			System.out.println(ConfigurationManager
					.leerPropiedad(mensajeGcFail)
					+ " desde la ruta " + ConfigurationManager.GC_PATH);
			e.printStackTrace();
		} catch (Throwable t) {

			System.out.println(ConfigurationManager
					.leerPropiedad(mensajeGcFail)
					+ " desde la ruta " + ConfigurationManager.GC_PATH);
			t.printStackTrace();
		}
	}

	public static String[][] loadComboBoxFromFile(File f) {
		String[][] resultado = null;

		try {
			DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
			Document doc = docBuilder.parse(f);
			NodeList listOfElements = doc.getElementsByTagName("Row");
			int numElementos = listOfElements.getLength();
			System.out.println("Cargando los datos del fichero " + f.getName()
					+ "(" + numElementos + " elementos)");
			
			resultado = new String[numElementos][2];

			for (int s = 0; s < listOfElements.getLength(); s++) {

				Node nodo = listOfElements.item(s);
				Element elemento = (Element) nodo;  
				
				NodeList contenido = elemento.getElementsByTagName("Value");
				Element valorCodigo = null;
				Element valorNombre=null;
				Element valorName=null;
				
				for (int i = 0; i < contenido.getLength(); i++) {
				
					Element elementoActual=(Element)contenido.item(i);
					
					if (elementoActual.getAttribute("ColumnRef").equalsIgnoreCase("code")) {
						// Codigo
						NodeList cnl = elementoActual.getElementsByTagName("SimpleValue");
						valorCodigo = (Element) cnl.item(0);
					} else if (elementoActual.getAttribute("ColumnRef").equalsIgnoreCase("nombre")) {
						//Nombre en espaol
						NodeList nnl = elementoActual.getElementsByTagName("SimpleValue");
						valorNombre = (Element) nnl.item(0); 
					}
					else if (elementoActual.getAttribute("ColumnRef").equalsIgnoreCase("name")) {
						//Nombre en ingls
						NodeList nnl = elementoActual.getElementsByTagName("SimpleValue");
						valorName = (Element) nnl.item(0); 
					}
				}				

				resultado[s][0]=valorNombre.getFirstChild().getNodeValue();
				resultado[s][1]=valorCodigo.getFirstChild().getNodeValue();
			}
		} catch (Exception e) {
			System.out.println("Error cargando los datos del fichero " + f.getName());
		}

		return resultado;
	}
	
	
	
	/**
	 * El mtodo recupera los valores de una lista de constantes que cumplen un criterio y las almacena en un combobox.
	 * El criterio consiste en que los cdigos de la lista comiencen por la cadena clave que se recibe como parmetro
	 * @param combo combobox en el que se almacen los valores.
	 * @param constant lista de constantes que se van a leer
	 * @param clave cadena por la que deben empezar las claves de los valorees que se van a almacenar
	 */
	
	public static void loadComboBoxFromConstantDiscrimacion(JComboBox<String> combo, String constant, String clave){
		String nombre=null;
		if (constant.lastIndexOf("/")==-1){
			nombre=constant.substring(constant.lastIndexOf(":")+1)+".gc";
		}else{
			nombre=constant.substring(constant.lastIndexOf("/")+1);
		}
		String names[]= ComboBoxUtils.getNamesFromComboBox(nombre);
		String values[] = ComboBoxUtils.getValuesFromComboBox(nombre);
		if (values==null){
			System.out.println("El combo '"+nombre+"' viene nulo");
		}else{
			for (int i=0;i<values.length;i++){
				if (values[i].startsWith(clave)){
					combo.addItem(names[i] + " (" + values[i] + ")");
				}	
			}
		}
	}
}
