/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.utils;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public class ConfigurationManager {

	public static final String CONFIG_PATH = "config/configuracion.properties";
	public static final String BP_PATH = "config/contractingPartyDefault.properties";
	public static final String CONNECTION_PATH = "config/connection.properties";
	public static final String SECURITY_PATH = "config/client-security-env.properties";
	
	public static final String DATA_PATH = "data";
	public static final String GC_PATH= "data/gc";

	public static final String UBL_VERSION = "ubl.version";
	public static final String CODICE_VERSION = "codice.version";
	public static final String CODICE_PROFILE_VERSION = "codice.profile.version";
	
	private static final String mensajeConfigOk="mensajeConfigOk";
	private static final String mensajeConfigFail="mensajeConfigFail";
	
	private static Properties configuracion = new Properties();
	private static Properties infoBP = new Properties();
	private static Properties security = new Properties();
	private static Properties connection = new Properties();
	
	private static ConfigurationManager instance = null;

	public static String leerPropiedad(String propiedad){
		String resultado = "Propiedad inexistente en el archivo de configuracin";
		try {
			resultado = (String) getConfiguracion().get(propiedad);
		} catch (Exception e) {
            System.out.println("No se ha encontrado la propiedad "+propiedad);
		}
		return resultado;
	}

	public static String leerPropiedadSecurity(String propiedad){
		String resultado = "Propiedad inexistente en el archivo de configuracin de seguridad";
		try {
			resultado = (String) getSecurity().get(propiedad);
		} catch (Exception e) {
            System.out.println("No se ha encontrado la propiedad "+propiedad);
		}
		return resultado;
	}
	
	public static String leerPropiedadConnection(String propiedad){
		String resultado = "Propiedad inexistente en el archivo de configuracin de conectividad";
		try {
			resultado = (String) getConnection().get(propiedad);
		} catch (Exception e) {
            System.out.println("No se ha encontrado la propiedad "+propiedad);
		}
		return resultado;
	}
	
	public static String leerPropiedadBP(String propiedad){
		String resultado = "Propiedad inexistente en el archivo de configuracin del rgano de Contratacin";
		try {
			resultado = (String) getDefaultBP().get(propiedad);
			resultado= new String(resultado.getBytes("UTF-8"),"UTF-8");
		} catch (Exception e) {
            System.out.println("No se ha encontrado la propiedad "+propiedad);
		}
		return resultado;
	}
	
	public static Properties getSecurity(){
		return security;
	}
	public static Properties getConnection(){
		return connection;
	}
	
	public static Properties getDefaultBP(){
		return infoBP;
	}
	public static Properties getConfiguracion() {
		return configuracion;
	}

	public static ConfigurationManager getInstance() {
		if (instance == null)
			instance = new ConfigurationManager();
		return instance;
	}

	private ConfigurationManager() {

		try { 
			InputStream is = null;
			configuracion = new Properties();
			is = new BufferedInputStream(new FileInputStream(CONFIG_PATH));
			configuracion.load(is); 
			
			InputStream is2=null;
            infoBP=new Properties();
            is2=new BufferedInputStream(new FileInputStream(BP_PATH));
            infoBP.load(is2);
            
            
            InputStream is3=null;
            connection=new Properties();
            is3=new BufferedInputStream(new FileInputStream(CONNECTION_PATH));
            connection.load(is3);
            
            InputStream is4=null;
            security=new Properties();
            is4=new BufferedInputStream(new FileInputStream(SECURITY_PATH));
            security.load(is4);
            
			System.out.println(ConfigurationManager.leerPropiedad(mensajeConfigOk)+" desde la ruta "+CONFIG_PATH);
		} catch (Exception e) {
			
			System.out.println(ConfigurationManager.leerPropiedad(mensajeConfigFail));
			e.printStackTrace();
		} catch (Throwable t) {	
			
			System.out.println(ConfigurationManager.leerPropiedad(mensajeConfigFail));
			t.printStackTrace();
		}
	}
}
