/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.utils;

import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSProcessor;
import com.sun.xml.wss.XWSSProcessorFactory;

public class FirmarServicioPublicacionHandler implements
SOAPHandler<SOAPMessageContext> { 

	public Set<QName> getHeaders() {

		QName securityHeader = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse");
        HashSet<QName> headers = new HashSet<QName>();
        headers.add(securityHeader);
        return headers;

		
	}
	public boolean handleMessage(SOAPMessageContext context) {

		try {

			Boolean outboundProperty = (Boolean) context

			.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

			if (outboundProperty.booleanValue()) 
			{  
				System.out.println("\nOutbound message:");
				context.setMessage(obtenerMensajeFirmado(context.getMessage()));	
				ClienteLlamadas.setMensajeEnviado(context.getMessage());
			}
			else {
				System.out.println("\nInbound message:");
				context.getMessage().writeTo(System.out);
				ClienteLlamadas.setMensajeRecibido(context.getMessage());
			}
				
			
			
			
		}catch(Exception ex)
		{
			ex.printStackTrace();

		}

		return true;

	}

	public boolean handleFault(SOAPMessageContext arg0) {

		return false;

	}

	public void close(MessageContext arg0) {

	}

	private SOAPMessage obtenerMensajeFirmado (SOAPMessage msg)
	{

		SOAPMessage secureMsg = null;
		FileInputStream clientConfig = null;
		
		try {
			//read client side security configuration
			clientConfig = new java.io.FileInputStream("./etc/client_security_config.xml");


			//Create a XWSSProcessFactory.
			XWSSProcessorFactory factory = XWSSProcessorFactory.newInstance();

			//Create XWSSProcessor to secure out going soap messages.
			//Sample SecurityEnvironment is configured to
			//use client side keystores.

			XWSSProcessor cprocessor =
				factory.createProcessorForSecurityConfiguration(
						clientConfig, new SecurityEnvironmentHandler("client"));

			clientConfig.close();


			//Create processing context and set the soap
			//message to be processed.
			ProcessingContext context = new ProcessingContext();
			context.setSOAPMessage(msg);

			//secure the message.
			secureMsg = cprocessor.secureOutboundMessage(context);

		}catch (Exception ex)
		{
			ex.printStackTrace();
		}

		return secureMsg;

	}

}
