/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.utils;


import es.dgpe.place.client.beans.AnularAnuncioBean;
import es.dgpe.place.client.beans.AnularDocumentoBean;
import es.dgpe.place.client.beans.ConsultaBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.OrganoContratacionBean;
import es.dgpe.place.client.beans.UtilidadesBean;

public class SessionDataManager {

	private static SessionDataManager instance = null;

	private static OrganoContratacionBean organoContratacion = null;
	private static ExpedienteBean expedienteBean = null;


	public static void setInstance(SessionDataManager instance) {
		SessionDataManager.instance = instance;
	}


	private static ConsultaBean datosConsulta = null;
	private static UtilidadesBean datosUtilidades = null;
	private static AnularAnuncioBean anularAnuncio=null;
	

	public static void setAnularDocumento(AnularDocumentoBean anularDocumento) {
		SessionDataManager.anularDocumento = anularDocumento;
	}

	private static AnularDocumentoBean anularDocumento=null;

	public static UtilidadesBean getDatosUtilidades() {
		return datosUtilidades;
	}

	public static void setDatosUtilidades(UtilidadesBean datosUtilidades) {
		SessionDataManager.datosUtilidades = datosUtilidades;
	}

	public static ConsultaBean getDatosConsulta() {
		return datosConsulta;
	}

	public static void setDatosConsulta(ConsultaBean datosConsulta) {
		SessionDataManager.datosConsulta = datosConsulta;
	}

	public static SessionDataManager getInstance() {
		if (instance == null)
			instance = new SessionDataManager();
		return instance;
	}

	public static OrganoContratacionBean getOrganoContratacion() {
		return organoContratacion;
	}

	public static void setOrganoContratacion(
			OrganoContratacionBean organoContratacion) {
		SessionDataManager.organoContratacion = organoContratacion;
	}

	public static ExpedienteBean getExpediente() {
		return expedienteBean;
	}

	public static void setExpediente(ExpedienteBean expediente) {
		SessionDataManager.expedienteBean = expediente;
	}
	
	public static AnularAnuncioBean getAnularAnuncio() {
		return anularAnuncio;
	}

	public static void setAnularAnuncio(AnularAnuncioBean anularAnuncio) {
		SessionDataManager.anularAnuncio = anularAnuncio;
	}

	public static AnularDocumentoBean getAnularDocumento() {
		return anularDocumento;
	}

	private SessionDataManager() {

		try {
			organoContratacion = new OrganoContratacionBean();
			expedienteBean = new ExpedienteBean();
			datosConsulta = new ConsultaBean();
			datosUtilidades=new UtilidadesBean();
			
		} catch (Exception e) {

			e.printStackTrace();
		} catch (Throwable t) {

			t.printStackTrace();
		}
	}

}
