/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.utils.documentsgenerator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;

import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.dgpe.codice.common.caclib.AddressLineType;
import org.dgpe.codice.common.caclib.AddressType;
import org.dgpe.codice.common.caclib.AttachmentType;
import org.dgpe.codice.common.caclib.AttendanceConditionsType;
import org.dgpe.codice.common.caclib.AuctionTermsType;
import org.dgpe.codice.common.caclib.BudgetAmountType;
import org.dgpe.codice.common.caclib.ClassificationCategoryType;
import org.dgpe.codice.common.caclib.ClassificationSchemeType;
import org.dgpe.codice.common.caclib.CommodityClassificationType;
import org.dgpe.codice.common.caclib.ContactType;
import org.dgpe.codice.common.caclib.ContractExecutionRequirementType;
import org.dgpe.codice.common.caclib.ContractModificationType;
import org.dgpe.codice.common.caclib.ContractType;
import org.dgpe.codice.common.caclib.ContractingPartyType;
import org.dgpe.codice.common.caclib.CountryType;
import org.dgpe.codice.common.caclib.DocumentReferenceType;
import org.dgpe.codice.common.caclib.EventType;
import org.dgpe.codice.common.caclib.InvoicingTermsType;
import org.dgpe.codice.common.caclib.LegalMonetaryTotalType;
import org.dgpe.codice.common.caclib.LocationType;
import org.dgpe.codice.common.caclib.PartyIdentificationType;
import org.dgpe.codice.common.caclib.PartyNameType;
import org.dgpe.codice.common.caclib.PartyType;
import org.dgpe.codice.common.caclib.PeriodType;
import org.dgpe.codice.common.caclib.PersonType;
import org.dgpe.codice.common.caclib.ProcessJustificationType;
import org.dgpe.codice.common.caclib.ProcurementProjectType;
import org.dgpe.codice.common.caclib.TenderResultType;
import org.dgpe.codice.common.caclib.TenderedProjectType;
import org.dgpe.codice.common.caclib.TendererQualificationRequestType;
import org.dgpe.codice.common.caclib.TenderingProcessType;
import org.dgpe.codice.common.caclib.TenderingTermsType;
import org.dgpe.codice.common.cbclib.AbnormallyLowTendersIndicatorType;
import org.dgpe.codice.common.cbclib.AcceleratedProcedureJustificationType;
import org.dgpe.codice.common.cbclib.ActivityCodeType;
import org.dgpe.codice.common.cbclib.AddressFormatCodeType;
import org.dgpe.codice.common.cbclib.AgencyNameType;
import org.dgpe.codice.common.cbclib.AttendanceConditionsDescriptionType;
import org.dgpe.codice.common.cbclib.AttendanceRestrictionCodeType;
import org.dgpe.codice.common.cbclib.AuctionConstraintIndicatorType;
import org.dgpe.codice.common.cbclib.AwardDateType;
import org.dgpe.codice.common.cbclib.CandidateReductionConstraintIndicatorType;
import org.dgpe.codice.common.cbclib.CityNameType;
import org.dgpe.codice.common.cbclib.CodeValueType;
import org.dgpe.codice.common.cbclib.ContractIDType;
import org.dgpe.codice.common.cbclib.ContractModificationDurationMeasureType;
import org.dgpe.codice.common.cbclib.ContractModificationJustificationType;
import org.dgpe.codice.common.cbclib.ContractModificationReasonCodeType;
import org.dgpe.codice.common.cbclib.ContractingPartyTypeCodeType;
import org.dgpe.codice.common.cbclib.ContractingSystemCodeType;
import org.dgpe.codice.common.cbclib.CountrySubentityCodeType;
import org.dgpe.codice.common.cbclib.CountrySubentityType;
import org.dgpe.codice.common.cbclib.CustomizationIDType;
import org.dgpe.codice.common.cbclib.DescriptionType;
import org.dgpe.codice.common.cbclib.DocumentTypeCodeType;
import org.dgpe.codice.common.cbclib.DocumentTypeType;
import org.dgpe.codice.common.cbclib.DurationMeasureType;
import org.dgpe.codice.common.cbclib.EUNationalsReceivedTenderQuantityType;
import org.dgpe.codice.common.cbclib.EcatalogIndicatorType;
import org.dgpe.codice.common.cbclib.ElectronicInvoicingIndicatorType;
import org.dgpe.codice.common.cbclib.ElectronicMailType;
import org.dgpe.codice.common.cbclib.EmbeddedDocumentBinaryObjectType;
import org.dgpe.codice.common.cbclib.EndDateType;
import org.dgpe.codice.common.cbclib.EndTimeType;
import org.dgpe.codice.common.cbclib.EorderingIndicatorType;
import org.dgpe.codice.common.cbclib.EpaymentMeansIndicatorType;
import org.dgpe.codice.common.cbclib.EstimatedOverallContractAmountType;
import org.dgpe.codice.common.cbclib.ExecutionRequirementCodeType;
import org.dgpe.codice.common.cbclib.ExpenseCodeType;
import org.dgpe.codice.common.cbclib.FinalDurationMeasureType;
import org.dgpe.codice.common.cbclib.GovernmentProcurementAgreementConstraintIndicatorType;
import org.dgpe.codice.common.cbclib.IDType;
import org.dgpe.codice.common.cbclib.IdentificationCodeType;
import org.dgpe.codice.common.cbclib.IdentificationIDType;
import org.dgpe.codice.common.cbclib.IssueDateType;
import org.dgpe.codice.common.cbclib.IssueTimeType;
import org.dgpe.codice.common.cbclib.ItemClassificationCodeType;
import org.dgpe.codice.common.cbclib.JobTitleType;
import org.dgpe.codice.common.cbclib.LanguageIDType;
import org.dgpe.codice.common.cbclib.LineType;
import org.dgpe.codice.common.cbclib.LotsCombinationContractingAuthorityRightsType;
import org.dgpe.codice.common.cbclib.MaximumLotPresentationQuantityType;
import org.dgpe.codice.common.cbclib.MaximumTendererAwardedLotsQuantityType;
import org.dgpe.codice.common.cbclib.NameType;
import org.dgpe.codice.common.cbclib.NonEUNationalsReceivedTenderQuantityType;
import org.dgpe.codice.common.cbclib.NoteType;
import org.dgpe.codice.common.cbclib.OccurrenceDateType;
import org.dgpe.codice.common.cbclib.OccurrenceTimeType;
import org.dgpe.codice.common.cbclib.OriginCountryCodeType;
import org.dgpe.codice.common.cbclib.PartPresentationCodeType;
import org.dgpe.codice.common.cbclib.PayableAmountType;
import org.dgpe.codice.common.cbclib.PostalZoneType;
import org.dgpe.codice.common.cbclib.ProcedureCodeType;
import org.dgpe.codice.common.cbclib.ProfileIDType;
import org.dgpe.codice.common.cbclib.ReasonCodeType;
import org.dgpe.codice.common.cbclib.ReceivedElectronicTenderQuantityType;
import org.dgpe.codice.common.cbclib.ReceivedTenderQuantityType;
import org.dgpe.codice.common.cbclib.RestrictedProcurementDocumentsJustificationType;
import org.dgpe.codice.common.cbclib.ResultCodeType;
import org.dgpe.codice.common.cbclib.SMEAwardedIndicatorType;
import org.dgpe.codice.common.cbclib.SMEsReceivedTenderQuantityType;
import org.dgpe.codice.common.cbclib.SchemeURIType;
import org.dgpe.codice.common.cbclib.StartDateType;
import org.dgpe.codice.common.cbclib.SubTypeCodeType;
import org.dgpe.codice.common.cbclib.SubmissionMethodCodeType;
import org.dgpe.codice.common.cbclib.TaxExclusiveAmountType;
import org.dgpe.codice.common.cbclib.TelefaxType;
import org.dgpe.codice.common.cbclib.TelephoneType;
import org.dgpe.codice.common.cbclib.TotalAmountType;
import org.dgpe.codice.common.cbclib.TypeCodeType;
import org.dgpe.codice.common.cbclib.UBLVersionIDType;
import org.dgpe.codice.common.cbclib.URIType;
import org.dgpe.codice.common.cbclib.UUIDType;
import org.dgpe.codice.common.cbclib.UrgencyCodeType;
import org.dgpe.codice.common.cbclib.VersionIDType;
import org.oasis.ubl.codelist.currencycode.CurrencyCodeContentType;
import org.oasis.ubl.codelist.mimemediatypecode.BinaryObjectMimeCodeContentType;
import org.oasis.ubl.codelist.unitcode.UnitCodeContentType;
import org.oasis.ubl.common.udt.CodeType;

import com.sun.xml.internal.ws.api.message.Attachment;

import es.dgpe.place.client.beans.CondicionesEjecucionBean;
import es.dgpe.place.client.beans.DatosModificacionBean;
import es.dgpe.place.client.beans.EventoAperturaBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.OrganoContratacionBean;
import es.dgpe.place.client.beans.codice.Code;
import es.dgpe.place.client.beans.codice.Contractingauthorityparty;
import es.dgpe.place.client.beans.codice.Documentreference;
import es.dgpe.place.client.beans.codice.Event;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.utils.CODICESerializing;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.ConfigurationManager;
import es.dgpe.place.client.utils.SessionDataManager;

public class DocumentGeneratorCommon {

	protected static CODICESerializing mapper = null;
	protected static ConfigurationManager cm = null;

	// Instancia del Serializador de CODICE a XML
	protected static CODICESerializing cs = CODICESerializing.getInstance();

	protected static Object getObjectFromSet(Set conjunto) {

		if (conjunto != null && conjunto.size() > 0)
			return conjunto.iterator().next();

		return null;
	}

	protected static EmbeddedDocumentBinaryObjectType createEmbeddedDocument(
			Attachment att, String url) {
		EmbeddedDocumentBinaryObjectType emb = null;
		try {
			emb = cs.getCbcFactory().createEmbeddedDocumentBinaryObjectType();

		} catch (Exception e) {
			e.printStackTrace();
		}
		return emb;
	}

	protected static DocumentReferenceType createDocumentReference(
			Documentreference document, String url, String name) {
		DocumentReferenceType dr = null;
		try {

			
			dr = cs.getCacFactory().createDocumentReferenceType();
			


			IDType id = cs.getCbcFactory().createIDType();
			id.setValue(url.substring(url.lastIndexOf(File.separator) + 1));

			dr.setID(id);

			IssueDateType issueDate = cs.getCbcFactory().createIssueDateType();
			issueDate.setValue(datetoXMLGregorianCalendar(new Date()));

			IssueTimeType issueTime = cs.getCbcFactory().createIssueTimeType();
			issueTime.setValue(timetoXMLGregorianCalendar(new Date()));

			dr.setIssueDate(issueDate);
			dr.setIssueTime(issueTime);

			Code tipoDOC = new Code();
			DocumentTypeCodeType tct = cs.getCbcFactory()
					.createDocumentTypeCodeType();
			tipoDOC.setDescription(document.getDocumenttypecode()
					.getDescription());
			tipoDOC.setListVersionId(document.getDocumenttypecode().getListVersionId());
			tipoDOC.setCodevalue(document.getDocumenttypecode().getCodevalue());

			code2Codice(document.getDocumenttypecode(), tct);

			tct.setLanguageID(ConstantsGC.LANGUAGE_ID);
			tct.setListURI(document.getDocumenttypecode().getListUri());
			tct.setName(document.getDocumenttypecode().getDescription());
			tct.setListName("Tipo de documento");
			tct.setListVersionID(document.getDocumenttypecode().getListVersionId());
			tct.setListSchemeURI(document.getDocumenttypecode().getListUri());
			tct.setValue(document.getDocumenttypecode().getCodevalue());

			dr.setDocumentTypeCode(tct);

			if (document.getDocumenttypecode()!=null&&
					document.getDocumenttypecode().getCodevalue()!=null&&
					document.getDocumenttypecode().getCodevalue().equalsIgnoreCase(
					"ZZZ")) {
				DocumentTypeType docType = cs.getCbcFactory()
						.createDocumentTypeType();
				docType.setValue(name);
				dr.setDocumentType(docType);
			}
			AttachmentType att = cs.getCacFactory().createAttachmentType();

			EmbeddedDocumentBinaryObjectType emb = cs.getCbcFactory()
					.createEmbeddedDocumentBinaryObjectType();
			emb.setMimeCode(BinaryObjectMimeCodeContentType.fromValue("application/octet-stream"));
			emb.setFilename(url.substring(url.lastIndexOf(File.separator) + 1));
			
			if (url.length() > 0){
    			try {
    				File fichero = new File(url);
    
    				FileInputStream fin = null;
    				fin = new FileInputStream(fichero);
    				long length = fichero.length();
    				 
    				if (length > Integer.MAX_VALUE) {
    					throw new IOException("Tamao del fichero excesivo: "  + length);
    				}
    //				Create the byte array
    				byte[] bytes = new byte[(int)length];
    				 
    //				Reads the file content
    				int offset = 0;
    				int numRead = 0;
    				while (offset < bytes.length
    					   && (numRead=fin.read(bytes, offset, bytes.length-offset)) >= 0) {
    					offset += numRead;
    				}
    				 
    //				Just to check if file was read completely
    				if (offset < bytes.length) {
    					throw new IOException("No se ha podido leer completamente el fichero " + fichero.getName());
    				}
    				 
    //				Close the input stream, all file contents are in the bytes variable
    				fin.close();
    				// assign the byte array to the embedded document
    				emb.setValue(bytes);
    				
    			} catch (Exception e) {
    				e.printStackTrace();
    			}
			}

			att.setEmbeddedDocumentBinaryObject(emb);

			dr.setAttachment(att);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return dr;
	}

	protected static Calendar datetoCalendar(Date fecha) {
		if (fecha == null)
			return null;

		Calendar res = Calendar.getInstance();
		res.setTime(fecha);
		return res;
	}

	protected static XMLGregorianCalendar datetoXMLGregorianCalendar(Date fecha) {
		XMLGregorianCalendar res = null;
		if (fecha == null)
			return null;
		try {
			Calendar c = new GregorianCalendar();
			c.setTime(fecha);
			int month = c.get(Calendar.MONTH) + 1;
			int day = c.get(Calendar.DAY_OF_MONTH);
			int year = c.get(Calendar.YEAR);

			DatatypeFactory df = DatatypeFactory.newInstance();
			res = df.newXMLGregorianCalendarDate(year, month, day, c
					.getTimeZone().getOffset(fecha.getTime())
					/ (60 * 1000));

		} catch (Exception ex) {
			ex.printStackTrace();
		}

		return res;
	}

	protected static XMLGregorianCalendar timetoXMLGregorianCalendar(Date fecha) {
		XMLGregorianCalendar res = null;
		if (fecha == null)
			return null;
		try {
			Calendar c = new GregorianCalendar();
			c.setTime(fecha);
			int hour = c.get(Calendar.HOUR);
			int minute = c.get(Calendar.MINUTE);
			int second = c.get(Calendar.SECOND);

			DatatypeFactory df = DatatypeFactory.newInstance();
			res = df.newXMLGregorianCalendarTime(hour, minute, second, c
					.getTimeZone().getOffset(fecha.getTime())
					/ (60 * 1000));
			res.setHour(c.get(Calendar.HOUR_OF_DAY));
			res.setMinute(c.get(Calendar.MINUTE));
			res.setSecond(c.get(Calendar.SECOND));

		} catch (Exception ex) {
			ex.printStackTrace();
		}

		return res;

	}

	protected static Date XMLGregorianCalendartoDate(XMLGregorianCalendar objeto) {
		if (objeto == null)
			return null;

		Date fecha = new Date();
		fecha.setDate(objeto.getDay());
		fecha.setMonth(objeto.getMonth());
		fecha.setYear(objeto.getYear());

		return fecha;

	}

	protected static Date XMLGregorianCalendartoTime(XMLGregorianCalendar objeto) {
		if (objeto == null)
			return null;

		Date fecha = new Date();
		fecha.setHours(objeto.getHour());
		fecha.setMinutes(objeto.getMinute());
		fecha.setSeconds(objeto.getSecond());

		return fecha;

	}

	protected static ProcurementProjectType crearProcurementProject(
			Code tipoContrato, Code subtipoContrato, String nombreContrato,
			Code cpv, BigDecimal sinImpuestos, BigDecimal conImpuestos, Code pais, Code nuts)
			throws JAXBException {
		
		BigDecimal valorEstimado=null;
		return crearProcurementProject(tipoContrato, subtipoContrato, nombreContrato,
			cpv, sinImpuestos, conImpuestos,valorEstimado, pais, nuts);
	}
	
	protected static ProcurementProjectType crearProcurementProject(
			Code tipoContrato, Code subtipoContrato, String nombreContrato,
			Code cpv, BigDecimal sinImpuestos, BigDecimal conImpuestos,BigDecimal valorEstimado, Code pais, Code nuts)
			throws JAXBException {
		
		CondicionesEjecucionBean duracionContrato=null;
		return crearProcurementProject(tipoContrato, subtipoContrato, nombreContrato,
			cpv, sinImpuestos, conImpuestos,valorEstimado, duracionContrato, pais, nuts);
	}
	
	protected static ProcurementProjectType crearProcurementProject(
			Code tipoContrato, Code subtipoContrato, String nombreContrato,
			Code cpv, BigDecimal sinImpuestos, BigDecimal conImpuestos,BigDecimal valorEstimado,
			CondicionesEjecucionBean duracionContrato, Code pais, Code nuts)
			throws JAXBException {

		ProcurementProjectType res = cs.getCacFactory()
				.createProcurementProjectType();

		// Nombre del contrato
		if (nombreContrato != null) {
			NameType nameType = cs.getCbcFactory().createNameType();
			nameType.setValue(nombreContrato);
			res.getName().add(nameType);
		}

		// Tipo de Contrato(TENDERING_CONTRACT)
		if (tipoContrato != null) {
			TypeCodeType tct = cs.getCbcFactory().createTypeCodeType();
			tipoContrato.setDescription(tipoContrato.getDescription());
			tipoContrato.setListVersionId(tipoContrato.getListVersionId());
			tipoContrato.setCodevalue(tipoContrato.getCodevalue());
			tct.setLanguageID(ConstantsGC.LANGUAGE_ID);
			tct.setListURI(tipoContrato.getListUri());
			tct.setName(tipoContrato.getDescription());
			tct.setListName("Tipo de Contrato");
			tct.setListVersionID(tipoContrato.getListVersionId());
			tct.setListSchemeURI(tipoContrato.getListUri());
			tct.setValue(tipoContrato.getCodevalue());
			code2Codice(tipoContrato, tct);
			res.setTypeCode(tct);
		}

		// Subtipo de Contrato(WORKS_CONTRACT)
		if (subtipoContrato != null) {
			SubTypeCodeType stct = cs.getCbcFactory().createSubTypeCodeType();
			subtipoContrato.setDescription(subtipoContrato.getDescription());
			subtipoContrato.setListVersionId(subtipoContrato.getListVersionId());
			subtipoContrato.setCodevalue(subtipoContrato.getCodevalue());
			subtipoContrato.setListUri(subtipoContrato.getListUri());
			stct.setListName("Subtipo de Contrato");
			stct.setListVersionID(subtipoContrato.getListVersionId());
			stct.setListSchemeURI(subtipoContrato.getListUri());
			stct.setLanguageID(ConstantsGC.LANGUAGE_ID);
			stct.setValue(subtipoContrato.getCodevalue());
			code2Codice(subtipoContrato, stct);
			res.setSubTypeCode(stct);
		}

		//Importes
		if (sinImpuestos != null || conImpuestos != null ||valorEstimado !=null) {
			BudgetAmountType ba = cs.getCacFactory().createBudgetAmountType();
			
			if ( conImpuestos!= null) {
				TotalAmountType totalAmountType = cs.getCbcFactory()
						.createTotalAmountType();
				totalAmountType.setValue(conImpuestos);
				totalAmountType.setCurrencyID(CurrencyCodeContentType.EUR);
				ba.setTotalAmount(totalAmountType);
			}

			if ( sinImpuestos!= null) {
				TaxExclusiveAmountType amountType = cs.getCbcFactory()
						.createTaxExclusiveAmountType();
				amountType.setValue(sinImpuestos);
				amountType.setCurrencyID(CurrencyCodeContentType.EUR);
				ba.setTaxExclusiveAmount(amountType);
			}
			
			if ( valorEstimado!= null) {
				EstimatedOverallContractAmountType amountType = cs.getCbcFactory().createEstimatedOverallContractAmountType();
				amountType.setValue(valorEstimado);
				amountType.setCurrencyID(CurrencyCodeContentType.EUR);
				ba.setEstimatedOverallContractAmount(amountType);
			}
			res.setBudgetAmount(ba);
		}
		//CPV
		if (cpv != null) {
			CommodityClassificationType comm = cs.getCacFactory()
					.createCommodityClassificationType();
			ItemClassificationCodeType itc = cs.cbcFactory
					.createItemClassificationCodeType();

			itc.setLanguageID(ConstantsGC.LANGUAGE_ID);
			itc.setListVersionID(cpv.getListVersionId());
			itc.setListName("CPV");
			itc.setListURI(cpv.getListUri());
			itc.setListSchemeURI(cpv.getListUri());
			itc.setName("CPV");
			itc.setValue(cpv.getCodevalue());
			cpv.setListUri(cpv.getListUri());
			cpv.setListVersionId(cpv.getListVersionId());
			asignarCode(itc, cpv);
			comm.setItemClassificationCode((itc));
			res.getRequiredCommodityClassification().add(comm);
		}
		
		LocationType location = CODICESerializing.getCacFactory().createLocationType();
		if(pais != null){
			CountrySubentityType countrySubentity = CODICESerializing.getCbcFactory().createCountrySubentityType();
			countrySubentity.setValue(nuts.getDescription());
			location.setCountrySubentity(countrySubentity);
	
			AddressType addressType = CODICESerializing.getCacFactory().createAddressType();
			CountryType countryType = CODICESerializing.getCacFactory().createCountryType();
			IdentificationCodeType identificationCodeType = CODICESerializing.getCbcFactory().createIdentificationCodeType();
			
			identificationCodeType.setValue(pais.getCodevalue());
			identificationCodeType.setListURI(pais.getListUri());
			identificationCodeType.setName(pais.getDescription());
			identificationCodeType.setListVersionID(pais.getListVersionId());	
			countryType.setIdentificationCode(identificationCodeType);
			
			NameType nameType = CODICESerializing.getCbcFactory().createNameType();
			nameType.setValue(pais.getDescription());
			countryType.setName(nameType);
			
			addressType.setCountry(countryType);
			
			
			location.setAddress(addressType);
		}
		
		if (nuts != null){
			CountrySubentityCodeType countryCode = CODICESerializing.getCbcFactory().createCountrySubentityCodeType();
			countryCode.setListURI(nuts.getListUri());
			countryCode.setValue(nuts.getCodevalue());
			location.setCountrySubentityCode(countryCode);
		}
		
		
		
	
			
		res.setRealizedLocation(location);

		
		//Duracion del contrato
		if (duracionContrato!=null){
			PeriodType plannedPeriod=crearPlannedPeriod(duracionContrato);
			res.setPlannedPeriod(plannedPeriod);
		}

		return res;
	}

	
	
	
	//Para poder incluir la justificacion de no publicacion de pliegos y las condiciones de ejecucion en el caso del anuncio de licitacin
	protected static TenderingTermsType crearTenderingTerms(int clasificacion,
			String solvencia, Contractingauthorityparty datosOC, int idDirectiva, String justifNoPubPliegos, CondicionesEjecucionBean condicionesEjecucion, int indicadorCatalogoElectronico) {
		TenderingTermsType res=crearTenderingTerms(clasificacion,solvencia,datosOC,idDirectiva);
		
		if (justifNoPubPliegos!=null)
			if(justifNoPubPliegos.length()>0){
				RestrictedProcurementDocumentsJustificationType justifNoPubPliegoType=cs.getCbcFactory().createRestrictedProcurementDocumentsJustificationType();
				justifNoPubPliegoType.setValue(justifNoPubPliegos);
				res.getRestrictedProcurementDocumentsJustification().add(justifNoPubPliegoType);}
		
		EcatalogIndicatorType catalogoElectronico=cs.getCbcFactory().createEcatalogIndicatorType();
		switch(indicadorCatalogoElectronico){
		case 0:
				
				catalogoElectronico.setValue(true);
				res.setEcatalogIndicator(catalogoElectronico);
				break;
		case 1:
				catalogoElectronico.setValue(false);
				res.setEcatalogIndicator(catalogoElectronico);
				break;

		}
		
		if(condicionesEjecucion!=null){
			EorderingIndicatorType eOrdering=cs.getCbcFactory().createEorderingIndicatorType();
			EpaymentMeansIndicatorType ePayment=cs.getCbcFactory().createEpaymentMeansIndicatorType();
			InvoicingTermsType invoicingTerms=cs.getCacFactory().createInvoicingTermsType();
			ElectronicInvoicingIndicatorType eInvoicing=cs.getCbcFactory().createElectronicInvoicingIndicatorType();
			
			
			switch (condicionesEjecucion.getPedidoElectronico()){
		
				case 0: eOrdering.setValue(true);
						res.setEorderingIndicator(eOrdering);
						break;
						
				case 1: eOrdering.setValue(false);
						res.setEorderingIndicator(eOrdering);		
						break;	
			}
			
			switch (condicionesEjecucion.getFacturaElectronica()){
			
	
			case 0: eInvoicing.setValue(true);
					invoicingTerms.setElectronicInvoicingIndicator(eInvoicing);
					res.setInvoicingTerms(invoicingTerms);
					break;
					
			case 1: eOrdering.setValue(false);
					invoicingTerms.setElectronicInvoicingIndicator(eInvoicing);
					res.setInvoicingTerms(invoicingTerms);
					break;	
			}
			
			switch (condicionesEjecucion.getPagoElectronico()){
			
		
			case 0: ePayment.setValue(true);
					res.setEpaymentMeansIndicator(ePayment);
					break;
					
			case 1: ePayment.setValue(false);
					res.setEpaymentMeansIndicator(ePayment);		
					break;	
		}
			
			
			
			
			if (condicionesEjecucion.getCombatirParo()!=null)
				if (condicionesEjecucion.getCombatirParo().length()>0){
					ContractExecutionRequirementType combatirParo=cs.getCacFactory().createContractExecutionRequirementType();
					
					ExecutionRequirementCodeType codigoCondicionEjecucion = cs.getCbcFactory().createExecutionRequirementCodeType();
					DescriptionType descripcion= cs.getCbcFactory().createDescriptionType();
					 
					//Tipo de condicion de ejecucion
					String idTipoCondicionCombatirParo=ComboBoxUtils.getComboBoxByConstant(ConstantsGC.EXECUTIONREQUIREMENTCODE)[5][1];
					Code tipoCondicionCombatirParo = crearCode("5","Combatir el paro",ConstantsGC.EXECUTIONREQUIREMENTCODE,ConstantsGC.EXECUTIONREQUIREMENTCODE_VER);
					
					asignarCode(codigoCondicionEjecucion,tipoCondicionCombatirParo);
					descripcion.setValue(condicionesEjecucion.getCombatirParo());
					
					
					combatirParo.setExecutionRequirementCode(codigoCondicionEjecucion);
					combatirParo.getDescription().add(descripcion);
					
					res.getContractExecutionRequirement().add(combatirParo);
				}
			
			if (condicionesEjecucion.getConsideracionesAmbientales()!=null)
				if (condicionesEjecucion.getConsideracionesAmbientales().length()>0){
					ContractExecutionRequirementType consideracionesAmbientales=cs.getCacFactory().createContractExecutionRequirementType();

					ExecutionRequirementCodeType codigoCondicionEjecucion = cs.getCbcFactory().createExecutionRequirementCodeType();
					DescriptionType descripcion= cs.getCbcFactory().createDescriptionType();

					//Tipo de condicion de ejecucion
					
					Code tipoCondicionConsideracionesAmbientales = crearCode("1","Consideraciones de tipo ambiental",ConstantsGC.EXECUTIONREQUIREMENTCODE,ConstantsGC.EXECUTIONREQUIREMENTCODE_VER);

					asignarCode(codigoCondicionEjecucion,tipoCondicionConsideracionesAmbientales);
					descripcion.setValue(condicionesEjecucion.getConsideracionesAmbientales());


					consideracionesAmbientales.setExecutionRequirementCode(codigoCondicionEjecucion);
					consideracionesAmbientales.getDescription().add(descripcion);

					res.getContractExecutionRequirement().add(consideracionesAmbientales);
				}

			if (condicionesEjecucion.getConsideracionesSocial()!=null)
				if (condicionesEjecucion.getConsideracionesSocial().length()>0){
					ContractExecutionRequirementType consideracionesSocial=cs.getCacFactory().createContractExecutionRequirementType();

					ExecutionRequirementCodeType codigoCondicionEjecucion = cs.getCbcFactory().createExecutionRequirementCodeType();
					DescriptionType descripcion= cs.getCbcFactory().createDescriptionType();

					//Tipo de condicion de ejecucion
					
					Code tipoCondicionConsideracionesSocial = crearCode("2","Consideraciones tipo social",ConstantsGC.EXECUTIONREQUIREMENTCODE,ConstantsGC.EXECUTIONREQUIREMENTCODE_VER);

					asignarCode(codigoCondicionEjecucion,tipoCondicionConsideracionesSocial);
					descripcion.setValue(condicionesEjecucion.getConsideracionesSocial());


					consideracionesSocial.setExecutionRequirementCode(codigoCondicionEjecucion);
					consideracionesSocial.getDescription().add(descripcion);

					res.getContractExecutionRequirement().add(consideracionesSocial);
				}

			if (condicionesEjecucion.getConvencionesOMT()!=null)
				if (condicionesEjecucion.getConvencionesOMT().length()>0){
					ContractExecutionRequirementType convencionesOMT=cs.getCacFactory().createContractExecutionRequirementType();

					ExecutionRequirementCodeType codigoCondicionEjecucion = cs.getCbcFactory().createExecutionRequirementCodeType();
					DescriptionType descripcion= cs.getCbcFactory().createDescriptionType();

					//Tipo de condicion de ejecucion
					
					Code tipoCondicionConvencionesOMT = crearCode("7","Cumplimiento de las Convenciones fundamentales de la Organizacin Mundial del Trabajo",ConstantsGC.EXECUTIONREQUIREMENTCODE,ConstantsGC.EXECUTIONREQUIREMENTCODE_VER);

					asignarCode(codigoCondicionEjecucion,tipoCondicionConvencionesOMT);
					descripcion.setValue(condicionesEjecucion.getConvencionesOMT());


					convencionesOMT.setExecutionRequirementCode(codigoCondicionEjecucion);
					convencionesOMT.getDescription().add(descripcion);

					res.getContractExecutionRequirement().add(convencionesOMT);
				}

			if (condicionesEjecucion.getEliminarDesigualdades()!=null)
				if (condicionesEjecucion.getEliminarDesigualdades().length()>0){
					ContractExecutionRequirementType eliminarDesigualdades=cs.getCacFactory().createContractExecutionRequirementType();

					ExecutionRequirementCodeType codigoCondicionEjecucion = cs.getCbcFactory().createExecutionRequirementCodeType();
					DescriptionType descripcion= cs.getCbcFactory().createDescriptionType();

					//Tipo de condicion de ejecucion
					
					Code tipoCondicionEliminarDesigualdades = crearCode("4","Eliminar desigualdades entre el hombre y la mujer",ConstantsGC.EXECUTIONREQUIREMENTCODE,ConstantsGC.EXECUTIONREQUIREMENTCODE_VER);

					asignarCode(codigoCondicionEjecucion,tipoCondicionEliminarDesigualdades);
					descripcion.setValue(condicionesEjecucion.getEliminarDesigualdades());


					eliminarDesigualdades.setExecutionRequirementCode(codigoCondicionEjecucion);
					eliminarDesigualdades.getDescription().add(descripcion);

					res.getContractExecutionRequirement().add(eliminarDesigualdades);
				}

			if (condicionesEjecucion.getFavorecerFormacion()!=null)
				if (condicionesEjecucion.getFavorecerFormacion().length()>0){
					ContractExecutionRequirementType favorecerFormacion=cs.getCacFactory().createContractExecutionRequirementType();

					ExecutionRequirementCodeType codigoCondicionEjecucion = cs.getCbcFactory().createExecutionRequirementCodeType();
					DescriptionType descripcion= cs.getCbcFactory().createDescriptionType();

					//Tipo de condicion de ejecucion
					
					Code tipoCondicionFavorecerFormacion = crearCode("6","Favorecer la formacin en el lugar de trabajo",ConstantsGC.EXECUTIONREQUIREMENTCODE,ConstantsGC.EXECUTIONREQUIREMENTCODE_VER);

					asignarCode(codigoCondicionEjecucion,tipoCondicionFavorecerFormacion);
					descripcion.setValue(condicionesEjecucion.getFavorecerFormacion());


					favorecerFormacion.setExecutionRequirementCode(codigoCondicionEjecucion);
					favorecerFormacion.getDescription().add(descripcion);

					res.getContractExecutionRequirement().add(favorecerFormacion);
				}

			if (condicionesEjecucion.getPromoverEmpleo()!=null)
				if (condicionesEjecucion.getPromoverEmpleo().length()>0){
					ContractExecutionRequirementType promoverEmpleo=cs.getCacFactory().createContractExecutionRequirementType();

					ExecutionRequirementCodeType codigoCondicionEjecucion = cs.getCbcFactory().createExecutionRequirementCodeType();
					DescriptionType descripcion= cs.getCbcFactory().createDescriptionType();

					//Tipo de condicion de ejecucion
					
					Code tipoCondicionPromoverEmpleo = crearCode("3","Promover el empleo de presonas con dificultades particulares de insercin en el mercado laboral",ConstantsGC.EXECUTIONREQUIREMENTCODE,ConstantsGC.EXECUTIONREQUIREMENTCODE_VER);

					asignarCode(codigoCondicionEjecucion,tipoCondicionPromoverEmpleo);
					descripcion.setValue(condicionesEjecucion.getPromoverEmpleo());


					promoverEmpleo.setExecutionRequirementCode(codigoCondicionEjecucion);
					promoverEmpleo.getDescription().add(descripcion);

					res.getContractExecutionRequirement().add(promoverEmpleo);
				}

		}
		return res;

	}


	protected static TenderingTermsType crearTenderingTerms(int clasificacion,
			String solvencia, Contractingauthorityparty datosOC, int idDirectiva) {
		TenderingTermsType res = cs.getCacFactory().createTenderingTermsType();

		
		if (idDirectiva > 0){
			DocumentReferenceType pplegdocref=cs.getCacFactory().createDocumentReferenceType();
			String directiva=ComboBoxUtils.getComboBoxByConstant(ConstantsGC.DIRECTIVA)[idDirectiva-1][1];
			IDType idDocRefDirectiva=cs.getCbcFactory().createIDType();
			idDocRefDirectiva.setValue(directiva);
			pplegdocref.setID(idDocRefDirectiva);
			res.setProcurementLegislationDocumentReference(pplegdocref);
		}
		
		if (clasificacion > -1 || solvencia != null) {
			TendererQualificationRequestType tqr = cs.getCacFactory()
					.createTendererQualificationRequestType();

			if ((clasificacion >-1)&(clasificacion<ComboBoxUtils.getComboBoxByConstant(ConstantsGC.BUSINESS_PROFILE_URI).length)) {
				String descClass=ComboBoxUtils.getComboBoxByConstant(ConstantsGC.BUSINESS_PROFILE_URI)[clasificacion][0];
				String codeClass=ComboBoxUtils.getComboBoxByConstant(ConstantsGC.BUSINESS_PROFILE_URI)[clasificacion][1];
				ClassificationSchemeType cst = cs.getCacFactory()
						.createClassificationSchemeType();

				ClassificationCategoryType cat = cs.getCacFactory()
						.createClassificationCategoryType();
				CodeValueType codev = cs.getCbcFactory().createCodeValueType();
				codev.setValue(codeClass);
				codev.setLanguageID(ConstantsGC.LANGUAGE_ID);
				cat.setCodeValue(codev);
				NameType catName= new NameType();
				catName.setValue("Elemento RequiredBusinessProfileCode");
				cat.setName(catName);
				DescriptionType descCat=new DescriptionType();
				descCat.setLanguageID(ConstantsGC.LANGUAGE_ID);
				descCat.setValue(descClass);
				List <DescriptionType> catDescList=cat.getDescription();
				catDescList.add(descCat);
		
				

				NameType name = cs.getCbcFactory().createNameType();
				name.setValue(ConstantsGC.BUSINESS_PROFILE);
				cst.setName(name);

				IDType id = cs.getCbcFactory().createIDType();
				id.setValue("RequiredBusinessProfileCode");
				cst.setID(id);

				LanguageIDType lang = cs.getCbcFactory().createLanguageIDType();
				lang.setValue("Espaol");
				cst.setLanguageID(lang);

				AgencyNameType agencyName = cs.getCbcFactory()
						.createAgencyNameType();
				agencyName
						.setValue("Direccin General del Patrimonio del Estado");
				cst.setAgencyName(agencyName);

				VersionIDType version = cs.getCbcFactory()
						.createVersionIDType();
				version.setValue(ConstantsGC.BUSINESS_PROFILE_CODE_VER);
				cst.setVersionID(version);

				URIType uri = cs.getCbcFactory().createURIType();
				uri.setValue(ConstantsGC.BUSINESS_PROFILE_URI);
				cst.setURI(uri);

				SchemeURIType schemeUri = cs.getCbcFactory()
						.createSchemeURIType();
				schemeUri.setValue(ConstantsGC.BUSINESS_PROFILE_CODE);
				cst.setSchemeURI(schemeUri);

				cst.getClassificationCategory().add(cat);
				tqr.getRequiredBusinessClassificationScheme().add(cst);

			}

			if (solvencia != null) {
				DescriptionType desc = cs.getCbcFactory()
						.createDescriptionType();
				desc.setValue(solvencia);
				tqr.getDescription().add(desc);
			}

			res.setTendererQualificationRequest(tqr);
		}

		return res;

	}

	protected static TenderingProcessType crearTenderingProcess(
			Code tipoProcedimiento, Code codeUrgency, Code codeExpense, Code codeSubmissionMethod, Date fechaFinOfertas,
			Date fechaFinSolicitudes, Event evento) {
		TenderingProcessType res = cs.getCacFactory()
				.createTenderingProcessType();
		if (tipoProcedimiento != null) {
			ProcedureCodeType pcode = cs.getCbcFactory()
					.createProcedureCodeType();

			asignarCode(pcode, tipoProcedimiento);
			res.setProcedureCode(pcode);
			
			
	         //Si es "Derivado de Acuerdo Marco, se indica el ContractingSystem como
            //"Contrato basado en Acuerdo Marco
            
            if (tipoProcedimiento.getCodevalue().compareTo("7") == 0){
              ContractingSystemCodeType contractingSystemCode = new ContractingSystemCodeType();

              
              contractingSystemCode.setValue("3");
              contractingSystemCode.setListURI(ConstantsGC.CONTRACTING_SYSTEM_TYPE_CODE);
              contractingSystemCode.setListVersionID(ConstantsGC.CONTRACTING_SYSTEM_TYPE_CODE_VER);
              contractingSystemCode.setName("Contrato basado en un Acuerdo Marco");
              
              res.setContractingSystemCode(contractingSystemCode);
            }
            
			
			
		}
		
		if (fechaFinOfertas != null) {
			PeriodType period = cs.getCacFactory().createPeriodType();
			EndDateType endDate = cs.getCbcFactory().createEndDateType();
			endDate.setValue(datetoXMLGregorianCalendar(fechaFinOfertas));
			period.setEndDate(endDate);

			EndTimeType endTime = cs.getCbcFactory().createEndTimeType();
			endTime.setValue(timetoXMLGregorianCalendar(fechaFinOfertas));
			period.setEndTime(endTime);

			res.setTenderSubmissionDeadlinePeriod(period);
		}
		
		if (fechaFinSolicitudes != null) {
			PeriodType period = cs.getCacFactory().createPeriodType();
			EndDateType endDate = cs.getCbcFactory().createEndDateType();
			endDate.setValue(datetoXMLGregorianCalendar(fechaFinSolicitudes));
			period.setEndDate(endDate);

			EndTimeType endTime = cs.getCbcFactory().createEndTimeType();
			endTime.setValue(timetoXMLGregorianCalendar(fechaFinSolicitudes));
			period.setEndTime(endTime);

			res.setParticipationRequestReceptionPeriod(period);
		}


		if (codeUrgency != null){
			UrgencyCodeType urgency = cs.getCbcFactory().createUrgencyCodeType();
			asignarCode(urgency, codeUrgency);
			res.setUrgencyCode(urgency);	
		}
		
		if (codeExpense != null){
			ExpenseCodeType expense = cs.getCbcFactory().createExpenseCodeType();
			asignarCode(expense, codeExpense);
			res.setExpenseCode(expense);
		}
		
		if (codeSubmissionMethod!=null){
			SubmissionMethodCodeType submissionMethod = cs.getCbcFactory().createSubmissionMethodCodeType();
			asignarCode(submissionMethod, codeSubmissionMethod);
			res.setSubmissionMethodCode(submissionMethod);
			}

		if (evento != null) {
			res.getOpenTenderEvent().add(crearEvent(evento));
		}
		return res;
	}


	public static TenderingProcessType crearTenderingProcess(Code tipoProcedimiento, Code codeUrgency, Code codeExpense, Code codeSubmissionMethod, Date fechaFinOfertas,
			Date fechaFinSolicitudes, Event evento, Date fechaEnvioInvitaciones, String justifProcAcelerado, int indicadorFasesSucesivas, 
			int indicadorSubastaElectronica, Boolean acuerdoCP, ExpedienteBean expediente, Code tipoJustificacionATPV, String textoJustificacionATPV ){
				
		TenderingProcessType res = crearTenderingProcess(tipoProcedimiento,codeUrgency,codeExpense,codeSubmissionMethod,fechaFinOfertas,
				fechaFinSolicitudes,evento);
		
		
		if (fechaEnvioInvitaciones != null) {
			PeriodType period = cs.getCacFactory().createPeriodType();
			EndDateType endDate = cs.getCbcFactory().createEndDateType();
			endDate.setValue(datetoXMLGregorianCalendar(fechaEnvioInvitaciones));
			period.setEndDate(endDate);

			EndTimeType endTime = cs.getCbcFactory().createEndTimeType();
			endTime.setValue(timetoXMLGregorianCalendar(fechaEnvioInvitaciones));
			period.setEndTime(endTime);

			res.setInvitationSubmissionPeriod(period);
		}
		

								
				
			//Textos
				//Justificacion procedimiento acelerado
		if (justifProcAcelerado!=null)
			if (justifProcAcelerado.length()>0){
			
				AcceleratedProcedureJustificationType procAcelerado=cs.getCbcFactory().createAcceleratedProcedureJustificationType();
				procAcelerado.setValue(justifProcAcelerado);
				res.setAcceleratedProcedureJustification(procAcelerado);
			}
			
		
				
				// Terminos de la subasta electrnica
		if (indicadorSubastaElectronica>=0){
			
			AuctionTermsType subasta=cs.getCacFactory().createAuctionTermsType();
			AuctionConstraintIndicatorType indicadorSubasta=cs.getCbcFactory().createAuctionConstraintIndicatorType();
			switch(indicadorSubastaElectronica){
			case 0:
				indicadorSubasta.setValue(true);
				DescriptionType terminosSubasta=cs.getCbcFactory().createDescriptionType();
				terminosSubasta.setValue(expediente.getTerminosSubastaElectronica());
				subasta.getDescription().add(terminosSubasta);
				break;
			case 1:indicadorSubasta.setValue(false);
				break;
			}
				subasta.setAuctionConstraintIndicator(indicadorSubasta);
				res.setAuctionTerms(subasta);
			}
		
		CandidateReductionConstraintIndicatorType fasesSucesivas=cs.getCbcFactory().createCandidateReductionConstraintIndicatorType();
		switch(indicadorFasesSucesivas){
		case 0:
			
				fasesSucesivas.setValue(true);
				res.setCandidateReductionConstraintIndicator(fasesSucesivas);
				break;
		case 1:
				fasesSucesivas.setValue(false);
				res.setCandidateReductionConstraintIndicator(fasesSucesivas);
				break;

		}
		
		
		//Si el expediente tiene lotes, se comprueba a cual ofertar
		if (expediente.getLotes() != null && expediente.getLotes().isTieneLotes()) {
			String idPresentarLotes = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDER_PRESENTATION)[expediente.getLotes().getIdDebeOfertar()][1];
			Code presentarLotes = crearCode(idPresentarLotes, expediente.getLotes().getDebeOfertar(), ConstantsGC.TENDER_PRESENTATION, ConstantsGC.TENDER_PRESENTATION_VER);

			PartPresentationCodeType partPresentationCodeType = new PartPresentationCodeType();
			partPresentationCodeType.setValue(idPresentarLotes);
			partPresentationCodeType.setListURI(presentarLotes.getListUri());
			partPresentationCodeType.setListVersionID(presentarLotes.getListVersionId());
			partPresentationCodeType.setName(presentarLotes.getDescription());
			res.setPartPresentationCode(partPresentationCodeType);

			// Se indica el nmero mximo de lotes a los que se puede presentar
			MaximumLotPresentationQuantityType maximumLotPresentationQuantityType = new MaximumLotPresentationQuantityType();
			maximumLotPresentationQuantityType.setValue(new BigDecimal(expediente.getLotes().getNumeroMaximoPresentacion()));
			res.setMaximumLotPresentationQuantity(maximumLotPresentationQuantityType);

			// Se indica el nmero mximo de lotes a los que se puede asignar el
			// mismo licitador
			MaximumTendererAwardedLotsQuantityType awardedLotsQuantityType = new MaximumTendererAwardedLotsQuantityType();
			awardedLotsQuantityType.setValue(new BigDecimal(expediente.getLotes().getNumeroMaximoAdjudicacion()));
			res.setMaximumTendererAwardedLotsQuantity(awardedLotsQuantityType);

			// Se india el texto explicativo sobre las posibilidades de
			// adjudicacin de combinaciones de lotes
			LotsCombinationContractingAuthorityRightsType lotsCombinationContractingAuthorityRightsType = new LotsCombinationContractingAuthorityRightsType();
			lotsCombinationContractingAuthorityRightsType.setValue(expediente.getLotes().getDetallePosibilidadAdjudicacion());
			res.getLotsCombinationContractingAuthorityRights().add(lotsCombinationContractingAuthorityRightsType);

		}
		
		//Si se indica el acuerdo de contratacin pblica, se aada
		if (acuerdoCP != null){
			GovernmentProcurementAgreementConstraintIndicatorType acp = CODICESerializing.cbcFactory.createGovernmentProcurementAgreementConstraintIndicatorType();
			acp.setValue(acuerdoCP);
			res.setGovernmentProcurementAgreementConstraintIndicator(acp);
		}
		
		
		ProcessJustificationType tenderProcJustif=null; 
		
		if (tipoJustificacionATPV!=null)
		{
			tenderProcJustif= new ProcessJustificationType();
			ReasonCodeType reasonCode=cs.getCbcFactory().createReasonCodeType();
			asignarCode(reasonCode,tipoJustificacionATPV);
			tenderProcJustif.setReasonCode(reasonCode);
			res.getProcessJustification().add(tenderProcJustif);
		}
		
		if (textoJustificacionATPV!=null)
		{
			tenderProcJustif= new ProcessJustificationType();
			DescriptionType procJustifDesc = cs.getCbcFactory().createDescriptionType();
			procJustifDesc.setLanguageID("es");
			procJustifDesc.setValue(textoJustificacionATPV);
			tenderProcJustif.getDescription().add(procJustifDesc);
			res.getProcessJustification().add(tenderProcJustif);
		}
		
		return res;
	}
	
	protected static EventType crearEvent(Event objeto) {
		if (objeto == null)
			return null;
		EventType res = cs.getCacFactory().createEventType();
		if (objeto.getIdentifier().length()>0) {
			IdentificationIDType id = cs.getCbcFactory()
					.createIdentificationIDType();
			id.setValue(objeto.getIdentifier());
			res.setIdentificationID(id);
		}
		if (objeto.getOccurrencedate() != null) {
			OccurrenceDateType fecha = cs.getCbcFactory()
					.createOccurrenceDateType();
			fecha.setValue(datetoXMLGregorianCalendar(objeto
					.getOccurrencedate()));
			res.setOccurrenceDate(fecha);
		}
		if (objeto.getOccurrencetime() != null) {
			OccurrenceTimeType hora = cs.getCbcFactory()
					.createOccurrenceTimeType();
			hora
					.setValue(timetoXMLGregorianCalendar(objeto
							.getOccurrencetime()));
			res.setOccurrenceTime(hora);
		}
		if (objeto.getDescription().length()>0) {
			DescriptionType descripcion = cs.getCbcFactory().createDescriptionType();
			descripcion.setValue(objeto.getDescription());
			res.getDescription().add(descripcion);
		}

		if (objeto.getCode() != null) {
			TypeCodeType codet = cs.getCbcFactory().createTypeCodeType();
			asignarCode(codet, objeto.getCode());
			res.setTypeCode(codet);
		}
		if (objeto.getAddress().length()>0 || objeto.getCity().length()>0
				|| objeto.getCountry() != null
				|| objeto.getPostalZone().length()>0) {
			LocationType loc = cs.getCacFactory().createLocationType();
			AddressType add = cs.getCacFactory().createAddressType();
			if (objeto.getAddress().length()>0) {
				AddressLineType line = cs.getCacFactory()
						.createAddressLineType();
				LineType linet = cs.getCbcFactory().createLineType();
				linet.setValue(objeto.getAddress());
				line.setLine(linet);
				add.getAddressLine().add(line);

			}
			if (objeto.getCity().length()>0) {
				CityNameType city = cs.getCbcFactory().createCityNameType();
				city.setValue(objeto.getCity());
				add.setCityName(city);
			}
			if (objeto.getPostalZone().length()>0) {
				PostalZoneType cp = cs.getCbcFactory().createPostalZoneType();
				cp.setValue(objeto.getPostalZone());
				add.setPostalZone(cp);
			}
			if (objeto.getCountry() != null) {
				CountryType pais = cs.getCacFactory().createCountryType();
				IdentificationCodeType idcode = cs.getCbcFactory()
						.createIdentificationCodeType();
				idcode.setValue("es");
				idcode.setLanguageID(ConstantsGC.LANGUAGE_ID);

				idcode.setListAgencyID(ConstantsGC.COUNTRY_CODE_VER);
				idcode.setListSchemeURI(ConstantsGC.COUNTRY_CODE);
				idcode.setListURI(ConstantsGC.COUNTRY_CODE);
				asignarCode(idcode, objeto.getCountry());
				pais.setIdentificationCode(idcode);
				idcode.setListVersionID(ConstantsGC.COUNTRY_CODE_VER);
				add.setCountry(pais);
			}
			loc.setAddress(add);
			
			if (objeto.getLocationDescription().length()>0){
			    DescriptionType dt=cs.getCbcFactory().createDescriptionType();
			    dt.setLanguageID("es");
			    dt.setValue(objeto.getLocationDescription());
				loc.setDescription(dt);
			}
			res.setOccurrenceLocation(loc);
		
			AttendanceConditionsType attendanceConditionsType = new AttendanceConditionsType();
			
			AttendanceRestrictionCodeType attendanceRestrictionCodeType = new AttendanceRestrictionCodeType();
			attendanceRestrictionCodeType.setValue(objeto.getTipoEvento().getCodevalue());
			attendanceRestrictionCodeType.setListURI(objeto.getTipoEvento().getListUri());
			attendanceRestrictionCodeType.setListVersionID(objeto.getTipoEvento().getListVersionId());
			attendanceRestrictionCodeType.setName(objeto.getTipoEvento().getDescription());
			attendanceConditionsType.setAttendanceRestrictionCode(attendanceRestrictionCodeType);
			
			AttendanceConditionsDescriptionType attendanceConditionsDescriptionType = new AttendanceConditionsDescriptionType();
			
			if (objeto.getCondicionesAcceso().length() > 0){
				attendanceConditionsDescriptionType.setValue(objeto.getCondicionesAcceso());
			}
			attendanceConditionsType.getAttendanceConditionsDescription().add(attendanceConditionsDescriptionType);
					
			res.setAttendanceConditions(attendanceConditionsType);
			
			

		}

		return res;
	}

	/**
	 * Se crea un elemento ContractModificactionType a partir de los datos introducidos
	 * @return
	 */
	protected static ContractModificationType crearContractModification(DatosModificacionBean datosModificacion, String numContrato){
		ContractModificationType modification = CODICESerializing.getCacFactory().createContractModificationType();
		
		//Se indica el identificar del contrato
		ContractIDType contractId = CODICESerializing.getCbcFactory().createContractIDType();
		contractId.setValue(numContrato);
		modification.setContractID(contractId);
		
		//Se indica el nmero de la modificacin y su fecha
		if (datosModificacion.getNumeroModificiacion() != null){
    		IDType idType = CODICESerializing.getCbcFactory().createIDType();
    		idType.setValue(datosModificacion.getNumeroModificiacion());
    		modification.setID(idType);
		}
		
		IssueDateType issueDate = CODICESerializing.getCbcFactory().createIssueDateType();
		if (datosModificacion.getFechaModificacion() != null){
			issueDate.setValue(datetoXMLGregorianCalendar(datosModificacion.getFechaModificacion()));
			modification.setIssueDate(issueDate);
		}
				
		//Se indican los cambios referentes al incremento de los importes
		if (datosModificacion.getIncrementoSinImpuestos() != null || datosModificacion.getIncrementoConImpuestos() != null){
    		LegalMonetaryTotalType incremento = CODICESerializing.getCacFactory().createLegalMonetaryTotalType();
    		
    		if (datosModificacion.getIncrementoSinImpuestos() != null) {
    			TaxExclusiveAmountType taxExclusive = CODICESerializing.getCbcFactory().createTaxExclusiveAmountType();
    			taxExclusive.setValue(datosModificacion.getIncrementoSinImpuestos());
    			taxExclusive.setCurrencyID(CurrencyCodeContentType.EUR);
    			incremento.setTaxExclusiveAmount(taxExclusive);
    		}
    		
    		if (datosModificacion.getIncrementoConImpuestos() != null) {
    			PayableAmountType payableAmount = CODICESerializing.getCbcFactory().createPayableAmountType();
    			payableAmount.setValue(datosModificacion.getIncrementoConImpuestos());
    			payableAmount.setCurrencyID(CurrencyCodeContentType.EUR);
    			incremento.setPayableAmount(payableAmount);
    		}
    		
    		modification.setContractModificationLegalMonetaryTotal(incremento);
		}
		
		
		// Se indican los cambios referentes a los importes totales
		if (datosModificacion.getImporteTotalSinImpuestos() != null || datosModificacion.getImporteTotalConImpuestos() != null){
    		LegalMonetaryTotalType importeTotal = CODICESerializing.getCacFactory().createLegalMonetaryTotalType();
    
    		if (datosModificacion.getImporteTotalSinImpuestos() != null){
    			TaxExclusiveAmountType taxExclusiveTotal = CODICESerializing.getCbcFactory().createTaxExclusiveAmountType();
    			taxExclusiveTotal.setValue(datosModificacion.getImporteTotalSinImpuestos());
    			taxExclusiveTotal.setCurrencyID(CurrencyCodeContentType.EUR);
    			importeTotal.setTaxExclusiveAmount(taxExclusiveTotal);
    		}
    
    		if (datosModificacion.getImporteTotalConImpuestos() != null){
    			PayableAmountType payableAmountTotal = CODICESerializing.getCbcFactory().createPayableAmountType();
    			payableAmountTotal.setValue(datosModificacion.getImporteTotalConImpuestos());
    			payableAmountTotal.setCurrencyID(CurrencyCodeContentType.EUR);
    			importeTotal.setPayableAmount(payableAmountTotal);
    		}
    		
    		modification.setFinalLegalMonetaryTotal(importeTotal);
		}
		
		
		
		//Se indican los cambios referentes al incremento de la duracion
		ContractModificationDurationMeasureType incrementoDuracion = CODICESerializing.getCbcFactory().createContractModificationDurationMeasureType();
		if (datosModificacion.getIncrementoDuracion() != null){
			incrementoDuracion.setValue(datosModificacion.getIncrementoDuracion());
			String unit=ComboBoxUtils.getComboBox(ConstantsGC.PERIOD_UNIT)[datosModificacion.getUnidadDuracionIncremento()][1];
			incrementoDuracion.setUnitCode(UnitCodeContentType.fromValue(unit));					
			modification.setContractModificationDurationMeasure(incrementoDuracion);
		}
		
		// Se indican los cambios referentes a la duracionFinal
		FinalDurationMeasureType finalDuracion = CODICESerializing.getCbcFactory().createFinalDurationMeasureType();
		if (datosModificacion.getDuracionTotal() != null) {
			finalDuracion.setValue(datosModificacion.getDuracionTotal());
			String unit = ComboBoxUtils.getComboBox(ConstantsGC.PERIOD_UNIT)[datosModificacion.getUnidadDuracionTotal()][1];
			finalDuracion.setUnitCode(UnitCodeContentType.fromValue(unit));
			modification.setFinalDurationMeasure(finalDuracion);
		}
				
		
		//Se indica la descripcin
		if (datosModificacion.getDescripcion() != null){
    		NoteType note = CODICESerializing.getCbcFactory().createNoteType();
    		note.setValue(datosModificacion.getDescripcion());
    		modification.getNote().add(note);
		}
		
		//Se indica la justificacin
		ContractModificationJustificationType justification = CODICESerializing.getCbcFactory().createContractModificationJustificationType();
		justification.setValue(datosModificacion.getJustificacionModificacion());
		modification.setContractModificationJustification(justification);
		
		//Se indica el motivo de la modificacin
		ContractModificationReasonCodeType reasonCode = CODICESerializing.getCbcFactory().createContractModificationReasonCodeType();
		reasonCode.setValue(ComboBoxUtils.getComboBox(ConstantsGC.MODIFICATION_REASON_CODE)[datosModificacion.getCodigoMotivoModificacion()][1]);
		reasonCode.setListURI(ConstantsGC.MODIFICATION_REASON_CODE);
		reasonCode.setName(ComboBoxUtils.getComboBox(ConstantsGC.MODIFICATION_REASON_CODE)[datosModificacion.getCodigoMotivoModificacion()][0]);
		modification.setContractModificationReasonCode(reasonCode);
		
		

		return modification;	
		
	}
	
	protected static void asignarCode(CodeType codeT, Code code) {
		
		codeT.setListURI(code.getListUri());
		codeT.setName(code.getDescription());
		codeT.setListVersionID(code.getListVersionId());
		codeT.setValue(code.getCodevalue());
	}

	protected static ContractingPartyType crearContractingPartyType(
			Contractingauthorityparty datosOC) throws JAXBException {

		if (datosOC == null)
			return null;

		ContractingPartyType res = cs.getCacFactory()
				.createContractingPartyType();

		if (datosOC.getContractingauthoritytypecode() != null) {
			ContractingPartyTypeCodeType codeType = cs.getCbcFactory()
					.createContractingPartyTypeCodeType();
			datosOC.getContractingauthoritytypecode().setListVersionId(
					ConstantsGC.CONTRACTING_AUTHORITY_TYPE_VER);
			datosOC.getContractingauthoritytypecode().setListUri(
					ConstantsGC.CONTRACTING_AUTHORITY_TYPE);
			code2Codice(datosOC.getContractingauthoritytypecode(), codeType);
			res.setContractingPartyTypeCode(codeType);
		}

		if (datosOC.getCaactivitytypecode() != null) {
			ActivityCodeType atc = cs.getCbcFactory().createActivityCodeType();
			datosOC.getCaactivitytypecode().setListVersionId(
					ConstantsGC.CONTRACTING_AUTHORITY_ACTIVITY_VER);
			datosOC.getCaactivitytypecode().setListUri(
					ConstantsGC.CONTRACTING_AUTHORITY_ACTIVITY);
			code2Codice(datosOC.getCaactivitytypecode(), atc);
			res.getActivityCode().add(atc);
		}
		
		PartyType party = cs.getCacFactory().createPartyType();
		
		
		PartyNameType name = cs.getCacFactory().createPartyNameType();
		NameType namet = cs.getCbcFactory().createNameType();
		namet.setValue(datosOC.getPartyname());
		name.setName(namet);

		party.getPartyName().add(name);
		
		if (datosOC.getIdPlataforma() != null) {
          PartyIdentificationType idplat = cs.getCacFactory()
                  .createPartyIdentificationType();
          IDType id = cs.getCbcFactory().createIDType();
          id.setValue(datosOC.getIdPlataforma());
          id.setSchemeName("ID_PLATAFORMA");
          idplat.setID(id);
          party.getPartyIdentification().add(idplat);
      }
		
		if (datosOC.getCif() != null) {
			PartyIdentificationType cif = cs.getCacFactory()
					.createPartyIdentificationType();
			IDType id = cs.getCbcFactory().createIDType();
			id.setValue(datosOC.getCif());
			id.setSchemeName("CIF");
			cif.setID(id);
			party.getPartyIdentification().add(cif);
		}

		
		
	
		if (datosOC.getJobRole() != null) {
			PersonType person = cs.getCacFactory().createPersonType();
			JobTitleType job = cs.getCbcFactory().createJobTitleType();
			job.setValue(datosOC.getJobRole());
			person.setJobTitle(job);
			party.setPerson(person);
		}
		
		res.setParty(party);
		return res;
	}
	
	private static ContactType crearContacto(String email, String telefono, String fax)
	{
		ContactType contact=cs.getCacFactory().createContactType();
		if (email.length()>0) 
			{ElectronicMailType eMailCbc=cs.getCbcFactory().createElectronicMailType();
			eMailCbc.setValue(email);
			contact.setElectronicMail(eMailCbc);}
		if (telefono.length()>0) 
			{TelephoneType telephoneCbc=cs.getCbcFactory().createTelephoneType();
			telephoneCbc.setValue(telefono);
			contact.setTelephone(telephoneCbc);}
		if (fax.length()>0) 
			{TelefaxType faxCbc=cs.getCbcFactory().createTelefaxType();
			faxCbc.setValue(fax);
			contact.setTelefax(faxCbc);}
		return contact;
	}
	
	protected static PartyType anyadeDireccionContactosPartyOC(PartyType party, Contractingauthorityparty datosOC)
	
	{
		
		


		if (datosOC.getAddressLine().length()> 0 || datosOC.getCityName().length()>0
				|| datosOC.getPostalZone().length()>0) {
			
			
			AddressType add = cs.getCacFactory().createAddressType();
			if (datosOC.getAddressLine().length()>0) {
				
				AddressFormatCodeType adfc=cs.getCbcFactory().createAddressFormatCodeType();
				adfc.setValue(ConstantsGC.ADDRESS_FORMAT_CODE_VALUE);
				adfc.setListURI(ConstantsGC.ADDRESS_FORMAT_CODE);
				adfc.setLanguageID("es");
				adfc.setListVersionID(ConstantsGC.ADDRESS_FORMAT_CODE_VER);
				adfc.setName(ConstantsGC.ADDRESS_FORMAT_CODE_NAME);
				add.setAddressFormatCode(adfc);
				
				AddressLineType line = cs.getCacFactory()
						.createAddressLineType();
				LineType linet = cs.getCbcFactory().createLineType();
				linet.setValue(datosOC.getAddressLine());
				line.setLine(linet);
				add.getAddressLine().add(line);
			}
			if (datosOC.getCityName().length()>0) {
				CityNameType city = cs.getCbcFactory().createCityNameType();
				city.setValue(datosOC.getCityName());
				add.setCityName(city);
			}
			if (datosOC.getPostalZone() != null) {
				PostalZoneType cp = cs.getCbcFactory().createPostalZoneType();
				cp.setValue(datosOC.getPostalZone());
				add.setPostalZone(cp);
			}

			
			if (datosOC.getCountry() != null) {
				CountryType pais = cs.getCacFactory().createCountryType();
				IdentificationCodeType idcode = cs.getCbcFactory()
						.createIdentificationCodeType();
				asignarCode(idcode, datosOC.getCountry());
				pais.setIdentificationCode(idcode);
				NameType countryName=cs.getCbcFactory().createNameType();
				countryName.setValue(idcode.getName());
				pais.setName(countryName);
				add.setCountry(pais);
			}
			
			party.setPostalAddress(add);
			
			
		}
		if (datosOC.getContactEmail().length()>0|datosOC.getTelephone().length()>0|datosOC.getFax().length()>0)
			party.setContact(crearContacto(datosOC.getContactEmail(),datosOC.getTelephone(),datosOC.getFax()));
			
		return party;
	}

	protected static void code2Codice(Code objeto, CodeType res) {

		if (objeto != null) {

			res.setListURI(objeto.getListUri());
			res.setListVersionID(objeto.getListVersionId());
			res.setName(objeto.getDescription());
			res.setValue(objeto.getCodevalue());
		}
	}

	protected static Calendar generatePublishDate() {
		Calendar calendar = Calendar.getInstance();
		Date date = new Date();
		date.setTime(System.currentTimeMillis());
		calendar.setTime(date);

		return calendar;
	}

	protected static XMLGregorianCalendar generatePublishDateXMLGregorianCalendar() {
		Date d = new Date();
		d.setTime(System.currentTimeMillis());
		XMLGregorianCalendar res = null;
		res = datetoXMLGregorianCalendar(d);

		return res;
	}

	protected static XMLGregorianCalendar generatePublishTimeXMLGregorianCalendar() {

		Date d = new Date();
		d.setTime(System.currentTimeMillis());

		XMLGregorianCalendar res = null;
		res = timetoXMLGregorianCalendar(d);
		return res;
	}

	protected static CustomizationIDType getCustomizationID() {
		CustomizationIDType version = null;
		version = cs.getCbcFactory().createCustomizationIDType();
		version.setValue(cm.getInstance().leerPropiedad(cm.CODICE_VERSION));

		return version;
	}

	protected static ProfileIDType getProfileID() {
		ProfileIDType version = null;
		version = cs.getCbcFactory().createProfileIDType();
		version.setValue(cm.getInstance().leerPropiedad(
				cm.CODICE_PROFILE_VERSION));

		return version;
	}

	protected static UBLVersionIDType getUBLVersionID() {
		UBLVersionIDType version = null;
		version = cs.getCbcFactory().createUBLVersionIDType();
		version.setValue(cm.getInstance().leerPropiedad(cm.UBL_VERSION));

		return version;
	}

	protected static UUIDType getUUID(String id) {

		UUIDType uuidtype = null;
		uuidtype = cs.getCbcFactory().createUUIDType();
		if (id != null)
			uuidtype.setValue(id);
		else
			uuidtype.setValue("PREVIEW");

		return uuidtype;

	}

	protected static IDType getID(String id) {

		IDType idtype = null;
		idtype = cs.getCbcFactory().createIDType();
		if (id != null)
			idtype.setValue(String.valueOf(System.currentTimeMillis()));
		else
			idtype.setValue("PREVIEW");
		return idtype;

	}

	protected static ContractType crearContract(String ID, Date contractDate, Date startDate) {
		
		ContractType contrato= null;
		if (ID.length()>0||contractDate!=null||startDate!=null)
		{
		contrato= new ContractType();
		if (ID.length()>0){
		IDType numContrato= new IDType();
		numContrato.setValue(ID);
		contrato.setID(numContrato);}
		
		if (contractDate!=null){
		IssueDateType fechaForm = new IssueDateType();
		fechaForm.setValue(datetoXMLGregorianCalendar(contractDate));
		contrato.setIssueDate(fechaForm);}
		
		if (startDate!=null){
		PeriodType periodoContrato= new PeriodType();
		StartDateType fechaVigorContrato=new StartDateType();
		fechaVigorContrato.setValue(datetoXMLGregorianCalendar(startDate));
		periodoContrato.setStartDate(fechaVigorContrato);
		contrato.setValidityPeriod(periodoContrato);}}
		
		return contrato;
	}
	
	protected static TenderResultType crearTenderResultAdjudicacion(ExpedienteBean objeto )
	{
		TenderResultType res=null;
		try{
			//String tipodoc = "DOC_ADJ";
			res=cs.getCacFactory().createTenderResultType();

			//Parte comun a adjudicacion, formalizacion, renuncia, desierto y desistimiento
			AwardDateType awardDate = cs.getCbcFactory().createAwardDateType();
			
			if (objeto.getLicitador()!=null){
				
				//Fecha de adjudicacion
				awardDate.setValue(datetoXMLGregorianCalendar(objeto.getLicitador().getFechaAdjudicacion()));
				res.setAwardDate(awardDate);
				
				//Motivacion
				DescriptionType description = cs.getCbcFactory().createDescriptionType();
				description.setValue(objeto.getLicitador().getMotivacion());
				res.getDescription().add(description);

				//Plazo de formalizacion
				PeriodType periodForm=cs.getCacFactory().createPeriodType();
				if (objeto.getLicitador().getFechaFinFormalizacion() != null){
					EndDateType endDate=cs.getCbcFactory().createEndDateType();
					endDate.setValue(datetoXMLGregorianCalendar(objeto.getLicitador().getFechaFinFormalizacion()));
	
					EndTimeType endTime=cs.getCbcFactory().createEndTimeType();
					endTime.setValue(timetoXMLGregorianCalendar(objeto.getLicitador().getFechaFinFormalizacion()));
					
					periodForm.setEndDate(endDate);
					periodForm.setEndTime(endTime);
				}
				
				
				DescriptionType descricpionFinAdjudicacion = cs.getCbcFactory().createDescriptionType();
				descricpionFinAdjudicacion.setValue(objeto.getLicitador().getDescripcionLimiteFormalizacion());
				periodForm.getDescription().add(descricpionFinAdjudicacion );
				

				res.setContractFormalizationPeriod(periodForm);


				//Importes de adjudicacion
				TenderedProjectType tpt = cs.getCacFactory().createTenderedProjectType();
				LegalMonetaryTotalType mtt= cs.getCacFactory().createLegalMonetaryTotalType();

				if (objeto.getLicitador().getImporteSinImpuestos().length() > 0){
					TaxExclusiveAmountType amountType=cs.getCbcFactory().createTaxExclusiveAmountType();
					amountType.setValue(new BigDecimal(objeto.getLicitador().getImporteSinImpuestos()));
					amountType.setCurrencyID(CurrencyCodeContentType.EUR );
					mtt.setTaxExclusiveAmount(amountType);
				}

				if (objeto.getLicitador().getImporteConImpuestos().length() > 0){
					PayableAmountType amountType2=cs.getCbcFactory().createPayableAmountType();
					amountType2.setValue(new BigDecimal(objeto.getLicitador().getImporteConImpuestos()));
					amountType2.setCurrencyID(CurrencyCodeContentType.EUR);
					mtt.setPayableAmount(amountType2);
				}

				tpt.setLegalMonetaryTotal(mtt);

				res.setAwardedTenderedProject(tpt);
				
				//Numero de ofertas recibidas
				if (objeto.getLicitador().getNumOfertasElectronicas() != null){
					ReceivedTenderQuantityType rtq=cs.getCbcFactory().createReceivedTenderQuantityType();
					rtq.setValue(new BigDecimal(objeto.getLicitador().getNumOfertasRecibidas()));
					res.setReceivedTenderQuantity(rtq);
				}
				
				//Ofertas recibidas de PYMES
				if (objeto.getLicitador().getNumOfertasRecibidasPymes() != null){
					SMEsReceivedTenderQuantityType value = cs.getCbcFactory().createSMEsReceivedTenderQuantityType();
					value.setValue(new BigDecimal(objeto.getLicitador().getNumOfertasRecibidasPymes()));
					res.setSMEsReceivedTenderQuantity(value);
				}
				
				//Ofertas recibidas extranjeros comunitarios
				if (objeto.getLicitador().getNumOfertasExtranjerosUE() != null){
					EUNationalsReceivedTenderQuantityType euNationalsReceivedTenderQuantityType = cs.getCbcFactory().createEUNationalsReceivedTenderQuantityType();
					euNationalsReceivedTenderQuantityType.setValue(new BigDecimal(objeto.getLicitador().getNumOfertasExtranjerosUE()));
					res.setEUNationalsReceivedTenderQuantity(euNationalsReceivedTenderQuantityType);
				}
				
				//Ofertas recibidas extranjeros extracomunitarios
				if (objeto.getLicitador().getNumOfertasExtranjerosNoUE() != null){
					NonEUNationalsReceivedTenderQuantityType nonEuNationalsReceivedTenderQuantityType = cs.getCbcFactory().createNonEUNationalsReceivedTenderQuantityType();
					nonEuNationalsReceivedTenderQuantityType.setValue(new BigDecimal(objeto.getLicitador().getNumOfertasExtranjerosNoUE()));
					res.setNonEUNationalsReceivedTenderQuantity(nonEuNationalsReceivedTenderQuantityType);
				}
				
				//Ofertas electrnicas recibidas
				if (objeto.getLicitador().getNumOfertasElectronicas() != null){
					ReceivedElectronicTenderQuantityType electronicTenderQuantityType = cs.getCbcFactory().createReceivedElectronicTenderQuantityType();
					electronicTenderQuantityType.setValue(new BigDecimal(objeto.getLicitador().getNumOfertasElectronicas()));
					res.setReceivedElectronicTenderQuantity(electronicTenderQuantityType);
				}
				
				//Se han recibido ofertas anormalmente bajas
				if (objeto.getLicitador().getOfertasBajas() != null){
					AbnormallyLowTendersIndicatorType abnormallyLowTendersIndicatorType = cs.getCbcFactory().createAbnormallyLowTendersIndicatorType();
					abnormallyLowTendersIndicatorType.setValue(objeto.getLicitador().getOfertasBajas().booleanValue());
					res.setAbnormallyLowTendersIndicator(abnormallyLowTendersIndicatorType);
				}
				
				//Pas origen del producto/servicio
				if (objeto.getLicitador().getIdPaisOrigen() >= 0){		
					OriginCountryCodeType originCountryCodeType = cs.getCbcFactory().createOriginCountryCodeType();	
					String idPais = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.COUNTRY_CODE)[objeto.getLicitador().getIdPaisOrigen()][1];
					Code pais = crearCode(idPais, ComboBoxUtils.getComboBoxByConstant(ConstantsGC.COUNTRY_CODE)[objeto.getLicitador().getIdPaisOrigen()][0], ConstantsGC.COUNTRY_CODE, ConstantsGC.COUNTRY_CODE_VER);
					originCountryCodeType.setValue(idPais);
					originCountryCodeType.setListURI(pais.getListUri());
					originCountryCodeType.setListVersionID(pais.getListVersionId());
					originCountryCodeType.setName(pais.getDescription());
					res.getOriginCountryCode().add(originCountryCodeType);
				}
				
				//Se indica si el adjudicatario es una PYME
				if (objeto.getLicitador().getAdjudicatarioPyme() != null){
					SMEAwardedIndicatorType smeAwardedIndicatorType = cs.getCbcFactory().createSMEAwardedIndicatorType();
					smeAwardedIndicatorType.setValue(objeto.getLicitador().getAdjudicatarioPyme());
					res.setSMEAwardedIndicator(smeAwardedIndicatorType);
				}


				/**WinningParty **/

				PartyType party = cs.getCacFactory().createPartyType();

				PartyNameType name = cs.getCacFactory().createPartyNameType();
				NameType na = cs.getCbcFactory().createNameType();
				na.setValue(objeto.getLicitador().getNombre());
				name.setName(na);
				party.getPartyName().add(name);

				PartyIdentificationType pit=cs.getCacFactory().createPartyIdentificationType();
				IDType typeParty=cs.getCbcFactory().createIDType();
				typeParty.setValue(objeto.getLicitador().getIdentificador());
				typeParty.setSchemeName(objeto.getLicitador().getTipoIdentificador());
				pit.setID(typeParty);
				party.getPartyIdentification().add(pit);
				
				
				
				//Se indica la direccin
				LocationType location = cs.getCacFactory().createLocationType();
				AddressType addressType = cs.getCacFactory().createAddressType();
			
				if (objeto.getLicitador().getCiudad().length() > 0){
					CityNameType cityName = cs.getCbcFactory().createCityNameType();
					cityName.setValue(objeto.getLicitador().getCiudad());
					addressType.setCityName(cityName);
				}
				
				if (objeto.getLicitador().getCodigoPostal().length() > 0){
					PostalZoneType postalZoneType = cs.getCbcFactory().createPostalZoneType();
					postalZoneType.setValue(objeto.getLicitador().getCodigoPostal());
					addressType.setPostalZone(postalZoneType);
				}

				if (objeto.getLicitador().getDireccion().length() > 0){
					AddressLineType addressLine = cs.getCacFactory().createAddressLineType();
					LineType line = cs.getCbcFactory().createLineType();
					line.setValue(objeto.getLicitador().getDireccion());
					addressLine.setLine(line);
					addressType.getAddressLine().add(addressLine);
				}

				IdentificationCodeType identificationCode = new IdentificationCodeType();
				String idPais = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.COUNTRY_CODE)[objeto.getLicitador().getIdPais()][1];
				Code paisCode = crearCode(idPais, objeto.getLicitador().getPais(), ConstantsGC.COUNTRY_CODE, ConstantsGC.COUNTRY_CODE_VER);

				identificationCode.setValue(idPais);
				identificationCode.setListURI(ConstantsGC.COUNTRY_CODE);
				identificationCode.setListVersionID(ConstantsGC.COUNTRY_CODE_VER);
				identificationCode.setName(paisCode.getDescription());
				CountryType countryType = new CountryType();
				countryType.setIdentificationCode(identificationCode);
				NameType name2 = new NameType();
				name2.setValue(paisCode.getDescription());
				countryType.setName(name2);
				addressType.setCountry(countryType);
				
				location.setAddress(addressType);
				
				//Se indica el cdigo nuts			
				CountrySubentityType countrySubentityType = cs.getCbcFactory().createCountrySubentityType();
				countrySubentityType.setValue(objeto.getLicitador().getNuts());
				location.setCountrySubentity(countrySubentityType);
				
				CountrySubentityCodeType codeType = cs.getCbcFactory().createCountrySubentityCodeType();
				codeType.setValue(objeto.getLicitador().getIdNuts());
				codeType.setListURI(ConstantsGC.NUTS);
				codeType.setListVersionID(ConstantsGC.NUTS_VER);
				codeType.setName(objeto.getLicitador().getNuts());
				location.setCountrySubentityCode(codeType);
				

				party.setPhysicalLocation(location);
				res.setWinningParty(party);
			}
			
			
			//Fin de la parte comun a Adjudicacion y Formalizacion

			ResultCodeType rct = cs.getCbcFactory().createResultCodeType();
			rct.setValue("8");
			rct.setLanguageID(ConstantsGC.LANGUAGE_ID);
			rct.setName("Adjudicado");
			rct.setListVersionID(ConstantsGC.TENDER_RESULT_VER);
			rct.setListSchemeURI(ConstantsGC.TENDER_RESULT);
			rct.setListURI(ConstantsGC.TENDER_RESULT);
			res.setResultCode(rct); 	


		}catch (Exception e){
			e.printStackTrace();
		}
		return res;
	}
	
	protected static TenderResultType crearTenderResultFormalizacion(ExpedienteBean objeto )
	{
		TenderResultType res=crearTenderResultAdjudicacion(objeto);
		res.getResultCode().setValue("9");
		res.getResultCode().setName("Formalizado");
		
		//Hay que incluir informacion sobre el contrato		
		ContractType contrato = crearContract(objeto.getNumContrato(), objeto.getFechaFormalizacion(), objeto.getFechaVigorContrato());
		res.setContract(contrato);
	
		
		
		return res;
	}
	
	protected static TenderResultType crearTenderResultRenuncia(ExpedienteBean objeto )
	{
		TenderResultType res=null;
		try{

			res=cs.getCacFactory().createTenderResultType();

			//Fecha del acuerdo
			AwardDateType awardDate = cs.getCbcFactory().createAwardDateType();
			awardDate.setValue(datetoXMLGregorianCalendar(objeto.getFechaAcuerdo()));
			res.setAwardDate(awardDate);
			
			//Tipo de resolucion

			ResultCodeType rct = cs.getCbcFactory().createResultCodeType();

			if (objeto.getTipoResolucion().equals(TipoDocumento.DESIERTO)) {
				rct.setValue("3");
				rct.setName("Desierto");}
			if (objeto.getTipoResolucion().equals(TipoDocumento.DESISTIMIENTO)) {
				rct.setValue("4");
				rct.setName("Desistimiento");}
			if (objeto.getTipoResolucion().equals(TipoDocumento.RENUNCIA)) {
				rct.setValue("5");
				rct.setName("Renuncia");}

			rct.setLanguageID(ConstantsGC.LANGUAGE_ID);

			rct.setListVersionID(ConstantsGC.TENDER_RESULT_VER);
			rct.setListSchemeURI(ConstantsGC.TENDER_RESULT);
			rct.setListURI(ConstantsGC.TENDER_RESULT);
			res.setResultCode(rct); 
			
			//Numero de ofertas recibidas
						
			ReceivedTenderQuantityType rtq=cs.getCbcFactory().createReceivedTenderQuantityType();
			if (objeto.getNumOfertasRecibidas() != null){
				rtq.setValue(new BigDecimal(objeto.getNumOfertasRecibidas()));
			}
			res.setReceivedTenderQuantity(rtq);

		}catch (Exception e){
			e.printStackTrace();
		}
		return res;
	}
	
	protected static TenderResultType crearTenderResultMenor(ExpedienteBean objeto )
	{
		TenderResultType res=null;
		try{
			res=cs.getCacFactory().createTenderResultType();

			//Parte comun a adjudicacion, formalizacion, renuncia, desierto y desistimiento
			AwardDateType awardDate = cs.getCbcFactory().createAwardDateType();
			
			if (objeto.getLicitador()!=null){
				
				//Fecha de adjudicacion
				awardDate.setValue(datetoXMLGregorianCalendar(objeto.getLicitador().getFechaAdjudicacion()));
				res.setAwardDate(awardDate);
	
				//Importes de adjudicacion
				TenderedProjectType tpt = cs.getCacFactory().createTenderedProjectType();
				LegalMonetaryTotalType mtt= cs.getCacFactory().createLegalMonetaryTotalType();

				TaxExclusiveAmountType amountType=cs.getCbcFactory().createTaxExclusiveAmountType();
				amountType.setValue(new BigDecimal(objeto.getLicitador().getImporteSinImpuestos()));
				amountType.setCurrencyID(CurrencyCodeContentType.EUR );
				mtt.setTaxExclusiveAmount(amountType);

				PayableAmountType amountType2=cs.getCbcFactory().createPayableAmountType();
				amountType2.setValue(new BigDecimal(objeto.getLicitador().getImporteConImpuestos()));
				amountType2.setCurrencyID(CurrencyCodeContentType.EUR);
				mtt.setPayableAmount(amountType2);

				tpt.setLegalMonetaryTotal(mtt);

				res.setAwardedTenderedProject(tpt);
				
				//Numero de ofertas recibidas
				
				ReceivedTenderQuantityType rtq=cs.getCbcFactory().createReceivedTenderQuantityType();
				rtq.setValue(new BigDecimal(objeto.getLicitador().getNumOfertasRecibidas()));
				res.setReceivedTenderQuantity(rtq);


				/**WinningParty **/

				PartyType party = cs.getCacFactory().createPartyType();

				PartyNameType name = cs.getCacFactory().createPartyNameType();
				NameType na = cs.getCbcFactory().createNameType();
				na.setValue(objeto.getLicitador().getNombre());
				name.setName(na);
				party.getPartyName().add(name);

				PartyIdentificationType pit=cs.getCacFactory().createPartyIdentificationType();
				IDType typeParty=cs.getCbcFactory().createIDType();
				typeParty.setValue(objeto.getLicitador().getIdentificador());
				typeParty.setSchemeName(objeto.getLicitador().getTipoIdentificador());
				pit.setID(typeParty);
				party.getPartyIdentification().add(pit);

				

				CountryType pais = cs.getCacFactory().createCountryType();
				IdentificationCodeType idcode = cs.getCbcFactory().createIdentificationCodeType();
				idcode.setValue("ES");
				idcode.setLanguageID("es");
				idcode.setListVersionID("0.3");				
				pais.setIdentificationCode(idcode);

				res.setWinningParty(party);
			}
			//Fin de la parte comun a Adjudicacion y Formalizacion

			ResultCodeType rct = cs.getCbcFactory().createResultCodeType();
			rct.setValue("8");
			rct.setLanguageID(ConstantsGC.LANGUAGE_ID);
			rct.setName("Adjudicado");
			rct.setListVersionID(ConstantsGC.TENDER_RESULT_VER);
			rct.setListSchemeURI(ConstantsGC.TENDER_RESULT);
			rct.setListURI(ConstantsGC.TENDER_RESULT);
			res.setResultCode(rct); 	


		}catch (Exception e){
			e.printStackTrace();
		}
		return res;
	}
	
	
	protected static Event crearEvent(EventoAperturaBean objeto){
		Event eventoApertura=null;
		if (objeto!=null){
			eventoApertura=new Event();
			eventoApertura.setIdentifier(objeto.getNombre());			
			eventoApertura.setAddress(objeto.getCalle());
			eventoApertura.setCity(objeto.getPoblacion());
			eventoApertura.setDescription(objeto.getDescripcion());
			eventoApertura.setOccurrencedate(objeto.getFechaApertura());
			eventoApertura.setOccurrencetime(objeto.getFechaApertura());
			eventoApertura.setPostalZone(objeto.getCp());
			eventoApertura.setCode(crearCode("4","Apertura sobre oferta econmica",ConstantsGC.EVENTTYPECODE,ConstantsGC.EVENTTYPECODE_VER));
			eventoApertura.setLocationDescription(objeto.getLugar());
			String idPais=ComboBoxUtils.getComboBoxByConstant(ConstantsGC.COUNTRY_CODE)[objeto.getIdPais()][1];
			eventoApertura.setCountry(crearCode(idPais,objeto.getPais(),ConstantsGC.COUNTRY_CODE,null));
			String idTipoEvento=ComboBoxUtils.getComboBoxByConstant(ConstantsGC.EVENTTYPECODE)[objeto.getIdTipoEventoApertura()][1];
			eventoApertura.setTipoEvento(crearCode(idTipoEvento,objeto.getTipoEventoApertura(),ConstantsGC.ATTENDANCERESTRICTIONCODE,ConstantsGC.ATTENDANCERESTRICTIONCODE_VER));
			eventoApertura.setCondicionesAcceso(objeto.getRequisitosAsistentes());
		}
		return eventoApertura;
	}
	 
	protected  static Code crearCode(String codevalue,String name, String nombreLista, String versionId)
	{
		Code res = new Code();
		res.setCodevalue(String.valueOf(codevalue));
		res.setListUri(nombreLista);
		res.setDescription(name);
		res.setListVersionId(versionId);
		
		return res;
	}
	
	protected static Contractingauthorityparty crearContractingParty()
	{
		OrganoContratacionBean datosOC=SessionDataManager.getInstance().getOrganoContratacion();		
		
		Contractingauthorityparty cap = new Contractingauthorityparty();
			
		cap.setPartyname(datosOC.getNombreOC());
		
		
		cap.setCif(datosOC.getNumDocumento());
		cap.setIdPlataforma(datosOC.getIdPlataforma());	
		

		String idAdmin=ComboBoxUtils.getComboBox(ConstantsGC.CONTRACTING_AUTHORITY_TYPE)[datosOC.getIdOrgContratante()][1];
		cap.setContractingauthoritytypecode(crearCode(idAdmin,datosOC.getNombreAdmin(),ConstantsGC.CONTRACTING_AUTHORITY_TYPE,null));

		cap.setIdPlataforma(datosOC.getIdPlataforma());
		
		cap.setAddressLine(datosOC.getVia());
		cap.setPostalZone(datosOC.getCP());
		cap.setCityName(datosOC.getPoblacion());
		
		if (datosOC.getIdPais() != -1) {
			CountryType pais = cs.getCacFactory().createCountryType();
			IdentificationCodeType idcode = cs.getCbcFactory()
					.createIdentificationCodeType();
			
			String codeValuePais=ComboBoxUtils.getComboBox(ConstantsGC.COUNTRY_CODE)[datosOC.getIdPais()][1];
			cap.setCountry(crearCode(codeValuePais,datosOC.getPais(),ConstantsGC.COUNTRY_CODE,ConstantsGC.COUNTRY_CODE_VER));
		}

		
		cap.setContactEmail(datosOC.getEmail());
		cap.setTelephone(datosOC.getTelefono());
		cap.setFax(datosOC.getFax());
	
		return cap;
		
		
	}
	
	protected static PeriodType crearPlannedPeriod(CondicionesEjecucionBean objeto)
	{
		PeriodType pp=null;
		try{

			pp=cs.getCacFactory().createPeriodType();

			//Fecha de Inicio
			if (objeto.getFechaInicio()!=null){
			StartDateType startDate = cs.getCbcFactory().createStartDateType();
			startDate.setValue(datetoXMLGregorianCalendar(objeto.getFechaInicio()));
			pp.setStartDate(startDate);
			}
			
			//Fecha Final
			
			if (objeto.getFechaFinal()!=null)
			{
			EndDateType endDate = cs.getCbcFactory().createEndDateType();
			endDate.setValue(datetoXMLGregorianCalendar(objeto.getFechaFinal()));
			pp.setEndDate(endDate);
			}
			
			//Duracion
			if (objeto.getDuracion()!=null)
			{
			DurationMeasureType duracion=cs.getCbcFactory().createDurationMeasureType();
			duracion.setValue(new BigDecimal(objeto.getDuracion()));
			String unit=ComboBoxUtils.getComboBox(ConstantsGC.PERIOD_UNIT)[objeto.getUnidadDuracion()][1];
			
			duracion.setUnitCode(UnitCodeContentType.fromValue(unit));
			pp.setDurationMeasure(duracion);
			}
			
		}catch (Exception e){
			e.printStackTrace();
		}
		
		return pp;
	}
	

}
