/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/

package es.dgpe.place.client.utils.documentsgenerator;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;

import org.dgpe.codice.common.caclib.AddressLineType;
import org.dgpe.codice.common.caclib.AddressType;
import org.dgpe.codice.common.caclib.AppealTermsType;
import org.dgpe.codice.common.caclib.AwardingCriteriaType;
import org.dgpe.codice.common.caclib.AwardingTermsType;
import org.dgpe.codice.common.caclib.BudgetAmountType;
import org.dgpe.codice.common.caclib.CommodityClassificationType;
import org.dgpe.codice.common.caclib.CountryType;
import org.dgpe.codice.common.caclib.DocumentReferenceType;
import org.dgpe.codice.common.caclib.EvaluationCriteriaType;
import org.dgpe.codice.common.caclib.LocationType;
import org.dgpe.codice.common.caclib.PartyIdentificationType;
import org.dgpe.codice.common.caclib.PartyNameType;
import org.dgpe.codice.common.caclib.PartyType;
import org.dgpe.codice.common.caclib.ProcurementProjectLotType;
import org.dgpe.codice.common.caclib.ProcurementProjectType;
import org.dgpe.codice.common.caclib.TenderRequirementType;
import org.dgpe.codice.common.caclib.TendererQualificationRequestType;
import org.dgpe.codice.common.caclib.TendererRequirementType;
import org.dgpe.codice.common.caclib.TenderingTermsType;
import org.dgpe.codice.common.cbclib.AgencyIDType;
import org.dgpe.codice.common.cbclib.AwardingCriteriaSubTypeCodeType;
import org.dgpe.codice.common.cbclib.AwardingCriteriaTypeCodeType;
import org.dgpe.codice.common.cbclib.CityNameType;
import org.dgpe.codice.common.cbclib.ContractFolderIDType;
import org.dgpe.codice.common.cbclib.CountrySubentityCodeType;
import org.dgpe.codice.common.cbclib.CountrySubentityType;
import org.dgpe.codice.common.cbclib.DescriptionType;
import org.dgpe.codice.common.cbclib.EvaluationCriteriaTypeCodeType;
import org.dgpe.codice.common.cbclib.IDType;
import org.dgpe.codice.common.cbclib.IdentificationCodeType;
import org.dgpe.codice.common.cbclib.IssueDateType;
import org.dgpe.codice.common.cbclib.IssueTimeType;
import org.dgpe.codice.common.cbclib.ItemClassificationCodeType;
import org.dgpe.codice.common.cbclib.LineType;
import org.dgpe.codice.common.cbclib.NameType;
import org.dgpe.codice.common.cbclib.NoteType;
import org.dgpe.codice.common.cbclib.PlannedDateType;
import org.dgpe.codice.common.cbclib.PostalZoneType;
import org.dgpe.codice.common.cbclib.RequirementTypeCodeType;
import org.dgpe.codice.common.cbclib.TaxExclusiveAmountType;
import org.dgpe.codice.common.cbclib.TechnicalCommitteeDescriptionType;
import org.dgpe.codice.common.cbclib.TendererRequirementTypeCodeType;
import org.dgpe.codice.common.cbclib.TotalAmountType;
import org.dgpe.codice.common.cbclib.UUIDType;
import org.dgpe.codice.common.cbclib.WebsiteURIType;
import org.dgpe.codice.common.cbclib.WeightNumericType;
import org.dgpe.codice.maindoc.callfortenders.CallForTendersType;
import org.dgpe.codice.maindoc.contractawardnotice.ContractAwardNoticeType;
import org.dgpe.codice.maindoc.contractmodificationnotice.ContractModificationNoticeType;
import org.dgpe.codice.maindoc.contractnotice.ContractNoticeType;
import org.dgpe.codice.maindoc.pin.PriorInformationNoticeType;
import org.oasis.ubl.codelist.currencycode.CurrencyCodeContentType;

import com.sun.xml.internal.bind.v2.runtime.unmarshaller.XsiNilLoader.Array;

import es.dgpe.place.client.beans.AnularAnuncioBean;
import es.dgpe.place.client.beans.AnularDocumentoBean;
import es.dgpe.place.client.beans.CondicionesEjecucionBean;
import es.dgpe.place.client.beans.CristeriosAdjudicacionBean;
import es.dgpe.place.client.beans.DatosModificacionBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.ReceptorRecursosBean;
import es.dgpe.place.client.beans.RequisitosParticipacionBean;
import es.dgpe.place.client.beans.codice.Code;
import es.dgpe.place.client.beans.codice.Contractingauthorityparty;
import es.dgpe.place.client.beans.codice.Documentreference;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ClientException;
import es.dgpe.place.client.utils.ClienteLlamadas;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import ext.place.codice.common.caclib.AdditionalPublicationRequestType;
import ext.place.codice.common.caclib.GeneralDocumentCancellationType;
import ext.place.codice.common.caclib.NoticeCancellationAttachmentDocumentReferenceType;
import ext.place.codice.common.caclib.NoticeCancellationType;
import ext.place.codice.common.cbclib.CancellationReasonCodeType;
import ext.place.codice.maindoc.cancelgeneraldocumentrequest.CancelGeneralContractDocumentRequestType;
import ext.place.codice.maindoc.cancelnoticerequest.CancelNoticeRequestType;

public class DocumentsGenerator extends DocumentGeneratorCommon {

	public static PriorInformationNoticeType generateDocumentPriorInformationNotice(ExpedienteBean objeto, String id,
			String noticeid) {

		PriorInformationNoticeType documento = null;
		try {
			documento = cs.getPinFactory().createPriorInformationNoticeType();
			IssueDateType issuedate = cs.getCbcFactory().createIssueDateType();

			// Generacin del versionado Codice:
			documento.setUBLVersionID(getUBLVersionID());
			documento.setCustomizationID(getCustomizationID());
			documento.setProfileID(getProfileID());
			documento.setID(getID(id));
			documento.setUUID(getUUID(id));

			if (objeto != null) {
				PlannedDateType plannedDate = cs.getCbcFactory().createPlannedDateType();
				plannedDate.setValue(datetoXMLGregorianCalendar(objeto.getFechaPrevIniProcAdj()));
				documento.setPlannedDate(plannedDate);
			}

			// se asignan los datos del documento, no componentes agregados
			issuedate.setValue(generatePublishDateXMLGregorianCalendar());
			documento.setIssueDate(issuedate);
			IssueTimeType issuetime = cs.getCbcFactory().createIssueTimeType();
			issuetime.setValue(generatePublishTimeXMLGregorianCalendar());
			documento.setIssueTime(issuetime);

			// contractfileid es el expedient number del espacio virtual de
			// licitacin
			ContractFolderIDType contractfileid = cs.getCbcFactory().createContractFolderIDType();
			contractfileid.setValue(objeto.getNumExpediente());
			documento.setContractFolderID(contractfileid);

			Contractingauthorityparty cap = crearContractingParty();
			// se asignan los componentes agregados al documento
			documento.setContractingParty(crearContractingPartyType(cap));

			// Tipo de contrato
			String idTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_CONTRACT)[objeto
					.getIdTipoContrato()][1];
			Code tipoContrato = crearCode(idTipoContrato, objeto.getTipoContrato(), ConstantsGC.TENDERING_CONTRACT,
					ConstantsGC.TENDERING_CONTRACT_VER);

			// Subtipo de contrato
			String idSubTipoContrato = null;
			Code subtipoContrato = null;
			if (idTipoContrato.equalsIgnoreCase("1")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.GOODS_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), ConstantsGC.GOODS_CONTRACT,
						ConstantsGC.GOODS_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("2")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_SERVICE_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(),
						ConstantsGC.TENDERING_SERVICE_CONTRACT, ConstantsGC.TENDERING_SERVICE_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("3")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.WORKS_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), ConstantsGC.WORKS_CONTRACT,
						ConstantsGC.WORKS_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("40")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION)[objeto.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(),
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION,
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION_VER);
			}

			// Lugar de ejecucin
			String idPais = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.COUNTRY_CODE)[objeto.getIdPais()][1];
			Code pais = crearCode(idPais, objeto.getPais(), ConstantsGC.COUNTRY_CODE, ConstantsGC.COUNTRY_CODE_VER);
			String idNuts = objeto.getIdNuts();
			Code nuts = crearCode(idNuts, objeto.getNuts(), ConstantsGC.NUTS, ConstantsGC.NUTS_VER);

			// CPV

			String idCPV = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.CPV)[objeto.getIdCpv()][1];
			Code cpv = crearCode(idCPV, objeto.getCpv(), ConstantsGC.CPV, ConstantsGC.CPV_VER);

			BigDecimal importeSin = null;
			BigDecimal importeCon = null;
			BigDecimal valorEstimado = null;

			if (objeto.getImporteSinImpuestos().length() > 0)
				try {
					importeSin = new BigDecimal(objeto.getImporteSinImpuestos());
				} catch (Exception e) {
					e.printStackTrace();
				}

			if (objeto.getImporteConImpuestos().length() > 0)
				try {
					importeCon = new BigDecimal(objeto.getImporteConImpuestos());
				} catch (Exception e) {
					e.printStackTrace();
				}

			if (objeto.getValorEstimado().length() > 0)
				try {
					valorEstimado = new BigDecimal(objeto.getValorEstimado());
				} catch (Exception e) {
					e.printStackTrace();
				}

			documento.setProcurementProject(crearProcurementProject(tipoContrato, subtipoContrato,
					objeto.getObjetoContrato(), cpv, importeSin, importeCon, valorEstimado, pais, nuts));

			// Preparacin de TenderingProcess
			String idTipoProc = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_PROCESS)[objeto
					.getIdProcContratacion()][1];
			Code codeTipoProcedimiento = crearCode(idTipoProc, objeto.getProcContratacion(),
					ConstantsGC.TENDERING_PROCESS, ConstantsGC.TENDERING_PROCESS_VER);

			String idTipoTram = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.DILIGENCE)[objeto
					.getIdTipoTramitacion()][1];
			Code codeTipoTram = crearCode(idTipoTram, objeto.getTipoTramitacion(), ConstantsGC.DILIGENCE,
					ConstantsGC.DILIGENCE_VER);

			String idTipoTramGasto = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.EXPENSE)[objeto
					.getIdTipoTramitacionGasto()][1];
			Code codeTipoTramGasto = crearCode(idTipoTramGasto, objeto.getTipoTramitacionGasto(), ConstantsGC.EXPENSE,
					ConstantsGC.EXPENSE_VER);

			documento.setTenderingProcess(crearTenderingProcess(codeTipoProcedimiento, null, null,
					null, null, null, null));

			// Preparacion de TenderingTerms
			documento.setTenderingTerms(crearTenderingTerms(-1, objeto.getDescSolvencia(),
						crearContractingParty(), objeto.getIdDirectivaAplicacion()));

			// Se aade el receptor de recursos
			documento.getTenderingTerms().setAppealTerms(obtenerReceptorRecursos(objeto));

		} catch (Exception e) {
			e.printStackTrace();
		}

		return documento;
	}

	public static ContractNoticeType generateDocumentContractNotice(ExpedienteBean objeto, String id, String noticeid) {

		ContractNoticeType documento = null;
		try {
			documento = cs.getCnFactory().createContractNoticeType();
			IssueDateType issuedate = cs.getCbcFactory().createIssueDateType();

			// Generacin del versionado Codice:
			documento.setUBLVersionID(getUBLVersionID());
			documento.setCustomizationID(getCustomizationID());
			documento.setProfileID(getProfileID());
			documento.setID(getID(id));
			documento.setUUID(getUUID(id));

			// se asignan los datos del documento, no componentes agregados
			issuedate.setValue(generatePublishDateXMLGregorianCalendar());
			documento.setIssueDate(issuedate);
			IssueTimeType issuetime = cs.getCbcFactory().createIssueTimeType();
			issuetime.setValue(generatePublishTimeXMLGregorianCalendar());
			documento.setIssueTime(issuetime);

			// ContractFolderId es el expedient number del espacio virtual de
			// licitacin
			ContractFolderIDType contractfileid = cs.getCbcFactory().createContractFolderIDType();
			contractfileid.setValue(objeto.getNumExpediente());
			documento.setContractFolderID(contractfileid);

			Contractingauthorityparty cap = crearContractingParty();
			// se asignan los componentes agregados al documento
			documento.setContractingParty(crearContractingPartyType(cap));

			// Preparacin de ProcurementProject

			// Tipo de contrato
			String idTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_CONTRACT)[objeto
					.getIdTipoContrato()][1];
			Code tipoContrato = crearCode(idTipoContrato, objeto.getTipoContrato(), ConstantsGC.TENDERING_CONTRACT,
					ConstantsGC.TENDERING_CONTRACT_VER);

			// Subtipo de contrato
			String idSubTipoContrato = null;
			Code subtipoContrato = null;
			if (idTipoContrato.equalsIgnoreCase("1")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.GOODS_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), ConstantsGC.GOODS_CONTRACT,
						ConstantsGC.GOODS_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("2")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_SERVICE_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(),
						ConstantsGC.TENDERING_SERVICE_CONTRACT, ConstantsGC.TENDERING_SERVICE_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("3")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.WORKS_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), ConstantsGC.WORKS_CONTRACT,
						ConstantsGC.WORKS_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("40")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION)[objeto.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(),
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION,
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION_VER);
			}

			// Lugar de ejecucin
			String idPais = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.COUNTRY_CODE)[objeto.getIdPais()][1];
			Code pais = crearCode(idPais, objeto.getPais(), ConstantsGC.COUNTRY_CODE, ConstantsGC.COUNTRY_CODE_VER);
			String idNuts = objeto.getIdNuts();
			Code nuts = crearCode(idNuts, objeto.getNuts(), ConstantsGC.NUTS, ConstantsGC.NUTS_VER);

			// CPV
			String idCPV = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.CPV)[objeto.getIdCpv()][1];
			Code cpv = crearCode(idCPV, objeto.getCpv(), ConstantsGC.CPV, ConstantsGC.CPV_VER);

			BigDecimal importeSin = null;
			BigDecimal importeCon = null;
			BigDecimal valorEstimado = null;

			if (objeto.getImporteSinImpuestos().length() > 0)
				try {
					importeSin = new BigDecimal(objeto.getImporteSinImpuestos());
				} catch (Exception e) {
					e.printStackTrace();
				}

			if (objeto.getImporteConImpuestos().length() > 0)
				try {
					importeCon = new BigDecimal(objeto.getImporteConImpuestos());
				} catch (Exception e) {
					e.printStackTrace();
				}

			if (objeto.getValorEstimado().length() > 0)
				try {
					valorEstimado = new BigDecimal(objeto.getValorEstimado());
				} catch (Exception e) {
					e.printStackTrace();
				}

			// Duracion del contrato
			CondicionesEjecucionBean duracionContrato = null;
			if (objeto.getCondicionesEjecucion() != null) {
				duracionContrato = objeto.getCondicionesEjecucion();
			}

			documento.setProcurementProject(
					crearProcurementProject(tipoContrato, subtipoContrato, objeto.getObjetoContrato(), cpv, importeSin,
							importeCon, valorEstimado, duracionContrato, pais, nuts));

			// Preparacin de TenderingProcess
			String idTipoProc = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_PROCESS)[objeto.getIdProcContratacion()][1];
			String nombreTipoProc = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_PROCESS)[objeto.getIdProcContratacion()][0];		
			Code codeTipoProcedimiento = crearCode(idTipoProc, nombreTipoProc, ConstantsGC.TENDERING_PROCESS, ConstantsGC.TENDERING_PROCESS_VER);

			String idTipoTram = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.DILIGENCE)[objeto.getIdTipoTramitacion()][1];
			String nombreTipoTram = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.DILIGENCE)[objeto.getIdTipoTramitacion()][0];
			Code codeTipoTram = crearCode(idTipoTram, nombreTipoTram, ConstantsGC.DILIGENCE, ConstantsGC.DILIGENCE_VER);

			String idTipoTramGasto = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.EXPENSE)[objeto.getIdTipoTramitacionGasto()][1];
			String nombreTipoTramGasto = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.EXPENSE)[objeto.getIdTipoTramitacionGasto()][0];
			Code codeTipoTramGasto = crearCode(idTipoTramGasto, nombreTipoTramGasto, ConstantsGC.EXPENSE,ConstantsGC.EXPENSE_VER);

			String idFormaPresentacion = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDER_DELIVERY)[objeto.getIdFormaPresentacion()][1];
			String nombreFormaPresentacion = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDER_DELIVERY)[objeto.getIdFormaPresentacion()][0];
			Code codeFormaPresentacion = crearCode(idFormaPresentacion, nombreFormaPresentacion, ConstantsGC.TENDER_DELIVERY, ConstantsGC.TENDER_DELIVERY_VER);

			
			Boolean acuerdoCP = (objeto.getAcuerdoCP() == 0) ? new Boolean(true) : new Boolean(false);		
			
			documento.setTenderingProcess(crearTenderingProcess(codeTipoProcedimiento, codeTipoTram, codeTipoTramGasto,
					codeFormaPresentacion, objeto.getFechaFinOfertas(), objeto.getFechaFinSolicitudes(),
					crearEvent(objeto.getEventoApertura()), objeto.getFechaEnvioInvitaciones(),
					objeto.getJustifProcAcelerado(), objeto.getIndicadorFasesSucesivas(),
					objeto.getIndicadorSubastaElectronica(), acuerdoCP, objeto, null, null));

			

			// Preparacion de TenderingTerms
			if ((objeto.getDescSolvencia() != null) | (objeto.getDirectivaAplicacion() != null)
					| (objeto.getJustifNoPubPliegos() != null) | objeto.getCondicionesEjecucion() != null) {
				documento.setTenderingTerms(crearTenderingTerms(objeto.getClasificacion(), objeto.getDescSolvencia(),
						crearContractingParty(), objeto.getIdDirectivaAplicacion(), objeto.getJustifNoPubPliegos(),
						objeto.getCondicionesEjecucion(), objeto.getIndicadorCatalogoElectronico()));
			} else {
				documento.setTenderingTerms(crearTenderingTerms(objeto.getClasificacion(), null,
						crearContractingParty(), objeto.getIdDirectivaAplicacion(), objeto.getJustifNoPubPliegos(),
						objeto.getCondicionesEjecucion(), objeto.getIndicadorCatalogoElectronico()));
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
		
		// Si el expediente tiene lotes, se aaden sus elementos correspondientes
		if (objeto.getLotes() != null && objeto.getLotes().isTieneLotes()) {
			ArrayList<ProcurementProjectLotType> listaLotes;
			listaLotes = obtenerDatosLotes(objeto);
			
			for (ProcurementProjectLotType procurementProjectLotType : listaLotes) {
				documento.getProcurementProjectLot().add(procurementProjectLotType);
			}
		}
		
		//Se aaden los distintos contactos a partir de la indicada sobre el rgano de contratacin
		insertarInformacionContacto(documento.getTenderingTerms());

		// Se aade el receptor de recursos
		documento.getTenderingTerms().setAppealTerms(obtenerReceptorRecursos(objeto));
		
		//Se aaden los requisitos de solvencia y capacidad de contratar
		documento.getTenderingTerms().setTendererQualificationRequest(obtenerRequisitosSolvencia(objeto, documento.getTenderingTerms().getTendererQualificationRequest()));
		
		//Si es anuncio de licitacin, se aaden los criterios de adjudicacin.
		documento.getTenderingTerms().setAwardingTerms(obtenerCriteriosAdjudiacion(objeto));

		return documento;
	}

	

	public static CallForTendersType generateDocumentCallForTenders(ExpedienteBean objeto, String id, String noticeid) {

		CallForTendersType documento = null;

		try {
			documento = cs.getCftFactory().createCallForTendersType();
			IssueDateType issuedate = cs.getCbcFactory().createIssueDateType();

			// Generacin del versionado Codice:
			documento.setUBLVersionID(getUBLVersionID());
			documento.setCustomizationID(getCustomizationID());
			documento.setProfileID(getProfileID());
			documento.setID(getID(id));
			documento.setUUID(getUUID(id));

			// se asignan los datos del documento, no componentes agregados
			issuedate.setValue(generatePublishDateXMLGregorianCalendar());
			documento.setIssueDate(issuedate);
			IssueTimeType issuetime = cs.getCbcFactory().createIssueTimeType();
			issuetime.setValue(generatePublishTimeXMLGregorianCalendar());
			documento.setIssueTime(issuetime);

			// contractfileid es el expedient number del espacio virtual de
			// licitacin
			ContractFolderIDType contractfileid = cs.getCbcFactory().createContractFolderIDType();
			contractfileid.setValue(objeto.getNumExpediente());
			documento.setContractFolderID(contractfileid);

			Contractingauthorityparty cap = crearContractingParty();
			// se asignan los componentes agregados al documento
			documento.setContractingParty(crearContractingPartyType(cap));

			// Tipo de contrato
			String idTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_CONTRACT)[objeto
					.getIdTipoContrato()][1];
			Code tipoContrato = crearCode(idTipoContrato, objeto.getTipoContrato(), ConstantsGC.TENDERING_CONTRACT,
					ConstantsGC.TENDERING_CONTRACT_VER);

			// Subtipo de contrato
			String idSubTipoContrato = null;
			Code subtipoContrato = null;
			if (idTipoContrato.equalsIgnoreCase("1")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.GOODS_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), ConstantsGC.GOODS_CONTRACT,
						ConstantsGC.GOODS_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("2")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_SERVICE_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(),
						ConstantsGC.TENDERING_SERVICE_CONTRACT, ConstantsGC.TENDERING_SERVICE_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("3")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.WORKS_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), ConstantsGC.WORKS_CONTRACT,
						ConstantsGC.WORKS_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("40")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION)[objeto.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(),
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION,
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION_VER);
			}

			// Lugar de ejecucin
			String idPais = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.COUNTRY_CODE)[objeto.getIdPais()][1];
			Code pais = crearCode(idPais, objeto.getPais(), ConstantsGC.COUNTRY_CODE, ConstantsGC.COUNTRY_CODE_VER);
			String idNuts = objeto.getIdNuts();
			Code nuts = crearCode(idNuts, objeto.getNuts(), ConstantsGC.NUTS, ConstantsGC.NUTS_VER);

			// CPV
			String idCPV = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.CPV)[objeto.getIdCpv()][1];
			Code cpv = crearCode(idCPV, objeto.getCpv(), ConstantsGC.CPV, ConstantsGC.CPV_VER);

			BigDecimal importeSin = null;
			BigDecimal importeCon = null;
			BigDecimal valorEstimado = null;

			if (objeto.getImporteSinImpuestos().length() > 0)
				try {
					importeSin = new BigDecimal(objeto.getImporteSinImpuestos());
				} catch (Exception e) {
					e.printStackTrace();
				}

			if (objeto.getImporteConImpuestos().length() > 0)
				try {
					importeCon = new BigDecimal(objeto.getImporteConImpuestos());
				} catch (Exception e) {
					e.printStackTrace();
				}

			if (objeto.getValorEstimado().length() > 0)
				try {
					valorEstimado = new BigDecimal(objeto.getValorEstimado());
				} catch (Exception e) {
					e.printStackTrace();
				}
			// Duracion del contrato
			CondicionesEjecucionBean duracionContrato = null;
			if (objeto.getCondicionesEjecucion() != null) {
				duracionContrato = objeto.getCondicionesEjecucion();
			}

			documento.setProcurementProject(
					crearProcurementProject(tipoContrato, subtipoContrato, objeto.getObjetoContrato(), cpv, importeSin,
							importeCon, valorEstimado, duracionContrato, pais, nuts));

			// Preparacin de TenderingProcess

			String idTipoProc = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_PROCESS)[objeto.getIdProcContratacion()][1];
			String nombreTipoProc = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_PROCESS)[objeto.getIdProcContratacion()][0];		
			Code codeTipoProcedimiento = crearCode(idTipoProc, nombreTipoProc, ConstantsGC.TENDERING_PROCESS, ConstantsGC.TENDERING_PROCESS_VER);

			String idTipoTram = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.DILIGENCE)[objeto.getIdTipoTramitacion()][1];
			String nombreTipoTram = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.DILIGENCE)[objeto.getIdTipoTramitacion()][0];
			Code codeTipoTram = crearCode(idTipoTram, nombreTipoTram, ConstantsGC.DILIGENCE, ConstantsGC.DILIGENCE_VER);

			String idTipoTramGasto = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.EXPENSE)[objeto.getIdTipoTramitacionGasto()][1];
			String nombreTipoTramGasto = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.EXPENSE)[objeto.getIdTipoTramitacionGasto()][0];
			Code codeTipoTramGasto = crearCode(idTipoTramGasto, nombreTipoTramGasto, ConstantsGC.EXPENSE,ConstantsGC.EXPENSE_VER);

			String idFormaPresentacion = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDER_DELIVERY)[objeto.getIdFormaPresentacion()][1];
			String nombreFormaPresentacion = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDER_DELIVERY)[objeto.getIdFormaPresentacion()][0];
			Code codeFormaPresentacion = crearCode(idFormaPresentacion, nombreFormaPresentacion, ConstantsGC.TENDER_DELIVERY, ConstantsGC.TENDER_DELIVERY_VER);

			Boolean acuerdoCP = (objeto.getAcuerdoCP() == 0) ? new Boolean(true) : new Boolean(false);		
			documento.setTenderingProcess(crearTenderingProcess(codeTipoProcedimiento, codeTipoTram, codeTipoTramGasto,
					codeFormaPresentacion, objeto.getFechaFinOfertas(), objeto.getFechaFinSolicitudes(),
					crearEvent(objeto.getEventoApertura()), objeto.getFechaEnvioInvitaciones(),
					objeto.getJustifProcAcelerado(), objeto.getIndicadorFasesSucesivas(),
					objeto.getIndicadorSubastaElectronica(), acuerdoCP, objeto, null,null));

		
			// Preparacion de TenderingTerms
			if ((objeto.getDescSolvencia() != null) | (objeto.getDirectivaAplicacion() != null)
					| (objeto.getJustifNoPubPliegos() != null) | objeto.getCondicionesEjecucion() != null) {
				documento.setTenderingTerms(crearTenderingTerms(objeto.getClasificacion(), objeto.getDescSolvencia(),
						crearContractingParty(), objeto.getIdDirectivaAplicacion(), objeto.getJustifNoPubPliegos(),
						objeto.getCondicionesEjecucion(), objeto.getIndicadorCatalogoElectronico()));
			} else {
				documento.setTenderingTerms(crearTenderingTerms(objeto.getClasificacion(), null,
						crearContractingParty(), objeto.getIdDirectivaAplicacion(), objeto.getJustifNoPubPliegos(),
						objeto.getCondicionesEjecucion(), objeto.getIndicadorCatalogoElectronico()));
			}


			Documentreference tdr = new Documentreference();
			Documentreference ldr = new Documentreference();
			tdr.setDocumentidentifier("DOC_PPT");
			tdr.setDocumenttypecode(crearCode("DOC_PPT", "Documento de Pliego de Prescripciones Tcnicas",
					ConstantsGC.DOCREF_TYPE_CODE, ConstantsGC.DOCREF_TYPE_CODE_VER));
			ldr.setDocumentidentifier("DOC_PCAP");
			ldr.setDocumenttypecode(crearCode("DOC_PCAP", "Documento de Pliego de Clusulas Administrativas",
					ConstantsGC.DOCREF_TYPE_CODE, ConstantsGC.DOCREF_TYPE_CODE_VER));
			documento.setTechnicalDocumentReference(createDocumentReference(tdr, objeto.getUrlPCAP(), null));
			documento.setLegalDocumentReference(createDocumentReference(ldr, objeto.getUrlPPT(), null));

		} catch (Exception e) {
			e.printStackTrace();
		}
		
		
		// Si el expediente tiene lotes, se aaden sus elementos correspondientes
		if (objeto.getLotes() != null && objeto.getLotes().isTieneLotes()) {
			ArrayList<ProcurementProjectLotType> listaLotes;
			listaLotes = obtenerDatosLotes(objeto);

			for (ProcurementProjectLotType procurementProjectLotType : listaLotes) {
				documento.getProcurementProjectLot().add(procurementProjectLotType);
			}
		}
		
		//Se aaden los distintos contactos a partir de la indicada sobre el rgano de contratacin
		insertarInformacionContacto(documento.getTenderingTerms());

		// Se aade el receptor de recursos
		documento.getTenderingTerms().setAppealTerms(obtenerReceptorRecursos(objeto));

		// Se aaden los requisitos de solvencia y capacidad de contratar
		documento.getTenderingTerms().setTendererQualificationRequest(obtenerRequisitosSolvencia(objeto, documento.getTenderingTerms().getTendererQualificationRequest()));

		// Si es anuncio de licitacin, se aaden los criterios de adjudicacin.
		documento.getTenderingTerms().setAwardingTerms(obtenerCriteriosAdjudiacion(objeto));

		return documento;
	}

	public static ContractAwardNoticeType generateDocumentContractAwardNoticeAdjudicacion(ExpedienteBean objeto,
			String id, String noticeid) {
		ContractAwardNoticeType documento = null;
		try {
			documento = cs.getCanFactory().createContractAwardNoticeType();
			IssueDateType issuedate = cs.getCbcFactory().createIssueDateType();

			// Generacin del versionado Codice:
			documento.setUBLVersionID(getUBLVersionID());
			documento.setCustomizationID(getCustomizationID());
			documento.setProfileID(getProfileID());
			documento.setID(getID(id));
			documento.setUUID(getUUID(id));

			// se asignan los datos del documento, no componentes agregados
			issuedate.setValue(generatePublishDateXMLGregorianCalendar());
			documento.setIssueDate(issuedate);
			IssueTimeType issuetime = cs.getCbcFactory().createIssueTimeType();
			issuetime.setValue(generatePublishTimeXMLGregorianCalendar());
			documento.setIssueTime(issuetime);

			// contractfileid es el expedient number del espacio virtual de
			// licitacin
			ContractFolderIDType contractfileid = cs.getCbcFactory().createContractFolderIDType();
			contractfileid.setValue(objeto.getNumExpediente());
			documento.setContractFolderID(contractfileid);

			Contractingauthorityparty cap = crearContractingParty();
			// se asignan los componentes agregados al documento
			documento.setContractingParty(crearContractingPartyType(cap));

			// Tipo de contrato
			String idTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_CONTRACT)[objeto
					.getIdTipoContrato()][1];
			Code tipoContrato = crearCode(idTipoContrato, objeto.getTipoContrato(), ConstantsGC.TENDERING_CONTRACT,
					ConstantsGC.TENDERING_CONTRACT_VER);

			// Subtipo de contrato
			String idSubTipoContrato = null;
			Code subtipoContrato = null;
			if (idTipoContrato.equalsIgnoreCase("1")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.GOODS_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), ConstantsGC.GOODS_CONTRACT,
						ConstantsGC.GOODS_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("2")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_SERVICE_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(),
						ConstantsGC.TENDERING_SERVICE_CONTRACT, ConstantsGC.TENDERING_SERVICE_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("3")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.WORKS_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), ConstantsGC.WORKS_CONTRACT,
						ConstantsGC.WORKS_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("40")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION)[objeto.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(),
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION,
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION_VER);
			}

			// CPV
			String idCPV = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.CPV)[objeto.getIdCpv()][1];
			Code cpv = crearCode(idCPV, objeto.getCpv(), ConstantsGC.CPV, ConstantsGC.CPV_VER);

			BigDecimal importeSin = null;
			BigDecimal importeCon = null;
			BigDecimal valorEstimado = null;

			if (objeto.getImporteSinImpuestos().length() > 0)
				try {
					importeSin = new BigDecimal(objeto.getImporteSinImpuestos());
				} catch (Exception e) {
					e.printStackTrace();
				}

			if (objeto.getImporteConImpuestos().length() > 0)
				try {
					importeCon = new BigDecimal(objeto.getImporteConImpuestos());
				} catch (Exception e) {
					e.printStackTrace();
				}

			if (objeto.getValorEstimado().length() > 0)
				try {
					valorEstimado = new BigDecimal(objeto.getValorEstimado());
				} catch (Exception e) {
					e.printStackTrace();
				}

			// Lugar de ejecucin
			String idPais = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.COUNTRY_CODE)[objeto.getIdPais()][1];
			Code pais = crearCode(idPais, objeto.getPais(), ConstantsGC.COUNTRY_CODE, ConstantsGC.COUNTRY_CODE_VER);
			String idNuts = objeto.getIdNuts();
			Code nuts = crearCode(idNuts, objeto.getNuts(), ConstantsGC.NUTS, ConstantsGC.NUTS_VER);

			// Duracion del contrato
			CondicionesEjecucionBean duracionContrato = null;
			if (objeto.getCondicionesEjecucion() != null) {
				duracionContrato = objeto.getCondicionesEjecucion();
			}

			documento.setProcurementProject(
					crearProcurementProject(tipoContrato, subtipoContrato, objeto.getObjetoContrato(), cpv, importeSin,
							importeCon, valorEstimado, duracionContrato, pais, nuts));

			// Preparacin de TenderingProcess
			String idTipoProc = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_PROCESS)[objeto.getIdProcContratacion()][1];
			String nombreTipoProc = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_PROCESS)[objeto.getIdProcContratacion()][0];		
			Code codeTipoProcedimiento = crearCode(idTipoProc, nombreTipoProc, ConstantsGC.TENDERING_PROCESS, ConstantsGC.TENDERING_PROCESS_VER);

			String idTipoTram = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.DILIGENCE)[objeto.getIdTipoTramitacion()][1];
			String nombreTipoTram = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.DILIGENCE)[objeto.getIdTipoTramitacion()][0];
			Code codeTipoTram = crearCode(idTipoTram, nombreTipoTram, ConstantsGC.DILIGENCE, ConstantsGC.DILIGENCE_VER);

			String idTipoTramGasto = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.EXPENSE)[objeto.getIdTipoTramitacionGasto()][1];
			String nombreTipoTramGasto = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.EXPENSE)[objeto.getIdTipoTramitacionGasto()][0];
			Code codeTipoTramGasto = crearCode(idTipoTramGasto, nombreTipoTramGasto, ConstantsGC.EXPENSE,ConstantsGC.EXPENSE_VER);

			String idFormaPresentacion = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDER_DELIVERY)[objeto.getIdFormaPresentacion()][1];
			String nombreFormaPresentacion = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDER_DELIVERY)[objeto.getIdFormaPresentacion()][0];
			Code codeFormaPresentacion = crearCode(idFormaPresentacion, nombreFormaPresentacion, ConstantsGC.TENDER_DELIVERY, ConstantsGC.TENDER_DELIVERY_VER);

			
			Code codeJustificacionATPV = null;
			if (objeto.getIdCodigoJustificacionATPV() >= 0) {
				String idJustificacionATPV = ComboBoxUtils.getComboBoxByConstant(
						ConstantsGC.PROCESSJUSTIFICATIONREASONCODE)[objeto.getIdCodigoJustificacionATPV()][1];
				codeJustificacionATPV = crearCode(idJustificacionATPV, objeto.getCodigoJustificacionATPV(),
						ConstantsGC.PROCESSJUSTIFICATIONREASONCODE, ConstantsGC.PROCESSJUSTIFICATIONREASONCODE_VER);
				;
			}
			
			documento.setTenderingProcess(crearTenderingProcess(codeTipoProcedimiento, codeTipoTram, codeTipoTramGasto,
					codeFormaPresentacion, objeto.getFechaFinOfertas(), objeto.getFechaFinSolicitudes(),
					crearEvent(objeto.getEventoApertura()), objeto.getFechaEnvioInvitaciones(),
					objeto.getJustifProcAcelerado(), objeto.getIndicadorFasesSucesivas(),
					objeto.getIndicadorSubastaElectronica(), null, objeto, codeJustificacionATPV,objeto.getTextoJustificacionATPV()));

			

			// Preparacion de TenderingTerms
			if ((objeto.getDescSolvencia() != null) | (objeto.getDirectivaAplicacion() != null)
					| (objeto.getJustifNoPubPliegos() != null) | objeto.getCondicionesEjecucion() != null) {
				documento.setTenderingTerms(crearTenderingTerms(objeto.getClasificacion(), objeto.getDescSolvencia(),
						crearContractingParty(), objeto.getIdDirectivaAplicacion(), objeto.getJustifNoPubPliegos(),
						objeto.getCondicionesEjecucion(), objeto.getIndicadorCatalogoElectronico()));
			} else {
				documento.setTenderingTerms(crearTenderingTerms(objeto.getClasificacion(), null,
						crearContractingParty(), objeto.getIdDirectivaAplicacion(), objeto.getJustifNoPubPliegos(),
						objeto.getCondicionesEjecucion(), objeto.getIndicadorCatalogoElectronico()));
			}

			// Preparacion de TenderResult
			documento.getTenderResult().add(crearTenderResultAdjudicacion(objeto));

		} catch (Exception e) {
			e.printStackTrace();
		}
		
		// Si el expediente tiene lotes, se aaden sus elementos
		// correspondientes
		if (objeto.getLotes() != null && objeto.getLotes().isTieneLotes()) {
			ArrayList<ProcurementProjectLotType> listaLotes;
			listaLotes = obtenerDatosLotes(objeto);

			for (ProcurementProjectLotType procurementProjectLotType : listaLotes) {
				documento.getProcurementProjectLot().add(procurementProjectLotType);
			}
		}

		// Se aade el receptor de recursos
		documento.getTenderingTerms().setAppealTerms(obtenerReceptorRecursos(objeto));

		// Si es anuncio de licitacin, se aaden los criterios de adjudicacin.
		documento.getTenderingTerms().setAwardingTerms(obtenerCriteriosAdjudiacion(objeto));
		
		
		return documento;
	}

	/* TODO Mejorar el mecanismo. No se utiliza la herencia de forma ortodoxa */
	public static ContractAwardNoticeType generateDocumentContractAwardNoticeFormalizacion(ExpedienteBean objeto,
			String id, String noticeid) {
		ContractAwardNoticeType documento = generateDocumentContractAwardNoticeAdjudicacion(objeto, id, noticeid);

		// Se cambia el Tender Result por el correspondiente a Formalizacion
		documento.getTenderResult().set(0, crearTenderResultFormalizacion(objeto));

		return documento;
	}

	public static ContractAwardNoticeType generateDocumentContractAwardNoticeRenuncia(ExpedienteBean objeto, String id,
			String noticeid) {
		ContractAwardNoticeType documento = generateDocumentContractAwardNoticeAdjudicacion(objeto, id, noticeid);

		// Aadir el texto del acuerdo
		NoteType textoAcuerdo = cs.getCbcFactory().createNoteType();
		textoAcuerdo.setValue(objeto.getTextoAcuerdo());
		documento.getNote().add(textoAcuerdo);

		// Se cambia el Tender Result por el correspondiente a Renuncia
		documento.getTenderResult().set(0, crearTenderResultRenuncia(objeto));

		return documento;
	}

	public static ContractAwardNoticeType generateDocumentContractAwardNoticeMenor(ExpedienteBean objeto, String id,
			String noticeid) {
		ContractAwardNoticeType documento = null;
		try {
			documento = cs.getCanFactory().createContractAwardNoticeType();
			IssueDateType issuedate = cs.getCbcFactory().createIssueDateType();

			// Generacin del versionado Codice:
			documento.setUBLVersionID(getUBLVersionID());
			documento.setCustomizationID(getCustomizationID());
			documento.setProfileID(getProfileID());
			documento.setID(getID(id));

			// se asignan los datos del documento, no componentes agregados
			issuedate.setValue(generatePublishDateXMLGregorianCalendar());
			documento.setIssueDate(issuedate);
			IssueTimeType issuetime = cs.getCbcFactory().createIssueTimeType();
			issuetime.setValue(generatePublishTimeXMLGregorianCalendar());
			documento.setIssueTime(issuetime);

			// contractfileid es el expedient number del espacio virtual de
			// licitacin
			ContractFolderIDType contractfileid = cs.getCbcFactory().createContractFolderIDType();
			contractfileid.setValue(objeto.getNumExpediente());
			documento.setContractFolderID(contractfileid);

			Contractingauthorityparty cap = crearContractingParty();
			// se asignan los componentes agregados al documento
			documento.setContractingParty(crearContractingPartyType(cap));

			// Tipo de contrato
			String idTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_CONTRACT)[objeto
					.getIdTipoContrato()][1];
			Code tipoContrato = crearCode(idTipoContrato, objeto.getTipoContrato(), ConstantsGC.TENDERING_CONTRACT,
					ConstantsGC.TENDERING_CONTRACT_VER);

			// Subtipo de contrato
			String idSubTipoContrato = null;
			Code subtipoContrato = null;
			if (idTipoContrato.equalsIgnoreCase("1")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.GOODS_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), ConstantsGC.GOODS_CONTRACT,
						ConstantsGC.GOODS_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("2")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_SERVICE_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(),
						ConstantsGC.TENDERING_SERVICE_CONTRACT, ConstantsGC.TENDERING_SERVICE_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("3")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.WORKS_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), ConstantsGC.WORKS_CONTRACT,
						ConstantsGC.WORKS_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("40")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION)[objeto.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(),
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION,
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION_VER);
			}
			
			
			// Lugar de ejecucin
			String idPais = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.COUNTRY_CODE)[objeto.getIdPais()][1];
			Code pais = crearCode(idPais, objeto.getPais(), ConstantsGC.COUNTRY_CODE, ConstantsGC.COUNTRY_CODE_VER);
			String idNuts = objeto.getIdNuts();
			Code nuts = crearCode(idNuts, objeto.getNuts(), ConstantsGC.NUTS, ConstantsGC.NUTS_VER);

			BigDecimal importeSin = null;
			BigDecimal importeCon = null;
			BigDecimal valorEstimado = null;

			if (objeto.getImporteSinImpuestos().length() > 0)
				try {
					importeSin = new BigDecimal(objeto.getImporteSinImpuestos());
				} catch (Exception e) {
					e.printStackTrace();
				}

			if (objeto.getImporteConImpuestos().length() > 0)
				try {
					importeCon = new BigDecimal(objeto.getImporteConImpuestos());
				} catch (Exception e) {
					e.printStackTrace();
				}

			// Duracion del contrato
			CondicionesEjecucionBean duracionContrato = null;
			if (objeto.getCondicionesEjecucion() != null) {
				duracionContrato = objeto.getCondicionesEjecucion();
			}
			documento.setProcurementProject(crearProcurementProject(tipoContrato, subtipoContrato,
					objeto.getObjetoContrato(), null, importeSin, importeCon, null, duracionContrato, pais, nuts));

			// Preparacin de TenderingProcess
			String idTipoProc = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_PROCESS)[6][1];
			Code codeTipoProcedimiento = crearCode(idTipoProc, ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_PROCESS)[6][0],
					ConstantsGC.TENDERING_PROCESS, ConstantsGC.TENDERING_PROCESS_VER);
			documento.setTenderingProcess(
					crearTenderingProcess(codeTipoProcedimiento,null,null,null, null, null,null));

			// Preparacion de TenderResult
			documento.getTenderResult().add(crearTenderResultMenor(objeto));

		} catch (Exception e) {
			e.printStackTrace();
		}
		return documento;
	}

	/*
	 * Mtodo que genera el elemento ContractModificationNoticeType, que
	 * representa la modificacin del contrato
	 */
	public static ContractModificationNoticeType generateContractModificaction(ExpedienteBean objeto, String id,
			String noticeid) {
		ContractModificationNoticeType documento = null;
		try {
			documento = cs.getContractModificationNoticeFactory().createContractModificationNoticeType();
			IssueDateType issuedate = cs.getCbcFactory().createIssueDateType();

			// Generacin del versionado Codice:
			documento.setUBLVersionID(getUBLVersionID());
			documento.setCustomizationID(getCustomizationID());
			documento.setProfileID(getProfileID());
			documento.setID(getID(id));
			documento.setUUID(getUUID(id));

			// se asignan los datos del documento, no componentes agregados
			issuedate.setValue(generatePublishDateXMLGregorianCalendar());
			documento.setIssueDate(issuedate);
			IssueTimeType issuetime = cs.getCbcFactory().createIssueTimeType();
			issuetime.setValue(generatePublishTimeXMLGregorianCalendar());
			documento.setIssueTime(issuetime);

			// contractfolderid es el expedient number del espacio virtual de
			// licitacin
			ContractFolderIDType contractfileid = cs.getCbcFactory().createContractFolderIDType();
			contractfileid.setValue(objeto.getNumExpediente());
			documento.setContractFolderID(contractfileid);

			Contractingauthorityparty cap = crearContractingParty();
			// se asignan los componentes agregados al documento
			documento.setContractingParty(crearContractingPartyType(cap));

			//Se indica la directiva
			if (objeto.getIdDirectivaAplicacion() > 0){
				DocumentReferenceType pplegdocref=cs.getCacFactory().createDocumentReferenceType();
				String directiva=ComboBoxUtils.getComboBoxByConstant(ConstantsGC.DIRECTIVA)[objeto.getIdDirectivaAplicacion()-1][1];
				IDType idDocRefDirectiva=cs.getCbcFactory().createIDType();
				idDocRefDirectiva.setValue(directiva);
				pplegdocref.setID(idDocRefDirectiva);
				documento.setProcurementLegislationDocumentReference(pplegdocref);
			}
			
			// Tipo de contrato
			String idTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_CONTRACT)[objeto
					.getIdTipoContrato()][1];
			Code tipoContrato = crearCode(idTipoContrato, objeto.getTipoContrato(), ConstantsGC.TENDERING_CONTRACT,
					ConstantsGC.TENDERING_CONTRACT_VER);

			// Subtipo de contrato
			String idSubTipoContrato = null;
			Code subtipoContrato = null;
			if (idTipoContrato.equalsIgnoreCase("1")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.GOODS_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), ConstantsGC.GOODS_CONTRACT,
						ConstantsGC.GOODS_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("2")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TENDERING_SERVICE_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(),
						ConstantsGC.TENDERING_SERVICE_CONTRACT, ConstantsGC.TENDERING_SERVICE_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("3")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.WORKS_CONTRACT)[objeto
						.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(), ConstantsGC.WORKS_CONTRACT,
						ConstantsGC.WORKS_CONTRACT_VER);
			} else if (idTipoContrato.equalsIgnoreCase("40")) {
				idSubTipoContrato = ComboBoxUtils.getComboBoxByConstant(
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION)[objeto.getIdSubtipoContrato()][1];
				subtipoContrato = crearCode(idSubTipoContrato, objeto.getSubtipoContrato(),
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION,
						ConstantsGC.WORKS_PUBLIC_PRIVATE_COLLABORATION_VER);
			}

			// CPV
			String idCPV = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.CPV)[objeto.getIdCpv()][1];
			Code cpv = crearCode(idCPV, objeto.getCpv(), ConstantsGC.CPV, ConstantsGC.CPV_VER);

			BigDecimal importeSin = null;
			BigDecimal importeCon = null;
			BigDecimal valorEstimado = null;

			if (objeto.getImporteSinImpuestos().length() > 0)
				try {
					importeSin = new BigDecimal(objeto.getImporteSinImpuestos());
				} catch (Exception e) {
					e.printStackTrace();
				}

			if (objeto.getImporteConImpuestos().length() > 0)
				try {
					importeCon = new BigDecimal(objeto.getImporteConImpuestos());
				} catch (Exception e) {
					e.printStackTrace();
				}

			if (objeto.getValorEstimado().length() > 0)
				try {
					valorEstimado = new BigDecimal(objeto.getValorEstimado());
				} catch (Exception e) {
					e.printStackTrace();
				}

			// Lugar de ejecucin
			String idPais = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.COUNTRY_CODE)[objeto.getIdPais()][1];
			Code pais = crearCode(idPais, objeto.getPais(), ConstantsGC.COUNTRY_CODE, ConstantsGC.COUNTRY_CODE_VER);
			String idNuts = objeto.getIdNuts();
			Code nuts = crearCode(idNuts, objeto.getNuts(), ConstantsGC.NUTS, ConstantsGC.NUTS_VER);

			// Duracion del contrato
			CondicionesEjecucionBean duracionContrato = null;
			if (objeto.getCondicionesEjecucion() != null) {
				duracionContrato = objeto.getCondicionesEjecucion();
			}

			documento.setProcurementProject(
					crearProcurementProject(tipoContrato, subtipoContrato, objeto.getObjetoContrato(), cpv, importeSin,
							importeCon, valorEstimado, duracionContrato, pais, nuts));

						
			// Preparacion de TenderResult
			documento.getTenderResult().add(crearTenderResultFormalizacion(objeto));

			// Preparacin del ContractModificaction
			DatosModificacionBean datosModificacion = null;
			if (objeto.getDatosModificacion() != null) {
				// Se han includo datos relacionados con la modificacin del
				// contrato
				datosModificacion = objeto.getDatosModificacion();
				documento.getContractModification()
						.add(crearContractModification(datosModificacion, objeto.getNumContrato()));
			} else {
				documento.getContractModification()
						.add(crearContractModification(new DatosModificacionBean(), objeto.getNumContrato()));
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
		
		// Si el expediente tiene lotes, se aaden sus elementos
		// correspondientes
		if (objeto.getLotes() != null && objeto.getLotes().isTieneLotes()) {
			ArrayList<ProcurementProjectLotType> listaLotes;
			listaLotes = obtenerDatosLotes(objeto);

			for (ProcurementProjectLotType procurementProjectLotType : listaLotes) {
				documento.getProcurementProjectLot().add(procurementProjectLotType);
			}
		}

		// Se aade el receptor de recursos
			documento.setAppealTerms(obtenerReceptorRecursos(objeto));
			
			
		return documento;
	}

	public static CancelNoticeRequestType generateCancelNoticeRequest(AnularAnuncioBean objeto, String id,
			String noticeid) {

		CancelNoticeRequestType documento = null;
		try {
			documento = cs.getCancelNoticeFactory().createCancelNoticeRequestType();

			documento.setID(getID(id));

			// ID del organo de contratacion
			PartyIdentificationType partyIdentification = new PartyIdentificationType();
			IDType partyId = new IDType();
			partyId.setValue(objeto.getBuyerProfileId());
			partyId.setSchemeName("ID_PLATAFORMA");
			partyIdentification.setID(partyId);
			documento.setContractingPartyIdentification(partyIdentification);

			// Referencias al anuncio anulado, Texto, codigo y documento anexo
			// con el motivo de la anulacion

			NoticeCancellationType noticeCancellation = new NoticeCancellationType();

			if (objeto.getIDRef().length() > 0) {
				IDType idRef = new IDType();
				idRef.setValue(objeto.getIDRef());
				noticeCancellation.setReferencedID(idRef);
			}

			if (objeto.getUUIDRef().length() > 0) {
				UUIDType uuidRef = new UUIDType();
				uuidRef.setValue(objeto.getUUIDRef());
				noticeCancellation.setReferencedUUID(uuidRef);
			}

			if (objeto.getCancellationDescription().length() > 0) {
				DescriptionType description = new DescriptionType();
				description.setValue(objeto.getCancellationDescription());
				noticeCancellation.setDescription(description);
			}

			String idMotivoAnulacion = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.CANCELLATION_REASON_CODE)[objeto
					.getCancellationReasonCodeId()][1];
			Code motivoAnulacion = crearCode(idMotivoAnulacion, objeto.getCancellationReasonCode(),
					ConstantsGC.CANCELLATION_REASON_CODE, ConstantsGC.CANCELLATION_REASON_VER);
			CancellationReasonCodeType cancellationReasonCode = new CancellationReasonCodeType();
			cancellationReasonCode.setValue(motivoAnulacion.getCodevalue());
			cancellationReasonCode.setLanguageID("es");
			cancellationReasonCode.setListURI(motivoAnulacion.getListUri());
			cancellationReasonCode.setListVersionID(motivoAnulacion.getListVersionId());
			cancellationReasonCode.setName(motivoAnulacion.getDescription());

			noticeCancellation.setCancellationReasonCode(cancellationReasonCode);

			// Documento anexo a la anulacion
			if (objeto.getCancellationDocumentReferencePath().length() > 0) {
				Documentreference canceldr = new Documentreference();
				canceldr.setDocumentidentifier("DOC_ANUL");
				canceldr.setDocumenttypecode(crearCode("NOTICE_CANCELLATION", "Documento motivo de anulacin",
						ConstantsGC.DOCREF_TYPE_CODE, ConstantsGC.DOCREF_TYPE_CODE_VER));
				DocumentReferenceType canceldrType = createDocumentReference(canceldr,
						objeto.getCancellationDocumentReferencePath(), null);
				NoticeCancellationAttachmentDocumentReferenceType notcanceldr = new NoticeCancellationAttachmentDocumentReferenceType();
				notcanceldr.setIssueTime(canceldrType.getIssueTime());
				notcanceldr.setIssueDate(canceldrType.getIssueDate());
				notcanceldr.setID(canceldrType.getID());
				notcanceldr.setDocumentTypeCode(canceldrType.getDocumentTypeCode());
				notcanceldr.setAttachment(canceldrType.getAttachment());
				noticeCancellation.setNoticeCancellationAttachmentDocumentReference(notcanceldr);
			}

			documento.setNoticeCancellation(noticeCancellation);

			// Enviar anulacion al DOUE
			if (objeto.isEnviarDOUE()) {
				AdditionalPublicationRequestType addPubReqDOUE = new AdditionalPublicationRequestType();
				AgencyIDType agencyID = new AgencyIDType();
				agencyID.setValue("DOUE");
				addPubReqDOUE.setAgencyID(agencyID);
				documento.getAdditionalPublicationRequest().add(addPubReqDOUE);
			}

			// Enviar anulacion al BOE
			if (objeto.isEnviarBOE()) {
				AdditionalPublicationRequestType addPubReqBOE = new AdditionalPublicationRequestType();
				AgencyIDType agencyID = new AgencyIDType();
				agencyID.setValue("BOE");
				addPubReqBOE.setAgencyID(agencyID);
				NoteType textoAnulBOE = new NoteType();
				textoAnulBOE.setLanguageID("es");
				textoAnulBOE.setValue(objeto.getTextoAnulacionBOE());
				addPubReqBOE.setNote(textoAnulBOE);
				documento.getAdditionalPublicationRequest().add(addPubReqBOE);
			}

		} catch (Exception e) {
			e.printStackTrace();
		}

		return documento;
	}

	public static CancelGeneralContractDocumentRequestType generateCancelGeneralDocumentRequest(
			AnularDocumentoBean objeto, String id, String noticeid) {

		CancelGeneralContractDocumentRequestType documento = null;
		try {
			documento = cs.getCancelDocumentFactory().createCancelGeneralContractDocumentRequestType();

			documento.setID(getID(id));

			// ID del organo de contratacion
			PartyIdentificationType partyIdentification = new PartyIdentificationType();
			IDType partyId = new IDType();
			partyId.setValue(objeto.getBuyerProfileId());
			partyId.setSchemeName("ID_PLATAFORMA");
			partyIdentification.setID(partyId);

			documento.setContractingPartyIdentification(partyIdentification);

			// Referencias al documento anulado

			GeneralDocumentCancellationType docCancel = new GeneralDocumentCancellationType();

			if (objeto.getIDRef().length() > 0) {
				IDType idRef = new IDType();
				idRef.setValue(objeto.getIDRef());
				docCancel.setCancelledDocumentID(idRef);
			}

			if (objeto.getUUIDRef().length() > 0) {
				UUIDType uuidRef = new UUIDType();
				uuidRef.setValue(objeto.getUUIDRef());
				docCancel.setCancelledDocumentUUID(uuidRef);
			}

			if (objeto.getNumExpediente().length() > 0) {
				ContractFolderIDType numexp = new ContractFolderIDType();
				numexp.setValue(objeto.getNumExpediente());
				docCancel.setContractFolderID(numexp);
			}

			documento.setGeneralDocumentCancellation(docCancel);

		} catch (Exception e) {
			e.printStackTrace();
		}

		return documento;
	}

	public static String generarDocumentoCODICE(String tipoDocumento) {

		String resultado = "";
		int tipoDoc = TipoDocumento.obtenerTipoDocumento(tipoDocumento);
		ExpedienteBean expediente = SessionDataManager.getInstance().getExpediente();
		switch (tipoDoc) {

		case 1: // Anuncio Previo

			PriorInformationNoticeType pin = generateDocumentPriorInformationNotice(expediente, "000001", "000001");

			try {
				ByteArrayOutputStream docXML = (ByteArrayOutputStream) cs.serializePriorInformationNotice(pin);
				System.out.println("Documento serializado correctamente");
				resultado = docXML.toString("UTF-8");

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;
		case 2: // Anuncio de Licitacin

			ContractNoticeType contractnotice = generateDocumentContractNotice(expediente, "000001", "000001");

			try {
				ByteArrayOutputStream docXML = (ByteArrayOutputStream) cs.serializeContractNotice(contractnotice);
				System.out.println("Documento serializado correctamente");
				resultado = docXML.toString("UTF-8");

				ClienteLlamadas.setDocSerializado(contractnotice);
				ClienteLlamadas.setTipoDocumento(tipoDocumento);

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;
		case 3: // Pliego

			CallForTendersType callforTender = generateDocumentCallForTenders(expediente, "000001", "000001");

			try {

				ByteArrayOutputStream docXML = (ByteArrayOutputStream) cs.serializeCallForTender(callforTender);
				System.out.println("Documento serializado correctamente");
				resultado = docXML.toString("UTF-8");

				ClienteLlamadas.setDocSerializado(callforTender);
				ClienteLlamadas.setTipoDocumento(tipoDocumento);

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		case 4: // Anuncio de Adjudicacion

			ContractAwardNoticeType can = generateDocumentContractAwardNoticeAdjudicacion(expediente, "000001",
					"000001");

			try {

				ByteArrayOutputStream docXML = (ByteArrayOutputStream) cs.serializeContractAwardNotice(can);
				System.out.println("Documento serializado correctamente");
				resultado = docXML.toString("UTF-8");

				ClienteLlamadas.setDocSerializado(can);
				ClienteLlamadas.setTipoDocumento(tipoDocumento);

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		case 5: // Documentos Generales

			try {
				Documentreference docref = new Documentreference();

				String idTipoDoc = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.GENERALCONTRACTDOCCODE)[expediente
						.getIdTypeDoc()][1];
				Code tipoDocCode = crearCode(idTipoDoc, expediente.getTypeDoc(), ConstantsGC.GENERALCONTRACTDOCCODE,
						ConstantsGC.GENERALCONTRACTDOCCODE_VER);
				docref.setDocumenttypecode(tipoDocCode);

				DocumentReferenceType dr = createDocumentReference(docref, expediente.getUrlDocument(),
						expediente.getNameDocument());

				ByteArrayOutputStream docXML = (ByteArrayOutputStream) cs.serialize_DocumentReferenceType(dr);
				System.out.println("Documento serializado correctamente");
				resultado = docXML.toString("UTF-8");

				ClienteLlamadas.setDocSerializado(dr);
				ClienteLlamadas.setTipoDocumento(tipoDocumento);

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		case 10: // Anulacion de anuncio

			AnularAnuncioBean anularAnuncio = SessionDataManager.getInstance().getAnularAnuncio();
			CancelNoticeRequestType cancelNotReq = generateCancelNoticeRequest(anularAnuncio, "000001", "000001");

			try {
				ByteArrayOutputStream docXML = (ByteArrayOutputStream) cs.serializeCancelNoticeRequest(cancelNotReq);
				System.out.println("Documento serializado correctamente");
				resultado = docXML.toString("UTF-8");

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		case 11: // Anulacion de documento

			AnularDocumentoBean anularDocumento = SessionDataManager.getInstance().getAnularDocumento();
			CancelGeneralContractDocumentRequestType cancelDocReq = generateCancelGeneralDocumentRequest(
					anularDocumento, "000001", "000001");

			try {
				ByteArrayOutputStream docXML = (ByteArrayOutputStream) cs
						.serializeCancelGeneralDocumentRequest(cancelDocReq);
				System.out.println("Documento serializado correctamente");
				resultado = docXML.toString("UTF-8");

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		case 12: // Anuncio de Formalizacion
			ContractAwardNoticeType form = generateDocumentContractAwardNoticeFormalizacion(expediente, "000001",
					"000001");

			try {

				ByteArrayOutputStream docXML = (ByteArrayOutputStream) cs.serializeContractAwardNotice(form);
				System.out.println("Documento serializado correctamente");
				resultado = docXML.toString("UTF-8");

				ClienteLlamadas.setDocSerializado(form);
				ClienteLlamadas.setTipoDocumento(tipoDocumento);

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		case 13: // Anuncio de Renuncia, Desierto o Desistimiento

			ContractAwardNoticeType ren = generateDocumentContractAwardNoticeRenuncia(expediente, "000001", "000001");

			try {

				ByteArrayOutputStream docXML = (ByteArrayOutputStream) cs.serializeContractAwardNotice(ren);
				System.out.println("Documento serializado correctamente");
				resultado = docXML.toString("UTF-8");

				ClienteLlamadas.setDocSerializado(ren);
				ClienteLlamadas.setTipoDocumento(tipoDocumento);

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		case 14: // Contrato menor
			ContractAwardNoticeType men = generateDocumentContractAwardNoticeMenor(expediente, "000001", "000001");

			try {

				ByteArrayOutputStream docXML = (ByteArrayOutputStream) cs.serializeContractAwardNotice(men);
				System.out.println("Documento serializado correctamente");
				resultado = docXML.toString("UTF-8");

				ClienteLlamadas.setDocSerializado(men);
				ClienteLlamadas.setTipoDocumento(tipoDocumento);

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		case 15: // Anuncio de modificacin

			ContractModificationNoticeType mod = generateContractModificaction(expediente, "000001", "000001");
			try {

				ByteArrayOutputStream docXML = (ByteArrayOutputStream) cs.serializeContractModificactionNotice(mod);
				System.out.println("Documento serializado correctamente");
				resultado = docXML.toString("UTF-8");

				ClienteLlamadas.setDocSerializado(mod);
				ClienteLlamadas.setTipoDocumento(tipoDocumento);

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		default:
			System.out.println("Tipo de documento no reconocido");
			break;
		}

		return resultado;
	}

	// Deserializa un documento a partir de un fichero. Util para servicios de
	// previsualizacion y validacion
	public static String generarCODICE(String tipoDocumento) throws ClientException {

		String resultado = "";
		int tipoDoc = TipoDocumento.obtenerTipoDocumento(tipoDocumento);

		String rutaFichero = SessionDataManager.getInstance().getDatosUtilidades().getUrlDoc();
		InputStream is = null;
		try {
			File file = new File(rutaFichero);
			is = new FileInputStream(file);
		} catch (Exception e) {
			e.printStackTrace();
		}

		switch (tipoDoc) {
		case 1: // Anuncio Previo

			try {
				PriorInformationNoticeType pin = (PriorInformationNoticeType) cs.deserializePriorInformationNotice(is);

				ClienteLlamadas.setTipoDocumento(tipoDocumento);
				ClienteLlamadas.setDocSerializado(pin);

			} catch (Exception e) {
				e.printStackTrace();
				throw (new ClientException(
						"Error al deserializar el documento CODICE. Este documento no es un Anuncio Previo CODICE vlido"));
			}
			break;
		case 2: // Anuncio de Licitacin
			try {

				ContractNoticeType contractnotice = (ContractNoticeType) cs.deserializeContractNotice(is);

				ClienteLlamadas.setDocSerializado(contractnotice);
				ClienteLlamadas.setTipoDocumento(tipoDocumento);

			} catch (Exception e) {
				e.printStackTrace();
				throw (new ClientException(
						"Error al deserializar el documento CODICE. Este documento no es un Anuncio de Licitacin CODICE vlido"));
			}
			break;
		case 3: // Pliego

			try {

				CallForTendersType callforTender = (CallForTendersType) cs.deserializeCallforTenders(is);

				ClienteLlamadas.setDocSerializado(callforTender);
				ClienteLlamadas.setTipoDocumento(tipoDocumento);

			} catch (Exception e) {
				e.printStackTrace();
				throw (new ClientException(
						"Error al deserializar el documento CODICE. Este documento no es un documento de Pliegos CODICE vlido"));
			}
			break;

		case 4: // Anuncio de Adjudicacion

			try {

				ContractAwardNoticeType can = (ContractAwardNoticeType) cs.deserializeContractAwardNotice(is);

				ClienteLlamadas.setDocSerializado(can);
				ClienteLlamadas.setTipoDocumento(tipoDocumento);

			} catch (Exception e) {
				e.printStackTrace();
				throw (new ClientException(
						"Error al deserializar el documento CODICE. Este documento no es un Anuncio de Adjudicacin CODICE vlido"));
			}
			break;

		case 5: // Documentos Generales

			try {

				DocumentReferenceType drt = (DocumentReferenceType) cs.deserializeDocumentReferenceType(is);
				ClienteLlamadas.setDocSerializado(drt);
				ClienteLlamadas.setTipoDocumento(tipoDocumento);

			} catch (Exception e) {
				e.printStackTrace();
				throw (new ClientException(
						"Error al deserializar el documento CODICE. Este documento no es un Documento General CODICE vlido"));
			}
			break;

		case 14: // Contrato menor

			try {

				ContractAwardNoticeType men = (ContractAwardNoticeType) cs.deserializeContractAwardNotice(is);

				ClienteLlamadas.setDocSerializado(men);
				ClienteLlamadas.setTipoDocumento(tipoDocumento);

			} catch (Exception e) {
				e.printStackTrace();
				throw (new ClientException(
						"Error al deserializar el documento CODICE. Este documento no es un Anuncio de Adjudicacin CODICE vlido"));
			}
			break;

		case 15: // Modificacin de contrato

			try {

				ContractModificationNoticeType mod = (ContractModificationNoticeType) cs
						.deserializeContractModificactionNotice(is);

				ClienteLlamadas.setDocSerializado(mod);
				ClienteLlamadas.setTipoDocumento(tipoDocumento);

			} catch (Exception e) {
				e.printStackTrace();
				throw (new ClientException(
						"Error al deserializar el documento CODICE. Este documento no es un Anuncio de Adjudicacin CODICE vlido"));
			}
			break;

		default:
			System.out.println("Tipo de documento no reconocido");
			break;
		}

		return resultado;

	}

	private static AppealTermsType obtenerReceptorRecursos(ExpedienteBean objeto) {

		AppealTermsType appealTermsType = new AppealTermsType();

		if (objeto.getReceptor() != null) {

			ReceptorRecursosBean receptor = objeto.getReceptor();
			appealTermsType.setAppealReceiverParty(new PartyType());

			PartyNameType partyNameType = new PartyNameType();
			NameType nameType = new NameType();
			nameType.setValue(receptor.getEntidad());
			partyNameType.setName(nameType);
			appealTermsType.getAppealReceiverParty().getPartyName().add(partyNameType);

			WebsiteURIType websiteURI = new WebsiteURIType();
			websiteURI.setValue(receptor.getUrl());
			appealTermsType.getAppealReceiverParty().setWebsiteURI(websiteURI);

			AddressType address = new AddressType();
			AddressLineType addresLine = new AddressLineType();
			LineType line = new LineType();
			line.setValue(receptor.getDireccionCalle());
			addresLine.setLine(line);
			address.getAddressLine().add(addresLine);

			PostalZoneType postalZone = new PostalZoneType();
			postalZone.setValue(receptor.getDireccionCP());
			address.setPostalZone(postalZone);

			CityNameType cityName = new CityNameType();
			cityName.setValue(receptor.getDireccionPoblacion());
			address.setCityName(cityName);

			IdentificationCodeType identificationCode = new IdentificationCodeType();
			String idPais = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.COUNTRY_CODE)[receptor.getIdPais()][1];
			Code pais = crearCode(idPais, receptor.getPais(), ConstantsGC.COUNTRY_CODE, ConstantsGC.COUNTRY_CODE_VER);

			identificationCode.setValue(idPais);
			identificationCode.setListURI(ConstantsGC.COUNTRY_CODE);
			identificationCode.setListVersionID(ConstantsGC.COUNTRY_CODE_VER);
			identificationCode.setName(pais.getDescription());
			CountryType countryType = new CountryType();
			countryType.setIdentificationCode(identificationCode);
			NameType name = new NameType();
			name.setValue(pais.getDescription());
			countryType.setName(name);
			
			address.setCountry(countryType);

			appealTermsType.getAppealReceiverParty().setPostalAddress(address);
		}

		return appealTermsType;
	}

	private static ArrayList<ProcurementProjectLotType> obtenerDatosLotes(ExpedienteBean expediente) {
		
		ArrayList<ProcurementProjectLotType> listaLotes = new ArrayList<ProcurementProjectLotType>();

		// Se crea el lote 1
		if (expediente.getLotes().getLote1Descripcion() != null
				&& expediente.getLotes().getLote1Descripcion().length() > 0) {
			ProcurementProjectLotType procurementProjectLotType = new ProcurementProjectLotType();

			// Identificador
			IDType idType = new IDType();
			idType.setValue("1");
			idType.setSchemeName("ID_LOTE");
			procurementProjectLotType.setID(idType);

			// Se crea el ProcurementProject
			ProcurementProjectType procurementProjectType = new ProcurementProjectType();
			procurementProjectType.setID(idType);

			// descripcin
			NameType nameType = new NameType();
			nameType.setValue(expediente.getLotes().getLote1Descripcion());
			procurementProjectType.getName().add(nameType);

			// Importes
			BudgetAmountType budgetAmountType = new BudgetAmountType();
			TotalAmountType totalAmountType = new TotalAmountType();
			totalAmountType.setValue(new BigDecimal(expediente.getLotes().getLote1ImporteConImpuestos()));
			totalAmountType.setCurrencyID(CurrencyCodeContentType.EUR);
			TaxExclusiveAmountType taxExclusiveAmountType = new TaxExclusiveAmountType();
			taxExclusiveAmountType.setValue(new BigDecimal(expediente.getLotes().getLote1ImporteSinImpuestos()));
			taxExclusiveAmountType.setCurrencyID(CurrencyCodeContentType.EUR);
			budgetAmountType.setTotalAmount(totalAmountType);
			budgetAmountType.setTaxExclusiveAmount(taxExclusiveAmountType);
			procurementProjectType.setBudgetAmount(budgetAmountType);

			// Cdigo CPV
			String idCPV = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.CPV)[expediente.getLotes()
					.getLote1IdCpv()][1];
			Code cpv = crearCode(idCPV, expediente.getLotes().getLote1Cpv(), ConstantsGC.CPV, ConstantsGC.CPV_VER);
			ItemClassificationCodeType itemClassificationCodeType = new ItemClassificationCodeType();
			itemClassificationCodeType.setValue(idCPV);
			itemClassificationCodeType.setListURI(cpv.getListUri());
			itemClassificationCodeType.setListVersionID(cpv.getListVersionId());
			itemClassificationCodeType.setName(cpv.getDescription());
			CommodityClassificationType commodityClassificationType = new CommodityClassificationType();
			commodityClassificationType.setItemClassificationCode(itemClassificationCodeType);
			procurementProjectType.getRequiredCommodityClassification().add(commodityClassificationType);

			// Lugar de ejecucin
			LocationType locationType = new LocationType();
			CountrySubentityCodeType countrySubentityCodeType = new CountrySubentityCodeType();

			String idPais = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.COUNTRY_CODE)[expediente.getLotes()
					.getLote1IdPais()][1];
			Code pais = crearCode(idPais, expediente.getLotes().getLote1Pais(), ConstantsGC.COUNTRY_CODE, ConstantsGC.COUNTRY_CODE_VER);
			String idNuts = expediente.getLotes().getLote1IdNuts();
			Code nuts = crearCode(idNuts, expediente.getLotes().getLote1Nuts(), ConstantsGC.NUTS, ConstantsGC.NUTS_VER);

			countrySubentityCodeType.setValue(idNuts);
			countrySubentityCodeType.setListURI(nuts.getListUri());
			countrySubentityCodeType.setListVersionID(nuts.getListVersionId());
			countrySubentityCodeType.setName(nuts.getDescription());
			locationType.setCountrySubentityCode(countrySubentityCodeType);

			AddressType addressType = new AddressType();
			CountryType countryType = new CountryType();
			IdentificationCodeType identificationCodeType = new IdentificationCodeType();
			identificationCodeType.setValue(idPais);
			identificationCodeType.setListURI(pais.getListUri());
			identificationCodeType.setListVersionID(pais.getListVersionId());
			identificationCodeType.setName(pais.getDescription());
			itemClassificationCodeType.setListName("CPV");
			countryType.setIdentificationCode(identificationCodeType);
			addressType.setCountry(countryType);
			locationType.setAddress(addressType);

			procurementProjectType.setRealizedLocation(locationType);

			procurementProjectLotType.setProcurementProject(procurementProjectType);
			listaLotes.add(procurementProjectLotType);
		}

		// Se crea el lote 2
		if (expediente.getLotes().getLote2Descripcion() != null
				&& expediente.getLotes().getLote2Descripcion().length() > 0) {
			ProcurementProjectLotType procurementProjectLotType = new ProcurementProjectLotType();

			// Identificador
			IDType idType = new IDType();
			idType.setValue("2");
			idType.setSchemeName("ID_LOTE");
			procurementProjectLotType.setID(idType);

			// Se crea el ProcurementProject
			ProcurementProjectType procurementProjectType = new ProcurementProjectType();
			procurementProjectType.setID(idType);

			// descripcin
			NameType nameType = new NameType();
			nameType.setValue(expediente.getLotes().getLote2Descripcion());
			procurementProjectType.getName().add(nameType);

			// Importes
			BudgetAmountType budgetAmountType = new BudgetAmountType();
			TotalAmountType totalAmountType = new TotalAmountType();
			totalAmountType.setValue(new BigDecimal(expediente.getLotes().getLote2ImporteConImpuestos()));
			totalAmountType.setCurrencyID(CurrencyCodeContentType.EUR);
			TaxExclusiveAmountType taxExclusiveAmountType = new TaxExclusiveAmountType();
			taxExclusiveAmountType.setValue(new BigDecimal(expediente.getLotes().getLote2ImporteSinImpuestos()));
			taxExclusiveAmountType.setCurrencyID(CurrencyCodeContentType.EUR);
			budgetAmountType.setTotalAmount(totalAmountType);
			budgetAmountType.setTaxExclusiveAmount(taxExclusiveAmountType);
			procurementProjectType.setBudgetAmount(budgetAmountType);

			// Cdigo CPV
			String idCPV = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.CPV)[expediente.getLotes()
					.getLote2IdCpv()][1];
			Code cpv = crearCode(idCPV, expediente.getLotes().getLote2Cpv(), ConstantsGC.CPV, ConstantsGC.CPV_VER);
			ItemClassificationCodeType itemClassificationCodeType = new ItemClassificationCodeType();
			itemClassificationCodeType.setValue(idCPV);
			itemClassificationCodeType.setListURI(cpv.getListUri());
			itemClassificationCodeType.setListVersionID(cpv.getListVersionId());
			itemClassificationCodeType.setName(cpv.getDescription());
			itemClassificationCodeType.setListName("CPV");
			CommodityClassificationType commodityClassificationType = new CommodityClassificationType();
			commodityClassificationType.setItemClassificationCode(itemClassificationCodeType);
			procurementProjectType.getRequiredCommodityClassification().add(commodityClassificationType);

			// Lugar de ejecucin
			LocationType locationType = new LocationType();
			CountrySubentityCodeType countrySubentityCodeType = new CountrySubentityCodeType();

			String idPais = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.COUNTRY_CODE)[expediente.getLotes()
					.getLote2IdPais()][1];
			Code pais = crearCode(idPais, expediente.getLotes().getLote2Pais(), ConstantsGC.COUNTRY_CODE, ConstantsGC.COUNTRY_CODE_VER);
			String idNuts = expediente.getLotes().getLote2IdNuts();
			Code nuts = crearCode(idNuts, expediente.getLotes().getLote2Nuts(), ConstantsGC.NUTS, ConstantsGC.NUTS_VER);

			countrySubentityCodeType.setValue(idNuts);
			countrySubentityCodeType.setListURI(nuts.getListUri());
			countrySubentityCodeType.setListVersionID(nuts.getListVersionId());
			countrySubentityCodeType.setName(nuts.getDescription());
			locationType.setCountrySubentityCode(countrySubentityCodeType);			
			CountrySubentityType countrySubentityType = new CountrySubentityType();
			countrySubentityType.setValue(nuts.getDescription());		
			locationType.setCountrySubentity(countrySubentityType);

			AddressType addressType = new AddressType();
			CountryType countryType = new CountryType();
			IdentificationCodeType identificationCodeType = new IdentificationCodeType();
			identificationCodeType.setValue(idPais);
			identificationCodeType.setListURI(pais.getListUri());
			identificationCodeType.setListVersionID(pais.getListVersionId());
			identificationCodeType.setName(pais.getDescription());
			countryType.setIdentificationCode(identificationCodeType);
			addressType.setCountry(countryType);
			locationType.setAddress(addressType);

			procurementProjectType.setRealizedLocation(locationType);

			procurementProjectLotType.setProcurementProject(procurementProjectType);
			listaLotes.add(procurementProjectLotType);
		}
		
		return listaLotes;

	}
	
	
	private static TendererQualificationRequestType obtenerRequisitosSolvencia(ExpedienteBean objeto, TendererQualificationRequestType tendererQualificationRequestType) {
		
		RequisitosParticipacionBean requisitos = objeto.getRequisitosParticipacion();
		if (tendererQualificationRequestType == null){
			 tendererQualificationRequestType = new TendererQualificationRequestType();
		}
		
		if (requisitos != null){
			//Requisito de solvencia tcnica 1
			if (requisitos.getIdSolvenciaTecnica1() >= 0){
				EvaluationCriteriaType evaluationCriteriaType = new EvaluationCriteriaType();

				String idCriterio = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TECHNICALCAPABILITYTYPECODE)[requisitos.getIdSolvenciaTecnica1()][1];
				Code criterio = crearCode(idCriterio, requisitos.getSolvenciaTecnica1(), ConstantsGC.TECHNICALCAPABILITYTYPECODE, ConstantsGC.TECHNICALCAPABILITYTYPECODE_VER);
				
				EvaluationCriteriaTypeCodeType evaluationCriteriaTypeCodeType = new EvaluationCriteriaTypeCodeType();
				evaluationCriteriaTypeCodeType.setValue(idCriterio);
				evaluationCriteriaTypeCodeType.setListURI(criterio.getListUri());
				evaluationCriteriaTypeCodeType.setListVersionID(criterio.getListVersionId());
				evaluationCriteriaTypeCodeType.setName(criterio.getDescription());
				evaluationCriteriaType.setEvaluationCriteriaTypeCode(evaluationCriteriaTypeCodeType);
				
				DescriptionType descriptionType = new DescriptionType();
				descriptionType.setValue(requisitos.getDescSolvenciaTecnica1());
				evaluationCriteriaType.getDescription().add(descriptionType);
				
				tendererQualificationRequestType.getTechnicalEvaluationCriteria().add(evaluationCriteriaType);
			}
			
			//Requisito de solvencia tcnica 2
			if (requisitos.getIdSolvenciaTecnica2() >= 0){
				EvaluationCriteriaType evaluationCriteriaType = new EvaluationCriteriaType();

				String idCriterio = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.TECHNICALCAPABILITYTYPECODE)[requisitos.getIdSolvenciaTecnica2()][1];
				Code criterio = crearCode(idCriterio, requisitos.getSolvenciaTecnica2(), ConstantsGC.TECHNICALCAPABILITYTYPECODE, ConstantsGC.TECHNICALCAPABILITYTYPECODE_VER);
				
				EvaluationCriteriaTypeCodeType evaluationCriteriaTypeCodeType = new EvaluationCriteriaTypeCodeType();
				evaluationCriteriaTypeCodeType.setValue(idCriterio);
				evaluationCriteriaTypeCodeType.setListURI(criterio.getListUri());
				evaluationCriteriaTypeCodeType.setListVersionID(criterio.getListVersionId());
				evaluationCriteriaTypeCodeType.setName(criterio.getDescription());
				evaluationCriteriaType.setEvaluationCriteriaTypeCode(evaluationCriteriaTypeCodeType);
				
				DescriptionType descriptionType = new DescriptionType();
				descriptionType.setValue(requisitos.getDescSolvenciaTecnica2());
				evaluationCriteriaType.getDescription().add(descriptionType);
				
				tendererQualificationRequestType.getTechnicalEvaluationCriteria().add(evaluationCriteriaType);
			}
			
			//Requisito de solvencia econmica 1
			if (requisitos.getIdSolvenciaEconomica1() >= 0){
				EvaluationCriteriaType evaluationCriteriaType = new EvaluationCriteriaType();

				String idCriterio = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.FINANCIALCAPABILITYTYPECODE)[requisitos.getIdSolvenciaEconomica1()][1];
				Code criterio = crearCode(idCriterio, requisitos.getSolvenciaEconomica1(), ConstantsGC.FINANCIALCAPABILITYTYPECODE, ConstantsGC.FINANCIALCAPABILITYTYPECODE_VER);
				
				EvaluationCriteriaTypeCodeType evaluationCriteriaTypeCodeType = new EvaluationCriteriaTypeCodeType();
				evaluationCriteriaTypeCodeType.setValue(idCriterio);
				evaluationCriteriaTypeCodeType.setListURI(criterio.getListUri());
				evaluationCriteriaTypeCodeType.setListVersionID(criterio.getListVersionId());
				evaluationCriteriaTypeCodeType.setName(criterio.getDescription());
				evaluationCriteriaType.setEvaluationCriteriaTypeCode(evaluationCriteriaTypeCodeType);
				
				DescriptionType descriptionType = new DescriptionType();
				descriptionType.setValue(requisitos.getDescSolvenciaEconomica1());
				evaluationCriteriaType.getDescription().add(descriptionType);
				
				tendererQualificationRequestType.getFinancialEvaluationCriteria().add(evaluationCriteriaType);
			}
			
			//Requisito de solvencia econmica 2
			if (requisitos.getIdSolvenciaEconomica2() >= 0){
				EvaluationCriteriaType evaluationCriteriaType = new EvaluationCriteriaType();

				String idCriterio = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.FINANCIALCAPABILITYTYPECODE)[requisitos.getIdSolvenciaEconomica2()][1];
				Code criterio = crearCode(idCriterio, requisitos.getSolvenciaEconomica2(), ConstantsGC.FINANCIALCAPABILITYTYPECODE, ConstantsGC.FINANCIALCAPABILITYTYPECODE_VER);
				
				EvaluationCriteriaTypeCodeType evaluationCriteriaTypeCodeType = new EvaluationCriteriaTypeCodeType();
				evaluationCriteriaTypeCodeType.setValue(idCriterio);
				evaluationCriteriaTypeCodeType.setListURI(criterio.getListUri());
				evaluationCriteriaTypeCodeType.setListVersionID(criterio.getListVersionId());
				evaluationCriteriaTypeCodeType.setName(criterio.getDescription());
				evaluationCriteriaType.setEvaluationCriteriaTypeCode(evaluationCriteriaTypeCodeType);
				
				DescriptionType descriptionType = new DescriptionType();
				descriptionType.setValue(requisitos.getDescSolvenciaEconomica2());
				evaluationCriteriaType.getDescription().add(descriptionType);
				
				tendererQualificationRequestType.getFinancialEvaluationCriteria().add(evaluationCriteriaType);
			}
			
			
			

			//Se revisan las condiciones de contratacin especificadas
			if (requisitos.isCapacidadObrar()){		
				tendererQualificationRequestType.getSpecificTendererRequirement().add(crearCondicionContratar(0));
			}
			if (requisitos.isNoProhibicionContratar()){		
				tendererQualificationRequestType.getSpecificTendererRequirement().add(crearCondicionContratar(1));
			}
			if (requisitos.isNoIncompatibilidades()){		
				tendererQualificationRequestType.getSpecificTendererRequirement().add(crearCondicionContratar(2));
			}
			if (requisitos.isCumplimientoObligacionesSS()){		
				tendererQualificationRequestType.getSpecificTendererRequirement().add(crearCondicionContratar(3));
			}
			if (requisitos.isCumplimientoObligacionesTributarias()){		
				tendererQualificationRequestType.getSpecificTendererRequirement().add(crearCondicionContratar(4));
			}
			if (requisitos.isNoAdjudicatarioAnterioridad()){		
				tendererQualificationRequestType.getSpecificTendererRequirement().add(crearCondicionContratar(5));
			}
			if (requisitos.isPreregistroROLECE()){		
				tendererQualificationRequestType.getSpecificTendererRequirement().add(crearCondicionContratar(6));
			}
			if (requisitos.isEmpresasExtranjeras()){		
				tendererQualificationRequestType.getSpecificTendererRequirement().add(crearCondicionContratar(7));
			}
			if (requisitos.isReservadoCentrosEspeciales()){		
				tendererQualificationRequestType.getSpecificTendererRequirement().add(crearCondicionContratar(8));
			}
			if (requisitos.isReservadorProgramasEmpleo()){		
				tendererQualificationRequestType.getSpecificTendererRequirement().add(crearCondicionContratar(9));
			}
			if (requisitos.isDeclaracionTrabajadoresDiscapacidad()){		
				tendererQualificationRequestType.getSpecificTendererRequirement().add(crearCondicionContratar(10));
			}
			if (requisitos.isDeclaracionPromocionLaboral()){		
				tendererQualificationRequestType.getSpecificTendererRequirement().add(crearCondicionContratar(11));
			}
			if (requisitos.isReservadoProfesion()){		
				tendererQualificationRequestType.getSpecificTendererRequirement().add(crearCondicionContratar(12));
			}
		}
		return tendererQualificationRequestType;
	}

	private static TendererRequirementType crearCondicionContratar(int indice) {
		String idCondicion;
		String nombreCondicion;
		String listURL;
		String versionList;
		
		idCondicion = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.DECLARATION)[indice][1];
		nombreCondicion = ComboBoxUtils.getComboBoxByConstant(ConstantsGC.DECLARATION)[indice][0];
		listURL = ConstantsGC.DECLARATION;
		versionList = ConstantsGC.DECLARATION_VER;	
		TendererRequirementType tendererRequirementType = new TendererRequirementType();
		RequirementTypeCodeType requirementTypeCodeType = new RequirementTypeCodeType();	
		requirementTypeCodeType.setValue(idCondicion);
		requirementTypeCodeType.setListURI(listURL);
		requirementTypeCodeType.setListVersionID(versionList);
		requirementTypeCodeType.setName(nombreCondicion);			
		tendererRequirementType.setRequirementTypeCode(requirementTypeCodeType);	

		return tendererRequirementType;
	}
	

	
	private static AwardingTermsType obtenerCriteriosAdjudiacion(ExpedienteBean expediente) {
		
		CristeriosAdjudicacionBean criterios = expediente.getCriteriosAdjudicacion();
		AwardingTermsType awardingTermsType = new AwardingTermsType();
		
		if (criterios != null){
			
			//Criterio cuantificable de precio
			if (criterios.getAutomaticoPrecioDescripcion() != null && criterios.getAutomaticoPrecioDescripcion().length() > 0){
				AwardingCriteriaType awardingCriteriaType = new AwardingCriteriaType();
				IDType idType = new IDType();
				idType.setValue("9001");	
				awardingCriteriaType.setID(idType);
				
				AwardingCriteriaTypeCodeType awardingCriteriaTypeCodeType = new AwardingCriteriaTypeCodeType();
				awardingCriteriaTypeCodeType.setValue(ComboBoxUtils.getComboBoxByConstant(ConstantsGC.AWARDINGTYPE)[0][1]);
				awardingCriteriaTypeCodeType.setListURI(ConstantsGC.AWARDINGTYPE);
				awardingCriteriaTypeCodeType.setListVersionID(ConstantsGC.AWARDINGTYPE_VER);
				awardingCriteriaTypeCodeType.setName(ComboBoxUtils.getComboBoxByConstant(ConstantsGC.AWARDINGTYPE)[0][0]);			
				awardingCriteriaType.setAwardingCriteriaTypeCode(awardingCriteriaTypeCodeType);
				
				DescriptionType descriptionType = new DescriptionType();
				descriptionType.setValue(criterios.getAutomaticoPrecioDescripcion());
				awardingCriteriaType.getDescription().add(descriptionType);
				
				AwardingCriteriaSubTypeCodeType awardingCriteriaSubTypeCodeType = new AwardingCriteriaSubTypeCodeType();
				awardingCriteriaSubTypeCodeType.setValue(ComboBoxUtils.getComboBoxByConstant(ConstantsGC.AWARDINGSUBTYPE)[0][1]);
				awardingCriteriaSubTypeCodeType.setListURI(ConstantsGC.AWARDINGSUBTYPE);
				awardingCriteriaSubTypeCodeType.setListVersionID(ConstantsGC.AWARDINGSUBTYPE_VER);
				awardingCriteriaSubTypeCodeType.setName(ComboBoxUtils.getComboBoxByConstant(ConstantsGC.AWARDINGSUBTYPE)[0][0]);	
				awardingCriteriaType.setAwardingCriteriaSubTypeCode(awardingCriteriaSubTypeCodeType);
				
				WeightNumericType weightNumericType = new WeightNumericType();
				weightNumericType.setValue(new BigDecimal(criterios.getAutomaticoPrecioPonderacion()));
				awardingCriteriaType.setWeightNumeric(weightNumericType);
				
				awardingTermsType.getAwardingCriteria().add(awardingCriteriaType);
			}
			
			//Criterio cuantificable de otros
			if (criterios.getAutomaticoOtrosDescripcion() != null && criterios.getAutomaticoOtrosDescripcion().length() > 0){
				AwardingCriteriaType awardingCriteriaType = new AwardingCriteriaType();
				IDType idType = new IDType();
				idType.setValue("9002");	
				awardingCriteriaType.setID(idType);
				
				AwardingCriteriaTypeCodeType awardingCriteriaTypeCodeType = new AwardingCriteriaTypeCodeType();
				awardingCriteriaTypeCodeType.setValue(ComboBoxUtils.getComboBoxByConstant(ConstantsGC.AWARDINGTYPE)[0][1]);
				awardingCriteriaTypeCodeType.setListURI(ConstantsGC.AWARDINGTYPE);
				awardingCriteriaTypeCodeType.setListVersionID(ConstantsGC.AWARDINGTYPE_VER);
				awardingCriteriaTypeCodeType.setName(ComboBoxUtils.getComboBoxByConstant(ConstantsGC.AWARDINGTYPE)[0][0]);			
				awardingCriteriaType.setAwardingCriteriaTypeCode(awardingCriteriaTypeCodeType);
				
				DescriptionType descriptionType = new DescriptionType();
				descriptionType.setValue(criterios.getAutomaticoOtrosDescripcion());
				awardingCriteriaType.getDescription().add(descriptionType);
				
				AwardingCriteriaSubTypeCodeType awardingCriteriaSubTypeCodeType = new AwardingCriteriaSubTypeCodeType();
				awardingCriteriaSubTypeCodeType.setValue(ComboBoxUtils.getComboBoxByConstant(ConstantsGC.AWARDINGSUBTYPE)[1][1]);
				awardingCriteriaSubTypeCodeType.setListURI(ConstantsGC.AWARDINGSUBTYPE);
				awardingCriteriaSubTypeCodeType.setListVersionID(ConstantsGC.AWARDINGSUBTYPE_VER);
				awardingCriteriaSubTypeCodeType.setName(ComboBoxUtils.getComboBoxByConstant(ConstantsGC.AWARDINGSUBTYPE)[1][0]);	
				awardingCriteriaType.setAwardingCriteriaSubTypeCode(awardingCriteriaSubTypeCodeType);
				
				WeightNumericType weightNumericType = new WeightNumericType();
				weightNumericType.setValue(new BigDecimal(criterios.getAutomaticoOtrosPonderacion()));
				awardingCriteriaType.setWeightNumeric(weightNumericType);
				
				awardingTermsType.getAwardingCriteria().add(awardingCriteriaType);
			}
			
			
			//Criterio cuantificable de juicio de valor
			if (criterios.getJuicioDescripcion() != null && criterios.getJuicioDescripcion().length() > 0){
				AwardingCriteriaType awardingCriteriaType = new AwardingCriteriaType();
				IDType idType = new IDType();
				idType.setValue("9003");	
				awardingCriteriaType.setID(idType);
				
				AwardingCriteriaTypeCodeType awardingCriteriaTypeCodeType = new AwardingCriteriaTypeCodeType();
				awardingCriteriaTypeCodeType.setValue(ComboBoxUtils.getComboBoxByConstant(ConstantsGC.AWARDINGTYPE)[1][1]);
				awardingCriteriaTypeCodeType.setListURI(ConstantsGC.AWARDINGTYPE);
				awardingCriteriaTypeCodeType.setListVersionID(ConstantsGC.AWARDINGTYPE_VER);
				awardingCriteriaTypeCodeType.setName(ComboBoxUtils.getComboBoxByConstant(ConstantsGC.AWARDINGTYPE)[1][0]);			
				awardingCriteriaType.setAwardingCriteriaTypeCode(awardingCriteriaTypeCodeType);
				
				DescriptionType descriptionType = new DescriptionType();
				descriptionType.setValue(criterios.getJuicioDescripcion());
				awardingCriteriaType.getDescription().add(descriptionType);
				
				WeightNumericType weightNumericType = new WeightNumericType();
				weightNumericType.setValue(new BigDecimal(criterios.getJuicioPonderacion()));
				awardingCriteriaType.setWeightNumeric(weightNumericType);
				
				awardingTermsType.getAwardingCriteria().add(awardingCriteriaType);
			}
			
			
		}
		
		
		return awardingTermsType;
	}

	
	private static void insertarInformacionContacto(TenderingTermsType tenderingTerms) {
		//INFORMACION SOBRE CONTACTOS
		//El demostrador cliente no la captura de formularios, sino que repite la que figura en el 
		//organo de contratacion. En un caso real estos datos no tienen por que coincidir
		
		Contractingauthorityparty datosOC = crearContractingParty();
		
		PartyType party = cs.getCacFactory().createPartyType();
		
		
		PartyNameType name = cs.getCacFactory().createPartyNameType();
		NameType namet = cs.getCbcFactory().createNameType();
		namet.setValue(datosOC.getPartyname());
		name.setName(namet);

		party.getPartyName().add(name);
		
		party=anyadeDireccionContactosPartyOC(party, datosOC);

		// 1. Contacto para informacion adicional
		tenderingTerms.setAdditionalInformationParty(party);
		// 2. Contacto para obtencion de pliegos
		tenderingTerms.setDocumentProviderParty(party);
		// 3. Contacto para presentacion de ofertas
		tenderingTerms.setTenderRecipientParty(party);
	}


}
