/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import es.dgpe.place.client.beans.OrganoContratacionBean;
import es.dgpe.place.client.beans.codice.Code;
import es.dgpe.place.client.beans.codice.Contractingauthorityparty;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.ConfigurationManager;
import es.dgpe.place.client.utils.SessionDataManager;
import java.awt.Rectangle;

public class ConfiguracionInicial extends ThemeJFrame {

	private static String pagina=Acciones.INIT_CONFIG; 
	
	public static String getPagina() {
		return pagina;
	}

	public static void setPagina(String pagina) {
		ConfiguracionInicial.pagina = pagina;
	}

	private static final long serialVersionUID = 1L;
	private JPanel jPanelContenido = null;
	private JLabel jLabelIndentificacion = null;
	private JLabel jLabelNombreOC = null;
	private JLabel jLabelDatosGenerales = null;
	private JLabel jLabelTipoDocumento = null;
	private JComboBox jComboBoxNombreAdmin = null;
	private JComboBox jComboBoxTipoDocumento = null;
	private JTextField jTextFieldNumDocumento = null;
	private JTextField jTextFieldNombreOC = null;
	private JLabel jLabeOrgContratante = null;
	private JComboBox jComboBoxOrgContratante = null;
	private JButton jButtonGuardar = null;
	private JButton jButtonPorDefecto = null;
	private OrganoContratacionBean datosOC=new OrganoContratacionBean();  //  @jve:decl-index=0:
	private JFrame gestorVentanas[]=new JFrame[2];
	private JLabel jLabelIdPlataforma = null;
	private JTextField jTextFieldIdPlataforma = null;
	private JTextField jTextFieldVia=null;
	private JTextField jTextFieldCodigoPostal=null;
	private JTextField jTextFieldPoblacion=null;
	private JLabel lblTelfono=null;
	private JLabel lblFax=null;
	private JLabel lblEmail=null;
	private JTextField jTextFieldTelefono=null;
	private JTextField jTextFieldFax=null;
	private JTextField jTextFieldEmail=null;
	private JLabel lblDireccin=null;
	private JLabel lblVa=null;
	private JLabel lblCdigoPostal=null;
	private JLabel lblPoblacin =null;
	private JLabel lblPas = null;
	private JComboBox jComboBoxPais = null;
	
	/**
	 * This is the default constructor
	 */
	public ConfiguracionInicial(JFrame ventanaPadre, boolean visible)throws ModelException {
		super();
		

		initialize();
		gestorVentanas[0]=ventanaPadre;
		this.setVisible(visible);
		cargarDatosOCPorDefecto();
	}
	
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() { 
		getJPanelContenido();
		this.setTitle("Configuracin inicial del rgano de Contratacin");
		jButtonGuardar.addActionListener(this); 
		jButtonPorDefecto.addActionListener(this);  
		cargarDatosComboBoxs();
	}
	
	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
 
			jLabelIdPlataforma = new JLabel();
			jLabelIdPlataforma.setText("Id Plataforma:");
			jLabelIdPlataforma.setSize(new Dimension(250, 18));
			jLabelIdPlataforma.setLocation(new Point(48, 242));
			jPanelContenido = super.getPanel();
 
			jLabeOrgContratante = new JLabel();
			jLabeOrgContratante.setText("Organizacin Contratante:");
			jLabeOrgContratante.setLocation(new Point(48, 122));
			jLabeOrgContratante.setSize(new Dimension(250, 18));
 
			jLabelTipoDocumento = new JLabel();
			jLabelTipoDocumento.setText("Tipo Documento:");
			jLabelTipoDocumento.setSize(new Dimension(200, 18));
			jLabelTipoDocumento.setLocation(new Point(48, 182));
			jLabelDatosGenerales = new JLabel();
			jLabelDatosGenerales.setText("Datos Generales:");
			jLabelDatosGenerales.setSize(new Dimension(250, 18));
			jLabelDatosGenerales.setFont(new Font("Dialog", Font.BOLD, 12));
			jLabelDatosGenerales.setLocation(new Point(39, 95));
			jLabelNombreOC = new JLabel();
			jLabelNombreOC.setText("Nombre O. Contratacin:");
			jLabelNombreOC.setSize(new Dimension(250, 18));
			jLabelNombreOC.setLocation(new Point(48, 212));
			jLabelIndentificacion = new JLabel();
			jLabelIndentificacion.setText("N Documento");
			jLabelIndentificacion.setSize(new Dimension(100, 18));
			jLabelIndentificacion.setLocation(new Point(473, 181));
 

			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.add(jLabelIndentificacion, null);
			jPanelContenido.add(jLabelNombreOC, null);
			jPanelContenido.add(jLabelDatosGenerales, null);
			jPanelContenido.add(jLabelTipoDocumento, null);
			jPanelContenido.add(getJComboBoxTipoDocumento(), null);
			jPanelContenido.add(getJTextFieldNumDocumento(), null);
			jPanelContenido.add(getJTextFieldNombreOC(), null);
			jPanelContenido.add(jLabeOrgContratante, null);
			jPanelContenido.add(getJComboBoxOrgContratante(), null);
			jPanelContenido.add(getJButtonGuardar(), null);
			jPanelContenido.add(getJButtonPorDefecto(), null);

			jPanelContenido.add(jLabelIdPlataforma, null);
			jPanelContenido.add(getJTextFieldIdPlataforma(), null);
			
			lblDireccin = new JLabel("Direcci\u00F3n");
			lblDireccin.setBounds(50, 294, 248, 14);
			jPanelContenido.add(lblDireccin);
			
			lblVa = new JLabel("V\u00EDa");
			lblVa.setBounds(105, 318, 46, 14);
			jPanelContenido.add(lblVa);
			
		
			jPanelContenido.add(getJTextFieldVia());
			
			lblCdigoPostal = new JLabel("C\u00F3digo Postal");
			lblCdigoPostal.setBounds(105, 370, 156, 14);
			jPanelContenido.add(lblCdigoPostal);
			
			
			jPanelContenido.add(getJTextFieldCodigoPostal());
			
			lblPoblacin = new JLabel("Poblaci\u00F3n");
			lblPoblacin.setBounds(105, 343, 156, 14);
			jPanelContenido.add(lblPoblacin);
			
			lblPas = new JLabel("Pa\u00EDs");
			lblPas.setBounds(105, 395, 156, 14);
			jPanelContenido.add(lblPas);
			
			
			jPanelContenido.add(getJTextFieldPoblacion());
			
			getPanel().add(getJComboBoxPais());
			
			jPanelContenido.add(getLblTelfono());
			jPanelContenido.add(getLblFax());
			jPanelContenido.add(getLblEmail());
			jPanelContenido.add(getJTextFieldTelefono());
			jPanelContenido.add(getJTextFieldFax());
			jPanelContenido.add(getJTextFieldEmail());
			
			
			
		}
		return jPanelContenido;
	}

	private void cargarDatosComboBoxs() {
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxOrgContratante, ConstantsGC.CONTRACTING_AUTHORITY_TYPE);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTipoDocumento, ConstantsGC.DOCUMENT_TYPE);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxPais, ConstantsGC.COUNTRY_CODE);
	}

	/**
	 * This method initializes jComboBoxTipoDocumento	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBoxTipoDocumento() {
		if (jComboBoxTipoDocumento == null) {
			jComboBoxTipoDocumento = new JComboBox();
			jComboBoxTipoDocumento.setLocation(new Point(318, 182));
			jComboBoxTipoDocumento.setSize(new Dimension(100, 18));
			
		}
		return jComboBoxTipoDocumento;
	}

	/**
	 * This method initializes jTextFieldNumDocumento	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldNumDocumento() {
		if (jTextFieldNumDocumento == null) {
			jTextFieldNumDocumento = new JTextField();
			jTextFieldNumDocumento.setLocation(new Point(578, 182));
			jTextFieldNumDocumento.setSize(new Dimension(150, 18));
		}
		return jTextFieldNumDocumento;
	}

	/**
	 * This method initializes jTextFieldNombreOC	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldNombreOC() {
		if (jTextFieldNombreOC == null) {
			jTextFieldNombreOC = new JTextField();
			jTextFieldNombreOC.setSize(new Dimension(210, 18));
			jTextFieldNombreOC.setLocation(new Point(318, 212));
		}
		return jTextFieldNombreOC;
	}

	
	/**
	 * This method initializes jComboBoxOrgContratante	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBoxOrgContratante() {
		if (jComboBoxOrgContratante == null) {
			jComboBoxOrgContratante = new JComboBox();
			jComboBoxOrgContratante.setSize(new Dimension(410, 18));
			jComboBoxOrgContratante.setLocation(new Point(318, 122));
		}
		return jComboBoxOrgContratante;
	}


	/**
	 * This method initializes jButtonGuardar	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonGuardar() {
		if (jButtonGuardar == null) {
			jButtonGuardar = new JButton();
			jButtonGuardar.setText("Guardar");
			jButtonGuardar.setSize(new Dimension(150, 30));
			jButtonGuardar.setLocation(new Point(260, this.getHeight() - 100));
			jButtonGuardar.setActionCommand(Acciones.SAVE_CONFIG);
		}
		return jButtonGuardar;
	}

	/**
	 * This method initializes jButtonPorDefecto	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonPorDefecto() {
		if (jButtonPorDefecto == null) {
			jButtonPorDefecto = new JButton();			
			jButtonPorDefecto.setText("Cargar valores por defecto");
			jButtonPorDefecto.setSize(new Dimension(200, 30));
			jButtonPorDefecto.setLocation(new Point(450, this.getHeight() - 100));
			jButtonPorDefecto.setActionCommand(Acciones.LOAD_CONFIG);
		}
		return jButtonPorDefecto;
	}
	
	public void cargarDatosOCPorDefecto(){ 
		
		datosOC = new OrganoContratacionBean();

		datosOC.setIdOrgContratante(new Integer(ConfigurationManager.leerPropiedadBP("contractingAutority.code")));
		datosOC.setOrgContratante(ConfigurationManager.leerPropiedadBP("contractingAutority.value"));
		jComboBoxOrgContratante.setSelectedItem(datosOC.getOrgContratante());
		
		
		datosOC.setTipoDocumento(ConfigurationManager.leerPropiedadBP("documentType.code"));	
		jComboBoxTipoDocumento.setSelectedItem(datosOC.getTipoDocumento());
		jComboBoxTipoDocumento.setEnabled(false);
		
		datosOC.setNumDocumento(ConfigurationManager.leerPropiedadBP("documentType.value"));
		jTextFieldNumDocumento.setText(datosOC.getNumDocumento());
		
		datosOC.setNombreOC(ConfigurationManager.leerPropiedadBP("partyName"));
		jTextFieldNombreOC.setText(datosOC.getNombreOC());
		
		datosOC.setIdPlataforma(ConfigurationManager.leerPropiedadBP("idPlataforma"));
		jTextFieldIdPlataforma.setText(datosOC.getIdPlataforma());
		
		
		//Calle y numero
		datosOC.setVia(ConfigurationManager.leerPropiedadBP("direccion.via"));
		jTextFieldVia.setText(datosOC.getVia());
		
		//Codigo Postal
		datosOC.setCP(ConfigurationManager.leerPropiedadBP("direccion.codigoPostal"));
		jTextFieldCodigoPostal.setText(datosOC.getCP());
		
		//Poblacion
		datosOC.setPoblacion(ConfigurationManager.leerPropiedadBP("direccion.poblacion"));
		jTextFieldPoblacion.setText(datosOC.getPoblacion());
		
		//Pais
		datosOC.setPais(ConfigurationManager.leerPropiedadBP("direccion.pais"));
		
		//Cargar el ComboBox con el pais
		jComboBoxPais.setSelectedItem((String) datosOC.getPais());
		//e-mail
		datosOC.setEmail(ConfigurationManager.leerPropiedadBP("contacto.eMail"));
		jTextFieldEmail.setText(datosOC.getEmail());
		
		//Telefono
		datosOC.setTelefono(ConfigurationManager.leerPropiedadBP("contacto.telefono"));
		jTextFieldTelefono.setText(datosOC.getTelefono());
		
		//Fax
		datosOC.setFax(ConfigurationManager.leerPropiedadBP("contacto.fax"));
		jTextFieldFax.setText(datosOC.getFax());
		
		//Por ltimo, se guarda en sesin
		SessionDataManager.getInstance().setOrganoContratacion(getDatosOC());
		
		
	}
	
	public OrganoContratacionBean getDatosOC() {

		datosOC = new OrganoContratacionBean();

		datosOC.setOrgContratante((String) jComboBoxOrgContratante.getSelectedItem());
		datosOC.setIdOrgContratante(jComboBoxOrgContratante.getSelectedIndex());


		datosOC.setTipoDocumento((String) jComboBoxTipoDocumento.getSelectedItem()); 
		datosOC.setNumDocumento(jTextFieldNumDocumento.getText());

		datosOC.setNombreOC(jTextFieldNombreOC.getText());

		datosOC.setIdPlataforma(jTextFieldIdPlataforma.getText());
		
		datosOC.setVia(jTextFieldVia.getText());
		datosOC.setPoblacion(jTextFieldPoblacion.getText());
		datosOC.setCP(jTextFieldCodigoPostal.getText());
		//TODO Leer Pas
		datosOC.setPais((String)getJComboBoxPais().getSelectedItem());
		datosOC.setIdPais(getJComboBoxPais().getSelectedIndex());
		datosOC.setEmail(jTextFieldEmail.getText());
		datosOC.setTelefono(jTextFieldTelefono.getText());
		datosOC.setFax(jTextFieldFax.getText());
		
		//Por ltimo, se guarda en sesin
		SessionDataManager.getInstance().setOrganoContratacion(datosOC);

		return datosOC;
	}

	public void setDatosOC(OrganoContratacionBean datosOC) {
		this.datosOC = datosOC;
	}
	
	public void actionPerformed(ActionEvent e) {
		
		if (e.getActionCommand().equalsIgnoreCase(Acciones.SAVE_CONFIG)){
			gestorVentanas[0].setVisible(true);
			this.setVisible(false);
			SessionDataManager.getInstance().setOrganoContratacion(getDatosOC());
			
		}if (e.getActionCommand().equalsIgnoreCase(Acciones.LOAD_CONFIG)){
			cargarDatosOCPorDefecto();			
		}
	}

	/**
	 * This method initializes jTextFieldIdPlataforma	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldIdPlataforma() {
		if (jTextFieldIdPlataforma == null) {
			jTextFieldIdPlataforma = new JTextField();
			jTextFieldIdPlataforma.setLocation(new Point(319, 242));
			jTextFieldIdPlataforma.setSize(new Dimension(210, 18));
		}
		return jTextFieldIdPlataforma;
	}
	
	private JLabel getLblTelfono() {
		if (lblTelfono == null) {
			lblTelfono = new JLabel("Tel\u00E9fono");
			lblTelfono.setBounds(50, 451, 156, 14);
		}
		return lblTelfono;
	}
	
	private JLabel getLblFax() {
		if (lblFax == null) {
			lblFax = new JLabel("Fax");
			lblFax.setBounds(50, 476, 156, 14);
		}
		return lblFax;
	}
	
	private JLabel getLblEmail() {
		if (lblEmail == null) {
			lblEmail = new JLabel("eMail");
			lblEmail.setBounds(50, 501, 156, 14);
		}
		return lblEmail;
	}
	
	private JTextField getJTextFieldVia() {
		if (jTextFieldVia == null) {
			jTextFieldVia=new JTextField();
			jTextFieldVia.setText((String) null);
			jTextFieldVia.setSize(new Dimension(210, 18));
			jTextFieldVia.setLocation(new Point(318, 212));
			jTextFieldVia.setBounds(320, 316, 412, 18);
		}
		return jTextFieldVia;
	}
	
	private JTextField getJTextFieldPoblacion() {
		if (jTextFieldPoblacion == null) {
			jTextFieldPoblacion = new JTextField();
			jTextFieldPoblacion.setText((String) null);
			jTextFieldPoblacion.setSize(new Dimension(210, 18));
			jTextFieldPoblacion.setLocation(new Point(318, 212));
			jTextFieldPoblacion.setBounds(320, 345, 412, 18);
		}
		return jTextFieldPoblacion;
	}
	
	private JTextField getJTextFieldCodigoPostal() {
		if (jTextFieldCodigoPostal == null) {
			jTextFieldCodigoPostal = new JTextField();
			jTextFieldCodigoPostal.setText((String) null);
			jTextFieldCodigoPostal.setSize(new Dimension(210, 18));
			jTextFieldCodigoPostal.setLocation(new Point(318, 212));
			jTextFieldCodigoPostal.setBounds(320, 368, 82, 18);
		}
		return jTextFieldCodigoPostal;
	}
	
	private JComboBox getJComboBoxPais() {
		if (jComboBoxPais == null) {
			jComboBoxPais = new JComboBox();
			jComboBoxPais.setSize(new Dimension(410, 18));
			jComboBoxPais.setLocation(new Point(318, 122));
			jComboBoxPais.setBounds(320, 397, 247, 18);
		}
		return jComboBoxPais;
	}
	
	private JTextField getJTextFieldTelefono() {
		if (jTextFieldTelefono == null) {
			jTextFieldTelefono = new JTextField();
			jTextFieldTelefono.setText((String) null);
			jTextFieldTelefono.setSize(new Dimension(210, 18));
			jTextFieldTelefono.setLocation(new Point(318, 212));
			jTextFieldTelefono.setBounds(320, 448, 150, 18);
		}
		return jTextFieldTelefono;
	}
	
	private JTextField getJTextFieldFax() {
		if (jTextFieldFax == null) {
			jTextFieldFax = new JTextField();
			jTextFieldFax.setText((String) null);
			jTextFieldFax.setSize(new Dimension(210, 18));
			jTextFieldFax.setLocation(new Point(318, 212));
			jTextFieldFax.setBounds(320, 473, 150, 18);
		}
		return jTextFieldFax;
	}
	
	private JTextField getJTextFieldEmail() {
		if (jTextFieldEmail == null) {
			jTextFieldEmail = new JTextField();
			jTextFieldEmail.setText((String) null);
			jTextFieldEmail.setSize(new Dimension(210, 18));
			jTextFieldEmail.setLocation(new Point(318, 212));
			jTextFieldEmail.setBounds(320, 498, 299, 18);
		}
		return jTextFieldEmail;
	}
}
