/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import org.dgpe.codice.common.caclib.DocumentReferenceType;
import org.dgpe.codice.maindoc.callfortenders.CallForTendersType;
import org.dgpe.codice.maindoc.contractawardnotice.ContractAwardNoticeType;
import org.dgpe.codice.maindoc.contractmodificationnotice.ContractModificationNoticeType;
import org.dgpe.codice.maindoc.contractnotice.ContractNoticeType;
import org.dgpe.codice.maindoc.pin.PriorInformationNoticeType;

import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ClientException;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.CODICESerializing;
import es.dgpe.place.client.utils.ClienteLlamadas;
import es.dgpe.place.client.utils.documentsgenerator.DocumentsGenerator;
import ext.place.codice.maindoc.cancelgeneraldocumentrequest.CancelGeneralContractDocumentRequestType;
import ext.place.codice.maindoc.cancelnoticerequest.CancelNoticeRequestType;



public class GeneracionCODICEForm extends ThemeJFrame {

	private static String pagina=Acciones.INIT_CODICE; 
	private static final long serialVersionUID = 1L;
	private JPanel jPanelContenido = null;
	private JLabel jLabelCodiceGenerado = null;
	private JLabel jLabelDocumentoTruncado = null;
	private JTextArea jTextAreaCODICE = null;
	JScrollPane areaScrollPane=null;
	private JButton jButtonGenerarCodice = null;
	private static int MAX_SIZE=200000;
	
	private JButton jButtonDescargarCodice=null;
 
	JFrame gestorVentanasGenCodice[] = new JFrame[2];
	
	private String tipoDocumento="";
 
	private String docSerializado="";
	
	final JFileChooser fc = new JFileChooser();
	

	public void setJButtonDescargarCodice(JButton buttonDescargarCodice) {
		jButtonDescargarCodice = buttonDescargarCodice;
	}


	public String getDocSerializado() {
		return docSerializado;
	}


	public void setDocSerializado(String docSerializado) {
		this.docSerializado = docSerializado;
	}


	public static String getPagina() {
		return pagina;
	}


	public static void setPagina(String pagina) {
		GeneracionCODICEForm.pagina = pagina;
	}


	public String getTipoDocumento() {
		return tipoDocumento;
	}


	public void setTipoDocumento(String tipoDocumento) {
		this.tipoDocumento = tipoDocumento;
	}


	public GeneracionCODICEForm(JFrame ventanaPadre, String tipoDocumento)  throws ModelException {
		super();
		initialize();
		
		gestorVentanasGenCodice[0]=ventanaPadre;
		setTipoDocumento(tipoDocumento);
		
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		jButtonDescargarCodice.addActionListener(this);  
		jButtonGenerarCodice.addActionListener(this);  
	}

	
	private void initialize() {		
		this.setBackground(Color.white);
		getJPanelContenido();
		this.setTitle("Generacin de CODICE");
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setVisible(true);
		
	}

	
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelCodiceGenerado = new JLabel();
			jLabelCodiceGenerado.setText("CODICE generado:");
			jLabelCodiceGenerado.setSize(new Dimension(250, 20));
			jLabelCodiceGenerado.setLocation(new Point(60, 155));
			jLabelDocumentoTruncado = new JLabel();
			jLabelDocumentoTruncado.setText("El documento generado es demasiado grande y ha sido truncado para su visualizacin");
			jLabelDocumentoTruncado.setSize(new Dimension(600, 20));
			jLabelDocumentoTruncado.setLocation(new Point(60, 550));
			jLabelDocumentoTruncado.setVisible(false);
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.add(jLabelCodiceGenerado, null);
			jPanelContenido.add(jLabelDocumentoTruncado,null);
			jPanelContenido.add(getJButtonGenerarCodice(), null); 
			jPanelContenido.add(getJButtonDescargarCodice(), null);
			
			areaScrollPane= new JScrollPane(getJTextAreaCODICE()); 
			areaScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			areaScrollPane.setSize(new Dimension(this.getWidth()-100, 300));
			areaScrollPane.setPreferredSize(new Dimension(this.getWidth()-100, 300));
			areaScrollPane.setLocation(new Point(60, 185));
			jPanelContenido.add(areaScrollPane, null); 
			
		}
		
		if (jTextAreaCODICE.getText() != null || "".equals(jTextAreaCODICE.getText()))
			jLabelDocumentoTruncado.setVisible(false);
		return jPanelContenido;
	}


	private JTextArea getJTextAreaCODICE() {
		if (jTextAreaCODICE == null) {
			jTextAreaCODICE = new JTextArea();
			jTextAreaCODICE.setLocation(new Point(60, 90));
			jTextAreaCODICE.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
			jTextAreaCODICE.setColumns(10);
			jTextAreaCODICE.setName("jTextAreaCODICE");
			jTextAreaCODICE.setText("");
			jTextAreaCODICE.setBorder(BorderFactory.createLineBorder(Color.black, 1));
			jTextAreaCODICE.setSize(new Dimension(700, 300));
			jTextAreaCODICE.setEditable(true);
			jTextAreaCODICE.setAutoscrolls(true);
			jTextAreaCODICE.setRows(20);
			
			
		}
		return jTextAreaCODICE;
	}

 
	private JButton getJButtonDescargarCodice() {
		
		if (jButtonDescargarCodice == null) {
			jButtonDescargarCodice = new JButton();
			jButtonDescargarCodice.setLocation(new Point(430, 508));
			jButtonDescargarCodice.setText("Descargar documento...");
			jButtonDescargarCodice.setSize(new Dimension(200, 30));
			jButtonDescargarCodice.setActionCommand(Acciones.SAVE_CODICE);
		}
		return jButtonDescargarCodice;
		
	}
	
	private JButton getJButtonGenerarCodice() {
		if (jButtonGenerarCodice == null) {
			jButtonGenerarCodice = new JButton();
			jButtonGenerarCodice.setLocation(new Point(200, 508));
			jButtonGenerarCodice.setText("Generar documento CODICE");
			jButtonGenerarCodice.setSize(new Dimension(200, 30));
			jButtonGenerarCodice.setActionCommand(Acciones.INIT_CODICE);
		}
		return jButtonGenerarCodice;
	}

	private String trimText(String inText) {
		String outText = null;
		
		int maxSize = MAX_SIZE;
		if (inText != null && inText.length() > maxSize)
			outText = inText.substring(0, maxSize);
		else
			outText = inText;

		return outText;
	
	}
	
	
	public void actionPerformed(ActionEvent e) {
		
		try{
			
		if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_CODICE)&&getTipoDocumento().equalsIgnoreCase(TipoDocumento.PIN)){
			setDocSerializado(DocumentsGenerator.generarDocumentoCODICE(TipoDocumento.PIN)); 
			jTextAreaCODICE.setText(trimText(getDocSerializado())); 		
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_CODICE)&&getTipoDocumento().equalsIgnoreCase(TipoDocumento.CN)){
			setDocSerializado(DocumentsGenerator.generarDocumentoCODICE(TipoDocumento.CN)); 
			jTextAreaCODICE.setText(trimText(getDocSerializado()));			
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_CODICE)&&getTipoDocumento().equalsIgnoreCase(TipoDocumento.CD)){
			setDocSerializado(DocumentsGenerator.generarDocumentoCODICE(TipoDocumento.CD)); 
			jTextAreaCODICE.setText(trimText(getDocSerializado()));
			//Si se ha truncado el texto, se impide editar el doc, y se visualiza el mensaje
			if (getDocSerializado().length() >= MAX_SIZE)
			{
					jLabelDocumentoTruncado.setVisible(true);
					jTextAreaCODICE.setEditable(false);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_CODICE)&&getTipoDocumento().equalsIgnoreCase(TipoDocumento.ADJ)){
			setDocSerializado(DocumentsGenerator.generarDocumentoCODICE(TipoDocumento.ADJ)); 
			jTextAreaCODICE.setText(trimText(getDocSerializado()));
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_CODICE)&&getTipoDocumento().equalsIgnoreCase(TipoDocumento.FORM)){
			setDocSerializado(DocumentsGenerator.generarDocumentoCODICE(TipoDocumento.FORM)); 
			jTextAreaCODICE.setText(trimText(getDocSerializado()));
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_CODICE)&&getTipoDocumento().equalsIgnoreCase(TipoDocumento.RENUNCIA)){
			setDocSerializado(DocumentsGenerator.generarDocumentoCODICE(TipoDocumento.RENUNCIA)); 
			jTextAreaCODICE.setText(trimText(getDocSerializado()));
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_CODICE)&&getTipoDocumento().equalsIgnoreCase(TipoDocumento.DOC_GEN)){
			setDocSerializado(DocumentsGenerator.generarDocumentoCODICE(TipoDocumento.DOC_GEN)); 
			jTextAreaCODICE.setText(trimText(getDocSerializado()));
			//Si se ha truncado el texto, se impide editar el doc, y se visualiza el mensaje
			if (getDocSerializado().length() >= MAX_SIZE)
			{
					jLabelDocumentoTruncado.setVisible(true);
					jTextAreaCODICE.setEditable(false);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_CODICE)&&getTipoDocumento().equalsIgnoreCase(TipoDocumento.MENOR)){
			setDocSerializado(DocumentsGenerator.generarDocumentoCODICE(TipoDocumento.MENOR)); 
			jTextAreaCODICE.setText(trimText(getDocSerializado()));
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_CODICE)&&getTipoDocumento().equalsIgnoreCase(TipoDocumento.MODIF)){
			setDocSerializado(DocumentsGenerator.generarDocumentoCODICE(TipoDocumento.MODIF)); 
			jTextAreaCODICE.setText(trimText(getDocSerializado()));
		}				
		else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_CODICE)&&getTipoDocumento().equalsIgnoreCase(TipoDocumento.CANCEL_NOTICE)){
			setDocSerializado(DocumentsGenerator.generarDocumentoCODICE(TipoDocumento.CANCEL_NOTICE)); 
			jTextAreaCODICE.setText(trimText(getDocSerializado()));
			//Si se ha truncado el texto, se impide editar el doc, y se visualiza el mensaje
			if (getDocSerializado().length() >= MAX_SIZE)
			{
					jLabelDocumentoTruncado.setVisible(true);
					jTextAreaCODICE.setEditable(false);
			}
		
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_CODICE)&&getTipoDocumento().equalsIgnoreCase(TipoDocumento.CANCEL_DOCUMENT)){
			setDocSerializado(DocumentsGenerator.generarDocumentoCODICE(TipoDocumento.CANCEL_DOCUMENT)); 
			jTextAreaCODICE.setText(trimText(getDocSerializado()));
			//Si se ha truncado el texto, se impide editar el doc, y se visualiza el mensaje
			if (getDocSerializado().length() >= MAX_SIZE)
			{
					jLabelDocumentoTruncado.setVisible(true);
					jTextAreaCODICE.setEditable(false);
			}
		
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.SAVE_CODICE)){
			
			int returnVal = fc.showSaveDialog(jButtonDescargarCodice);
			 if (returnVal == JFileChooser.APPROVE_OPTION) {
				 File file = fc.getSelectedFile();
				 try{
				 Writer writer = new FileWriter(file);
				 writer.write(new String(getDocSerializado().getBytes("UTF-8")));  //Documento generado
				 writer.close();
				 }catch (Exception e1){
					 e1.printStackTrace();
				 }
				 
			 }
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)){
			jTextAreaCODICE.setText("");
			jLabelDocumentoTruncado.setVisible(false);
			gestorVentanasGenCodice[0].setVisible(true);
			this.setVisible(false);
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {

			if (getTipoDocumento().equalsIgnoreCase(TipoDocumento.PIN)){
				try{
					setDocSerializado(jTextAreaCODICE.getText());
					InputStream is = new ByteArrayInputStream(getDocSerializado().getBytes("UTF-8"));
					PriorInformationNoticeType pin=CODICESerializing.getInstance().deserializePriorInformationNotice(is);
					ClienteLlamadas.setTipoDocumento(tipoDocumento);
					ClienteLlamadas.setDocSerializado(pin);
				}catch (Exception e1){
					e1.printStackTrace();
					throw (new ClientException("Error al obtener el documento Anuncio Previo CODICE generado. El documento no es vlido."));
				}
			}else if (getTipoDocumento().equalsIgnoreCase(TipoDocumento.CN)){
				try{
					setDocSerializado(jTextAreaCODICE.getText());
					InputStream is = new ByteArrayInputStream(getDocSerializado().getBytes("UTF-8"));
					ContractNoticeType cn=CODICESerializing.getInstance().deserializeContractNotice(is);
					ClienteLlamadas.setTipoDocumento(tipoDocumento);
					ClienteLlamadas.setDocSerializado(cn);
				}catch (Exception e1){
					e1.printStackTrace();
					throw (new ClientException("Error al obtener el documento Anuncio de Licitacin CODICE generado. El documento no es vlido."));
				}
			}else if (getTipoDocumento().equalsIgnoreCase(TipoDocumento.CD)){
				try{
					// Si el tamao es menor que el lmite, se puede editar
					if (getDocSerializado().length() < MAX_SIZE)
						setDocSerializado(jTextAreaCODICE.getText());
					
					InputStream is = new ByteArrayInputStream(getDocSerializado().getBytes("UTF-8"));
					CallForTendersType cft=CODICESerializing.getInstance().deserializeCallforTenders(is);
					ClienteLlamadas.setTipoDocumento(tipoDocumento);
					ClienteLlamadas.setDocSerializado(cft);
				}catch (Exception e1){
					e1.printStackTrace();
					throw (new ClientException("Error al obtener el documento de Pliegos CODICE generado. El documento no es vlido."));
				}
			}else if (getTipoDocumento().equalsIgnoreCase(TipoDocumento.ADJ)||
					getTipoDocumento().equalsIgnoreCase(TipoDocumento.FORM)||
					getTipoDocumento().equalsIgnoreCase(TipoDocumento.RENUNCIA)||
					getTipoDocumento().equalsIgnoreCase(TipoDocumento.MENOR)){
				try{
					setDocSerializado(jTextAreaCODICE.getText());
					InputStream is = new ByteArrayInputStream(getDocSerializado().getBytes("UTF-8"));
					ContractAwardNoticeType can=CODICESerializing.getInstance().deserializeContractAwardNotice(is);
					ClienteLlamadas.setTipoDocumento(tipoDocumento);
					ClienteLlamadas.setDocSerializado(can);
				}catch (Exception e1){
					e1.printStackTrace();
					throw (new ClientException("Error al obtener el documento Anuncio CODICE generado. El documento no es vlido."));
					}
				
			}else if (
					getTipoDocumento().equalsIgnoreCase(TipoDocumento.MODIF)){
				try{
					setDocSerializado(jTextAreaCODICE.getText());
					InputStream is = new ByteArrayInputStream(getDocSerializado().getBytes("UTF-8"));
					ContractModificationNoticeType mod=CODICESerializing.getInstance().deserializeContractModificactionNotice(is);
					ClienteLlamadas.setTipoDocumento(tipoDocumento);
					ClienteLlamadas.setDocSerializado(mod);
				}catch (Exception e1){
					e1.printStackTrace();
					throw (new ClientException("Error al obtener el documento Anuncio CODICE generado. El documento no es vlido."));
					}
			}else if (getTipoDocumento().equalsIgnoreCase(TipoDocumento.DOC_GEN)){
				try{
					// Si el tamao es menor que el lmite, se puede editar
					if (getDocSerializado().length() < MAX_SIZE)
						setDocSerializado(jTextAreaCODICE.getText());
					
					InputStream is = new ByteArrayInputStream(getDocSerializado().getBytes("UTF-8"));
					DocumentReferenceType dr=CODICESerializing.getInstance().deserializeDocumentReferenceType(is);
					ClienteLlamadas.setTipoDocumento(tipoDocumento);
					ClienteLlamadas.setDocSerializado(dr);
				}catch (Exception e1){
					e1.printStackTrace();
					throw (new ClientException("Error al obtener el documento General CODICE generado. El documento no es vlido."));
				}
			}else if (getTipoDocumento().equalsIgnoreCase(TipoDocumento.CANCEL_NOTICE)){
				try{
					// Si el tamao es menor que el lmite, se puede editar
					if (getDocSerializado().length() < MAX_SIZE)
						setDocSerializado(jTextAreaCODICE.getText());
					
					InputStream is = new ByteArrayInputStream(getDocSerializado().getBytes("UTF-8"));
					CancelNoticeRequestType cancelNotice=CODICESerializing.getInstance().deserializeCancelNoticeRequest(is);
					ClienteLlamadas.setTipoDocumento(tipoDocumento);
					ClienteLlamadas.setDocSerializado(cancelNotice);
				}catch (Exception e1){
					e1.printStackTrace();
					throw (new ClientException("Error al obtener el documento de anulacion de anuncio CODICE generado. El documento no es vlido."));
				}
			}else if (getTipoDocumento().equalsIgnoreCase(TipoDocumento.CANCEL_DOCUMENT)){
				try{
					// Si el tamao es menor que el lmite, se puede editar
					if (getDocSerializado().length() < MAX_SIZE)
						setDocSerializado(jTextAreaCODICE.getText());
					
					InputStream is = new ByteArrayInputStream(getDocSerializado().getBytes("UTF-8"));
					CancelGeneralContractDocumentRequestType cancelDocument=CODICESerializing.getInstance().deserializeCancelGeneralContractDocumentRequest(is);
					ClienteLlamadas.setTipoDocumento(tipoDocumento);
					ClienteLlamadas.setDocSerializado(cancelDocument);
				}catch (Exception e1){
					e1.printStackTrace();
					throw (new ClientException("Error al obtener el documento de anulacion de documento General CODICE generado. El documento no es vlido."));
				}
			}
			this.setVisible(false);
			gestorVentanasGenCodice[1] = new WebServiceCODICEForm(this,	tipoDocumento);
			gestorVentanasGenCodice[1].setVisible(true);

		}
		
		} catch (ClientException ex)
		{
			try {
			this.setVisible(false);
			gestorVentanasGenCodice[1] = new WebServiceCODICEForm(this,Acciones.INIT_PREVIEW, ex);
			} catch (ModelException e1){
			e1.printStackTrace();
			} 
		} catch (ModelException e1){
			e1.printStackTrace();
			}
	}



}
