/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ClientException;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ClienteLlamadas;


public class PresentacionResultadoPeticion extends ThemeJFrame {

	private static String pagina = Acciones.INIT_WEB_SERVICE;

	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;

	private JLabel jLabelCodiceGenerado = null;

	private JTextArea jTextAreaMensajeEnviado = null;

	JScrollPane AreaMensajeEnviado = null;

	JFrame gestorVentanasGenCodice[] = new JFrame[2];

	private String tipoDocumento = ""; // @jve:decl-index=0:

	private JLabel jLabelMensajeRecibido = null;
	private JButton jButtonGuardarDatosRecibidos = null;
	
	final JFileChooser fc = new JFileChooser();
	
	private String mensajeEnviado = null, mensajeRecibido = null;

	

	
	public void setJButtonGuardarDatosRecibidos(JButton buttonGuardarDatosRecibidos) {
		jButtonGuardarDatosRecibidos = buttonGuardarDatosRecibidos;
	}

	public static String getPagina() {
		return pagina;
	}

	public static void setPagina(String pagina) {
		PresentacionResultadoPeticion.pagina = pagina;
	}

	public String getTipoDocumento() {
		return tipoDocumento;
	}

	public void setTipoDocumento(String tipoDocumento) {
		this.tipoDocumento = tipoDocumento;
	}

	/**
	 * @wbp.parser.constructor
	 */
	public PresentacionResultadoPeticion(JFrame ventanaPadre, String tipoDocumento)
			throws ModelException {
		super();
		initialize();
		
		gestorVentanasGenCodice[0] = ventanaPadre;
		setTipoDocumento(tipoDocumento);
		ClienteLlamadas.setTipoDocumento(tipoDocumento);

		setHasButtonPrev(true);

		if (isHasButtonPrev()) {
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		jButtonGuardarDatosRecibidos.addActionListener(this);
	}
	
	
	public PresentacionResultadoPeticion(JFrame ventanaPadre, String tipoDocumento, ClientException e)
	throws ModelException {
		super();
		initialize();

		gestorVentanasGenCodice[0] = ventanaPadre;
		setTipoDocumento(tipoDocumento);
		ClienteLlamadas.setTipoDocumento(tipoDocumento);

		setHasButtonPrev(true);

		if (isHasButtonPrev()) {
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		jButtonGuardarDatosRecibidos.setEnabled(false);
		
		if (e != null)
		{
			
			final Writer result = new StringWriter();
		    final PrintWriter printWriter = new PrintWriter(result);
		    e.printStackTrace(printWriter);
		    jTextAreaMensajeEnviado.setText("Se ha producido un error: Por favor revise la excepcin" + "\n" + result.toString());
		}
	}
	
	

	private void initialize() {
		this.setBackground(Color.white);
		getJPanelContenido();
		this.setTitle("Resultado");
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setVisible(true);

	}

	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelCodiceGenerado = new JLabel();
			jLabelCodiceGenerado.setText("Respuesta obtenida");
			jLabelCodiceGenerado.setSize(new Dimension(250, 20));
			jLabelCodiceGenerado.setLocation(new Point(34, 22));
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.add(jLabelCodiceGenerado, null);
			jPanelContenido.add(getJButtonGuardarDatosRecibidos(), null);
			
			AreaMensajeEnviado = new JScrollPane(getJTextAreaCODICE());
			AreaMensajeEnviado
					.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			AreaMensajeEnviado.setSize(new Dimension(829, 584));
			AreaMensajeEnviado.setPreferredSize(new Dimension(this.getWidth()-100, 300));
			AreaMensajeEnviado.setLocation(new Point(44, 53));
			jPanelContenido.add(AreaMensajeEnviado, null);

		}
		return jPanelContenido;
	}

	public JButton getJButtonGuardarDatosRecibidos() {
		if (jButtonGuardarDatosRecibidos == null) {
			jButtonGuardarDatosRecibidos = new JButton();
			jButtonGuardarDatosRecibidos.setLocation(new Point(super.getWidth()-250, super.getHeight()-100));
			jButtonGuardarDatosRecibidos.setText("Guardar");
			jButtonGuardarDatosRecibidos.setSize(new Dimension(200, 30));
			jButtonGuardarDatosRecibidos.setActionCommand(Acciones.SAVE_RESPONSE);
		}
		return jButtonGuardarDatosRecibidos;
		
	}
	
	public JTextArea getJTextAreaCODICE() {
		if (jTextAreaMensajeEnviado == null) {
			jTextAreaMensajeEnviado = new JTextArea();
			jTextAreaMensajeEnviado.setLocation(new Point(60, 90));
			jTextAreaMensajeEnviado
					.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
			jTextAreaMensajeEnviado.setColumns(10);
			jTextAreaMensajeEnviado.setName("jTextAreaMensajeEnviado");
			jTextAreaMensajeEnviado.setText("");
			jTextAreaMensajeEnviado.setBorder(BorderFactory.createLineBorder(
					Color.black, 1));
			jTextAreaMensajeEnviado.setSize(new Dimension(this.getWidth()-100, 300));
			jTextAreaMensajeEnviado.setEditable(false);
			jTextAreaMensajeEnviado.setAutoscrolls(true);
			jTextAreaMensajeEnviado.setLineWrap(true);
			jTextAreaMensajeEnviado.setWrapStyleWord(true);
			jTextAreaMensajeEnviado.setLineWrap(false);
			jTextAreaMensajeEnviado.setWrapStyleWord(false);
			jTextAreaMensajeEnviado.setRows(20);

		}
		return jTextAreaMensajeEnviado;
	}

	public void actionPerformed(ActionEvent e) {
		
		String sent=null, received=null;
		
		
		if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_COMM)) {
			
//			realizarLlamadaWebService(ClienteLlamadas.getTipoDocumento());
//			mensajeEnviado = ClienteLlamadas.getMensajeEnviado();
//			mensajeRecibido = ClienteLlamadas.getMensajeRecibido();
//
//			
//			int maxSize = 20000;
//			if (mensajeEnviado != null && mensajeEnviado.length() > maxSize)
//				sent = mensajeEnviado.substring(0, maxSize);
//			else
//				sent = mensajeEnviado;
//			if (mensajeRecibido != null && mensajeRecibido.length() > maxSize)
//				received = mensajeRecibido.substring(0, maxSize);
//			else
//				received = mensajeRecibido;
//
//			jTextAreaMensajeEnviado.setText(sent);
//			
			
		
			 
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			gestorVentanasGenCodice[0].setVisible(true);
			this.setVisible(false);
		}

	}

	



}
