/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingConstants;

import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ConfigurationManager;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.windows.publication.service.ServicioPublicacionForm;
import es.dgpe.place.client.windows.query.service.ServicioConsultaForm;
import es.dgpe.place.client.windows.util.service.ServicioUtilidadesForm;
import es.dgpe.place.client.windows.anulaciones.service.ServicioAnulacionesForm;

public class VentanaPrincipal extends ThemeJFrame {
	
	private static String pagina=Acciones.INIT_MAIN;
	
	public static String getPagina() {
		return pagina;
	}

	public static void setPagina(String pagina) {
		VentanaPrincipal.pagina = pagina;
	}

	private static final long serialVersionUID = -124924870805332497L;


	private JPanel jPanelContenido = null;
	
	private JLabel jLabelTitulo = null;
	
	private JPanel jPanelSeleccion = null;	
	
 	private ButtonGroup selectorMenuPrincipal = new ButtonGroup();
	
	private JRadioButton jRadioButton1 = null;

	private JRadioButton jRadioButton2 = null;	

	private JRadioButton jRadioButton3 = null;

	private JRadioButton jRadioButton4 = null;

	private JRadioButton jRadioButton5 = null;
	
	
	
	JFrame gestorVentanas[] = new JFrame[5];

	public VentanaPrincipal() throws ModelException {
		super(); 
		setHasButtonNext(true);
		initialize();
		this.setVisible(true);

		gestorVentanas[0] = null;//INIT_CONFIG
		gestorVentanas[1] = null;//INIT_PUB
		gestorVentanas[2] = null;//INIT_QUERY
		gestorVentanas[3] = null;//INIT_UTILITY
		gestorVentanas[4] = null;//INIT_ANUL
		try{
			gestorVentanas[0] = new ConfiguracionInicial(this,false);
		}catch (Exception e){
			
		}
		
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		
		jPanelContenido =   super.getPanel();
		
		this.setTitle("Demostrador Cliente Web Services para CODICE");		 
		jPanelContenido.add(getLabelTitulo(),null);
		jPanelContenido.add(getJPanelSeleccion(), null);
		
		this.getContentPane().add(jPanelContenido, null);
		this.setBackground(Color.WHITE);
		jPanelContenido.setBackground(Color.WHITE);
				
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		} 
		
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE); 
		this.repaint(500);
	}
	
	private JLabel getLabelTitulo() {
		if (jLabelTitulo == null) {
			jLabelTitulo = new JLabel();
			jLabelTitulo.setBounds(new Rectangle(100, 165, this.getWidth(), 50));
			jLabelTitulo.setFont(new Font("Dialog", Font.BOLD, 18));
			jLabelTitulo.setText("Men principal");
		}
		return jLabelTitulo;
	}
	
	private JPanel getJPanelSeleccion() {
		if (jPanelSeleccion== null) {
			jPanelSeleccion = new JPanel();
			jPanelSeleccion.setLayout(new BoxLayout(jPanelSeleccion, BoxLayout.Y_AXIS));
			jPanelSeleccion.setBounds(new Rectangle(250, 225, 246, 119));
			jPanelSeleccion.setBackground(Color.WHITE);
			jPanelSeleccion.setAlignmentX(50.0F);
			jPanelSeleccion.add(getJRadioButton1(), null);
			jPanelSeleccion.add(getJRadioButton2(), null);
			jPanelSeleccion.add(getJRadioButton3(), null);
			jPanelSeleccion.add(getJRadioButton4(), null);
			jPanelSeleccion.add(getJRadioButton5(), null);			
			
			
			selectorMenuPrincipal.add(jRadioButton1);
			selectorMenuPrincipal.add(jRadioButton2);
			selectorMenuPrincipal.add(jRadioButton3);
			selectorMenuPrincipal.add(jRadioButton4);
			selectorMenuPrincipal.add(jRadioButton5);
			
			
		}
		return jPanelSeleccion;
	}	


	private JRadioButton getJRadioButton1() {
		if (jRadioButton1 == null) {
			jRadioButton1 = new JRadioButton();
			jRadioButton1.setBackground(Color.white);
			jRadioButton1.setName("jRadioButton1");
			jRadioButton1.setActionCommand(Acciones.INIT_CONFIG);
			jRadioButton1.setBackground(Color.white);
			jRadioButton1.setText("Iniciar asistente de configuracin");
		}
		return jRadioButton1;
	}

	private JRadioButton getJRadioButton2() {
		if (jRadioButton2 == null) {
			jRadioButton2 = new JRadioButton();
			jRadioButton2.setBackground(Color.white);
			jRadioButton2.setName("jRadioButton2");
			jRadioButton2.setBackground(Color.white);
			jRadioButton2.setActionCommand(Acciones.INIT_PUB);
			jRadioButton2.setText("Servicio de publicacin");
		}
		return jRadioButton2;
	}

	private JRadioButton getJRadioButton3() {
		if (jRadioButton3 == null) {
			jRadioButton3 = new JRadioButton();
			jRadioButton3.setText("Servicio de consulta");
			jRadioButton3.setActionCommand(Acciones.INIT_QUERY);
			jRadioButton3.setBackground(Color.white);
		}
		return jRadioButton3;
	}

	private JRadioButton getJRadioButton4() {
		if (jRadioButton4 == null) {
			jRadioButton4 = new JRadioButton();
			jRadioButton4.setText("Utilidades CODICE");
			jRadioButton4.setActionCommand(Acciones.INIT_UTILITY);
			jRadioButton4.setBackground(Color.white);
		}
		return jRadioButton4;
	} 
	
	private JRadioButton getJRadioButton5() {
		if (jRadioButton5 == null) {
			jRadioButton5 = new JRadioButton();
			jRadioButton5.setText("Anular anuncios y documentos");
			jRadioButton5.setActionCommand(Acciones.INIT_ANUL);
			jRadioButton5.setBackground(Color.white);
		}
		return jRadioButton5;
	} 
 
	@Override
	public void actionPerformed(ActionEvent e) {
		
		try{
		 
			if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)&&jRadioButton1.isSelected()) {
				if (gestorVentanas[0] == null) {
					this.setVisible(false);				 
					gestorVentanas[0] = new ConfiguracionInicial(this,true);
					
				} else {
					this.setVisible(false);
					gestorVentanas[0].setVisible(true);
				}
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)&&jRadioButton2.isSelected()) {
				if (gestorVentanas[1] == null) {
					this.setVisible(false);				
					gestorVentanas[1] = new ServicioPublicacionForm(this);
					
				} else {
					this.setVisible(false);
					gestorVentanas[1].setVisible(true);
				}
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)&&jRadioButton3.isSelected()) {
				if (gestorVentanas[2] == null) {
					this.setVisible(false);
					gestorVentanas[2] = new ServicioConsultaForm(this);
				} else {
					this.setVisible(false);
					gestorVentanas[2].setVisible(true);
				}
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)&&jRadioButton4.isSelected()) {
				if (gestorVentanas[3] == null) {
					this.setVisible(false);
					gestorVentanas[3] = new ServicioUtilidadesForm(this);
				} else {
					this.setVisible(false);
					gestorVentanas[3].setVisible(true);
				} 
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)&&jRadioButton5.isSelected()) {
					if (gestorVentanas[4] == null) {
						this.setVisible(false);
						gestorVentanas[4] = new ServicioAnulacionesForm(this);
					} else {
						this.setVisible(false);
						gestorVentanas[4].setVisible(true);
					}
			}		
		} catch (ModelException e1) { 
			e1.printStackTrace();
		}
	}

}
