/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.dgpe.codice.common.caclib.DocumentReferenceType;
import org.dgpe.codice.maindoc.callfortenders.CallForTendersType;
import org.dgpe.codice.maindoc.contractawardnotice.ContractAwardNoticeType;
import org.dgpe.codice.maindoc.contractmodificationnotice.ContractModificationNoticeType;
import org.dgpe.codice.maindoc.contractnotice.ContractNoticeType;
import org.dgpe.codice.maindoc.pin.PriorInformationNoticeType;

import es.contrataciondelestado.b2b.publicacion.Publication;
import es.contrataciondelestado.b2b.publicacion.Publications;
import es.dgpe.place.client.beans.ConsultaBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.PublicacionesOficialesBean;
import es.dgpe.place.client.beans.UtilidadesBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.constants.TipoDocumentoDOUE;
import es.dgpe.place.client.exceptions.ClientException;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ClienteLlamadas;
import es.dgpe.place.client.utils.CommonUtilities;
import es.dgpe.place.client.utils.SessionDataManager;
import ext.place.codice.maindoc.cancelgeneraldocumentrequest.CancelGeneralContractDocumentRequestType;
import ext.place.codice.maindoc.cancelnoticerequest.CancelNoticeRequestType;


public class WebServiceCODICEForm extends ThemeJFrame {

	private static String pagina = Acciones.INIT_WEB_SERVICE;

	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;

	private JLabel jLabelCodiceGenerado = null;

	private JTextArea jTextAreaMensajeEnviado = null;

	JScrollPane AreaMensajeEnviado = null;

	private JButton jButtonEnviarDatos = null;

	JFrame gestorVentanasGenCodice[] = new JFrame[2];

	private String tipoDocumento = ""; // @jve:decl-index=0:

	private JScrollPane AreaMensajeRecibido = null;

	private JTextArea jTextAreaMensajeRespuesta = null;

	private JLabel jLabelMensajeRecibido = null;

	private JButton jButtonGuardarDatosEnviados = null;
	private JButton jButtonGuardarDatosRecibidos = null;
	
	final JFileChooser fc = new JFileChooser();
	
	private String mensajeEnviado = null, mensajeRecibido = null;

	public void setJButtonGuardarDatosEnviados(JButton buttonGuardarDatosEnviados) {
		jButtonGuardarDatosEnviados = buttonGuardarDatosEnviados;
	}

	
	public void setJButtonGuardarDatosRecibidos(JButton buttonGuardarDatosRecibidos) {
		jButtonGuardarDatosRecibidos = buttonGuardarDatosRecibidos;
	}

	public static String getPagina() {
		return pagina;
	}

	public static void setPagina(String pagina) {
		WebServiceCODICEForm.pagina = pagina;
	}

	public String getTipoDocumento() {
		return tipoDocumento;
	}

	public void setTipoDocumento(String tipoDocumento) {
		this.tipoDocumento = tipoDocumento;
	}

	/**
	 * @wbp.parser.constructor
	 */
	public WebServiceCODICEForm(JFrame ventanaPadre, String tipoDocumento)
			throws ModelException {
		super();
		initialize();
		
		gestorVentanasGenCodice[0] = ventanaPadre;
		setTipoDocumento(tipoDocumento);
		ClienteLlamadas.setTipoDocumento(tipoDocumento);

		setHasButtonPrev(true);

		if (isHasButtonPrev()) {
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		jButtonEnviarDatos.addActionListener(this);
		jButtonGuardarDatosEnviados.addActionListener(this);
		jButtonGuardarDatosRecibidos.addActionListener(this);
	}
	
	
	public WebServiceCODICEForm(JFrame ventanaPadre, String tipoDocumento, ClientException e)
	throws ModelException {
		super();
		initialize();

		gestorVentanasGenCodice[0] = ventanaPadre;
		setTipoDocumento(tipoDocumento);
		ClienteLlamadas.setTipoDocumento(tipoDocumento);

		setHasButtonPrev(true);

		if (isHasButtonPrev()) {
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		jButtonEnviarDatos.setEnabled(false);
		jButtonGuardarDatosEnviados.setEnabled(false);
		jButtonGuardarDatosRecibidos.setEnabled(false);
		
		if (e != null)
		{
			
			final Writer result = new StringWriter();
		    final PrintWriter printWriter = new PrintWriter(result);
		    e.printStackTrace(printWriter);
		    jTextAreaMensajeEnviado.setText("Se ha producido un error: Por favor revise la excepcin" + "\n" + result.toString());
		}
	}
	
	

	private void initialize() {
		this.setBackground(Color.white);
		getJPanelContenido();
		this.setTitle("Envo de datos");
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setVisible(true);

	}

	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelMensajeRecibido = new JLabel();
			jLabelMensajeRecibido.setBounds(new Rectangle(35, 334, 149, 16));
			jLabelMensajeRecibido.setText("Mensaje recibido: ");
			jLabelCodiceGenerado = new JLabel();
			jLabelCodiceGenerado.setText("Mensaje a enviar/enviado: ");
			jLabelCodiceGenerado.setSize(new Dimension(250, 20));
			jLabelCodiceGenerado.setLocation(new Point(33, 88));
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.add(jLabelCodiceGenerado, null);

			jPanelContenido.add(getJButtonEnviarDatos(), null);
			jPanelContenido.add(getJButtonGuardarDatosRecibidos(), null);
			jPanelContenido.add(getJButtonGuardarDatosEnviados(), null);
			
			AreaMensajeEnviado = new JScrollPane(getJTextAreaCODICE());
			AreaMensajeEnviado
					.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			AreaMensajeEnviado.setSize(new Dimension(this.getWidth()-100, 164));
			AreaMensajeEnviado.setPreferredSize(new Dimension(this.getWidth()-100, 300));
			AreaMensajeEnviado.setLocation(new Point(34, 119));
			jPanelContenido.add(AreaMensajeEnviado, null);
			jPanelContenido.add(getAreaMensajeRecibido(), null);
			jPanelContenido.add(jLabelMensajeRecibido, null);

		}
		return jPanelContenido;
	}

	public JButton getJButtonGuardarDatosRecibidos() {
		if (jButtonGuardarDatosRecibidos == null) {
			jButtonGuardarDatosRecibidos = new JButton();
			jButtonGuardarDatosRecibidos.setLocation(new Point(super.getWidth()-250, super.getHeight()-100));
			jButtonGuardarDatosRecibidos.setText("Guardar mensaje recibido...");
			jButtonGuardarDatosRecibidos.setSize(new Dimension(200, 30));
			jButtonGuardarDatosRecibidos.setActionCommand(Acciones.SAVE_RESPONSE);
		}
		return jButtonGuardarDatosRecibidos;
		
	}
	
	public JButton getJButtonGuardarDatosEnviados() {
		if (jButtonGuardarDatosEnviados == null) {
			jButtonGuardarDatosEnviados = new JButton();
			jButtonGuardarDatosEnviados.setLocation(new Point(super.getWidth()-250*2, super.getHeight()-100));
			jButtonGuardarDatosEnviados.setText("Guardar mensaje enviado...");
			jButtonGuardarDatosEnviados.setSize(new Dimension(200, 30));
			jButtonGuardarDatosEnviados.setActionCommand(Acciones.SAVE_REQUEST);
		}
		return jButtonGuardarDatosEnviados;
	}
	
	public JTextArea getJTextAreaCODICE() {
		if (jTextAreaMensajeEnviado == null) {
			jTextAreaMensajeEnviado = new JTextArea();
			jTextAreaMensajeEnviado.setLocation(new Point(60, 90));
			jTextAreaMensajeEnviado
					.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
			jTextAreaMensajeEnviado.setColumns(10);
			jTextAreaMensajeEnviado.setName("jTextAreaMensajeEnviado");
			jTextAreaMensajeEnviado.setText("");
			jTextAreaMensajeEnviado.setBorder(BorderFactory.createLineBorder(
					Color.black, 1));
			jTextAreaMensajeEnviado.setSize(new Dimension(this.getWidth()-100, 300));
			jTextAreaMensajeEnviado.setEditable(false);
			jTextAreaMensajeEnviado.setAutoscrolls(true);
			jTextAreaMensajeEnviado.setLineWrap(true);
			jTextAreaMensajeEnviado.setWrapStyleWord(true);
			jTextAreaMensajeEnviado.setLineWrap(false);
			jTextAreaMensajeEnviado.setWrapStyleWord(false);
			jTextAreaMensajeEnviado.setRows(20);

		}
		return jTextAreaMensajeEnviado;
	}

	private JButton getJButtonEnviarDatos() {
		if (jButtonEnviarDatos == null) {
			jButtonEnviarDatos = new JButton();
			jButtonEnviarDatos.setLocation(new Point(292, 306));
			jButtonEnviarDatos.setText("Enviar datos");
			jButtonEnviarDatos.setSize(new Dimension(200, 25));
			jButtonEnviarDatos.setActionCommand(Acciones.INIT_COMM);
		}
		return jButtonEnviarDatos;
	}

	/**
	 * This method initializes jTextAreaMensajeRespuesta
	 * 
	 * @return javax.swing.JTextArea
	 */
	public JTextArea getJTextAreaMensajeRespuesta() {
		if (jTextAreaMensajeRespuesta == null) {
			jTextAreaMensajeRespuesta = new JTextArea();
			jTextAreaMensajeRespuesta.setLocation(new Point(60, 90));
			jTextAreaMensajeRespuesta
					.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
			jTextAreaMensajeRespuesta.setName("jTextAreaCODICE");
			jTextAreaMensajeRespuesta.setAutoscrolls(true);
			jTextAreaMensajeRespuesta.setBorder(BorderFactory.createLineBorder(
					Color.black, 1));
			jTextAreaMensajeRespuesta.setText("");
			jTextAreaMensajeRespuesta.setEditable(false);
			jTextAreaMensajeRespuesta.setColumns(10);
			jTextAreaMensajeRespuesta.setRows(20);
			jTextAreaMensajeRespuesta.setLineWrap(true);
			jTextAreaMensajeRespuesta.setWrapStyleWord(true);
			jTextAreaMensajeRespuesta.setWrapStyleWord(false);
			jTextAreaMensajeRespuesta.setLineWrap(false);
			jTextAreaMensajeRespuesta.setSize(new Dimension(700, 300));
		}
		return jTextAreaMensajeRespuesta;
	}

	/**
	 * This method initializes AreaMensajeRecibido
	 * 
	 * @return javax.swing.JScrollPane
	 */
	private JScrollPane getAreaMensajeRecibido() {
		if (AreaMensajeRecibido == null) {
			AreaMensajeRecibido = new JScrollPane(
					getJTextAreaMensajeRespuesta());
			AreaMensajeRecibido
					.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			AreaMensajeRecibido.setLocation(new Point(34, 357));
			AreaMensajeRecibido.setSize(new Dimension(this.getWidth()-100, 164));
			AreaMensajeRecibido.setPreferredSize(new Dimension(this.getWidth()-100, 300));
		}
		return AreaMensajeRecibido;
	}

	public void actionPerformed(ActionEvent e) {
		

		if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_COMM)) {
	
			realizarLlamadaWebService(ClienteLlamadas.getTipoDocumento());
			
            StringWriter stringWriterEnviado = new StringWriter();
            StringWriter stringWriterRecibido = new StringWriter();
            StreamResult xmlOutEnviado = new StreamResult(stringWriterEnviado);
            StreamResult xmlOutRecibido = new StreamResult(stringWriterRecibido);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
             
            Transformer transformer;
			try {
				transformer = transformerFactory.newTransformer();
				transformer.setOutputProperty(OutputKeys.METHOD, "xml");
				transformer.setOutputProperty(OutputKeys.INDENT, "yes");
				transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
				transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount","4");
								
	            transformer.transform(new DOMSource(ClienteLlamadas.getMensajeEnviado().getSOAPPart()), xmlOutEnviado);           
	            transformer.transform(new DOMSource(ClienteLlamadas.getMensajeRecibido().getSOAPPart()), xmlOutRecibido);
	            
			} catch (TransformerConfigurationException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}catch (TransformerException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
            
            

			jTextAreaMensajeEnviado.setText(xmlOutEnviado.getWriter().toString());
			mensajeEnviado = new String(xmlOutEnviado.getWriter().toString());
			jTextAreaMensajeRespuesta.setText(xmlOutRecibido.getWriter().toString());
			mensajeRecibido = new String(xmlOutRecibido.getWriter().toString());
			
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.SAVE_REQUEST)){
			
			int returnVal = fc.showSaveDialog(jButtonGuardarDatosEnviados);
			 if (returnVal == JFileChooser.APPROVE_OPTION) {
				 File file = fc.getSelectedFile();
				 try{
				 Writer writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file), "UTF-8"));
				writer.write(mensajeEnviado);  //Mensaje enviado
				 writer.close();
				 }catch (Exception e1){
					 e1.printStackTrace();
				 }

			 }
			 
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.SAVE_RESPONSE)){
			
			int returnVal = fc.showSaveDialog(jButtonGuardarDatosEnviados);
			 if (returnVal == JFileChooser.APPROVE_OPTION) {
				 File file = fc.getSelectedFile();
				 try{
				 Writer writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file), "UTF-8"));
				 writer.write(mensajeRecibido);  //Mensaje recibido
				 writer.close();
				 }catch (Exception e1){
					 e1.printStackTrace();
				 }

			 }
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			gestorVentanasGenCodice[0].setVisible(true);
			this.setVisible(false);
		}

	}

	public void realizarLlamadaWebService(String tipoDocumento) {
		int tipoDoc = TipoDocumento.obtenerTipoDocumento(tipoDocumento);

		Publications pubs=obtenerPublicacionesOficiales(SessionDataManager
				.getInstance().getExpediente().getDiarios());
		switch (tipoDoc) {
		case 1: // Anuncio Previo
			try {			
				ClienteLlamadas client = new ClienteLlamadas();
				client.llamarPIN((PriorInformationNoticeType) client
						.getDocSerializado(), pubs);
			} catch (Exception e) {
				e.printStackTrace();
			}
			break;
		case 2: // Anuncio de Licitacin
			try {
				ClienteLlamadas client = new ClienteLlamadas();
				client
						.llamarCN((ContractNoticeType) client
								.getDocSerializado(), pubs);
			} catch (Exception e) {
				e.printStackTrace();
			}
			break;
		case 3: // Pliego
			try {
				ClienteLlamadas client = new ClienteLlamadas();
				client
						.llamarCD((CallForTendersType) client
								.getDocSerializado());
			} catch (Exception e) {
				e.printStackTrace();
			}
			break;
		case 4: // Anuncio de Adjudicacin
			try {
				//Publications pubs=new Publications();
				ClienteLlamadas client = new ClienteLlamadas();
				client.llamarCAN((ContractAwardNoticeType) client
						.getDocSerializado(), pubs);
			} catch (Exception e) {
				e.printStackTrace();
			}
			break;
		case 5: // Documentos Generales
			try {
				ExpedienteBean exp = SessionDataManager.getInstance().getExpediente();
				ClienteLlamadas client = new ClienteLlamadas();
				
				client.llamarDOCGEN(String.valueOf(System.currentTimeMillis()), exp
						.getNumExpediente(), exp.getBuyerProfileId(),
						(DocumentReferenceType) client.getDocSerializado());
			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		case 6: // Consulta Estado Expediente
			try {
				ConsultaBean consultaExp = (ConsultaBean) SessionDataManager
						.getInstance().getDatosConsulta();
				ClienteLlamadas client = new ClienteLlamadas();
				client.llamarConsultaExp(consultaExp.getExpedientNumber(),
						consultaExp.getBuyerProfileId());
			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		case 7: // Consulta datos rgano Contratacin
			try {
				ConsultaBean consultaExp = (ConsultaBean) SessionDataManager
						.getInstance().getDatosConsulta();
				ClienteLlamadas client = new ClienteLlamadas();
				client.llamarConsultaBuyerProfile(consultaExp
						.getBuyerProfileId());

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		case 8: // Validacin
			try {
				UtilidadesBean utilidades = (UtilidadesBean) SessionDataManager
						.getInstance().getDatosUtilidades();
				ClienteLlamadas client = new ClienteLlamadas();
				client.llamarUtilidadValidacion(TipoDocumento
						.obtenerTipoDocumento(utilidades.getTipoDoc()));

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		case 9: // Previsualizacin
			try {
				UtilidadesBean utilidades = (UtilidadesBean) SessionDataManager
						.getInstance().getDatosUtilidades();
				ClienteLlamadas client = new ClienteLlamadas();
				client.llamarUtilidadPrevisualizacion(TipoDocumento
						.obtenerTipoDocumento(utilidades.getTipoDoc()));

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;


		case 10: // Anulacin de anuncios
			try {
				ClienteLlamadas client = new ClienteLlamadas();
				client.llamarAnulacionAnuncio((CancelNoticeRequestType) 
						client.getDocSerializado());


			} catch (Exception e) {
				e.printStackTrace();
			}
			break;


		case 11: // Anulacin de documentos
			try {

				ClienteLlamadas client = new ClienteLlamadas();
				client.llamarAnulacionDocumento((CancelGeneralContractDocumentRequestType) 
						client.getDocSerializado());

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;


		case 12: // Anuncio de formalizacion
			try {
				ClienteLlamadas client = new ClienteLlamadas();
				client.llamarCAN((ContractAwardNoticeType) 
						client.getDocSerializado(), pubs);

			} catch (Exception e) {
				e.printStackTrace();
			}
			break;

		case 13: // Anuncio de renuncia, desierto o desistimiento
			try {
				ClienteLlamadas client = new ClienteLlamadas();
				client.llamarCAN((ContractAwardNoticeType) 
						client.getDocSerializado(), pubs);

			}
			catch (Exception e) {
				e.printStackTrace();
			}
			break;
		case 14: //Contrato menor
			try {
				//Publications pubs=new Publications();
				ClienteLlamadas client = new ClienteLlamadas();
				client.llamarCAN((ContractAwardNoticeType) client.getDocSerializado(), pubs);
			} catch (Exception e) {
				e.printStackTrace();
			}
			break;
		case 15: //Modifiacin de contrato
			try {

				ClienteLlamadas client = new ClienteLlamadas();
				client.llamarModifiacionAnuncio((ContractModificationNoticeType) client.getDocSerializado(), pubs);
			} catch (Exception e) {
				e.printStackTrace();
			}
			break;
			
	}
	}

	private Publications obtenerPublicacionesOficiales(PublicacionesOficialesBean diarios){
		Publications pubs = new Publications();
		Publication BOE=new Publication();
		Publication DOUE=new Publication();
		Publication Otros=new Publication();
		
		BOE.setPublishAgency("BOE");
		Otros.setPublishAgency("Others");
		 
			
		
		if(diarios!=null){
			//BOE
			if (diarios.isEnviarBOE()){				
			    BOE.setPublish(false);			
				pubs.getPublication().add(BOE);
			}else if (diarios.isYaPublicadoBOE()){
				BOE.setPublish(true);
				BOE.setPublishDate(CommonUtilities.datetoXMLGregorianCalendar(diarios.getFechaPubBOE()));				
				pubs.getPublication().add(BOE);
			}
			
			//DOUE
			if (diarios.isEnviarDOUE()){				
				DOUE.setPublish(false);
				if (diarios.getTipoAnuncioDOUE()==TipoDocumentoDOUE.ATPV)
					DOUE.setPublishAgency("DOUE-ATPV");
				else DOUE.setPublishAgency("DOUE");
				
				pubs.getPublication().add(DOUE);
			}else if (diarios.isYaEnviadoDOUE()){
				DOUE.setPublish(true);
				DOUE.setPublishAgency("DOUE");
				DOUE.setPublishDate(CommonUtilities.datetoXMLGregorianCalendar(diarios.getFechaPubDOUE()));
				DOUE.setSendDate(CommonUtilities.datetoXMLGregorianCalendar(diarios.getFechaEnvioDOUE()));
				pubs.getPublication().add(DOUE);
			}
			
			//Otros Diarios
			if (diarios.getNombreOtrosDiarios()!=null && !diarios.getNombreOtrosDiarios().equalsIgnoreCase("")&&diarios.getFechaPubOtrosDiarios()!=null){
				Otros.setPublish(true);
				Otros.setPublishAgency(diarios.getNombreOtrosDiarios());
				Otros.setPublishDate(CommonUtilities.datetoXMLGregorianCalendar(diarios.getFechaPubOtrosDiarios()));
				pubs.getPublication().add(Otros);
			}
		}
		
		return pubs;
	}

}
