/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.anulaciones.service;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import es.dgpe.place.client.beans.AnularDocumentoBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.windows.GeneracionCODICEForm;
import es.dgpe.place.client.windows.WebServiceCODICEForm;

public class CancelDocumentForm extends ThemeJFrame {

	private static String pagina=Acciones.INIT_CANCEL_DOCUMENT;
	
	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;

	private AnularDocumentoBean anularDocumento=null;
	
	JFrame gestorVentanasPub[] = new JFrame[2];

	private JLabel jLabelTitulo = null;

	private JLabel jLabelIdBP = null;

	private JTextField jTextFieldIdBuyerProfile = null;
	private JTextField textFieldIDRef;
	private JTextField textFieldUUIDRef;
	private JTextField textFieldContractFolderId;
	
	
	public static String getPagina() {
		return pagina;
	}

	public static void setPagina(String pagina) {
		CancelDocumentForm.pagina = pagina;
	}

	public AnularDocumentoBean getAnularDocumento() {
		if (anularDocumento==null){
			anularDocumento=new AnularDocumentoBean();			
		}
		
		anularDocumento.setIDRef(textFieldIDRef.getText());
		anularDocumento.setUUIDRef(textFieldUUIDRef.getText());
		anularDocumento.setNumExpediente(textFieldContractFolderId.getText());
		anularDocumento.setBuyerProfileId(jTextFieldIdBuyerProfile.getText());
		SessionDataManager.getInstance().setAnularDocumento(anularDocumento);
		return anularDocumento;
	}

	public void setAnularDocumento(AnularDocumentoBean anularDocumento) {
		this.anularDocumento = anularDocumento;
	}
	
	public CancelDocumentForm(JFrame ventanaPadre) throws ModelException {
		super();
		initialize();
		
		
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		JLabel lblIdDelDocumento = new JLabel();
		lblIdDelDocumento.setText("ID del documento a anular");
		lblIdDelDocumento.setSize(new Dimension(250, 18));
		lblIdDelDocumento.setLocation(new Point(162, 297));
		lblIdDelDocumento.setBounds(164, 345, 250, 18);
		getPanel().add(lblIdDelDocumento);
		
		JLabel lblUuidDelDocumento = new JLabel();
		lblUuidDelDocumento.setText("UUID del documento a anular");
		lblUuidDelDocumento.setSize(new Dimension(250, 18));
		lblUuidDelDocumento.setLocation(new Point(162, 297));
		lblUuidDelDocumento.setBounds(164, 374, 250, 18);
		getPanel().add(lblUuidDelDocumento);
		
		textFieldIDRef = new JTextField();
		textFieldIDRef.setColumns(10);
		textFieldIDRef.setBounds(424, 344, 175, 20);
		getPanel().add(textFieldIDRef);
		
		textFieldUUIDRef = new JTextField();
		textFieldUUIDRef.setColumns(10);
		textFieldUUIDRef.setBounds(424, 373, 175, 20);
		getPanel().add(textFieldUUIDRef);
		
		JLabel label_2 = new JLabel();
		label_2.setText("Expediente:");
		label_2.setSize(new Dimension(250, 18));
		label_2.setLocation(new Point(58, 108));
		label_2.setBounds(164, 316, 250, 18);
		getPanel().add(label_2);
		
		textFieldContractFolderId = new JTextField();
		textFieldContractFolderId.setSize(new Dimension(210, 18));
		textFieldContractFolderId.setLocation(new Point(329, 108));
		textFieldContractFolderId.setBounds(424, 315, 210, 18);
		getPanel().add(textFieldContractFolderId);
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		gestorVentanasPub[0] = ventanaPadre;//Ventana principal
		gestorVentanasPub[1] = null;//INIT_PUB 
 
	}

	private JLabel getTitulo(){
		if (jLabelTitulo==null){
		jLabelTitulo = new JLabel();
		jLabelTitulo.setText("Anular documento publicado");
 
		jLabelTitulo.setBounds(new Rectangle(100, 165, this.getWidth(), 50));
		jLabelTitulo.setFont(new Font("Dialog", Font.BOLD, 18));
		 
		}
		return jLabelTitulo;
	}
	
	private void initialize() {
	
		getJPanelContenido();
		this.setTitle("Servicio de anulaciones - Anular documento publicado");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelIdBP = new JLabel();
			jLabelIdBP.setText("Identificador del O. de Contratacin:");
			jLabelIdBP.setSize(new Dimension(250, 18));
			jLabelIdBP.setLocation(new Point(162, 267));
		 
			
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white); 
			jPanelContenido.add(getTitulo(), null);
			jPanelContenido.add(jLabelIdBP, null);
			jPanelContenido.add(getJTextFieldIdBuyerProfile(), null);
			
			String idPlataforma=SessionDataManager.getInstance().getOrganoContratacion().getIdPlataforma();
			jTextFieldIdBuyerProfile.setText(idPlataforma);
			jTextFieldIdBuyerProfile.setEditable(false);
		}
		return jPanelContenido;
	}

 
	


	/**
	 * This method initializes jTextFieldIdBuyerProfile	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldIdBuyerProfile() {
		if (jTextFieldIdBuyerProfile == null) {
			jTextFieldIdBuyerProfile = new JTextField();
			jTextFieldIdBuyerProfile.setSize(new Dimension(175, 18));
			jTextFieldIdBuyerProfile.setLocation(new Point(420, 267));
		}
		return jTextFieldIdBuyerProfile;
	}

	public void actionPerformed(ActionEvent e) {
try{
		getAnularDocumento();
		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)){
			this.setVisible(false);
			gestorVentanasPub[0].setVisible(true);
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {
				getAnularDocumento();

				this.setVisible(false);
				gestorVentanasPub[1] = new GeneracionCODICEForm(this,TipoDocumento.CANCEL_DOCUMENT);

			}
			} catch (ModelException e1){
	e1.printStackTrace();
}	
	}
}
