/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.anulaciones.service;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import es.dgpe.place.client.beans.AnularAnuncioBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.windows.GeneracionCODICEForm;
import es.dgpe.place.client.windows.WebServiceCODICEForm;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;
import java.awt.ComponentOrientation;
import java.io.File;

import javax.swing.JComboBox;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.UIManager;

public class CancelNoticeForm extends ThemeJFrame{

	private static String pagina=Acciones.INIT_CANCEL_NOTICE;
	
	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;

 
	
	JFrame gestorVentanasPub[] = new JFrame[2];

	private JLabel jLabelTitulo = null;

	private JLabel jLabelNumExp = null;

	private JLabel jLabelIdBP = null;

	private AnularAnuncioBean anularAnuncio=null;
	
	private JTextField jTextFieldIdBuyerProfile = null;
	private JTextField textFieldIDRef=null;
	private JTextField textFieldUUIDRef=null;
	private JComboBox comboBoxCancellationReasonCode = null;
	private JTextArea textAreaCancellationDescription = null;
	
	private JButton buttonSelCancellationDocumentReference = null; 
	private JTextField textFieldCancellationDocumentReferencePath;
	final JFileChooser fc = new JFileChooser();
	
	private JCheckBox chckbxEnviarDOUE=null;
	private JCheckBox chckbxEnviarBOE=null;
	JTextArea textAreaAnulacionBOE=null;
	
	
	private JLabel getTitulo(){
		if (jLabelTitulo==null){
		jLabelTitulo = new JLabel();
		jLabelTitulo.setText("Anular anuncio");
 
		jLabelTitulo.setBounds(new Rectangle(104, 112, 929, 50));
		jLabelTitulo.setFont(new Font("Dialog", Font.BOLD, 18));
		 
		}
		return jLabelTitulo;
	}
	
	
    public AnularAnuncioBean getAnularAnuncio() {
		if (anularAnuncio==null){
			anularAnuncio=new AnularAnuncioBean();			
		}
		anularAnuncio.setBuyerProfileId(jTextFieldIdBuyerProfile.getText());
		anularAnuncio.setIDRef(textFieldIDRef.getText());
		anularAnuncio.setUUIDRef(textFieldUUIDRef.getText());
		anularAnuncio.setCancellationReasonCodeId(comboBoxCancellationReasonCode.getSelectedIndex());
		anularAnuncio.setCancellationReasonCode((String) comboBoxCancellationReasonCode.getSelectedItem());
		anularAnuncio.setCancellationDescription(textAreaCancellationDescription.getText());
		anularAnuncio.setCancellationDocumentReferencePath(textFieldCancellationDocumentReferencePath.getText());
		anularAnuncio.setEnviarDOUE(chckbxEnviarDOUE.isSelected());
		anularAnuncio.setEnviarBOE(chckbxEnviarBOE.isSelected());
		anularAnuncio.setTextoAnulacionBOE(textAreaAnulacionBOE.getText());
		
		SessionDataManager.getInstance().setAnularAnuncio(anularAnuncio);
		return anularAnuncio;
	}

	public void setAnularAnuncio(AnularAnuncioBean anularAnuncio) {
		this.anularAnuncio = anularAnuncio;
	}

	public static String getPagina() {
		return pagina;
	}

	public static void setPagina(String pagina) {
		CancelNoticeForm.pagina = pagina;
	}

	
	public CancelNoticeForm(JFrame ventanaPadre) throws ModelException {
		super();
		initialize();
		ComboBoxUtils.loadComboBoxFromConstant(comboBoxCancellationReasonCode, ConstantsGC.CANCELLATION_REASON_CODE);
		
		gestorVentanasPub[0] = ventanaPadre;//Ventana principal
		gestorVentanasPub[1] = null;//INIT_PUB 
		 
	 
	}

	private void initialize() {
		 
		this.setContentPane(getJContentPane());
		this.setTitle("Servicio de Anulaciones - Anular Anuncio");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		 
		
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		getSelButtonCancellationDocumentReference().addActionListener(this);
	
		
	}

	private JPanel getJContentPane() {
		if (jPanelContenido == null) {
			jLabelIdBP = new JLabel();
			jLabelIdBP.setText("Identificador del O. de Contratacin:");
			jLabelIdBP.setSize(new Dimension(250, 18));
			jLabelIdBP.setLocation(new Point(166, 231));
		 
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			 
			jPanelContenido.add(getTitulo(), null);
			jPanelContenido.add(jLabelIdBP, null);
			jPanelContenido.add(getJTextFieldIdBuyerProfile(), null);
			
			String idPlataforma=SessionDataManager.getInstance().getOrganoContratacion().getIdPlataforma();
			jTextFieldIdBuyerProfile.setText(idPlataforma);
			jTextFieldIdBuyerProfile.setEditable(false);
			
			JLabel lblIdDelAnuncio = new JLabel();
			lblIdDelAnuncio.setText("ID del anuncio a anular");
			lblIdDelAnuncio.setSize(new Dimension(250, 18));
			lblIdDelAnuncio.setLocation(new Point(162, 297));
			lblIdDelAnuncio.setBounds(166, 173, 250, 18);
			jPanelContenido.add(lblIdDelAnuncio);
			
			JLabel lblUuidDelAnuncio = new JLabel();
			lblUuidDelAnuncio.setText("UUID del anuncio a anular");
			lblUuidDelAnuncio.setSize(new Dimension(250, 18));
			lblUuidDelAnuncio.setLocation(new Point(162, 297));
			lblUuidDelAnuncio.setBounds(166, 202, 250, 18);
			jPanelContenido.add(lblUuidDelAnuncio);
			
			textFieldIDRef= new JTextField();
			textFieldIDRef.setBounds(447, 173, 175, 20);
			jPanelContenido.add(textFieldIDRef);
			textFieldIDRef.setColumns(10);
			
			textFieldUUIDRef = new JTextField();
			textFieldUUIDRef.setColumns(10);
			textFieldUUIDRef.setBounds(447, 201, 175, 20);
			jPanelContenido.add(textFieldUUIDRef);
			
			JLabel lblMotivoDeLa = new JLabel();
			lblMotivoDeLa.setText("Motivo de la anulaci\u00F3n");
			lblMotivoDeLa.setSize(new Dimension(250, 18));
			lblMotivoDeLa.setLocation(new Point(162, 284));
			lblMotivoDeLa.setBounds(166, 273, 250, 18);
			jPanelContenido.add(lblMotivoDeLa);
			
			JLabel lblTextoDeLa = new JLabel();
			lblTextoDeLa.setText("Texto de la anulaci\u00F3n");
			lblTextoDeLa.setSize(new Dimension(250, 18));
			lblTextoDeLa.setLocation(new Point(162, 284));
			lblTextoDeLa.setBounds(166, 315, 250, 18);
			jPanelContenido.add(lblTextoDeLa);
			
			JLabel lblAdjuntarDocumentoDe = new JLabel();
			lblAdjuntarDocumentoDe.setText("Adjuntar documento de anulaci\u00F3n");
			lblAdjuntarDocumentoDe.setSize(new Dimension(250, 18));
			lblAdjuntarDocumentoDe.setLocation(new Point(162, 284));
			lblAdjuntarDocumentoDe.setBounds(166, 450, 250, 18);
			jPanelContenido.add(lblAdjuntarDocumentoDe);
			
			textAreaCancellationDescription = new JTextArea();
			textAreaCancellationDescription.setWrapStyleWord(true);
			textAreaCancellationDescription.setRows(20);
			textAreaCancellationDescription.setName("TextAreaCancellationDescription");
			textAreaCancellationDescription.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
			textAreaCancellationDescription.setColumns(20);
			textAreaCancellationDescription.setBackground(UIManager.getColor("TextArea.background"));
			textAreaCancellationDescription.setBounds(368, 312, 493, 113);
			textAreaCancellationDescription.setBorder(BorderFactory.createLineBorder(Color.BLACK));
			
			
			jPanelContenido.add(textAreaCancellationDescription);
			
			textFieldCancellationDocumentReferencePath = new JTextField();
			textFieldCancellationDocumentReferencePath.setBounds(447, 450, 210, 18);
			jPanelContenido.add(textFieldCancellationDocumentReferencePath);
			
			jPanelContenido.add(getSelButtonCancellationDocumentReference());
			
			comboBoxCancellationReasonCode = new JComboBox();
			comboBoxCancellationReasonCode.setBounds(447, 273, 210, 18);
			jPanelContenido.add(comboBoxCancellationReasonCode);
			
			chckbxEnviarDOUE = new JCheckBox("Solicitar anulaci\u00F3n del anuncio enviado al DOUE");
			chckbxEnviarDOUE.setBackground(Color.WHITE);
			chckbxEnviarDOUE.setBounds(166, 499, 315, 23);
			jPanelContenido.add(chckbxEnviarDOUE);
			
			
			jPanelContenido.add(getCheckBoxEnviarBOE());
			
			JLabel lblTextoDeLa_1 = new JLabel();
			lblTextoDeLa_1.setText("Texto de la anulaci\u00F3n en el BOE");
			lblTextoDeLa_1.setSize(new Dimension(250, 18));
			lblTextoDeLa_1.setLocation(new Point(162, 284));
			lblTextoDeLa_1.setBounds(205, 570, 250, 18);
			jPanelContenido.add(lblTextoDeLa_1);
			
			textAreaAnulacionBOE = new JTextArea();
			textAreaAnulacionBOE.setEditable(false);
			textAreaAnulacionBOE.setWrapStyleWord(true);
			textAreaAnulacionBOE.setRows(20);
			textAreaAnulacionBOE.setName("TextAreaCancellationDescription");
			textAreaAnulacionBOE.setLineWrap(false);
			textAreaAnulacionBOE.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
			textAreaAnulacionBOE.setColumns(20);
			textAreaAnulacionBOE.setBackground(new Color(245, 243, 242));
			textAreaAnulacionBOE.setBounds(403, 567, 458, 87);
			textAreaAnulacionBOE.setBorder(BorderFactory.createLineBorder(Color.BLACK));
			jPanelContenido.add(textAreaAnulacionBOE);
		}
		return jPanelContenido;
	}

	/**
	 * This method initializes jTextFieldIdBuyerProfile	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldIdBuyerProfile() {
		if (jTextFieldIdBuyerProfile == null) {
			jTextFieldIdBuyerProfile = new JTextField();
			jTextFieldIdBuyerProfile.setSize(new Dimension(175, 18));
			jTextFieldIdBuyerProfile.setLocation(new Point(447, 231));
		}
		return jTextFieldIdBuyerProfile;
	}
	
	public JButton getSelButtonCancellationDocumentReference() {
		if (buttonSelCancellationDocumentReference==null){
			buttonSelCancellationDocumentReference = new JButton();
			buttonSelCancellationDocumentReference.setText("Examinar...");
			buttonSelCancellationDocumentReference.setActionCommand(Acciones.LOAD_CANCEL_DOCREF);
			buttonSelCancellationDocumentReference.setBounds(664, 450, 98, 18);}

		return buttonSelCancellationDocumentReference;
	}
	
	private JCheckBox getCheckBoxEnviarBOE() {
		if (chckbxEnviarBOE==null){
			chckbxEnviarBOE = new JCheckBox("Solicitar anulaci\u00F3n del anuncio publicado en el BOE");
			chckbxEnviarBOE.setBackground(Color.WHITE);
			chckbxEnviarBOE.setBounds(166, 537, 315, 23);
			chckbxEnviarBOE.addItemListener(new ItemListener()
			{
				 public void itemStateChanged(ItemEvent e)
		            {
					 textAreaAnulacionBOE.setEditable(chckbxEnviarBOE.isSelected());
					 if (chckbxEnviarBOE.isEnabled()) textAreaAnulacionBOE.setBackground(new Color(255,255,255)); 
					 else textAreaAnulacionBOE.setBackground(new Color(245, 243, 242));
					
		            }
			}
					);}
		
			
		return chckbxEnviarBOE;
	}
		
	public void actionPerformed(ActionEvent e) {
		try{
			if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)){
				this.setVisible(false);
				gestorVentanasPub[0].setVisible(true);
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {
				getAnularAnuncio();

				this.setVisible(false);
				gestorVentanasPub[1] = new GeneracionCODICEForm(this,TipoDocumento.CANCEL_NOTICE);

			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.LOAD_CANCEL_DOCREF)) {
				SessionDataManager.getInstance().setAnularAnuncio(getAnularAnuncio());
				int returnVal = fc.showOpenDialog(buttonSelCancellationDocumentReference);
				if (returnVal == JFileChooser.APPROVE_OPTION) {
					File file = fc.getSelectedFile();
					textFieldCancellationDocumentReferencePath.setText(file.getAbsolutePath());
				} 

			}
		} catch (ModelException e1){
			e1.printStackTrace();
		}	
	}
	
	}
