/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.anulaciones.service;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ModelException;

public class ServicioAnulacionesForm extends ThemeJFrame {

	private static String pagina=Acciones.INIT_QUERY;
	
	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;

	private JLabel jLabelTitulo = null;
	
	private JPanel jPanelSeleccion = null;	

	private ButtonGroup selectorMenuServicioConsulta = new ButtonGroup();  //  @jve:decl-index=0:
	
	private JRadioButton jRadioButton1 = null;

	private JRadioButton jRadioButton2 = null; 
	
	JFrame gestorVentanasPub[] = new JFrame[3];

	
	public static String getPagina() {
		return pagina;
	}

	public static void setPagina(String pagina) {
		ServicioAnulacionesForm.pagina = pagina;
	}

	public ServicioAnulacionesForm(JFrame ventanaPadre) throws ModelException {
		super();
		initialize();
		

		
		gestorVentanasPub[0] = ventanaPadre;//Ventana principal
		gestorVentanasPub[1] = null;//INIT_CANCEL_NOTICE
		gestorVentanasPub[2] = null;//INIT_CANCEL_DOCUMENT 
		
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
	}

	private void initialize() {  
		getJPanelContenido();
		this.setTitle("Servicio de Anulacion de Anuncios y Documentos");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		
	}

	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.add(getLabelTitulo(), null); 
			jPanelContenido.add(getJPanelSeleccion(), null);
			
		}
		return jPanelContenido;
	}

	private JLabel getLabelTitulo() {
		if (jLabelTitulo == null) {
			jLabelTitulo = new JLabel();
			jLabelTitulo.setBounds(new Rectangle(100, 165, this.getWidth(), 50));
			jLabelTitulo.setFont(new Font("Dialog", Font.BOLD, 18));
			jLabelTitulo.setText("Servicio de Anulacion de Anuncios y Documentos");
		}
		return jLabelTitulo;
	}
	
	private JPanel getJPanelSeleccion() {
		if (jPanelSeleccion == null) {
			jPanelSeleccion = new JPanel();
			
			jPanelSeleccion.setLayout(new BoxLayout(jPanelSeleccion, BoxLayout.Y_AXIS));
			jPanelSeleccion.setBounds(new Rectangle(250, 225, 446, 119));
			jPanelSeleccion.setBackground(Color.WHITE);
			jPanelSeleccion.setAlignmentX(50.0F);
			
			jPanelSeleccion.add(getJRadioButton1(), null);
			jPanelSeleccion.add(getJRadioButton2(), null); 			
			
			selectorMenuServicioConsulta.add(getJRadioButton1());
			selectorMenuServicioConsulta.add(getJRadioButton2());
			
			
		}
		return jPanelSeleccion;
	}

	private JRadioButton getJRadioButton1() {
		if (jRadioButton1 == null) {
			jRadioButton1 = new JRadioButton();
			jRadioButton1.setText("Anular anuncio");
			jRadioButton1.setBackground(Color.white);
			jRadioButton1.setActionCommand(Acciones.INIT_CANCEL_NOTICE);
		}
		return jRadioButton1;
	}

	private JRadioButton getJRadioButton2() {
		if (jRadioButton2 == null) {
			jRadioButton2 = new JRadioButton();
			jRadioButton2.setText("Anular documento");
			jRadioButton2.setBackground(Color.white);
			jRadioButton1.setActionCommand(Acciones.INIT_CANCEL_DOCUMENT);
		}
		return jRadioButton2;
	} 
 
	
	public void actionPerformed(ActionEvent e) {

		try{
		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)){
			this.setVisible(false);
			gestorVentanasPub[0].setVisible(true);
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)&&jRadioButton1.isSelected()) {
			if (gestorVentanasPub[1] == null) {
				this.setVisible(false);
				gestorVentanasPub[1] = new CancelNoticeForm(this);
			} else {
				this.setVisible(false);
				gestorVentanasPub[1].setVisible(true);
			}
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)&&jRadioButton2.isSelected()) {
			if (gestorVentanasPub[2] == null) {
				this.setVisible(false);
				gestorVentanasPub[2] = new CancelDocumentForm(this);
			} else {
				this.setVisible(false);
				gestorVentanasPub[2].setVisible(true);
			}
		}  
		}catch (ModelException e1){
			e1.printStackTrace();
		}
		
	}

}
