/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.PublicacionesOficialesBean;
import es.dgpe.place.client.components.ComboListener;
import es.dgpe.place.client.components.ComboListenerCountry;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.constants.TipoDocumentoDOUE;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.windows.GeneracionCODICEForm;
import es.dgpe.place.client.windows.publication.service.commons.CondicionesEjecucionForm;
import es.dgpe.place.client.windows.publication.service.commons.CriteriosAdjudicacionForm;
import es.dgpe.place.client.windows.publication.service.commons.EventosAperturaForm;
import es.dgpe.place.client.windows.publication.service.commons.LicitadorForm;
import es.dgpe.place.client.windows.publication.service.commons.LotesForm;
import es.dgpe.place.client.windows.publication.service.commons.ProcedimientoForm;
import es.dgpe.place.client.windows.publication.service.commons.ReceptorRecurosForm;
import es.dgpe.place.client.windows.publication.service.commons.RequisitosParticipacionForm;

public class AnuncioAdjudicacionForm extends ThemeJFrame {


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;

	private JLabel jLabelExpediente = null;

	private JTextField jTextFieldExpediente = null;

	private JLabel jLabelTipoContrato = null;

	private JLabel jLabelSubTipoContrato = null;

	private JLabel jLabelObjetoContrato = null;

	private JLabel jLabelProcContratacion = null;

	private JLabel jLabelTipoTramitacin = null;

	private JLabel jLabelTramitacionGasto = null;

	private JLabel jLabelFechaPrevAdj = null;

	private JLabel jLabelSelCPV = null;

	private JLabel jLabelCodigoCPV = null;

	private JComboBox jComboBoxTipoContrato = null;

	private JComboBox jComboBoxSubtipoContrato = null;

	private JTextField jTextFieldObjetoContrato = null;

	private JComboBox jComboBoxCPV = null;
	
	private JComboBox jComboBoxPais = null;
	private JComboBox<String> jComboBoxNuts = null;

	private JLabel jLabelAnuncio = null;
	
	private JLabel jLabelImporteSin = null;

	private JLabel jLabelImporteCon = null;

	private JLabel jLabelClasificacion = null;

	private JLabel jLabelDescSolvencias = null;
	
	private JComboBox<String> jComboBoxDirectiva = null;

	private JTextField jTextFieldImporteSin = null;

	private JTextField jTextFieldImporteCon = null;

	private JButton jButtonLicitador = null;
	private JButton jButtonDuracionContrato = null;
	private JButton jButtonLotes;
	private JButton jButtonReceptorRecursos = null;
	private JButton jButtonProcedimiento = null;
	private JButton jButtonRequisitosParticipacion;
	
	final JFileChooser fc = new JFileChooser();
	private JLabel lblValorEstimadoDel;
	private JTextField jTextFieldValorEstimado;
	
	private JCheckBox jCheckBoxEnviarATPV=null;
	private JComboBox jComboBoxJustificacionATPV= null;
	private JTextArea jTextAreaJustificacionATPV=null;
	private JButton jButtonCriteriosAdjudicacion;
	
	JFrame gestorVentanasFormCD[] = new JFrame[10];
	
	ExpedienteBean expediente=new ExpedienteBean();  //  @jve:decl-index=0:
	private JPanel panel;

	

	public ExpedienteBean getExpediente() {
		
		if (expediente==null){
			expediente = new ExpedienteBean();
		}
		
		expediente.setDirectivaAplicacion((String) jComboBoxDirectiva.getSelectedItem()); 
		expediente.setIdDirectivaAplicacion(jComboBoxDirectiva.getSelectedIndex());
		
		expediente.setNumExpediente(jTextFieldExpediente.getText());

		expediente.setTipoContrato((String) jComboBoxTipoContrato.getSelectedItem());
		expediente.setIdTipoContrato(jComboBoxTipoContrato.getSelectedIndex());

		expediente.setSubtipoContrato((String) jComboBoxSubtipoContrato.getSelectedItem());
		expediente.setIdSubtipoContrato(jComboBoxSubtipoContrato.getSelectedIndex());

		expediente.setObjetoContrato(jTextFieldObjetoContrato.getText());
		expediente.setCpv((String) jComboBoxCPV.getSelectedItem());
		expediente.setIdCpv(jComboBoxCPV.getSelectedIndex());
		
		expediente.setPais((String) jComboBoxPais.getSelectedItem());
		expediente.setIdPais(jComboBoxPais.getSelectedIndex());
				
		String nutsSeleccionado = (String)jComboBoxNuts.getSelectedItem();
		expediente.setNuts(nutsSeleccionado.substring(0, nutsSeleccionado.lastIndexOf("(")-1));
		expediente.setIdNuts(nutsSeleccionado.substring(nutsSeleccionado.lastIndexOf("(")+1, nutsSeleccionado.length()-1));

		expediente.setImporteSinImpuestos(jTextFieldImporteSin.getText());
		expediente.setImporteConImpuestos(jTextFieldImporteCon.getText());
		expediente.setValorEstimado(jTextFieldValorEstimado.getText());
		
		expediente.setEnviarATPV(jCheckBoxEnviarATPV.isSelected());
		
		PublicacionesOficialesBean publicacionesOficiales=null;

		if (expediente.getEnviarATPV()){
			expediente.setIdCodigoJustificacionATPV(jComboBoxJustificacionATPV.getSelectedIndex());
			expediente.setCodigoJustificacionATPV((String) jComboBoxJustificacionATPV.getSelectedItem());
			expediente.setTextoJustificacionATPV(jTextAreaJustificacionATPV.getText());
			publicacionesOficiales=new PublicacionesOficialesBean();
			publicacionesOficiales.setEnviarDOUE(true);
			publicacionesOficiales.setTipoAnuncioDOUE(TipoDocumentoDOUE.ATPV);
		}else
		{expediente.setIdCodigoJustificacionATPV(-1);
		expediente.setCodigoJustificacionATPV(null);
		expediente.setTextoJustificacionATPV(null);
		publicacionesOficiales=null;}
		
		expediente.setDiarios(publicacionesOficiales);
		
		SessionDataManager.getInstance().setExpediente(expediente);
		
		return expediente;
	}

	public void setAnuncioAdjudicacion(ExpedienteBean exp) { 
		
		this.expediente = exp;
	}

	public void cargarDatosComboBoxs() {
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTipoContrato, ConstantsGC.TENDERING_CONTRACT);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxCPV, ConstantsGC.CPV);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxPais, ConstantsGC.COUNTRY_CODE);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxJustificacionATPV, ConstantsGC.PROCESSJUSTIFICATIONREASONCODE);
		//Cargo el primer valor de Directiva como no sujeto a regulacion armonizada
		jComboBoxDirectiva.addItem(ConstantsGC.NO_SARA);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxDirectiva, ConstantsGC.DIRECTIVA);
	}

	public AnuncioAdjudicacionForm(JFrame ventanaPadre) throws ModelException {
		super();
		initialize();
		cargarDatosComboBoxs();
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null;
		jButtonDuracionContrato.addActionListener(this);
		jButtonLotes.addActionListener(this); 
		jButtonCriteriosAdjudicacion.addActionListener(this); 
		jButtonReceptorRecursos.addActionListener(this);	
		jButtonRequisitosParticipacion.addActionListener(this); 	
		jButtonProcedimiento.addActionListener(this);

		
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosExpediente();
		}
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosExpediente();
			}
		});
	}
	
	
	private void escribeDatosExpediente(){
		jComboBoxDirectiva.setSelectedIndex(expediente.getIdDirectivaAplicacion());
		jTextFieldExpediente.setText(expediente.getNumExpediente());
		jComboBoxTipoContrato.setSelectedIndex(expediente.getIdTipoContrato());
		jComboBoxSubtipoContrato.setSelectedIndex(expediente.getIdSubtipoContrato());
		jTextFieldObjetoContrato.setText(expediente.getObjetoContrato());
		jTextFieldValorEstimado.setText(expediente.getValorEstimado());
		jTextFieldImporteSin.setText(expediente.getImporteSinImpuestos());
		jTextFieldImporteCon.setText(expediente.getImporteConImpuestos());
		
		jComboBoxCPV.setSelectedIndex(expediente.getIdCpv());

		jComboBoxPais.setSelectedIndex(expediente.getIdPais());
		jComboBoxNuts.setSelectedItem(expediente.getNuts() + " (" + expediente.getIdNuts() + ")");
		
		jCheckBoxEnviarATPV.setSelected(expediente.getEnviarATPV());
		jComboBoxJustificacionATPV.setSelectedIndex(expediente.getIdCodigoJustificacionATPV());
		jTextAreaJustificacionATPV.setText(expediente.getTextoJustificacionATPV());
	}

	private void initialize() {
		 
		getJPanelContenido();
		
		this.setTitle("Servicio de Publicacin - Anuncio de Adjudicacin");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	 
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelAnuncio = new JLabel();
			jLabelAnuncio.setFont(new Font("Dialog", Font.BOLD, 18));
			jLabelAnuncio.setLocation(new Point(17, 77));
			jLabelAnuncio.setSize(new Dimension(250, 18));
			jLabelAnuncio.setText("Anuncio de Adjudicacin");
			jLabelObjetoContrato = new JLabel();
			jLabelObjetoContrato.setText("Objeto del contrato:");
			jLabelObjetoContrato.setLocation(new Point(63, 210));
			jLabelObjetoContrato.setSize(new Dimension(250, 18));
			jLabelSubTipoContrato = new JLabel();
			jLabelSubTipoContrato.setText("Subtipo de contrato:");
			jLabelSubTipoContrato.setSize(new Dimension(250, 18));
			jLabelSubTipoContrato.setLocation(new Point(63, 185));
			jLabelTipoContrato = new JLabel();
			jLabelTipoContrato.setText("Tipo de contrato:");
			jLabelTipoContrato.setLocation(new Point(63, 160));
			jLabelTipoContrato.setSize(new Dimension(250, 18));
			jLabelExpediente = new JLabel();
			jLabelExpediente.setText("Expediente:");
			jLabelExpediente.setLocation(new Point(62, 140));
			jLabelExpediente.setSize(new Dimension(250, 18));
			
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.add(jLabelExpediente, null); 
			jPanelContenido.add(getJTextFieldExpediente(), null);
			jPanelContenido.add(jLabelTipoContrato, null);
			jPanelContenido.add(getJComboBoxTipoContrato(), null);
			jPanelContenido.add(jLabelSubTipoContrato, null);
			jPanelContenido.add(jLabelObjetoContrato, null);
			jPanelContenido.add(getJComboBoxSubtipoContrato(), null);
			jPanelContenido.add(getJTextFieldObjetoContrato(), null);
			getPanel().add(getJButtonDuracionContrato());
			getPanel().add(getJButtonCriteriosAdjudicacion());
			getPanel().add(getJButtonProcedimiento());
			getPanel().add(getJButtonRequisitosParticipacion());
			getPanel().add(getJButtonLicitador());

			jPanelContenido.add(jLabelAnuncio, null);
			getPanel().add(getJButtonLotes());
			getPanel().add(getJButtonReceptorRecuros());
			getPanel().add(getJTextFieldImporteSin());
			getPanel().add(getJTextFieldImporteCon());
			getPanel().add(getLblValorEstimadoDel());
			getPanel().add(getJTextFieldValorEstimado());
			jButtonLicitador.addActionListener(this); 
			jLabelSelCPV = new JLabel();
			jLabelSelCPV.setBounds(57, 321, 250, 18);
			getPanel().add(jLabelSelCPV);
			jLabelSelCPV.setText("Seleccin del CPV");
			jLabelCodigoCPV = new JLabel();
			jLabelCodigoCPV.setBounds(87, 341, 220, 18);
			getPanel().add(jLabelCodigoCPV);
			jLabelCodigoCPV.setText("Cdigo CPV");
			getPanel().add(getJComboBoxCPV());
			jLabelImporteSin = new JLabel();
			jLabelImporteSin.setBounds(57, 271, 250, 18);
			getPanel().add(jLabelImporteSin);
			jLabelImporteSin.setText("Importe Base (Sin impuestos)");
			jLabelImporteCon = new JLabel();
			jLabelImporteCon.setBounds(57, 296, 250, 18);
			getPanel().add(jLabelImporteCon);
			jLabelImporteCon.setText("Importe Base (Con impuestos)");
			getPanel().add(getPanel_1());
			
			jComboBoxPais = new JComboBox();
			jComboBoxPais.setBounds(186, 370, 204, 18);
			getPanel().add(jComboBoxPais);
			
			jComboBoxNuts = new JComboBox();
			jComboBoxNuts.setBounds(186, 399, 204, 18);
			getPanel().add(jComboBoxNuts);
			
			JLabel lblLugarDeEjecucin = new JLabel("Lugar de ejecuci\u00F3n");
			lblLugarDeEjecucin.setBounds(57, 370, 230, 14);
			getPanel().add(lblLugarDeEjecucin);
			
			jComboBoxTipoContrato.addItemListener(new ComboListener(jComboBoxTipoContrato,jComboBoxSubtipoContrato));
			jComboBoxPais.addItemListener(new ComboListenerCountry(jComboBoxPais,jComboBoxNuts));
			
			
			
			JLabel lblDirectivaDeAplicacin = new JLabel("Directiva de aplicaci\u00F3n");
			lblDirectivaDeAplicacin.setBounds(60, 115, 178, 14);
			getPanel().add(lblDirectivaDeAplicacin);
			
			jPanelContenido.add(getJComboBoxDirectiva(),null);
								
		}
		return jPanelContenido;
	}
	
	private JComboBox getJComboBoxDirectiva(){
		if (jComboBoxDirectiva==null){
		jComboBoxDirectiva = new JComboBox();
		jComboBoxDirectiva.setBounds(327, 115, 378, 20);
		}
		return jComboBoxDirectiva;		
	}

	private JCheckBox getJCheckBoxEnviarATPV(){
		if (jCheckBoxEnviarATPV == null){
			jCheckBoxEnviarATPV = new JCheckBox("Enviar Anuncio de Transparencia Previa Voluntaria a DOUE (ATPV)");
			jCheckBoxEnviarATPV.setBounds(6, 16, 431, 23);
			jCheckBoxEnviarATPV.setBackground(Color.WHITE);
			jCheckBoxEnviarATPV.addItemListener(new ItemListener()
			{
				 public void itemStateChanged(ItemEvent e)
		            {
					 jTextAreaJustificacionATPV.setEditable(jCheckBoxEnviarATPV.isSelected());
					 if (jCheckBoxEnviarATPV.isSelected()) jTextAreaJustificacionATPV.setBackground(new Color(255,255,255)); 
					 else jTextAreaJustificacionATPV.setBackground(new Color(245, 243, 242));
					
		            }
			}
					);
		}
		return jCheckBoxEnviarATPV;
	}
	
	private JButton getJButtonDuracionContrato() {
		if (jButtonDuracionContrato == null) {
			jButtonDuracionContrato = new JButton();
			jButtonDuracionContrato.setText("Condiciones de ejecuci\u00F3n");
			jButtonDuracionContrato.setActionCommand(Acciones.EDIT_DURACION);
			jButtonDuracionContrato.setBounds(645, 448, 187, 18);
					}
		return jButtonDuracionContrato;
	}
	private JTextArea getJTextAreaJustificacionATPV(){
		if (jTextAreaJustificacionATPV == null){
			jTextAreaJustificacionATPV=new JTextArea();
			jTextAreaJustificacionATPV.setBounds(276, 75, 493, 50);
			jTextAreaJustificacionATPV.setBackground(new Color(245, 243, 242));
			jTextAreaJustificacionATPV.setEditable(false);
			jTextAreaJustificacionATPV.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		}
		return jTextAreaJustificacionATPV;
	}
	
	private JComboBox getJComboBoxJustificacionATPV(){
		if (jComboBoxJustificacionATPV == null){
			jComboBoxJustificacionATPV=new JComboBox();
			jComboBoxJustificacionATPV.setBounds(276, 46, 493, 18);
			jComboBoxJustificacionATPV.setFont(new Font("Tahoma", Font.PLAIN, 9));
		}
		return jComboBoxJustificacionATPV;
	}
	
	private JTextField getJTextFieldExpediente() {
		if (jTextFieldExpediente == null) {
			jTextFieldExpediente = new JTextField();
			jTextFieldExpediente.setSize(new Dimension(210, 18));
			jTextFieldExpediente.setLocation(new Point(327, 140));
		}
		return jTextFieldExpediente;
	}

	private JComboBox getJComboBoxTipoContrato() {
		if (jComboBoxTipoContrato == null) {
			jComboBoxTipoContrato = new JComboBox();
			jComboBoxTipoContrato.setLocation(new Point(327, 160));
			jComboBoxTipoContrato.setSize(new Dimension(210, 18));
		}
		return jComboBoxTipoContrato;
	}

	private JComboBox getJComboBoxSubtipoContrato() {
		if (jComboBoxSubtipoContrato == null) {
			jComboBoxSubtipoContrato = new JComboBox();
			jComboBoxSubtipoContrato.setLocation(new Point(327, 185));
			jComboBoxSubtipoContrato.setSize(new Dimension(493, 18));
		}
		return jComboBoxSubtipoContrato;
	}

	private JTextField getJTextFieldObjetoContrato() {
		if (jTextFieldObjetoContrato == null) {
			jTextFieldObjetoContrato = new JTextField();
			jTextFieldObjetoContrato.setLocation(new Point(327, 210));
			jTextFieldObjetoContrato.setSize(new Dimension(493, 18));
		}
		return jTextFieldObjetoContrato;
	}

	private JComboBox getJComboBoxCPV() {
		if (jComboBoxCPV == null) {
			jComboBoxCPV = new JComboBox();
			jComboBoxCPV.setBounds(327, 341, 493, 18);
		}
		return jComboBoxCPV;
	}

	/**
	 * This method initializes jTextFieldImporteSin	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteSin() {
		if (jTextFieldImporteSin == null) {
			jTextFieldImporteSin = new JTextField();
			jTextFieldImporteSin.setBounds(327, 271, 210, 18);
		}
		return jTextFieldImporteSin;
	}

	/**
	 * This method initializes jTextFieldImporteCon	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteCon() {
		if (jTextFieldImporteCon == null) {
			jTextFieldImporteCon = new JTextField();
			jTextFieldImporteCon.setBounds(327, 296, 210, 18);
		}
		return jTextFieldImporteCon;
	}

	/**
	 * This method initializes jButtonLicitador	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonLicitador() {
		if (jButtonLicitador == null) {
			jButtonLicitador = new JButton();
			jButtonLicitador.setBounds(448, 448, 193, 18);
			jButtonLicitador.setText("Adjudicatario");
			jButtonLicitador.setActionCommand(Acciones.INIT_LIC);
		}
		return jButtonLicitador;
	}


	public void actionPerformed(ActionEvent e) {

		try{
			SessionDataManager.getInstance().setExpediente(getExpediente());
		
		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			gestorVentanasFormCD[0].setVisible(true);
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {
			
			if (gestorVentanasFormCD[1] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[1] = new GeneracionCODICEForm(this,TipoDocumento.ADJ); 
				gestorVentanasFormCD[1].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[1].setVisible(true);
			}
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_EVENT)) {
			if (gestorVentanasFormCD[2] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[2] = new EventosAperturaForm(this,TipoDocumento.ADJ); 
				gestorVentanasFormCD[2].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[2].setVisible(true);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_LIC)) {
			if (gestorVentanasFormCD[3] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[3] = new LicitadorForm(this,TipoDocumento.ADJ); 
				gestorVentanasFormCD[3].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[3].setVisible(true);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_DURACION)) {
			if (gestorVentanasFormCD[4] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[4] = new CondicionesEjecucionForm(this,TipoDocumento.ADJ);
				gestorVentanasFormCD[4].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[4].setVisible(true);
			}
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_LOTES)) {
			if (gestorVentanasFormCD[5] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[5] = new LotesForm(this,TipoDocumento.ADJ);
				gestorVentanasFormCD[5].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[5].setVisible(true);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_CRITERIOS_ADJUDICACION)) {
			if (gestorVentanasFormCD[6] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[6] = new CriteriosAdjudicacionForm(this,TipoDocumento.ADJ);
				gestorVentanasFormCD[6].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[6].setVisible(true);
			}
		}
			else if (e.getActionCommand().equalsIgnoreCase(Acciones.RECEPTOR_RECURSOS)) {
				if (gestorVentanasFormCD[7] == null) {
					this.setVisible(false);
					gestorVentanasFormCD[7] = new ReceptorRecurosForm(this, TipoDocumento.ADJ);
					gestorVentanasFormCD[7].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCD[7].setVisible(true);
				}
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_REQUISITOS)) {
				if (gestorVentanasFormCD[8] == null) {
					getExpediente();
					this.setVisible(false);
					gestorVentanasFormCD[8] = new RequisitosParticipacionForm(this,TipoDocumento.ADJ);
					gestorVentanasFormCD[8].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCD[8].setVisible(true);
				}
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_PROCEDIMIENTO)) {
				if (gestorVentanasFormCD[9] == null) {
					getExpediente();
					this.setVisible(false);
					gestorVentanasFormCD[9] = new ProcedimientoForm(this,TipoDocumento.ADJ);
					gestorVentanasFormCD[9].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCD[9].setVisible(true);
				}
			}
		}catch (ModelException e1){
			e1.printStackTrace();
		}

	}
	
	private JLabel getLblValorEstimadoDel() {
		if (lblValorEstimadoDel == null) {
			lblValorEstimadoDel = new JLabel("Valor estimado del contrato");
			lblValorEstimadoDel.setBounds(57, 246, 230, 14);
		}
		return lblValorEstimadoDel;
	}
	
	private JTextField getJTextFieldValorEstimado() {
		if (jTextFieldValorEstimado == null) {
			jTextFieldValorEstimado = new JTextField();
			jTextFieldValorEstimado.setBounds(327, 240, 210, 20);
			jTextFieldValorEstimado.setColumns(10);
		}
		return jTextFieldValorEstimado;
	}
	
	private JPanel getPanel_1() {
		if (panel == null) {
			panel = new JPanel();
			panel.setBorder(new TitledBorder(null, "Anuncio de Transparencia Previa Voluntaria", TitledBorder.LEADING, TitledBorder.TOP, new Font("Tahoma", Font.BOLD, 11)));
			panel.setBounds(57, 545, 775, 132);
			panel.setLayout(null);
			panel.add(getJCheckBoxEnviarATPV());
			
			JLabel lblJustificacinDeAdjudicacin = new JLabel();
			lblJustificacinDeAdjudicacin.setBounds(6, 37, 339, 37);
			panel.add(lblJustificacinDeAdjudicacin);
			lblJustificacinDeAdjudicacin.setText("Justificaci\u00F3n de Adjudicaci\u00F3n sin publicaci\u00F3n");
			panel.add(getJComboBoxJustificacionATPV());
			
			JLabel lblAnuncioDeLicitacin = new JLabel();
			lblAnuncioDeLicitacin.setBounds(35, 53, 339, 37);
			panel.add(lblAnuncioDeLicitacin);
			lblAnuncioDeLicitacin.setText("del Anuncio de Licitaci\u00F3n  en el DOUE");
			
			JLabel lblJustificacin = new JLabel();
			lblJustificacin.setBounds(6, 85, 250, 18);
			panel.add(lblJustificacin);
			lblJustificacin.setText("Justificaci\u00F3n");
			panel.add(getJTextAreaJustificacionATPV());
		}
		return panel;
	}
	
	private JButton getJButtonLotes() {
		if (jButtonLotes == null) {
			jButtonLotes = new JButton();
			jButtonLotes.setText("Lotes");
			jButtonLotes.setActionCommand(Acciones.EDIT_LOTES);
			jButtonLotes.setBounds(448, 477, 193, 18);
		}
		return jButtonLotes;
	}
	
	private JButton getJButtonCriteriosAdjudicacion() {
		if (jButtonCriteriosAdjudicacion == null) {
			jButtonCriteriosAdjudicacion = new JButton();
			jButtonCriteriosAdjudicacion.setText("Criterios de adjudicaci\u00F3n");
			jButtonCriteriosAdjudicacion.setFont(new Font("Tahoma", Font.BOLD, 11));
			jButtonCriteriosAdjudicacion.setActionCommand(Acciones.EDIT_CRITERIOS_ADJUDICACION);
			jButtonCriteriosAdjudicacion.setBounds(52, 477, 192, 18);
		}
		return jButtonCriteriosAdjudicacion;
	}
	
	  
	  private JButton getJButtonReceptorRecuros() {
			if (jButtonReceptorRecursos == null) {
				jButtonReceptorRecursos = new JButton();
				jButtonReceptorRecursos.setBounds(249, 477, 192, 18);
				jButtonReceptorRecursos.setText("Receptor de recursos");
				jButtonReceptorRecursos.setActionCommand(Acciones.RECEPTOR_RECURSOS);
			}
			return jButtonReceptorRecursos;
		}
	  
	  
	  private JButton getJButtonProcedimiento() {
			if (jButtonProcedimiento == null) {
				jButtonProcedimiento = new JButton();
				jButtonProcedimiento.setText("Procedimiento");
				jButtonProcedimiento.setActionCommand(Acciones.EDIT_PROCEDIMIENTO);
				jButtonProcedimiento.setBounds(52, 448, 192, 18);
			}
			return jButtonProcedimiento;
		}
	  
	  private JButton getJButtonRequisitosParticipacion() {
			if (jButtonRequisitosParticipacion == null) {
				jButtonRequisitosParticipacion = new JButton();
				jButtonRequisitosParticipacion.setText("Requisitos de participaci\u00F3n");
				jButtonRequisitosParticipacion.setActionCommand(Acciones.EDIT_REQUISITOS);
				jButtonRequisitosParticipacion.setBounds(249, 448, 192, 18);
			}
			return jButtonRequisitosParticipacion;
		}
}
