/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ComboListener;
import es.dgpe.place.client.components.ComboListenerCountry;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.windows.GeneracionCODICEForm;
import es.dgpe.place.client.windows.publication.service.commons.CondicionesEjecucionForm;
import es.dgpe.place.client.windows.publication.service.commons.CriteriosAdjudicacionForm;
import es.dgpe.place.client.windows.publication.service.commons.LicitadorForm;
import es.dgpe.place.client.windows.publication.service.commons.LotesForm;
import es.dgpe.place.client.windows.publication.service.commons.ProcedimientoForm;
import es.dgpe.place.client.windows.publication.service.commons.PublicacionesOficialesForm;
import es.dgpe.place.client.windows.publication.service.commons.ReceptorRecurosForm;
import es.dgpe.place.client.windows.publication.service.commons.RequisitosParticipacionForm;

public class AnuncioFormalizacionForm extends ThemeJFrame {


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;

	private JLabel jLabelExpediente = null;

	private JTextField jTextFieldExpediente = null;

	private JLabel jLabelTipoContrato = null;

	private JLabel jLabelSubTipoContrato = null;

	private JLabel jLabelObjetoContrato = null;

	private JLabel jLabelProcContratacion = null;

	private JLabel jLabelTipoTramitacin = null;

	private JLabel jLabelTramitacionGasto = null;

	private JLabel jLabelFechaPrevAdj = null;

	private JLabel jLabelSelCPV = null;

	private JLabel jLabelCodigoCPV = null;

	private JComboBox jComboBoxTipoContrato = null;

	private JComboBox jComboBoxSubtipoContrato = null;
	
	private JComboBox<String> jComboBoxDirectiva = null;

	private JTextField jTextFieldObjetoContrato = null;

	private JComboBox jComboBoxCPV = null;
	private JComboBox jComboBoxPais = null;
	private JComboBox jComboBoxNuts = null;
	

	private JLabel jLabelAnuncioFormalizacion = null;
	
	private JLabel jLabelImporteSin = null;

	private JLabel jLabelImporteCon = null;

	private JLabel jLabelClasificacion = null;

	private JLabel jLabelDescSolvencias = null;

	private JTextField jTextFieldImporteSin = null;

	private JTextField jTextFieldImporteCon = null;

	private JButton jButtonLicitador = null;
	
	private JButton jButtonDiariosOficiales = null;
	
	private JButton jButtonDuracionContrato = null;
	private JButton jButtonLotes;
	private JButton jButtonReceptorRecursos = null;
	
	final JFileChooser fc = new JFileChooser();
	private JLabel lblValorEstimadoDel;
	private JTextField jTextFieldValorEstimado;
	
	JFrame gestorVentanasFormCD[] = new JFrame[11];
	
	ExpedienteBean expediente=new ExpedienteBean();  //  @jve:decl-index=0:
	private JTextField textFieldNumContrato=null;
	private JTextField textFieldFechaForm=null;
	private JTextField textFieldFechaVigorContrato=null;
	private JButton jButtonCriteriosAdjudicacion;
	private JButton jButtonProcedimiento = null;
	private JButton jButtonRequisitosParticipacion;

	

	public ExpedienteBean getExpediente() {
		
		if (expediente==null){
			expediente = new ExpedienteBean();
		}
		
		expediente.setNumExpediente(jTextFieldExpediente.getText());
		
		expediente.setDirectivaAplicacion((String) jComboBoxDirectiva.getSelectedItem()); 
		expediente.setIdDirectivaAplicacion(jComboBoxDirectiva.getSelectedIndex());

		expediente.setTipoContrato((String) jComboBoxTipoContrato.getSelectedItem());
		expediente.setIdTipoContrato(jComboBoxTipoContrato.getSelectedIndex());

		expediente.setSubtipoContrato((String) jComboBoxSubtipoContrato.getSelectedItem());
		expediente.setIdSubtipoContrato(jComboBoxSubtipoContrato.getSelectedIndex());

		expediente.setObjetoContrato(jTextFieldObjetoContrato.getText());


		expediente.setCpv((String) jComboBoxCPV.getSelectedItem());
		expediente.setIdCpv(jComboBoxCPV.getSelectedIndex());
		
		expediente.setPais((String) jComboBoxPais.getSelectedItem());
		expediente.setIdPais(jComboBoxPais.getSelectedIndex());
		
		String nutsSeleccionado = (String)jComboBoxNuts.getSelectedItem();
        expediente.setNuts(nutsSeleccionado.substring(0, nutsSeleccionado.lastIndexOf("(")-1));
        expediente.setIdNuts(nutsSeleccionado.substring(nutsSeleccionado.lastIndexOf("(")+1, nutsSeleccionado.length()-1));

		expediente.setImporteSinImpuestos(jTextFieldImporteSin.getText());
		expediente.setImporteConImpuestos(jTextFieldImporteCon.getText());
		expediente.setValorEstimado(jTextFieldValorEstimado.getText());
		expediente.setNumContrato(textFieldNumContrato.getText());
		
		Date fechaFormalizacion=null;
		if (textFieldFechaForm.getText().length()>0)
			try {
				fechaFormalizacion = new SimpleDateFormat("dd-MM-yyyy").parse(textFieldFechaForm.getText());
			} catch (ParseException e) {

				e.printStackTrace();
				System.out.println("Error en el formato de la fecha de formalizacin");	
			}
		expediente.setFechaFormalizacion(fechaFormalizacion);
		
		Date fechaVigorContrato=null;
		if (textFieldFechaVigorContrato.getText().length()>0)
			try {
				fechaVigorContrato = new SimpleDateFormat("dd-MM-yyyy").parse(textFieldFechaVigorContrato.getText());
			} catch (ParseException e) {
				e.printStackTrace();
				System.out.println("Error en el formato de la fecha de entrada en vigor del contrato");	
			}
			expediente.setFechaVigorContrato(fechaVigorContrato);
		
		SessionDataManager.getInstance().setExpediente(expediente);
		
		return expediente;
	}

	public void setAnuncioFormalizacion(ExpedienteBean exp) { 
		
		this.expediente = exp;
	}

	public void cargarDatosComboBoxs() {
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTipoContrato, ConstantsGC.TENDERING_CONTRACT);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxCPV, ConstantsGC.CPV);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxPais, ConstantsGC.COUNTRY_CODE);  
		
		//Cargo el primer valor de Directiva como no sujeto a regulacion armonizada
		jComboBoxDirectiva.addItem(ConstantsGC.NO_SARA);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxDirectiva, ConstantsGC.DIRECTIVA);
	}

	public AnuncioFormalizacionForm(JFrame ventanaPadre) throws ModelException {
		super();
		initialize();
		cargarDatosComboBoxs();
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null;
		gestorVentanasFormCD[2] =null;
		gestorVentanasFormCD[3] =null;
		gestorVentanasFormCD[4] =null;
	
		jButtonDuracionContrato.addActionListener(this);
		jButtonLotes.addActionListener(this); 
		jButtonCriteriosAdjudicacion.addActionListener(this);
		jButtonReceptorRecursos.addActionListener(this);	
		jButtonRequisitosParticipacion.addActionListener(this); 	
		jButtonProcedimiento.addActionListener(this);

		
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosExpediente();
		}
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosExpediente();
			}
		});
		
	}
	
	
	/**
	 * La funcin rellena los datos del formulario a partir de los indicados en el objeto expediente.
	 * Los valores del objeto expediente son los que se han almacenado con anterioridad en session
	 */
	private void escribeDatosExpediente(){
		
		
		DateFormat df = new SimpleDateFormat("dd-MM-yyyy");
		
		jComboBoxDirectiva.setSelectedIndex(expediente.getIdDirectivaAplicacion());
		jTextFieldExpediente.setText(expediente.getNumExpediente());
		jComboBoxTipoContrato.setSelectedIndex(expediente.getIdTipoContrato());
		jComboBoxSubtipoContrato.setSelectedIndex(expediente.getIdSubtipoContrato());
		jTextFieldObjetoContrato.setText(expediente.getObjetoContrato());

		jTextFieldValorEstimado.setText(expediente.getValorEstimado());
		jTextFieldImporteSin.setText(expediente.getImporteSinImpuestos());
		jTextFieldImporteCon.setText(expediente.getImporteConImpuestos());
		
		jComboBoxCPV.setSelectedIndex(expediente.getIdCpv());

		
		jComboBoxPais.setSelectedIndex(expediente.getIdPais());
		jComboBoxNuts.setSelectedItem(expediente.getNuts() + " (" + expediente.getIdNuts() + ")");
		
		textFieldNumContrato.setText(expediente.getNumContrato());
		
		if (expediente.getFechaFormalizacion() != null){
			textFieldFechaForm.setText(df.format(expediente.getFechaFormalizacion()));
		}
		
		if (expediente.getFechaVigorContrato() != null){
			textFieldFechaVigorContrato.setText(df.format(expediente.getFechaVigorContrato()));
		}
	}
	

	private void initialize() {
		 
		getJPanelContenido();
		
		this.setTitle("Servicio de Publicaci\u00F3n - Anuncio de Formalizaci\u00F3n");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	 
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelAnuncioFormalizacion = new JLabel();
			jLabelAnuncioFormalizacion.setFont(new Font("Dialog", Font.BOLD, 18));
			jLabelAnuncioFormalizacion.setLocation(new Point(17, 77));
			jLabelAnuncioFormalizacion.setSize(new Dimension(250, 18));
			jLabelAnuncioFormalizacion.setText("Anuncio de Formalizaci\u00F3n");
			jLabelObjetoContrato = new JLabel();
			jLabelObjetoContrato.setText("Objeto del contrato:");
			jLabelObjetoContrato.setLocation(new Point(63, 209));
			jLabelObjetoContrato.setSize(new Dimension(250, 18));
			jLabelSubTipoContrato = new JLabel();
			jLabelSubTipoContrato.setText("Subtipo de contrato:");
			jLabelSubTipoContrato.setSize(new Dimension(250, 18));
			jLabelSubTipoContrato.setLocation(new Point(63, 184));
			jLabelTipoContrato = new JLabel();
			jLabelTipoContrato.setText("Tipo de contrato:");
			jLabelTipoContrato.setLocation(new Point(63, 159));
			jLabelTipoContrato.setSize(new Dimension(250, 18));
			jLabelExpediente = new JLabel();
			jLabelExpediente.setText("Expediente:");
			jLabelExpediente.setLocation(new Point(62, 134));
			jLabelExpediente.setSize(new Dimension(250, 18));
			
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.add(jLabelExpediente, null); 
			jPanelContenido.add(getJTextFieldExpediente(), null);
			jPanelContenido.add(jLabelTipoContrato, null);
			jPanelContenido.add(getJComboBoxTipoContrato(), null);
			jPanelContenido.add(jLabelSubTipoContrato, null);
			jPanelContenido.add(jLabelObjetoContrato, null);
			jPanelContenido.add(getJComboBoxSubtipoContrato(), null);
			jPanelContenido.add(getJTextFieldObjetoContrato(), null);
			getPanel().add(getJButtonDuracionContrato());
			getPanel().add(getJButtonCriteriosAdjudicacion());
	        getPanel().add(getJButtonReceptorRecuros());
			getPanel().add(getJButtonProcedimiento());
			getPanel().add(getJButtonRequisitosParticipacion());

			jPanelContenido.add(jLabelAnuncioFormalizacion, null);
			getPanel().add(getJButtonLotes());
			getPanel().add(getJTextFieldImporteSin());
			getPanel().add(getJTextFieldImporteCon());
			getPanel().add(getLblValorEstimadoDel());
			getPanel().add(getJTextFieldValorEstimado());
			getPanel().add(getJButtonLicitador());
			getPanel().add(getJButtonDiariosOficiales());
			jButtonLicitador.addActionListener(this); 
			jButtonDiariosOficiales.addActionListener(this);
			
			jLabelSelCPV = new JLabel();
			jLabelSelCPV.setBounds(63, 321, 250, 18);
			getPanel().add(jLabelSelCPV);
			jLabelSelCPV.setText("Seleccin del CPV");
			jLabelCodigoCPV = new JLabel();
			jLabelCodigoCPV.setBounds(93, 341, 220, 18);
			getPanel().add(jLabelCodigoCPV);
			jLabelCodigoCPV.setText("Cdigo CPV");
			getPanel().add(getJComboBoxCPV());
			jLabelImporteSin = new JLabel();
			jLabelImporteSin.setBounds(63, 271, 250, 18);
			getPanel().add(jLabelImporteSin);
			jLabelImporteSin.setText("Importe Base (Sin impuestos)");
			jLabelImporteCon = new JLabel();
			jLabelImporteCon.setBounds(63, 296, 250, 18);
			getPanel().add(jLabelImporteCon);
			jLabelImporteCon.setText("Importe Base (Con impuestos)");
		
			
			JLabel lblNewLabel = new JLabel("N\u00FAmero de contrato");
			lblNewLabel.setBounds(63, 576, 167, 14);
			getPanel().add(lblNewLabel);
			
			JLabel lblNewLabel_1 = new JLabel("Fecha de formalizaci\u00F3n (dd-mm-aaaa)");
			lblNewLabel_1.setBounds(63, 601, 242, 14);
			getPanel().add(lblNewLabel_1);
			
			JLabel lblNewLabel_2 = new JLabel("Fecha de entrada en vigor ");
			lblNewLabel_2.setBounds(63, 626, 269, 14);
			getPanel().add(lblNewLabel_2);
			
			getPanel().add(getJTextFieldNumContrato());
			getPanel().add(getJTextFieldFechaForm());
			getPanel().add(getJTextFieldFechaVigorContrato());
			
			JLabel lblDelContratoddmmaaaa = new JLabel("del contrato (dd-mm-aaaa)");
			lblDelContratoddmmaaaa.setBounds(73, 642, 269, 14);
			getPanel().add(lblDelContratoddmmaaaa);
			
			jComboBoxPais = new JComboBox();
			jComboBoxPais.setBounds(97, 385, 242, 18);
			getPanel().add(jComboBoxPais);
			
			jComboBoxNuts = new JComboBox();
			jComboBoxNuts.setBounds(97, 409, 242, 18);
			getPanel().add(jComboBoxNuts);
			
			JLabel lblLugarDeEjecucin = new JLabel("Lugar de ejecuci\u00F3n");
			lblLugarDeEjecucin.setBounds(63, 370, 230, 14);
			getPanel().add(lblLugarDeEjecucin);
			
			jComboBoxTipoContrato.addItemListener(new ComboListener(jComboBoxTipoContrato,jComboBoxSubtipoContrato));
			jComboBoxPais.addItemListener(new ComboListenerCountry(jComboBoxPais,jComboBoxNuts));
			
			JLabel lblDirectivaDeAplicacin = new JLabel("Directiva de aplicaci\u00F3n");
			lblDirectivaDeAplicacin.setBounds(63, 110, 178, 14);
			getPanel().add(lblDirectivaDeAplicacin);
			jPanelContenido.add(getJComboBoxDirectiva(),null);
		}
		return jPanelContenido;
	}

	private JComboBox getJComboBoxDirectiva(){
		if (jComboBoxDirectiva==null){
		jComboBoxDirectiva = new JComboBox();
		jComboBoxDirectiva.setBounds(333, 110, 378, 20);
		}
		return jComboBoxDirectiva;		
	}
	
	private JTextField getJTextFieldNumContrato() {
		if (textFieldNumContrato == null) {
			textFieldNumContrato = new JTextField();
			textFieldNumContrato.setBounds(333, 573, 125, 20);
			textFieldNumContrato.setColumns(10);
		}
		return textFieldNumContrato;
	}
	
	private JButton getJButtonDuracionContrato() {
		if (jButtonDuracionContrato == null) {
			jButtonDuracionContrato = new JButton();
			jButtonDuracionContrato.setText("Condiciones de ejecuci\u00F3n");
			jButtonDuracionContrato.setActionCommand(Acciones.EDIT_DURACION);
			jButtonDuracionContrato.setBounds(387, 385, 221, 18);
					}
		return jButtonDuracionContrato;
	}
	
	private JTextField getJTextFieldFechaForm() {
		if (textFieldFechaForm == null) {
			textFieldFechaForm = new JTextField();
			SimpleDateFormat dateFormat;
			dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			textFieldFechaForm.setText(dateFormat.format(new Date()));
			textFieldFechaForm.setBounds(333, 598, 125, 20);
			getPanel().add(textFieldFechaForm);
			textFieldFechaForm.setColumns(10);
		}
		return textFieldFechaForm;
	}
	
	private JTextField getJTextFieldFechaVigorContrato() {
		if (textFieldFechaVigorContrato == null) {
			textFieldFechaVigorContrato = new JTextField();
			SimpleDateFormat dateFormat;
			dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			textFieldFechaVigorContrato.setText(dateFormat.format(new Date()));
			textFieldFechaVigorContrato.setBounds(333, 626, 125, 20);
			getPanel().add(textFieldFechaVigorContrato);
			textFieldFechaVigorContrato.setColumns(10);
		}
		return textFieldFechaVigorContrato;
	}
	
	private JTextField getJTextFieldExpediente() {
		if (jTextFieldExpediente == null) {
			jTextFieldExpediente = new JTextField();
			jTextFieldExpediente.setSize(new Dimension(210, 18));
			jTextFieldExpediente.setLocation(new Point(333, 134));
		}
		return jTextFieldExpediente;
	}

	private JComboBox getJComboBoxTipoContrato() {
		if (jComboBoxTipoContrato == null) {
			jComboBoxTipoContrato = new JComboBox();
			jComboBoxTipoContrato.setLocation(new Point(333, 159));
			jComboBoxTipoContrato.setSize(new Dimension(210, 18));
		}
		return jComboBoxTipoContrato;
	}

	private JComboBox getJComboBoxSubtipoContrato() {
		if (jComboBoxSubtipoContrato == null) {
			jComboBoxSubtipoContrato = new JComboBox();
			jComboBoxSubtipoContrato.setLocation(new Point(333, 184));
			jComboBoxSubtipoContrato.setSize(new Dimension(493, 18));
		}
		return jComboBoxSubtipoContrato;
	}

	private JTextField getJTextFieldObjetoContrato() {
		if (jTextFieldObjetoContrato == null) {
			jTextFieldObjetoContrato = new JTextField();
			jTextFieldObjetoContrato.setLocation(new Point(333, 209));
			jTextFieldObjetoContrato.setSize(new Dimension(493, 18));
		}
		return jTextFieldObjetoContrato;
	}

	private JComboBox getJComboBoxCPV() {
		if (jComboBoxCPV == null) {
			jComboBoxCPV = new JComboBox();
			jComboBoxCPV.setBounds(333, 341, 493, 18);
		}
		return jComboBoxCPV;
	}

	/**
	 * This method initializes jTextFieldImporteSin	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteSin() {
		if (jTextFieldImporteSin == null) {
			jTextFieldImporteSin = new JTextField();
			jTextFieldImporteSin.setBounds(333, 271, 210, 18);
		}
		return jTextFieldImporteSin;
	}

	/**
	 * This method initializes jTextFieldImporteCon	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteCon() {
		if (jTextFieldImporteCon == null) {
			jTextFieldImporteCon = new JTextField();
			jTextFieldImporteCon.setBounds(333, 296, 210, 18);
		}
		return jTextFieldImporteCon;
	}

	/**
	 * This method initializes jButtonLicitador	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonLicitador() {
		if (jButtonLicitador == null) {
			jButtonLicitador = new JButton();
			jButtonLicitador.setBounds(523, 438, 221, 18);
			jButtonLicitador.setText("Adjudicatario...");
			jButtonLicitador.setActionCommand(Acciones.INIT_LIC);
		}
		return jButtonLicitador;
	}
	
	private JButton getJButtonDiariosOficiales() {
		if (jButtonDiariosOficiales == null) {
			jButtonDiariosOficiales = new JButton();
			jButtonDiariosOficiales.setBounds(523, 464, 221, 18);
			jButtonDiariosOficiales.setText("Publicacion en diarios oficiales");
			jButtonDiariosOficiales.setActionCommand(Acciones.INIT_OFFICIAL_PUB);
		
		}
		return jButtonDiariosOficiales;
	}

	
	private JLabel getLblValorEstimadoDel() {
		if (lblValorEstimadoDel == null) {
			lblValorEstimadoDel = new JLabel("Valor estimado del contrato");
			lblValorEstimadoDel.setBounds(63, 246, 230, 14);
		}
		return lblValorEstimadoDel;
	}
	
    private JTextField getJTextFieldValorEstimado() {
		if (jTextFieldValorEstimado == null) {
			jTextFieldValorEstimado = new JTextField();
			jTextFieldValorEstimado.setBounds(333, 240, 210, 20);
			jTextFieldValorEstimado.setColumns(10);
		}
		return jTextFieldValorEstimado;
	}

    public void actionPerformed(ActionEvent e) {

		try{
			
			SessionDataManager.getInstance().setExpediente(getExpediente());
		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			gestorVentanasFormCD[0].setVisible(true);
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {
			
			if (gestorVentanasFormCD[1] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[1] = new GeneracionCODICEForm(this,TipoDocumento.FORM); 
				gestorVentanasFormCD[1].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[1].setVisible(true);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_LIC)) {
			if (gestorVentanasFormCD[3] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[3] = new LicitadorForm(this,TipoDocumento.FORM); 
				gestorVentanasFormCD[3].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[3].setVisible(true);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_OFFICIAL_PUB)) {
			if (gestorVentanasFormCD[4] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[4] = new PublicacionesOficialesForm(this,TipoDocumento.FORM); 
				gestorVentanasFormCD[4].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[4].setVisible(true);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_DURACION)) {
			if (gestorVentanasFormCD[5] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[5] = new CondicionesEjecucionForm(this,TipoDocumento.FORM);
				gestorVentanasFormCD[5].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[5].setVisible(true);
			}
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_LOTES)) {
			if (gestorVentanasFormCD[6] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[6] = new LotesForm(this,TipoDocumento.FORM);
				gestorVentanasFormCD[6].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[6].setVisible(true);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_CRITERIOS_ADJUDICACION)) {
				if (gestorVentanasFormCD[7] == null) {
					getExpediente();
					this.setVisible(false);
					gestorVentanasFormCD[7] = new CriteriosAdjudicacionForm(this,TipoDocumento.FORM);
					gestorVentanasFormCD[7].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCD[7].setVisible(true);
				}
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.RECEPTOR_RECURSOS)) {
				if (gestorVentanasFormCD[8] == null) {
					this.setVisible(false);
					gestorVentanasFormCD[8] = new ReceptorRecurosForm(this, TipoDocumento.FORM);
					gestorVentanasFormCD[8].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCD[8].setVisible(true);
				}
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_REQUISITOS)) {
				if (gestorVentanasFormCD[9] == null) {
					getExpediente();
					this.setVisible(false);
					gestorVentanasFormCD[9] = new RequisitosParticipacionForm(this,TipoDocumento.FORM);
					gestorVentanasFormCD[9].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCD[9].setVisible(true);
				}
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_PROCEDIMIENTO)) {
				if (gestorVentanasFormCD[10] == null) {
					getExpediente();
					this.setVisible(false);
					gestorVentanasFormCD[10] = new ProcedimientoForm(this,TipoDocumento.FORM);
					gestorVentanasFormCD[10].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCD[10].setVisible(true);
				}
			}
		
		} catch (ModelException e1){
			e1.printStackTrace();
		}

	}
    
    private JButton getJButtonLotes() {
		if (jButtonLotes == null) {
			jButtonLotes = new JButton();
			jButtonLotes.setText("Lotes");
			jButtonLotes.setActionCommand(Acciones.EDIT_LOTES);
			jButtonLotes.setBounds(387, 414, 221, 18);
		}
		return jButtonLotes;
	}
    
	private JButton getJButtonCriteriosAdjudicacion() {
		if (jButtonCriteriosAdjudicacion == null) {
			jButtonCriteriosAdjudicacion = new JButton();
			jButtonCriteriosAdjudicacion.setText("Criterios de adjudicaci\u00F3n");
			jButtonCriteriosAdjudicacion.setFont(new Font("Tahoma", Font.BOLD, 11));
			jButtonCriteriosAdjudicacion.setActionCommand(Acciones.EDIT_CRITERIOS_ADJUDICACION);
			jButtonCriteriosAdjudicacion.setBounds(50, 464, 221, 18);
		}
		return jButtonCriteriosAdjudicacion;
	}
	
	  private JButton getJButtonReceptorRecuros() {
			if (jButtonReceptorRecursos == null) {
				jButtonReceptorRecursos = new JButton();
				jButtonReceptorRecursos.setBounds(281, 464, 221, 18);
				jButtonReceptorRecursos.setText("Receptor de recursos");
				jButtonReceptorRecursos.setActionCommand(Acciones.RECEPTOR_RECURSOS);
			}
			return jButtonReceptorRecursos;
		}
	  
	  
	  private JButton getJButtonProcedimiento() {
			if (jButtonProcedimiento == null) {
				jButtonProcedimiento = new JButton();
				jButtonProcedimiento.setText("Procedimiento");
				jButtonProcedimiento.setActionCommand(Acciones.EDIT_PROCEDIMIENTO);
				jButtonProcedimiento.setBounds(50, 438, 221, 18);
			}
			return jButtonProcedimiento;
		}
	  
	  private JButton getJButtonRequisitosParticipacion() {
			if (jButtonRequisitosParticipacion == null) {
				jButtonRequisitosParticipacion = new JButton();
				jButtonRequisitosParticipacion.setText("Requisitos de participaci\u00F3n");
				jButtonRequisitosParticipacion.setActionCommand(Acciones.EDIT_REQUISITOS);
				jButtonRequisitosParticipacion.setBounds(280, 438, 221, 18);
			}
			return jButtonRequisitosParticipacion;
		}
}
