/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ComboListener;
import es.dgpe.place.client.components.ComboListenerCountry;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.windows.GeneracionCODICEForm;
import es.dgpe.place.client.windows.publication.service.commons.CondicionesEjecucionForm;
import es.dgpe.place.client.windows.publication.service.commons.CriteriosAdjudicacionForm;
import es.dgpe.place.client.windows.publication.service.commons.EventosAperturaForm;
import es.dgpe.place.client.windows.publication.service.commons.LotesForm;
import es.dgpe.place.client.windows.publication.service.commons.ProcedimientoForm;
import es.dgpe.place.client.windows.publication.service.commons.PublicacionesOficialesForm;
import es.dgpe.place.client.windows.publication.service.commons.ReceptorRecurosForm;
import es.dgpe.place.client.windows.publication.service.commons.RequisitosParticipacionForm;

public class AnuncioLicitacionForm extends ThemeJFrame {

	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;  //  @jve:decl-index=0:visual-constraint="-2,629"

	private JLabel jLabelExpediente = null;

	private JTextField jTextFieldExpediente = null;

	private JLabel jLabelTipoContrato = null;

	private JLabel jLabelSubTipoContrato = null;

	private JLabel jLabelObjetoContrato = null;

	private JLabel jLabelCodigoCPV = null;

	private JComboBox<String> jComboBoxDirectiva=null;
	
	private JComboBox jComboBoxTipoContrato = null;

	private JComboBox jComboBoxSubtipoContrato = null;

	private JTextField jTextFieldObjetoContrato = null;
	

	private JComboBox jComboBoxCPV = null;
	
	

	private JLabel jLabelAnuncioLicitacion = null;
	
	JFrame gestorVentanasFormCN[] = new JFrame[10];
	
	ExpedienteBean expediente=new ExpedienteBean();

	private JButton jButtonEventosApertura = null;

	private JLabel jLabelImporteSin = null;

	private JLabel jLabelImporteCon = null;

	private JTextField jTextFieldImporteSin = null;
	private JTextField jTextFieldImporteCon = null;
	private JButton jButtonCondicionesEjecucion = null;
	private JButton jButtonPubOff = null;
	private JButton jButtonProcedimiento = null;
	
	private JTextField jTextFieldValorEstimado=null;
	private JTextArea jTextFieldJustifNoPliegos;
	private JButton jButtonReceptorRecursos = null;
	private JComboBox<String> jComboBoxAcuerdoCP = new JComboBox<String>();
	
	
	private JComboBox jComboBoxPais;
    private JComboBox jComboBoxNuts;
    private JLabel lblLugarDeEjecucin;
    private JButton jButtonRequisitosParticipacion;
    private JButton jButtonLotes;
    private JButton jButtonCriteriosAdjudicacion;
    private JLabel lblDirectivaDeAplicacin_1;
    private JLabel lblJustificacinNoPublicacin;
	
	public ExpedienteBean getExpediente() {
		if (expediente==null){
			expediente = new ExpedienteBean();
		}
		
		expediente.setDirectivaAplicacion((String) jComboBoxDirectiva.getSelectedItem()); 
		expediente.setIdDirectivaAplicacion(jComboBoxDirectiva.getSelectedIndex());

		expediente.setNumExpediente(jTextFieldExpediente.getText());

		expediente.setTipoContrato((String) jComboBoxTipoContrato.getSelectedItem());
		expediente.setIdTipoContrato(jComboBoxTipoContrato.getSelectedIndex());

		expediente.setSubtipoContrato((String) jComboBoxSubtipoContrato.getSelectedItem());
		expediente.setIdSubtipoContrato(jComboBoxSubtipoContrato.getSelectedIndex());

		expediente.setObjetoContrato(jTextFieldObjetoContrato.getText());

		
		expediente.setCpv((String) jComboBoxCPV.getSelectedItem());
		expediente.setIdCpv(jComboBoxCPV.getSelectedIndex());

		expediente.setImporteSinImpuestos(jTextFieldImporteSin.getText());
		expediente.setImporteConImpuestos(jTextFieldImporteCon.getText());
		expediente.setValorEstimado(jTextFieldValorEstimado.getText());
		
		
		
		expediente.setPais((String) jComboBoxPais.getSelectedItem());
        expediente.setIdPais(jComboBoxPais.getSelectedIndex());
        
        String nutsSeleccionado = (String)jComboBoxNuts.getSelectedItem();
        if (nutsSeleccionado != null){
        	expediente.setNuts(nutsSeleccionado.substring(0, nutsSeleccionado.lastIndexOf("(")-1));
        	expediente.setIdNuts(nutsSeleccionado.substring(nutsSeleccionado.lastIndexOf("(")+1, nutsSeleccionado.length()-1));
        }
        
		expediente.setJustifNoPubPliegos(jTextFieldJustifNoPliegos.getText());
		expediente.setAcuerdoCP(jComboBoxAcuerdoCP.getSelectedIndex());
		
		
		
		SessionDataManager.getInstance().setExpediente(expediente);
		
		return expediente;
	}

	public void setExpediente(ExpedienteBean anuncioLicitacion) { 
		
		this.expediente = anuncioLicitacion;
	}

	public void cargarDatosComboBoxs() {
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTipoContrato, ConstantsGC.TENDERING_CONTRACT);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxPais, ConstantsGC.COUNTRY_CODE);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxCPV, ConstantsGC.CPV);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxAcuerdoCP, ConstantsGC.SI_NO);
		
		
		//Cargo el primer valor de Directiva como no sujeto a regulacion armonizada
		jComboBoxDirectiva.addItem(ConstantsGC.NO_SARA);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxDirectiva, ConstantsGC.DIRECTIVA);
	}

	public AnuncioLicitacionForm(JFrame ventanaPadre)throws ModelException {
		super();
		initialize();
		cargarDatosComboBoxs();
		gestorVentanasFormCN[0] =ventanaPadre;
		gestorVentanasFormCN[1] =null;
	 
		jButtonEventosApertura.addActionListener(this); 	
		jButtonPubOff.addActionListener(this);	
		jButtonCondicionesEjecucion.addActionListener(this);
		jButtonRequisitosParticipacion.addActionListener(this); 	
		jButtonLotes.addActionListener(this); 
		jButtonCriteriosAdjudicacion.addActionListener(this);
		jButtonProcedimiento.addActionListener(this);
		jButtonReceptorRecursos.addActionListener(this);	
		
		
		
		getPanel().add(getLabelExpediente());
		getPanel().add(getLabelTipoContrato());
		getPanel().add(getLabelSubTipoContrato());
		getPanel().add(getLabelObjetoContrato());
		getPanel().add(getLabelAnuncioLicitacion());
		getPanel().add(getJButtonCriteriosAdjudicacion());
		getPanel().add(getTextFieldJustifNoPliegos());
		getPanel().add(getLblDirectivaDeAplicacin_1());
		getPanel().add(getLblJustificacinNoPublicacin());
		
		JLabel lblSujetoAlAcuerdo = new JLabel();
		lblSujetoAlAcuerdo.setText("Sujeto al Acuerdo de Contraci\u00F3n P\u00FAblica de la OMC");
		lblSujetoAlAcuerdo.setBounds(57, 348, 343, 16);
		getPanel().add(lblSujetoAlAcuerdo);
		

		
		
		
		
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosExpediente();
			}
		});
		
		
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosExpediente();
		}
		
	
	}
	
	
	/**
	 * La funcin rellena los datos del formulario a partir de los indicados en el objeto expediente.
	 * Los valores del objeto expediente son los que se han almacenado con anterioridad en session
	 */
	private void escribeDatosExpediente(){
		jComboBoxDirectiva.setSelectedIndex(expediente.getIdDirectivaAplicacion());
		jTextFieldExpediente.setText(expediente.getNumExpediente());
		jComboBoxTipoContrato.setSelectedIndex(expediente.getIdTipoContrato());
		jComboBoxSubtipoContrato.setSelectedIndex(expediente.getIdSubtipoContrato());
		jTextFieldObjetoContrato.setText(expediente.getObjetoContrato());
		jTextFieldValorEstimado.setText(expediente.getValorEstimado());
		jTextFieldImporteSin.setText(expediente.getImporteSinImpuestos());
		jTextFieldImporteCon.setText(expediente.getImporteConImpuestos());
		jComboBoxPais.setSelectedIndex(expediente.getIdPais());
		jComboBoxNuts.setSelectedItem(expediente.getNuts() + " (" + expediente.getIdNuts() + ")");
		jComboBoxCPV.setSelectedIndex(expediente.getIdCpv());
		jTextFieldJustifNoPliegos.setText(expediente.getJustifNoPubPliegos());
		jComboBoxAcuerdoCP.setSelectedIndex(expediente.getAcuerdoCP());
	}
	

	private void initialize() {
		 
		getJPanelContenido();		
		this.setTitle("Servicio de Publicacin - Anuncio de Licitacin");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
	
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {		
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.setSize(new Dimension(932, 570));
			
			
			
			getPanel().add(getLabelImporteSin());
			getPanel().add(getJTextFieldImporteSin());
			getPanel().add(getLabelImporteCon());
			getPanel().add(getJTextFieldImporteCon());
			getPanel().add(getCodigoCPV());
			getPanel().add(getJComboBoxCPV());
			getPanel().add(getJButtonEventosApertura());
			getPanel().add(getJButtonPubOff());
			getPanel().add(getJButtonDuracionContrato());
			getPanel().add(getJButtonRequisitosParticipacion());
			getPanel().add(getJComboBoxSubtipoContrato());
			getPanel().add(getJTextFieldObjetoContrato());
			getPanel().add(getJButtonLotes());
			getPanel().add(getJButtonCriteriosAdjudicacion());
			getPanel().add(getJComboBoxDirectiva());
			getPanel().add(getJButtonProcedimiento());
			getPanel().add(getjComboBoxFasesSucesivas());
			
			
			
			JLabel lblValorEstimadoDel = new JLabel("Valor estimado del contrato");
			lblValorEstimadoDel.setBounds(57, 271, 204, 14);
			getPanel().add(lblValorEstimadoDel);
			
			jTextFieldValorEstimado = new JTextField();
			jTextFieldValorEstimado.setBounds(420, 266, 210, 20);
			getPanel().add(jTextFieldValorEstimado);
			jTextFieldValorEstimado.setColumns(10);
			getPanel().add(getJTextFieldExpediente());
			getPanel().add(getJComboBoxTipoContrato());
			
	        getPanel().add(getJComboBoxNuts());
	        getPanel().add(getJComboBoxPais());
	        getPanel().add(getLblLugarDeEjecucin());
	        getPanel().add(getJButtonReceptorRecuros());
			
			jComboBoxTipoContrato.addItemListener(new ComboListener(jComboBoxTipoContrato,jComboBoxSubtipoContrato));
			jComboBoxPais.addItemListener(new ComboListenerCountry(jComboBoxPais,jComboBoxNuts));
			
			JLabel lblDirectivaDeAplicacin = new JLabel("Directiva de aplicaci\u00F3n");
			lblDirectivaDeAplicacin.setBounds(53, 124, 178, 14);
		
	
		}
		return jPanelContenido;
	}

	private JComboBox getJComboBoxDirectiva(){
		if (jComboBoxDirectiva==null){
		jComboBoxDirectiva = new JComboBox();
		jComboBoxDirectiva.setBounds(417, 123, 378, 20);
		}
		return jComboBoxDirectiva;		
	}
	private JLabel getLabelAnuncioLicitacion(){
		if (jLabelAnuncioLicitacion==null)
		{
		jLabelAnuncioLicitacion = new JLabel();
		jLabelAnuncioLicitacion.setBounds(21, 95, 250, 18);
		jLabelAnuncioLicitacion.setFont(new Font("Dialog", Font.BOLD, 18));
		jLabelAnuncioLicitacion.setText("Anuncio de Licitacin");
		}
		return jLabelAnuncioLicitacion;
	}
	
	private JLabel getLabelExpediente(){
		if (jLabelExpediente==null){
		jLabelExpediente = new JLabel();
		jLabelExpediente.setBounds(57, 149, 250, 18);
		jLabelExpediente.setText("Expediente:");
		}
		return jLabelExpediente;
	}
	
	private JLabel getLabelTipoContrato(){
		if (jLabelTipoContrato==null){
			jLabelTipoContrato = new JLabel();
			jLabelTipoContrato.setBounds(57, 178, 250, 18);
			jLabelTipoContrato.setText("Tipo de contrato:");
		}
		return jLabelTipoContrato;
	}
	
	private JLabel getLabelSubTipoContrato(){
		if (jLabelSubTipoContrato==null){
			jLabelSubTipoContrato = new JLabel();
			jLabelSubTipoContrato.setBounds(84, 207, 250, 18);
			jLabelSubTipoContrato.setText("Subtipo de contrato:");
		}
		return jLabelSubTipoContrato;
	}
	 
	private JLabel getLabelObjetoContrato(){
		if (jLabelObjetoContrato==null){
			jLabelObjetoContrato = new JLabel();
			jLabelObjetoContrato.setBounds(57, 236, 250, 18);
			jLabelObjetoContrato.setText("Objeto del contrato:");
		}
		return jLabelObjetoContrato;
	}
	
	private JLabel getLabelImporteSin(){
		if (jLabelImporteSin==null){ 
			jLabelImporteSin = new JLabel();
			jLabelImporteSin.setBounds(57, 296, 246, 16);
			jLabelImporteSin.setText("Importe Base (Sin impuestos)");
		}
		return jLabelImporteSin;
	}
	
	private JLabel getLabelImporteCon(){
		if (jLabelImporteCon==null){ 
			jLabelImporteCon = new JLabel();
			jLabelImporteCon.setBounds(57, 321, 246, 16);
			jLabelImporteCon.setText("Importe Base (Con impuestos)");
		}
		return jLabelImporteCon;
	}
	
	private JLabel getCodigoCPV(){
		if (jLabelCodigoCPV==null){
			jLabelCodigoCPV = new JLabel(); 
			jLabelCodigoCPV.setBounds(57, 395, 220, 18);
			jLabelCodigoCPV.setText("Cdigo CPV");
		}
		return jLabelCodigoCPV;
	}
	
	private JComboBox getJComboBoxCPV() {
		if (jComboBoxCPV == null) {
			jComboBoxCPV = new JComboBox();
			jComboBoxCPV.setBounds(420, 395, 493, 18);
		}
		return jComboBoxCPV;
	}
  
	private JButton getJButtonEventosApertura() {
		if (jButtonEventosApertura == null) {
			jButtonEventosApertura = new JButton();
			jButtonEventosApertura.setBounds(669, 575, 193, 23);
			jButtonEventosApertura.setText("Eventos de apertura");
			jButtonEventosApertura.setFont(new Font("Tahoma", Font.BOLD, 11));
			jButtonEventosApertura.setActionCommand(Acciones.INIT_EVENT);
		}
		return jButtonEventosApertura;
	}
	
	private JTextField getJTextFieldExpediente() {
		if (jTextFieldExpediente == null) {
			jTextFieldExpediente = new JTextField();
			jTextFieldExpediente.setBounds(420, 154, 375, 18);
		}
		return jTextFieldExpediente;
	}

	private JComboBox getJComboBoxTipoContrato() {
		if (jComboBoxTipoContrato == null) {
			jComboBoxTipoContrato = new JComboBox();
			jComboBoxTipoContrato.setBounds(420, 178, 375, 18);
		}
		return jComboBoxTipoContrato;
	}

	private JComboBox getJComboBoxSubtipoContrato() {
		if (jComboBoxSubtipoContrato == null) {
			jComboBoxSubtipoContrato = new JComboBox();
			jComboBoxSubtipoContrato.setBounds(420, 207, 493, 18);
		}
		return jComboBoxSubtipoContrato;
	}

	
	//Elementos
	private JTextField getJTextFieldObjetoContrato() {
		if (jTextFieldObjetoContrato == null) {
			jTextFieldObjetoContrato = new JTextField();
			jTextFieldObjetoContrato.setBounds(420, 236, 493, 18);
		}
		return jTextFieldObjetoContrato;
	}
 
	public void actionPerformed(ActionEvent e) {

		try{
			SessionDataManager.getInstance().setExpediente(getExpediente());
			if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
				this.setVisible(false);
				gestorVentanasFormCN[0].setVisible(true);		
			} else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_EVENT)) {
				if (gestorVentanasFormCN[1] == null) {
					getExpediente();
					this.setVisible(false);
					gestorVentanasFormCN[1] = new EventosAperturaForm(this,TipoDocumento.CN);
					gestorVentanasFormCN[1].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCN[1].setVisible(true);
				}

			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_OFFICIAL_PUB)) {
				if (gestorVentanasFormCN[2] == null) {
					getExpediente();
					this.setVisible(false);
					gestorVentanasFormCN[2] = new PublicacionesOficialesForm(this,TipoDocumento.CN);
					gestorVentanasFormCN[2].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCN[2].setVisible(true);
				}
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_DURACION)) {
				if (gestorVentanasFormCN[3] == null) {
					getExpediente();
					this.setVisible(false);
					gestorVentanasFormCN[3] = new CondicionesEjecucionForm(this,TipoDocumento.CN);
					gestorVentanasFormCN[3].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCN[3].setVisible(true);
				}
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_PROCEDIMIENTO)) {
				if (gestorVentanasFormCN[4] == null) {
					getExpediente();
					this.setVisible(false);
					gestorVentanasFormCN[4] = new ProcedimientoForm(this,TipoDocumento.CN);
					gestorVentanasFormCN[4].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCN[4].setVisible(true);
				}
				
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_REQUISITOS)) {
					if (gestorVentanasFormCN[5] == null) {
						getExpediente();
						this.setVisible(false);
						gestorVentanasFormCN[5] = new RequisitosParticipacionForm(this,TipoDocumento.CN);
						gestorVentanasFormCN[5].setVisible(true);
					} else {
						this.setVisible(false);
						gestorVentanasFormCN[5].setVisible(true);
					}
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_LOTES)) {
				if (gestorVentanasFormCN[6] == null) {
					getExpediente();
					this.setVisible(false);
					gestorVentanasFormCN[6] = new LotesForm(this,TipoDocumento.CN);
					gestorVentanasFormCN[6].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCN[6].setVisible(true);
				}
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_CRITERIOS_ADJUDICACION)) {
				if (gestorVentanasFormCN[7] == null) {
					getExpediente();
					this.setVisible(false);
					gestorVentanasFormCN[7] = new CriteriosAdjudicacionForm(this,TipoDocumento.CN);
					gestorVentanasFormCN[7].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCN[7].setVisible(true);
				}
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {
				if (gestorVentanasFormCN[8] == null) {
					getExpediente();
					this.setVisible(false);
					gestorVentanasFormCN[8] = new GeneracionCODICEForm(this,
							TipoDocumento.CN);
					gestorVentanasFormCN[8].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCN[8].setVisible(true);
				}
			} else if (e.getActionCommand().equalsIgnoreCase(Acciones.RECEPTOR_RECURSOS)) {
				if (gestorVentanasFormCN[9] == null) {
					this.setVisible(false);
					gestorVentanasFormCN[9] = new ReceptorRecurosForm(this, TipoDocumento.CN);
					gestorVentanasFormCN[9].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormCN[9].setVisible(true);
				}
			}

		} catch (ModelException e1){
			e1.printStackTrace();
		}
	}

	/**
	 * This method initializes jTextFieldImporteSin	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteSin() {
		if (jTextFieldImporteSin == null) {
			jTextFieldImporteSin = new JTextField();
			jTextFieldImporteSin.setBounds(420, 295, 210, 18);
		}
		return jTextFieldImporteSin;
	}

	/**
	 * This method initializes jTextFieldImporteCon	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteCon() {
		if (jTextFieldImporteCon == null) {
			jTextFieldImporteCon = new JTextField();
			jTextFieldImporteCon.setBounds(420, 320, 210, 18);
		}
		return jTextFieldImporteCon;
	}

	private JButton getJButtonPubOff() {
		if (jButtonPubOff == null) {
			jButtonPubOff = new JButton();
			jButtonPubOff.setFont(new Font("Tahoma", Font.BOLD, 11));
			jButtonPubOff.setBounds(466, 541, 193, 23);
			jButtonPubOff.setText("Publicaciones oficiales...");
			jButtonPubOff.setActionCommand(Acciones.INIT_OFFICIAL_PUB);
		}
		return jButtonPubOff;
	}
	
	private JButton getJButtonDuracionContrato() {
		if (jButtonCondicionesEjecucion == null) {
			jButtonCondicionesEjecucion = new JButton();
			jButtonCondicionesEjecucion.setFont(new Font("Tahoma", Font.BOLD, 11));
			jButtonCondicionesEjecucion.setText("Condiciones de Ejecucion");
			jButtonCondicionesEjecucion.setActionCommand(Acciones.EDIT_DURACION);
			jButtonCondicionesEjecucion.setBounds(259, 541, 193, 23);
					}
		return jButtonCondicionesEjecucion;
	}
	
	private JComboBox<String> getJComboBoxPais() {
      if (jComboBoxPais == null) {
          jComboBoxPais = new JComboBox<String>();
          jComboBoxPais.setBounds(420, 432, 193, 18);
      }
      return jComboBoxPais;
  }
  private JComboBox<String> getJComboBoxNuts() {
      if (jComboBoxNuts == null) {
          jComboBoxNuts = new JComboBox<String>();
          jComboBoxNuts.setBounds(676, 432, 193, 18);
      }
      return jComboBoxNuts;
  }
  
  private JLabel getLblLugarDeEjecucin() {
    if (lblLugarDeEjecucin == null) {
        lblLugarDeEjecucin = new JLabel("Lugar de ejecuci\u00F3n");
        lblLugarDeEjecucin.setFont(new Font("Tahoma", Font.BOLD, 11));
        lblLugarDeEjecucin.setBounds(57, 434, 230, 14);
    }
    return lblLugarDeEjecucin;
}
	private JButton getJButtonRequisitosParticipacion() {
		if (jButtonRequisitosParticipacion == null) {
			jButtonRequisitosParticipacion = new JButton();
			jButtonRequisitosParticipacion.setFont(new Font("Tahoma", Font.BOLD, 11));
			jButtonRequisitosParticipacion.setText("Requisitos de participaci\u00F3n");
			jButtonRequisitosParticipacion.setActionCommand(Acciones.EDIT_REQUISITOS);
			jButtonRequisitosParticipacion.setBounds(259, 575, 193, 23);
		}
		return jButtonRequisitosParticipacion;
	}
	private JButton getJButtonLotes() {
		if (jButtonLotes == null) {
			jButtonLotes = new JButton();
			jButtonLotes.setFont(new Font("Tahoma", Font.BOLD, 11));
			jButtonLotes.setText("Lotes");
			jButtonLotes.setActionCommand(Acciones.EDIT_LOTES);
			jButtonLotes.setBounds(57, 575, 193, 22);
		}
		return jButtonLotes;
	}
	private JButton getJButtonCriteriosAdjudicacion() {
		if (jButtonCriteriosAdjudicacion == null) {
			jButtonCriteriosAdjudicacion = new JButton();
			jButtonCriteriosAdjudicacion.setText("Criterios de adjudicaci\u00F3n");
			jButtonCriteriosAdjudicacion.setFont(new Font("Tahoma", Font.BOLD, 11));
			jButtonCriteriosAdjudicacion.setActionCommand(Acciones.EDIT_CRITERIOS_ADJUDICACION);
			jButtonCriteriosAdjudicacion.setBounds(466, 575, 193, 23);
		}
		return jButtonCriteriosAdjudicacion;
	}
	private JTextArea getTextFieldJustifNoPliegos() {
		if (jTextFieldJustifNoPliegos == null){
			jTextFieldJustifNoPliegos = new JTextArea();
			jTextFieldJustifNoPliegos.setBounds(420, 461, 493, 61);
			jTextFieldJustifNoPliegos.setBorder(BorderFactory.createLineBorder(Color.BLACK));
			getPanel().add(jTextFieldJustifNoPliegos);
		}
		return jTextFieldJustifNoPliegos;
	}
	
	private JLabel getLblDirectivaDeAplicacin_1() {
		if (lblDirectivaDeAplicacin_1 == null) {
			lblDirectivaDeAplicacin_1 = new JLabel();
			lblDirectivaDeAplicacin_1.setText("Directiva de aplicaci\u00F3n");
			lblDirectivaDeAplicacin_1.setBounds(53, 123, 250, 18);
		}
		return lblDirectivaDeAplicacin_1;
	}
	private JLabel getLblJustificacinNoPublicacin() {
		if (lblJustificacinNoPublicacin == null) {
			lblJustificacinNoPublicacin = new JLabel();
			lblJustificacinNoPublicacin.setText("Justificaci\u00F3n no publicaci\u00F3n de pliegos, en su caso");
			lblJustificacinNoPublicacin.setBounds(57, 464, 357, 18);
		}
		return lblJustificacinNoPublicacin;
	}
	
	  private JButton getJButtonProcedimiento() {
			if (jButtonProcedimiento == null) {
				jButtonProcedimiento = new JButton();
				jButtonProcedimiento.setFont(new Font("Tahoma", Font.BOLD, 11));
				jButtonProcedimiento.setText("Procedimiento");
				jButtonProcedimiento.setActionCommand(Acciones.EDIT_PROCEDIMIENTO);
				jButtonProcedimiento.setBounds(57, 541, 193, 23);
			}
			return jButtonProcedimiento;
		}
	  
	  private JButton getJButtonReceptorRecuros() {
			if (jButtonReceptorRecursos == null) {
				jButtonReceptorRecursos = new JButton();
				jButtonReceptorRecursos.setFont(new Font("Tahoma", Font.BOLD, 11));
				jButtonReceptorRecursos.setBounds(669, 541, 193, 23);
				jButtonReceptorRecursos.setText("Receptor de recursos");
				jButtonReceptorRecursos.setActionCommand(Acciones.RECEPTOR_RECURSOS);
			}
			return jButtonReceptorRecursos;
		}
	  
		public JComboBox getjComboBoxFasesSucesivas() {
			jComboBoxAcuerdoCP = new JComboBox();
			jComboBoxAcuerdoCP.setBounds(420, 349, 92, 18);
			return jComboBoxAcuerdoCP;
		}
}
