/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ComboListener;
import es.dgpe.place.client.components.ComboListenerCountry;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.windows.GeneracionCODICEForm;
import es.dgpe.place.client.windows.publication.service.commons.PublicacionesOficialesForm;
import es.dgpe.place.client.windows.publication.service.commons.ReceptorRecurosForm;

public class AnuncioPrevioForm extends ThemeJFrame {

	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;

	private JLabel jLabelExpediente = null;

	private JTextField jTextFieldExpediente = null;

	private JLabel jLabelTipoContrato = null;

	private JLabel jLabelSubTipoContrato = null;

	private JLabel jLabelObjetoContrato = null;

	private JLabel jLabelProcContratacion = null;

	private JLabel jLabelTipoTramitacin = null;

	private JLabel jLabelTramitacionGasto = null;

	private JLabel jLabelFechaPrevAdj = null;

	private JLabel jLabelSelCPV = null;

	private JLabel jLabelCodigoCPV = null;

	private JComboBox<String> jComboBoxDirectiva=null;
	
	private JComboBox jComboBoxTipoContrato = null;

	private JComboBox jComboBoxSubtipoContrato = null;

	private JComboBox jComboBoxProcContratacion = null;

	private JComboBox jComboBoxSistemaContratacio = null;

	private JTextField jTextFieldObjetoContrato = null;

	private JComboBox jComboBoxCPV = null;

	private JLabel jLabelAnuncioPrevio = null;

	private JTextField jTextFieldFechaInicioProcAdj=null;
	
	private JComboBox<String> jComboBoxPais;
    private JComboBox<String> jComboBoxNuts;
    private JLabel lblLugarDeEjecucin;
 
	
	JFrame gestorVentanasFormPIN[] = new JFrame[4];
	
	ExpedienteBean expediente=new ExpedienteBean(); 
	
	private JLabel jLabelImporteSin = null;

	private JLabel jLabelImporteCon = null;

	private JTextField jTextFieldImporteCon = null;

	private JTextField jTextFieldImporteSin = null;

	private JButton jButtonPubOff = null;
	private JButton jButtonReceptorRecursos = null;
	private JLabel lblValorEstimadoDel;
	private JTextField jTextFieldValorEstimado;
	
	public ExpedienteBean getExpediente() {
		
		if (expediente==null){
			expediente = new ExpedienteBean();
		}
		
		expediente.setDirectivaAplicacion((String) jComboBoxDirectiva.getSelectedItem()); 
		expediente.setIdDirectivaAplicacion(jComboBoxDirectiva.getSelectedIndex());
		
		expediente.setNumExpediente(jTextFieldExpediente.getText());

		expediente.setTipoContrato((String) jComboBoxTipoContrato.getSelectedItem());
		expediente.setIdTipoContrato(jComboBoxTipoContrato.getSelectedIndex());

		expediente.setSubtipoContrato((String) jComboBoxSubtipoContrato.getSelectedItem());
		expediente.setIdSubtipoContrato(jComboBoxSubtipoContrato.getSelectedIndex());

		expediente.setObjetoContrato(jTextFieldObjetoContrato.getText());

		expediente.setProcContratacion((String) jComboBoxProcContratacion.getSelectedItem());
		expediente.setIdProcContratacion(jComboBoxProcContratacion.getSelectedIndex());
		
		expediente.setPais((String) jComboBoxPais.getSelectedItem());
		expediente.setIdPais(jComboBoxPais.getSelectedIndex());
		
		if (jComboBoxNuts.getSelectedIndex()>-1){
		String nutsSeleccionado = (String)jComboBoxNuts.getSelectedItem();
        expediente.setNuts(nutsSeleccionado.substring(0, nutsSeleccionado.lastIndexOf("(")-1));
        expediente.setIdNuts(nutsSeleccionado.substring(nutsSeleccionado.lastIndexOf("(")+1, nutsSeleccionado.length()-1));}


		
		Date fechaPrevIniProcAdj=null;
		if (jTextFieldFechaInicioProcAdj.getText().length()>0)
			try {
				fechaPrevIniProcAdj = new SimpleDateFormat("dd-MM-yyyy").parse(jTextFieldFechaInicioProcAdj.getText());
			} catch (ParseException e) {

				e.printStackTrace();
				System.out.println("Error en el formato de la fecha prevista de inicio del procedimiento");	
			}
		expediente.setFechaPrevIniProcAdj(fechaPrevIniProcAdj);

		expediente.setCpv((String) jComboBoxCPV.getSelectedItem());
		expediente.setIdCpv(jComboBoxCPV.getSelectedIndex());


		expediente.setImporteSinImpuestos(jTextFieldImporteSin.getText());
		expediente.setImporteConImpuestos(jTextFieldImporteCon.getText());
		expediente.setValorEstimado(jTextFieldValorEstimado.getText());
		
		
		SessionDataManager.getInstance().setExpediente(expediente);
		
		return expediente;
	}

	public void setExpediente(ExpedienteBean expediente) { 
		
		this.expediente = expediente;
	}

	public void cargarDatosComboBoxs() {
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTipoContrato, ConstantsGC.TENDERING_CONTRACT);
	
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxProcContratacion, ConstantsGC.TENDERING_PROCESS);
		jComboBoxProcContratacion.setSelectedIndex(1);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxCPV, ConstantsGC.CPV);  
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxPais, ConstantsGC.COUNTRY_CODE);
		
		//Cargo el primer valor de Directiva como no sujeto a regulacion armonizada
		jComboBoxDirectiva.addItem(ConstantsGC.NO_SARA);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxDirectiva, ConstantsGC.DIRECTIVA);
		
	}

	public AnuncioPrevioForm(JFrame ventanaPadre) throws ModelException {
		super();
		initialize();
		cargarDatosComboBoxs();
		
		gestorVentanasFormPIN[0] =ventanaPadre;
		gestorVentanasFormPIN[1] =null; 
		
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		jButtonPubOff.addActionListener(this);	
		jButtonReceptorRecursos.addActionListener(this);	
		
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosExpediente();
			}
		});
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosExpediente();
		}
	}
	
	
	/**
	 * La funcin rellena los datos del formulario a partir de los indicados en el objeto expediente.
	 * Los valores del objeto expediente son los que se han almacenado con anterioridad en session
	 */
	private void escribeDatosExpediente(){

		DateFormat df = new SimpleDateFormat("MM-dd-yyyy");
		
		jComboBoxDirectiva.setSelectedIndex(expediente.getIdDirectivaAplicacion());
		jTextFieldExpediente.setText(expediente.getNumExpediente());
		jComboBoxTipoContrato.setSelectedIndex(expediente.getIdTipoContrato());
		jComboBoxSubtipoContrato.setSelectedIndex(expediente.getIdSubtipoContrato());
		jTextFieldObjetoContrato.setText(expediente.getObjetoContrato());
		jComboBoxProcContratacion.setSelectedIndex(expediente.getIdProcContratacion());
		if (expediente.getFechaPrevIniProcAdj() != null){
			jTextFieldFechaInicioProcAdj.setText(df.format(expediente.getFechaPrevIniProcAdj()));
		}
		jTextFieldValorEstimado.setText(expediente.getValorEstimado());
		jTextFieldImporteSin.setText(expediente.getImporteSinImpuestos());
		jTextFieldImporteCon.setText(expediente.getImporteConImpuestos());
		jComboBoxCPV.setSelectedIndex(expediente.getIdCpv());
				
		jComboBoxPais.setSelectedIndex(expediente.getIdPais());
		jComboBoxNuts.setSelectedItem(expediente.getNuts() + " (" + expediente.getIdNuts() + ")");
		
	}
	


	private void initialize() {
		getJPanelContenido();
		this.setTitle("Servicio de Publicacin - Anuncio Previo");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}


	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelProcContratacion = new JLabel();
			jLabelProcContratacion.setText("Procedimiento Contratacin:");
			jLabelProcContratacion.setSize(new Dimension(250, 18));
			jLabelProcContratacion.setLocation(new Point(60, 276));
			jLabelObjetoContrato = new JLabel();
			jLabelObjetoContrato.setText("Objeto del contrato:");
			jLabelObjetoContrato.setLocation(new Point(60, 246));
			jLabelObjetoContrato.setSize(new Dimension(250, 18));
			jLabelSubTipoContrato = new JLabel();
			jLabelSubTipoContrato.setText("Subtipo de contrato:");
			jLabelSubTipoContrato.setSize(new Dimension(250, 18));
			jLabelSubTipoContrato.setLocation(new Point(60, 216));
			jLabelTipoContrato = new JLabel();
			jLabelTipoContrato.setText("Tipo de contrato:");
			jLabelTipoContrato.setLocation(new Point(60, 186));
			jLabelTipoContrato.setSize(new Dimension(250, 18));
			jLabelExpediente = new JLabel();
			jLabelExpediente.setText("Expediente:");
			jLabelExpediente.setLocation(new Point(60, 156));
			jLabelExpediente.setSize(new Dimension(250, 18));
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.add(jLabelExpediente, null); 
			jPanelContenido.add(getJTextFieldExpediente(), null);
			jPanelContenido.add(jLabelTipoContrato, null);
			jPanelContenido.add(getJComboBoxTipoContrato(), null);
			jPanelContenido.add(jLabelSubTipoContrato, null);
			jPanelContenido.add(jLabelObjetoContrato, null);
			jPanelContenido.add(jLabelProcContratacion, null);
			jPanelContenido.add(getJComboBoxSubtipoContrato(), null);
			jPanelContenido.add(getJComboBoxProcContratacion(), null);
			jPanelContenido.add(getJTextFieldObjetoContrato(), null);
			jPanelContenido.add(getJButtonPubOff(), null);
			
			getPanel().add(getSeleccionCPV());
			getPanel().add(getCodigoCVP());
			getPanel().add(getJComboBoxCPV());
			jLabelImporteSin = new JLabel();
			jLabelImporteSin.setBounds(56, 393, 246, 16);
			getPanel().add(jLabelImporteSin);
			jLabelImporteSin.setText("Importe Base (Sin impuestos)");
			jLabelImporteSin.setPreferredSize(new Dimension(246, 16));
			jLabelImporteCon = new JLabel();
			jLabelImporteCon.setBounds(56, 423, 246, 16);
			getPanel().add(jLabelImporteCon);
			jLabelImporteCon.setText("Importe Base (Con impuestos)");
			jLabelImporteCon.setPreferredSize(new Dimension(246, 16));
			getPanel().add(getJTextFieldImporteCon());
			getPanel().add(getJTextFieldImporteSin());
			getPanel().add(getLblValorEstimadoDel());
			getPanel().add(getJTextFieldValorEstimado());
			
	        getPanel().add(getJComboBoxNuts());
	        getPanel().add(getJComboBoxPais());
	        getPanel().add(getLblLugarDeEjecucin());
	            
			jComboBoxTipoContrato.addItemListener(new ComboListener(jComboBoxTipoContrato,jComboBoxSubtipoContrato));
			jComboBoxPais.addItemListener(new ComboListenerCountry(jComboBoxPais,jComboBoxNuts));
			
			jLabelAnuncioPrevio = new JLabel();
			jLabelAnuncioPrevio.setBounds(33, 75, 250, 18);
			getPanel().add(jLabelAnuncioPrevio);
			jLabelAnuncioPrevio.setFont(new Font("Dialog", Font.BOLD, 18));
			jLabelAnuncioPrevio.setText("Anuncio Previo");
			
			
			
			JLabel lblDirectivaDeAplicacin = new JLabel("Directiva de aplicaci\u00F3n");
			lblDirectivaDeAplicacin.setBounds(56, 120, 178, 14);
			getPanel().add(lblDirectivaDeAplicacin);
			getPanel().add(getLabelFechaAdj());
			getPanel().add(getFechaInicioProcAdj());
			getPanel().add(getJButtonReceptorRecuros());
			jPanelContenido.add(getJComboBoxDirectiva(),null);
		}
		return jPanelContenido;
	}

	private JComboBox getJComboBoxDirectiva(){
		if (jComboBoxDirectiva==null){
		jComboBoxDirectiva = new JComboBox();
		jComboBoxDirectiva.setBounds(326, 117, 378, 20);
		}
		return jComboBoxDirectiva;		
	}
	
	private JLabel getLabelFechaAdj() {
		if (jLabelFechaPrevAdj == null) {
			jLabelFechaPrevAdj = new JLabel();
			jLabelFechaPrevAdj.setBounds(56, 318, 250, 18);
			jLabelFechaPrevAdj.setText("Fecha prevista inicio del procedimiento:");
		}
		return jLabelFechaPrevAdj;

	}
	
	private JLabel getSeleccionCPV(){
		if (jLabelSelCPV==null){
			jLabelSelCPV = new JLabel();
			jLabelSelCPV.setBounds(56, 453, 250, 18);
			jLabelSelCPV.setText("Selecci\u00F3n del CPV");
		}
		return jLabelSelCPV;
	}
	
	private JLabel getCodigoCVP(){
		if (jLabelCodigoCPV==null){
			jLabelCodigoCPV = new JLabel(); 
			jLabelCodigoCPV.setBounds(86, 483, 220, 18);
			jLabelCodigoCPV.setText("Cdigo CPV");
		}
		return jLabelCodigoCPV;
	}
	
	private JComboBox getJComboBoxCPV() {
		if (jComboBoxCPV == null) {
			jComboBoxCPV = new JComboBox();
			jComboBoxCPV.setBounds(326, 483, 493, 18);
		}
		return jComboBoxCPV;
	} 
	private JTextField getFechaInicioProcAdj(){
		if (jTextFieldFechaInicioProcAdj == null) {
			jTextFieldFechaInicioProcAdj=new JTextField();
			jTextFieldFechaInicioProcAdj.setBounds(328, 318, 210, 18);
			SimpleDateFormat dateFormat;
			dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			jTextFieldFechaInicioProcAdj.setText(dateFormat.format(new Date()));
		}
		return jTextFieldFechaInicioProcAdj;
	}
	private JTextField getJTextFieldExpediente() {
		if (jTextFieldExpediente == null) {
			jTextFieldExpediente = new JTextField();
			jTextFieldExpediente.setSize(new Dimension(210, 18));
			jTextFieldExpediente.setLocation(new Point(330, 157));
		}
		return jTextFieldExpediente;
	}

	private JComboBox getJComboBoxTipoContrato() {
		if (jComboBoxTipoContrato == null) {
			jComboBoxTipoContrato = new JComboBox();
			jComboBoxTipoContrato.setLocation(new Point(330, 186));
			jComboBoxTipoContrato.setSize(new Dimension(210, 18));
		}
		return jComboBoxTipoContrato;
	}

	private JComboBox getJComboBoxSubtipoContrato() {
		if (jComboBoxSubtipoContrato == null) {
			jComboBoxSubtipoContrato = new JComboBox();
			jComboBoxSubtipoContrato.setLocation(new Point(330, 216));
			jComboBoxSubtipoContrato.setSize(new Dimension(493, 18));
		}
		return jComboBoxSubtipoContrato;
	}

	private JComboBox getJComboBoxProcContratacion() {
		if (jComboBoxProcContratacion == null) {
			jComboBoxProcContratacion = new JComboBox();
			jComboBoxProcContratacion.setLocation(new Point(330, 276));
			jComboBoxProcContratacion.setSize(new Dimension(210, 18));
		}
		return jComboBoxProcContratacion;
	}

	private JTextField getJTextFieldObjetoContrato() {
		if (jTextFieldObjetoContrato == null) {
			jTextFieldObjetoContrato = new JTextField();
			jTextFieldObjetoContrato.setLocation(new Point(330, 246));
			jTextFieldObjetoContrato.setSize(new Dimension(493, 18));
		}
		return jTextFieldObjetoContrato;
	}



	/**
	 * This method initializes jTextFieldImporteCon	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteCon() {
		if (jTextFieldImporteCon == null) {
			jTextFieldImporteCon = new JTextField();
			jTextFieldImporteCon.setBounds(326, 423, 210, 18);
			jTextFieldImporteCon.setPreferredSize(new Dimension(210, 18));
		}
		return jTextFieldImporteCon;
	}

	/**
	 * This method initializes jTextFieldImporteSin	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteSin() {
		if (jTextFieldImporteSin == null) {
			jTextFieldImporteSin = new JTextField();
			jTextFieldImporteSin.setBounds(326, 393, 210, 18);
			jTextFieldImporteSin.setPreferredSize(new Dimension(210, 18));
		}
		return jTextFieldImporteSin;
	}
	
	public void actionPerformed(ActionEvent e) {

		try {
			SessionDataManager.getInstance().setExpediente(getExpediente());
			if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {
				if (gestorVentanasFormPIN[1] == null) {
					this.setVisible(false);
					gestorVentanasFormPIN[1] = new GeneracionCODICEForm(this, TipoDocumento.PIN);
					gestorVentanasFormPIN[1].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormPIN[1].setVisible(true);
				}
			}
			if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_OFFICIAL_PUB)) {
				if (gestorVentanasFormPIN[2] == null) {
					this.setVisible(false);
					gestorVentanasFormPIN[2] = new PublicacionesOficialesForm(this, TipoDocumento.PIN);
					gestorVentanasFormPIN[2].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormPIN[2].setVisible(true);
				}
			} else if (e.getActionCommand().equalsIgnoreCase(Acciones.RECEPTOR_RECURSOS)) {
				if (gestorVentanasFormPIN[3] == null) {
					this.setVisible(false);
					gestorVentanasFormPIN[3] = new ReceptorRecurosForm(this, TipoDocumento.PIN);
					gestorVentanasFormPIN[3].setVisible(true);
				} else {
					this.setVisible(false);
					gestorVentanasFormPIN[3].setVisible(true);
				}
			} else if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
				this.setVisible(false);
				gestorVentanasFormPIN[0].setVisible(true);
			}

		} catch (ModelException e1) {
			e1.printStackTrace();
		}

	}

	/**
	 * This method initializes jButtonPubOff	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonPubOff() {
		if (jButtonPubOff == null) {
			jButtonPubOff = new JButton();
			jButtonPubOff.setText("Publicaciones oficiales");
			jButtonPubOff.setLocation(new Point(56, 600));
			jButtonPubOff.setSize(new Dimension(180, 18));
			jButtonPubOff.setActionCommand(Acciones.INIT_OFFICIAL_PUB);
		}
		return jButtonPubOff;
	}
	
	private JButton getJButtonReceptorRecuros() {
		if (jButtonReceptorRecursos == null) {
			jButtonReceptorRecursos = new JButton();
			jButtonReceptorRecursos.setBounds(261, 600, 180, 18);
			jButtonReceptorRecursos.setText("Receptor de recursos");
			jButtonReceptorRecursos.setActionCommand(Acciones.RECEPTOR_RECURSOS);
		}
		return jButtonReceptorRecursos;
	}
	
	

	private JLabel getLblValorEstimadoDel() {
		if (lblValorEstimadoDel == null) {
			lblValorEstimadoDel = new JLabel("Valor estimado del contrato");
			lblValorEstimadoDel.setBounds(58, 368, 210, 14);
		}
		return lblValorEstimadoDel;
	}
	private JTextField getJTextFieldValorEstimado() {
		if (jTextFieldValorEstimado == null) {
			jTextFieldValorEstimado = new JTextField();
			jTextFieldValorEstimado.setBounds(326, 365, 210, 20);
			jTextFieldValorEstimado.setColumns(10);
		}
		return jTextFieldValorEstimado;
	}
	
	private JComboBox getJComboBoxPais() {
      if (jComboBoxPais == null) {
          jComboBoxPais = new JComboBox();
          jComboBoxPais.setBounds(69, 550, 243, 18);
      }
      return jComboBoxPais;
  }
  private JComboBox getJComboBoxNuts() {
      if (jComboBoxNuts == null) {
          jComboBoxNuts = new JComboBox();
          jComboBoxNuts.setBounds(359, 550, 243, 18);
      }
      return jComboBoxNuts;
  }
  
  private JLabel getLblLugarDeEjecucin() {
    if (lblLugarDeEjecucin == null) {
        lblLugarDeEjecucin = new JLabel("Lugar de ejecuci\u00F3n");
        lblLugarDeEjecucin.setBounds(56, 525, 230, 14);
    }
    return lblLugarDeEjecucin;
}
}
