/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ComboListener;
import es.dgpe.place.client.components.ComboListenerCountry;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.windows.GeneracionCODICEForm;
import es.dgpe.place.client.windows.publication.service.commons.CondicionesEjecucionForm;
import es.dgpe.place.client.windows.publication.service.commons.CriteriosAdjudicacionForm;
import es.dgpe.place.client.windows.publication.service.commons.LotesForm;
import es.dgpe.place.client.windows.publication.service.commons.PublicacionesOficialesForm;
import es.dgpe.place.client.windows.publication.service.commons.ReceptorRecurosForm;

public class AnuncioRenunciaForm extends ThemeJFrame {


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;

	private JLabel jLabelExpediente = null;

	private JTextField jTextFieldExpediente = null;

	private JLabel jLabelTipoContrato = null;

	private JLabel jLabelSubTipoContrato = null;

	private JLabel jLabelObjetoContrato = null;

	private JLabel jLabelProcContratacion = null;

	private JLabel jLabelTipoTramitacin = null;

	private JLabel jLabelTramitacionGasto = null;

	private JLabel jLabelFechaPrevAdj = null;

	private JLabel jLabelSelCPV = null;

	private JLabel jLabelCodigoCPV = null;

	private JComboBox jComboBoxTipoContrato = null;

	private JComboBox jComboBoxSubtipoContrato = null;

	private JComboBox jComboBoxProcContratacion = null;

	private JComboBox jComboBoxTipoTramitacion = null;

	private JComboBox jComboBoxTramitacionGasto = null;
	
	private JComboBox<String> jComboBoxDirectiva = null;

	private JTextField jTextFieldObjetoContrato = null;

	private JComboBox jComboBoxCPV = null;

	private JLabel jLabelAnuncioLicitacion = null;
	
	private JLabel jLabelImporteSin = null;
	
	private JButton jButtonDuracionContrato = null;
	private JButton jButtonLotes;
	private JButton jButtonDiariosOficiales = null;

	private JLabel jLabelImporteCon = null;

	private JLabel jLabelClasificacion = null;

	private JLabel jLabelDescSolvencias = null;

	private JComboBox jComboBoxClasificacion = null;

	private JTextArea jTextAreaDescSolvencias = null;

	private JTextField jTextFieldImporteSin = null;

	private JTextField jTextFieldImporteCon = null;
	
	final JFileChooser fc = new JFileChooser();
	private JLabel lblValorEstimadoDel;
	private JTextField jTextFieldValorEstimado;
	
	private JTextArea textAreaAcuerdo;
	
	private JButton jButtonCriteriosAdjudicacion;
	private JButton jButtonReceptorRecursos = null;
	
	JFrame gestorVentanasFormCD[] = new JFrame[7];
	
	ExpedienteBean expediente=new ExpedienteBean();  //  @jve:decl-index=0:
	private JLabel lblNewLabel;
	
	private JRadioButton rdbtnDesierto= null;
	private JRadioButton rdbtnRenuncia= null;
	private JRadioButton rdbtnDesistimiento= null;
	private final ButtonGroup buttonGroup = new ButtonGroup();
	private JTextField textFieldFechaAcuerdo=null;
	private JLabel lblNmeroDeOfertas;
	private JTextField jTextFieldNumOfertasRecibidas;
	private JComboBox<String> jComboBoxPais;
	private JComboBox<String> jComboBoxNuts;
	private JLabel lblLugarDeEjecucin;
	
	public ExpedienteBean getExpediente() {
		
		if (expediente==null){
			expediente = new ExpedienteBean();
		}
		
		expediente.setDirectivaAplicacion((String) jComboBoxDirectiva.getSelectedItem()); 
		expediente.setIdDirectivaAplicacion(jComboBoxDirectiva.getSelectedIndex());
		expediente.setNumExpediente(jTextFieldExpediente.getText());

		expediente.setTipoContrato((String) jComboBoxTipoContrato.getSelectedItem());
		expediente.setIdTipoContrato(jComboBoxTipoContrato.getSelectedIndex());

		expediente.setSubtipoContrato((String) jComboBoxSubtipoContrato.getSelectedItem());
		expediente.setIdSubtipoContrato(jComboBoxSubtipoContrato.getSelectedIndex());

		expediente.setObjetoContrato(jTextFieldObjetoContrato.getText());

		expediente.setProcContratacion((String) jComboBoxProcContratacion.getSelectedItem());
		expediente.setIdProcContratacion(jComboBoxProcContratacion.getSelectedIndex());

		expediente.setTipoTramitacion((String) jComboBoxTipoTramitacion.getSelectedItem());
		expediente.setIdTipoTramitacion(jComboBoxTipoTramitacion.getSelectedIndex());

		expediente.setTipoTramitacionGasto((String) jComboBoxTramitacionGasto.getSelectedItem());
		expediente.setIdTipoTramitacionGasto(jComboBoxTramitacionGasto.getSelectedIndex());

		expediente.setCpv((String) jComboBoxCPV.getSelectedItem());
		expediente.setIdCpv(jComboBoxCPV.getSelectedIndex());
		
		expediente.setPais((String) jComboBoxPais.getSelectedItem());
		expediente.setIdPais(jComboBoxPais.getSelectedIndex());
		
		String nutsSeleccionado = (String)jComboBoxNuts.getSelectedItem();
        expediente.setNuts(nutsSeleccionado.substring(0, nutsSeleccionado.lastIndexOf("(")-1));
        expediente.setIdNuts(nutsSeleccionado.substring(nutsSeleccionado.lastIndexOf("(")+1, nutsSeleccionado.length()-1));

		expediente.setClasificacion(jComboBoxClasificacion.getSelectedIndex());
		expediente.setDescSolvencia(jTextAreaDescSolvencias.getText());
		expediente.setImporteSinImpuestos(jTextFieldImporteSin.getText());
		expediente.setImporteConImpuestos(jTextFieldImporteCon.getText());
		expediente.setValorEstimado(jTextFieldValorEstimado.getText());
		
		if (rdbtnDesierto.isSelected()) expediente.setTipoResolucion(TipoDocumento.DESIERTO);
		if (rdbtnRenuncia.isSelected()) expediente.setTipoResolucion(TipoDocumento.RENUNCIA);
		if (rdbtnDesistimiento.isSelected()) expediente.setTipoResolucion(TipoDocumento.DESISTIMIENTO);
		
		expediente.setTextoAcuerdo(textAreaAcuerdo.getText());
		
		Date fechaAcuerdo=null;
		if (textFieldFechaAcuerdo.getText().length()>0)
		try {
			fechaAcuerdo = new SimpleDateFormat("dd-MM-yyyy").parse(textFieldFechaAcuerdo.getText());
		} catch (ParseException e) {
			
			e.printStackTrace();
			System.out.println("Error en el formato de la fecha del acuerd");	
		}
		expediente.setFechaAcuerdo(fechaAcuerdo);
		
		if (!jTextFieldNumOfertasRecibidas.getText().isEmpty())
		expediente.setNumOfertasRecibidas(Integer.parseInt(jTextFieldNumOfertasRecibidas.getText()));
		
		
		SessionDataManager.getInstance().setExpediente(expediente);
		
		return expediente;
	}

	public void setAnuncioRenuncia(ExpedienteBean exp) { 
		
		this.expediente = exp;
	}

	public void cargarDatosComboBoxs() {
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTipoContrato, ConstantsGC.TENDERING_CONTRACT);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxProcContratacion, ConstantsGC.TENDERING_PROCESS);
		jComboBoxProcContratacion.setSelectedIndex(1);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTipoTramitacion, ConstantsGC.DILIGENCE);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTramitacionGasto, ConstantsGC.EXPENSE);
		ComboBoxUtils.loadComboBoxNoObligatorioFromConstant(jComboBoxClasificacion, ConstantsGC.BUSINESS_PROFILE_CODE);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxCPV, ConstantsGC.CPV);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxPais, ConstantsGC.COUNTRY_CODE);  
		//Cargo el primer valor de Directiva como no sujeto a regulacion armonizada
		jComboBoxDirectiva.addItem(ConstantsGC.NO_SARA);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxDirectiva, ConstantsGC.DIRECTIVA);
	}

	public AnuncioRenunciaForm(JFrame ventanaPadre) throws ModelException {
		super();
		initialize();
		cargarDatosComboBoxs();
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null;
		jButtonDuracionContrato.addActionListener(this);
		jButtonLotes.addActionListener(this); 
		jButtonCriteriosAdjudicacion.addActionListener(this);
		jButtonReceptorRecursos.addActionListener(this);	

		
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosExpediente();
		}
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosExpediente();
			}
		});
	}
	
	
	/**
	 * La funcin rellena los datos del formulario a partir de los indicados en el objeto expediente.
	 * Los valores del objeto expediente son los que se han almacenado con anterioridad en session
	 */
	private void escribeDatosExpediente(){
		
		
		DateFormat df = new SimpleDateFormat("MM-dd-yyyy");
		
		jComboBoxDirectiva.setSelectedIndex(expediente.getIdDirectivaAplicacion());
		jTextFieldExpediente.setText(expediente.getNumExpediente());
		jComboBoxTipoContrato.setSelectedIndex(expediente.getIdTipoContrato());
		jComboBoxSubtipoContrato.setSelectedIndex(expediente.getIdSubtipoContrato());
		jTextFieldObjetoContrato.setText(expediente.getObjetoContrato());
		jComboBoxProcContratacion.setSelectedIndex(expediente.getIdProcContratacion());
		jComboBoxTipoTramitacion.setSelectedIndex(expediente.getIdTipoTramitacion());
		jComboBoxTramitacionGasto.setSelectedIndex(expediente.getIdTipoTramitacionGasto());
		jTextFieldValorEstimado.setText(expediente.getValorEstimado());
		jTextFieldImporteSin.setText(expediente.getImporteSinImpuestos());
		jTextFieldImporteCon.setText(expediente.getImporteConImpuestos());
		
		
		jComboBoxCPV.setSelectedIndex(expediente.getIdCpv());
		jComboBoxClasificacion.setSelectedIndex(expediente.getClasificacion());
		jTextAreaDescSolvencias.setText(expediente.getDescSolvencia());
		
		jComboBoxPais.setSelectedIndex(expediente.getIdPais());
		jComboBoxNuts.setSelectedItem(expediente.getNuts() + " (" + expediente.getIdNuts() + ")");
		
		rdbtnDesierto.setSelected(false);
		rdbtnRenuncia.setSelected(false);
		rdbtnDesistimiento.setSelected(false);
		if (expediente.getTipoResolucion() != null) {
			if (expediente.getTipoResolucion().equals(TipoDocumento.DESIERTO)) {
				rdbtnDesierto.setSelected(true);
			} else if (expediente.getTipoResolucion().equals(TipoDocumento.RENUNCIA)) {
				rdbtnRenuncia.setSelected(true);
			} else {
				rdbtnDesistimiento.setSelected(true);
			}
		}
		
		textAreaAcuerdo.setText(expediente.getTextoAcuerdo());
		
		if (expediente.getFechaAcuerdo() != null){
			textFieldFechaAcuerdo.setText(df.format(expediente.getFechaAcuerdo()));
		}
		
		if (expediente.getNumOfertasRecibidas() != null){
			jTextFieldNumOfertasRecibidas.setText(expediente.getNumOfertasRecibidas().toString());
		}
	}

	private void initialize() {
		 
		getJPanelContenido();
		
		this.setTitle("Servicio de Publicaci\u00F3n - Anuncio de Desierto, Renuncia, Desistimiento");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	 
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelAnuncioLicitacion = new JLabel();
			jLabelAnuncioLicitacion.setFont(new Font("Dialog", Font.BOLD, 18));
			jLabelAnuncioLicitacion.setLocation(new Point(17, 77));
			jLabelAnuncioLicitacion.setSize(new Dimension(461, 18));
			jLabelAnuncioLicitacion.setText("Anuncio de Renuncia, Desierto, Desistimiento");
			jLabelTramitacionGasto = new JLabel();
			jLabelTramitacionGasto.setText("Tramitacin Gasto:");
			jLabelTramitacionGasto.setSize(new Dimension(250, 18));
			jLabelTramitacionGasto.setLocation(new Point(63, 279));
			jLabelTipoTramitacin = new JLabel();
			jLabelTipoTramitacin.setText("Tipo  Tramitacin:");
			jLabelTipoTramitacin.setSize(new Dimension(250, 18));
			jLabelTipoTramitacin.setLocation(new Point(63, 254));
			jLabelProcContratacion = new JLabel();
			jLabelProcContratacion.setText("Procedimiento Contratacin:");
			jLabelProcContratacion.setSize(new Dimension(250, 18));
			jLabelProcContratacion.setLocation(new Point(63, 234));
			jLabelObjetoContrato = new JLabel();
			jLabelObjetoContrato.setText("Objeto del contrato:");
			jLabelObjetoContrato.setLocation(new Point(63, 209));
			jLabelObjetoContrato.setSize(new Dimension(250, 18));
			jLabelSubTipoContrato = new JLabel();
			jLabelSubTipoContrato.setText("Subtipo de contrato:");
			jLabelSubTipoContrato.setSize(new Dimension(250, 18));
			jLabelSubTipoContrato.setLocation(new Point(63, 184));
			jLabelTipoContrato = new JLabel();
			jLabelTipoContrato.setText("Tipo de contrato:");
			jLabelTipoContrato.setLocation(new Point(63, 159));
			jLabelTipoContrato.setSize(new Dimension(250, 18));
			jLabelExpediente = new JLabel();
			jLabelExpediente.setText("Expediente:");
			jLabelExpediente.setLocation(new Point(62, 134));
			jLabelExpediente.setSize(new Dimension(250, 18));
			getPanel().add(getJButtonCriteriosAdjudicacion());
			getPanel().add(getJButtonDiariosOficiales());
			jButtonDiariosOficiales.addActionListener(this);
			
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.add(jLabelExpediente, null); 
			jPanelContenido.add(getJTextFieldExpediente(), null);
			jPanelContenido.add(jLabelTipoContrato, null);
			jPanelContenido.add(getJComboBoxTipoContrato(), null);
			jPanelContenido.add(jLabelSubTipoContrato, null);
			jPanelContenido.add(jLabelObjetoContrato, null);
			jPanelContenido.add(jLabelProcContratacion, null);
			jPanelContenido.add(jLabelTipoTramitacin, null);
			jPanelContenido.add(jLabelTramitacionGasto, null);
			jPanelContenido.add(getJComboBoxSubtipoContrato(), null);
			jPanelContenido.add(getJComboBoxProcContratacion(), null);
			jPanelContenido.add(getJComboBoxTipoTramitacion(), null);
			jPanelContenido.add(getJComboBoxTramitacionGasto(), null);
			jPanelContenido.add(getJTextFieldObjetoContrato(), null);

			jPanelContenido.add(jLabelAnuncioLicitacion, null);
			getPanel().add(getJButtonLotes());
	        getPanel().add(getJButtonReceptorRecuros());
			
			getPanel().add(getJComboBoxClasificacion());
			getPanel().add(getJTextAreaDescSolvencias());
			getPanel().add(getJTextFieldImporteSin());
			getPanel().add(getJTextFieldImporteCon());
			getPanel().add(getLblValorEstimadoDel());
			getPanel().add(getJTextFieldValorEstimado());
			jLabelSelCPV = new JLabel();
			jLabelSelCPV.setBounds(63, 420, 250, 18);
			getPanel().add(jLabelSelCPV);
			jLabelSelCPV.setText("Seleccin del CPV");
			jLabelCodigoCPV = new JLabel();
			jLabelCodigoCPV.setBounds(93, 440, 220, 18);
			getPanel().add(jLabelCodigoCPV);
			jLabelCodigoCPV.setText("Cdigo CPV");
			getPanel().add(getJComboBoxCPV());
			jLabelImporteSin = new JLabel();
			jLabelImporteSin.setBounds(63, 370, 250, 18);
			getPanel().add(jLabelImporteSin);
			jLabelImporteSin.setText("Importe Base (Sin impuestos)");
			jLabelImporteCon = new JLabel();
			jLabelImporteCon.setBounds(63, 395, 250, 18);
			getPanel().add(jLabelImporteCon);
			jLabelImporteCon.setText("Importe Base (Con impuestos)");
			jLabelClasificacion = new JLabel();
			jLabelClasificacion.setBounds(63, 465, 250, 18);
			getPanel().add(jLabelClasificacion);
			jLabelClasificacion.setText("Clasificacin:");
			jLabelDescSolvencias = new JLabel();
			jLabelDescSolvencias.setBounds(63, 490, 250, 18);
			getPanel().add(jLabelDescSolvencias);
			jLabelDescSolvencias.setText("Descripcin de solvencias:");
			getPanel().add(getLblNewLabel());
			
			 
			buttonGroup.add(getRdbtnDesierto());
			getPanel().add(getRdbtnDesierto());
			
			buttonGroup.add(getRdbtnRenuncia());
			getPanel().add(getRdbtnRenuncia());
			
			buttonGroup.add(getRdbtnDesistimiento());
			getPanel().add(getRdbtnDesistimiento());
			
			JLabel lblTextoDelAcuerdo = new JLabel();
			lblTextoDelAcuerdo.setText("Texto del acuerdo");
			lblTextoDelAcuerdo.setBounds(63, 634, 250, 18);
			getPanel().add(lblTextoDelAcuerdo);
			
			getPanel().add(getTextAreaAcuerdo());
			
			JLabel lblFechaDelAcuerdo = new JLabel();
			lblFechaDelAcuerdo.setText("Fecha del acuerdo (dd-mm-aaaa)");
			lblFechaDelAcuerdo.setBounds(63, 605, 250, 18);
			getPanel().add(lblFechaDelAcuerdo);
			
			
			getPanel().add(getTextFieldFechaAcuerdo());
			getPanel().add(getLblNmeroDeOfertas());
			getPanel().add(getJTextFieldNumOfertasRecibidas());
			
			getPanel().add(getJButtonDuracionContrato());
			getPanel().add(getJComboBoxPais());
			getPanel().add(getJComboBoxNuts());
			getPanel().add(getLblLugarDeEjecucin());
			
			
			jComboBoxTipoContrato.addItemListener(new ComboListener(jComboBoxTipoContrato,jComboBoxSubtipoContrato));
			jComboBoxPais.addItemListener(new ComboListenerCountry(jComboBoxPais,jComboBoxNuts));
			
			JLabel lblDirectivaDeAplicacin = new JLabel("Directiva de aplicaci\u00F3n");
			lblDirectivaDeAplicacin.setBounds(62, 110, 178, 14);
			getPanel().add(lblDirectivaDeAplicacin);
			jPanelContenido.add(getJComboBoxDirectiva(),null);		
		}
		return jPanelContenido;
	}
	
	private JComboBox getJComboBoxDirectiva(){
		if (jComboBoxDirectiva==null){
		jComboBoxDirectiva = new JComboBox();
		jComboBoxDirectiva.setBounds(333, 105, 378, 20);
		}
		return jComboBoxDirectiva;		
	}

	private JTextField getTextFieldFechaAcuerdo(){
		if (textFieldFechaAcuerdo==null){	
			textFieldFechaAcuerdo = new JTextField();
			SimpleDateFormat dateFormat;
			dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			textFieldFechaAcuerdo.setText(dateFormat.format(new Date()));
			textFieldFechaAcuerdo.setBounds(333, 605, 116, 18);
		}
		return textFieldFechaAcuerdo;
	}
	
	private JRadioButton getRdbtnDesierto(){
		if (rdbtnDesierto==null){
			rdbtnDesierto = new JRadioButton("Desierto");
			rdbtnDesierto.setBackground(Color.WHITE);
			rdbtnDesierto.setBounds(333, 568, 109, 23);
		}
		return rdbtnDesierto;
	}
	
	private JRadioButton getRdbtnRenuncia(){
		if (rdbtnRenuncia==null){
			rdbtnRenuncia = new JRadioButton("Renuncia");
			rdbtnRenuncia.setBackground(Color.WHITE);
			rdbtnRenuncia.setBounds(480, 568, 109, 23);
		}
		return rdbtnRenuncia;
	}
	
	private JRadioButton getRdbtnDesistimiento(){
		if (rdbtnDesistimiento==null){
			rdbtnDesistimiento = new JRadioButton("Desistimiento");
			rdbtnDesistimiento.setBackground(Color.WHITE);
			rdbtnDesistimiento.setBounds(644, 568, 109, 23);
		}
		return rdbtnDesistimiento;
	}
	
	private JTextArea getTextAreaAcuerdo() {
		if (textAreaAcuerdo == null) {
			textAreaAcuerdo = new JTextArea();
			textAreaAcuerdo.setBackground(SystemColor.menu);
			textAreaAcuerdo.setBounds(333, 634, 493, 50);
		}
		return textAreaAcuerdo;
	}
	
	private JTextField getJTextFieldExpediente() {
		if (jTextFieldExpediente == null) {
			jTextFieldExpediente = new JTextField();
			jTextFieldExpediente.setSize(new Dimension(210, 18));
			jTextFieldExpediente.setLocation(new Point(333, 134));
		}
		return jTextFieldExpediente;
	}

	private JComboBox getJComboBoxTipoContrato() {
		if (jComboBoxTipoContrato == null) {
			jComboBoxTipoContrato = new JComboBox();
			jComboBoxTipoContrato.setLocation(new Point(333, 159));
			jComboBoxTipoContrato.setSize(new Dimension(210, 18));
		}
		return jComboBoxTipoContrato;
	}

	private JComboBox getJComboBoxSubtipoContrato() {
		if (jComboBoxSubtipoContrato == null) {
			jComboBoxSubtipoContrato = new JComboBox();
			jComboBoxSubtipoContrato.setLocation(new Point(333, 184));
			jComboBoxSubtipoContrato.setSize(new Dimension(493, 18));
		}
		return jComboBoxSubtipoContrato;
	}

	private JComboBox getJComboBoxProcContratacion() {
		if (jComboBoxProcContratacion == null) {
			jComboBoxProcContratacion = new JComboBox();
			jComboBoxProcContratacion.setLocation(new Point(333, 234));
			jComboBoxProcContratacion.setSize(new Dimension(210, 18));
		}
		return jComboBoxProcContratacion;
	}


	private JComboBox getJComboBoxTipoTramitacion() {
		if (jComboBoxTipoTramitacion == null) {
			jComboBoxTipoTramitacion = new JComboBox();
			jComboBoxTipoTramitacion.setLocation(new Point(333, 254));
			jComboBoxTipoTramitacion.setSize(new Dimension(210, 18));
		}
		return jComboBoxTipoTramitacion;
	}

	private JComboBox getJComboBoxTramitacionGasto() {
		if (jComboBoxTramitacionGasto == null) {
			jComboBoxTramitacionGasto = new JComboBox();
			jComboBoxTramitacionGasto.setLocation(new Point(333, 279));
			jComboBoxTramitacionGasto.setSize(new Dimension(210, 18));
		}
		return jComboBoxTramitacionGasto;
	}

	private JTextField getJTextFieldObjetoContrato() {
		if (jTextFieldObjetoContrato == null) {
			jTextFieldObjetoContrato = new JTextField();
			jTextFieldObjetoContrato.setLocation(new Point(333, 209));
			jTextFieldObjetoContrato.setSize(new Dimension(493, 18));
		}
		return jTextFieldObjetoContrato;
	}

	private JComboBox getJComboBoxCPV() {
		if (jComboBoxCPV == null) {
			jComboBoxCPV = new JComboBox();
			jComboBoxCPV.setBounds(333, 440, 493, 18);
		}
		return jComboBoxCPV;
	}


	/**
	 * This method initializes jComboBoxClasificacion	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBoxClasificacion() {
		if (jComboBoxClasificacion == null) {
			jComboBoxClasificacion = new JComboBox();
			jComboBoxClasificacion.setBounds(333, 465, 493, 18);
		}
		return jComboBoxClasificacion;
	}

	/**
	 * This method initializes jTextAreaDescSolvencias	
	 * 	
	 * @return javax.swing.JTextArea	
	 */
	private JTextArea getJTextAreaDescSolvencias() {
		if (jTextAreaDescSolvencias == null) {
			jTextAreaDescSolvencias = new JTextArea();
			jTextAreaDescSolvencias.setBounds(333, 490, 493, 50);
			jTextAreaDescSolvencias.setBackground(SystemColor.control);
		}
		return jTextAreaDescSolvencias;
	}

	/**
	 * This method initializes jTextFieldImporteSin	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteSin() {
		if (jTextFieldImporteSin == null) {
			jTextFieldImporteSin = new JTextField();
			jTextFieldImporteSin.setBounds(333, 370, 210, 18);
		}
		return jTextFieldImporteSin;
	}

	/**
	 * This method initializes jTextFieldImporteCon	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteCon() {
		if (jTextFieldImporteCon == null) {
			jTextFieldImporteCon = new JTextField();
			jTextFieldImporteCon.setBounds(333, 395, 210, 18);
		}
		return jTextFieldImporteCon;
	}

	public void actionPerformed(ActionEvent e) {

		try{
			SessionDataManager.getInstance().setExpediente(getExpediente());
		
		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			gestorVentanasFormCD[0].setVisible(true);
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {
			
			if (gestorVentanasFormCD[1] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[1] = new GeneracionCODICEForm(this,TipoDocumento.RENUNCIA); 
				gestorVentanasFormCD[1].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[1].setVisible(true);
			}
		
		}
		else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_DURACION)) {
			if (gestorVentanasFormCD[2] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[2] = new CondicionesEjecucionForm(this,TipoDocumento.RENUNCIA);
				gestorVentanasFormCD[2].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[2].setVisible(true);
			}
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_LOTES)) {
			if (gestorVentanasFormCD[3] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[3] = new LotesForm(this,TipoDocumento.RENUNCIA);
				gestorVentanasFormCD[3].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[3].setVisible(true);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_CRITERIOS_ADJUDICACION)) {
			if (gestorVentanasFormCD[4] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[4] = new CriteriosAdjudicacionForm(this,TipoDocumento.RENUNCIA);
				gestorVentanasFormCD[4].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[4].setVisible(true);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.RECEPTOR_RECURSOS)) {
			if (gestorVentanasFormCD[5] == null) {
				this.setVisible(false);
				gestorVentanasFormCD[5] = new ReceptorRecurosForm(this, TipoDocumento.RENUNCIA);
				gestorVentanasFormCD[5].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[5].setVisible(true);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_OFFICIAL_PUB)) {
			if (gestorVentanasFormCD[6] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[6] = new PublicacionesOficialesForm(this,TipoDocumento.RENUNCIA); 
				gestorVentanasFormCD[6].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[6].setVisible(true);
			}
		}
		} catch (ModelException e1){
			e1.printStackTrace();
		}

	}
	
	private JLabel getLblValorEstimadoDel() {
		if (lblValorEstimadoDel == null) {
			lblValorEstimadoDel = new JLabel("Valor estimado del contrato");
			lblValorEstimadoDel.setBounds(63, 345, 230, 14);
		}
		return lblValorEstimadoDel;
	}
	
	private JTextField getJTextFieldValorEstimado() {
		if (jTextFieldValorEstimado == null) {
			jTextFieldValorEstimado = new JTextField();
			jTextFieldValorEstimado.setBounds(333, 339, 210, 20);
			jTextFieldValorEstimado.setColumns(10);
		}
		return jTextFieldValorEstimado;
	}
	
	private JLabel getLblNewLabel() {
		if (lblNewLabel == null) {
			lblNewLabel = new JLabel("Resultado del procedimiento");
			lblNewLabel.setBounds(63, 568, 167, 14);
		}
		return lblNewLabel;
	}
	private JLabel getLblNmeroDeOfertas() {
		if (lblNmeroDeOfertas == null) {
			lblNmeroDeOfertas = new JLabel("N\u00FAmero de ofertas recibidas");
			lblNmeroDeOfertas.setBounds(480, 607, 210, 14);
		}
		return lblNmeroDeOfertas;
	}
	private JTextField getJTextFieldNumOfertasRecibidas() {
		if (jTextFieldNumOfertasRecibidas == null) {
			jTextFieldNumOfertasRecibidas = new JTextField();
			jTextFieldNumOfertasRecibidas.setBounds(644, 603, 86, 20);
			jTextFieldNumOfertasRecibidas.setColumns(10);
		}
		return jTextFieldNumOfertasRecibidas;
	}
	
	private JButton getJButtonDuracionContrato() {
		if (jButtonDuracionContrato == null) {
			jButtonDuracionContrato = new JButton();
			jButtonDuracionContrato.setText("Duraci\u00F3n del contrato");
			jButtonDuracionContrato.setActionCommand(Acciones.EDIT_DURACION);
			jButtonDuracionContrato.setBounds(620, 231, 222, 18);
					}
		return jButtonDuracionContrato;
	}
	private JComboBox getJComboBoxPais() {
		if (jComboBoxPais == null) {
			jComboBoxPais = new JComboBox();
			jComboBoxPais.setBounds(593, 369, 243, 18);
		}
		return jComboBoxPais;
	}
	private JComboBox getJComboBoxNuts() {
		if (jComboBoxNuts == null) {
			jComboBoxNuts = new JComboBox();
			jComboBoxNuts.setBounds(593, 394, 243, 18);
		}
		return jComboBoxNuts;
	}
	private JLabel getLblLugarDeEjecucin() {
		if (lblLugarDeEjecucin == null) {
			lblLugarDeEjecucin = new JLabel("Lugar de ejecuci\u00F3n");
			lblLugarDeEjecucin.setBounds(565, 355, 230, 14);
		}
		return lblLugarDeEjecucin;
	}
	
	private JButton getJButtonLotes() {
		if (jButtonLotes == null) {
			jButtonLotes = new JButton();
			jButtonLotes.setText("Lotes");
			jButtonLotes.setActionCommand(Acciones.EDIT_LOTES);
			jButtonLotes.setBounds(620, 255, 221, 18);
		}
		return jButtonLotes;
	}
	
	private JButton getJButtonCriteriosAdjudicacion() {
		if (jButtonCriteriosAdjudicacion == null) {
			jButtonCriteriosAdjudicacion = new JButton();
			jButtonCriteriosAdjudicacion.setText("Criterios de adjudicaci\u00F3n");
			jButtonCriteriosAdjudicacion.setFont(new Font("Tahoma", Font.PLAIN, 11));
			jButtonCriteriosAdjudicacion.setActionCommand(Acciones.EDIT_CRITERIOS_ADJUDICACION);
			jButtonCriteriosAdjudicacion.setBounds(620, 276, 220, 18);
		}
		return jButtonCriteriosAdjudicacion;
	}
	
	private JButton getJButtonReceptorRecuros() {
		if (jButtonReceptorRecursos == null) {
			jButtonReceptorRecursos = new JButton();
			jButtonReceptorRecursos.setBounds(620, 298, 221, 18);
			jButtonReceptorRecursos.setText("Receptor de recursos");
			jButtonReceptorRecursos.setActionCommand(Acciones.RECEPTOR_RECURSOS);
		}
		return jButtonReceptorRecursos;
	}
	
	private JButton getJButtonDiariosOficiales() {
		if (jButtonDiariosOficiales == null) {
			jButtonDiariosOficiales = new JButton();
			jButtonDiariosOficiales.setBounds(620, 327, 220, 18);
			jButtonDiariosOficiales.setText("Publicacion en diarios oficiales");
			jButtonDiariosOficiales.setActionCommand(Acciones.INIT_OFFICIAL_PUB);
		
		}
		return jButtonDiariosOficiales;
	}
}
