/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ComboListener;
import es.dgpe.place.client.components.ComboListenerCountry;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.windows.GeneracionCODICEForm;
import es.dgpe.place.client.windows.publication.service.commons.AdjudicatarioForm;
import es.dgpe.place.client.windows.publication.service.commons.CondicionesEjecucionForm;

public class ContratoMenorForm extends ThemeJFrame {


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;

	private JLabel jLabelExpediente = null;

	private JTextField jTextFieldExpediente = null;

	private JLabel jLabelTipoContrato = null;

	private JLabel jLabelSubTipoContrato = null;

	private JLabel jLabelObjetoContrato = null;

	private JComboBox jComboBoxTipoContrato = null;

	private JComboBox jComboBoxSubtipoContrato = null;

	private JTextField jTextFieldObjetoContrato = null;

	private JLabel jLabelAnuncio = null;
	
	private JLabel jLabelImporteSin = null;

	private JLabel jLabelImporteCon = null;

	private JTextField jTextFieldImporteSin = null;

	private JTextField jTextFieldImporteCon = null;

	private JButton jButtonLicitador = null;
	private JButton jButtonDuracionContrato = null;
	
	private JComboBox<String> jComboBoxPais;
    private JComboBox<String> jComboBoxNuts;
	
	final JFileChooser fc = new JFileChooser();
	
	JFrame gestorVentanasFormCD[] = new JFrame[5];
	
	ExpedienteBean expediente=new ExpedienteBean();  //  @jve:decl-index=0:

	

	public ExpedienteBean getExpediente() {
		
		if (expediente==null){
			expediente = new ExpedienteBean();
		}
		
		expediente.setNumExpediente(jTextFieldExpediente.getText());

		expediente.setTipoContrato((String) jComboBoxTipoContrato.getSelectedItem());
		expediente.setIdTipoContrato(jComboBoxTipoContrato.getSelectedIndex());

		expediente.setSubtipoContrato((String) jComboBoxSubtipoContrato.getSelectedItem());
		expediente.setIdSubtipoContrato(jComboBoxSubtipoContrato.getSelectedIndex());

		expediente.setObjetoContrato(jTextFieldObjetoContrato.getText());

		expediente.setImporteSinImpuestos(jTextFieldImporteSin.getText());
		expediente.setImporteConImpuestos(jTextFieldImporteCon.getText());
		
		expediente.setPais((String) jComboBoxPais.getSelectedItem());
        expediente.setIdPais(jComboBoxPais.getSelectedIndex());
        
        String nutsSeleccionado = (String)jComboBoxNuts.getSelectedItem();
        if (nutsSeleccionado != null){
        	expediente.setNuts(nutsSeleccionado.substring(0, nutsSeleccionado.lastIndexOf("(")-1));
        	expediente.setIdNuts(nutsSeleccionado.substring(nutsSeleccionado.lastIndexOf("(")+1, nutsSeleccionado.length()-1));
        }
        	
		SessionDataManager.getInstance().setExpediente(expediente);
		
		return expediente;
	}

	public void setExpediente(ExpedienteBean exp) { 
		
		this.expediente = exp;
	}

	public void cargarDatosComboBoxs() {
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTipoContrato, ConstantsGC.TENDERING_CONTRACT);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxPais, ConstantsGC.COUNTRY_CODE);

	}

	public ContratoMenorForm(JFrame ventanaPadre) throws ModelException {
		super();
		initialize();
		cargarDatosComboBoxs();
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null;
		jButtonDuracionContrato.addActionListener(this);

		
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosExpediente();
		}
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosExpediente();
			}
		});
		
	}
	
	/**
	 * La funcin rellena los datos del formulario a partir de los indicados en el objeto expediente.
	 * Los valores del objeto expediente son los que se han almacenado con anterioridad en session
	 */
	private void escribeDatosExpediente(){
		
		jTextFieldExpediente.setText(expediente.getNumExpediente());
		jComboBoxTipoContrato.setSelectedIndex(expediente.getIdTipoContrato());
		jComboBoxSubtipoContrato.setSelectedIndex(expediente.getIdSubtipoContrato());
		jTextFieldObjetoContrato.setText(expediente.getObjetoContrato());
		jTextFieldImporteSin.setText(expediente.getImporteSinImpuestos());
		jTextFieldImporteCon.setText(expediente.getImporteConImpuestos());
		jComboBoxPais.setSelectedIndex(expediente.getIdPais());
		jComboBoxNuts.setSelectedItem(expediente.getNuts() + " (" + expediente.getIdNuts() + ")");
	
	}
	
	

	private void initialize() {
		 
		getJPanelContenido();
		
		this.setTitle("Servicio de Publicaci\u00F3n - Anuncio de Adjudicaci\u00F3n Contrato Menor");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	 
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelAnuncio = new JLabel();
			jLabelAnuncio.setFont(new Font("Dialog", Font.BOLD, 18));
			jLabelAnuncio.setLocation(new Point(17, 77));
			jLabelAnuncio.setSize(new Dimension(250, 18));
			jLabelAnuncio.setText("Contrato Menor");
			jLabelObjetoContrato = new JLabel();
			jLabelObjetoContrato.setText("Objeto del contrato:");
			jLabelObjetoContrato.setLocation(new Point(63, 179));
			jLabelObjetoContrato.setSize(new Dimension(250, 18));
			jLabelSubTipoContrato = new JLabel();
			jLabelSubTipoContrato.setText("Subtipo de contrato:");
			jLabelSubTipoContrato.setSize(new Dimension(250, 18));
			jLabelSubTipoContrato.setLocation(new Point(63, 154));
			jLabelTipoContrato = new JLabel();
			jLabelTipoContrato.setText("Tipo de contrato:");
			jLabelTipoContrato.setLocation(new Point(63, 129));
			jLabelTipoContrato.setSize(new Dimension(250, 18));
			jLabelExpediente = new JLabel();
			jLabelExpediente.setText("Expediente:");
			jLabelExpediente.setLocation(new Point(62, 104));
			jLabelExpediente.setSize(new Dimension(250, 18));
			
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.add(jLabelExpediente, null); 
			jPanelContenido.add(getJTextFieldExpediente(), null);
			jPanelContenido.add(jLabelTipoContrato, null);
			jPanelContenido.add(getJComboBoxTipoContrato(), null);
			jPanelContenido.add(jLabelSubTipoContrato, null);
			jPanelContenido.add(jLabelObjetoContrato, null);
			jPanelContenido.add(getJComboBoxSubtipoContrato(), null);
			jPanelContenido.add(getJTextFieldObjetoContrato(), null);
			getPanel().add(getJButtonDuracionContrato());

			getPanel().add(getJButtonLicitador());
			
			jPanelContenido.add(jLabelAnuncio, null);
			getPanel().add(getJTextFieldImporteSin());
			getPanel().add(getJTextFieldImporteCon());
			jButtonLicitador.addActionListener(this);
			jLabelImporteSin = new JLabel();
			jLabelImporteSin.setBounds(77, 264, 250, 18);
			getPanel().add(jLabelImporteSin);
			jLabelImporteSin.setText("Importe Base (Sin impuestos)");
			jLabelImporteCon = new JLabel();
			jLabelImporteCon.setBounds(77, 293, 250, 18);
			getPanel().add(jLabelImporteCon);
			jLabelImporteCon.setText("Importe Base (Con impuestos)");
			
			JLabel lblPresupuestoBase = new JLabel("Presupuesto Base");
			lblPresupuestoBase.setFont(new Font("Tahoma", Font.BOLD, 13));
			lblPresupuestoBase.setBounds(63, 239, 198, 14);
			getPanel().add(lblPresupuestoBase);
			
			JLabel label = new JLabel("Lugar de ejecuci\u00F3n");
			label.setFont(new Font("Tahoma", Font.BOLD, 11));
			label.setBounds(63, 336, 230, 14);
			getPanel().add(label);

			getPanel().add(getJComboBoxNuts());
	        getPanel().add(getJComboBoxPais());
			jComboBoxPais.addItemListener(new ComboListenerCountry(jComboBoxPais,jComboBoxNuts));
			
			
			
			
			jComboBoxTipoContrato.addItemListener(new ComboListener(jComboBoxTipoContrato,jComboBoxSubtipoContrato));
								
		}
		return jPanelContenido;
	}
	
	private JButton getJButtonDuracionContrato() {
		if (jButtonDuracionContrato == null) {
			jButtonDuracionContrato = new JButton();
			jButtonDuracionContrato.setText("Duraci\u00F3n del contrato");
			jButtonDuracionContrato.setActionCommand(Acciones.EDIT_DURACION);
			jButtonDuracionContrato.setBounds(63, 409, 180, 18);
					}
		return jButtonDuracionContrato;
	}
	
	private JTextField getJTextFieldExpediente() {
		if (jTextFieldExpediente == null) {
			jTextFieldExpediente = new JTextField();
			jTextFieldExpediente.setSize(new Dimension(210, 18));
			jTextFieldExpediente.setLocation(new Point(333, 104));
		}
		return jTextFieldExpediente;
	}

	private JComboBox getJComboBoxTipoContrato() {
		if (jComboBoxTipoContrato == null) {
			jComboBoxTipoContrato = new JComboBox();
			jComboBoxTipoContrato.setLocation(new Point(333, 129));
			jComboBoxTipoContrato.setSize(new Dimension(210, 18));
		}
		return jComboBoxTipoContrato;
	}

	private JComboBox getJComboBoxSubtipoContrato() {
		if (jComboBoxSubtipoContrato == null) {
			jComboBoxSubtipoContrato = new JComboBox();
			jComboBoxSubtipoContrato.setLocation(new Point(333, 154));
			jComboBoxSubtipoContrato.setSize(new Dimension(493, 18));
		}
		return jComboBoxSubtipoContrato;
	}

	private JTextField getJTextFieldObjetoContrato() {
		if (jTextFieldObjetoContrato == null) {
			jTextFieldObjetoContrato = new JTextField();
			jTextFieldObjetoContrato.setLocation(new Point(333, 179));
			jTextFieldObjetoContrato.setSize(new Dimension(493, 18));
		}
		return jTextFieldObjetoContrato;
	}

	/**
	 * This method initializes jTextFieldImporteSin	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteSin() {
		if (jTextFieldImporteSin == null) {
			jTextFieldImporteSin = new JTextField();
			jTextFieldImporteSin.setBounds(337, 264, 210, 18);
		}
		return jTextFieldImporteSin;
	}

	/**
	 * This method initializes jTextFieldImporteCon	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteCon() {
		if (jTextFieldImporteCon == null) {
			jTextFieldImporteCon = new JTextField();
			jTextFieldImporteCon.setBounds(337, 293, 210, 18);
		}
		return jTextFieldImporteCon;
	}

	/**
	 * This method initializes jButtonLicitador	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonLicitador() {
		if (jButtonLicitador == null) {
			jButtonLicitador = new JButton();
			jButtonLicitador.setBounds(253, 409, 184, 18);
			jButtonLicitador.setText("Adjudicatario...");
			jButtonLicitador.setActionCommand(Acciones.INIT_LIC);
		}
		return jButtonLicitador;
	}


	public void actionPerformed(ActionEvent e) {

		try{
			SessionDataManager.getInstance().setExpediente(getExpediente());
		
		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			gestorVentanasFormCD[0].setVisible(true);
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {		
			if (gestorVentanasFormCD[1] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[1] = new GeneracionCODICEForm(this,TipoDocumento.MENOR); 
				gestorVentanasFormCD[1].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[1].setVisible(true);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_LIC)) {
			if (gestorVentanasFormCD[3] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[3] = new AdjudicatarioForm(this,TipoDocumento.MENOR); 
				gestorVentanasFormCD[3].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[3].setVisible(true);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_DURACION)) {
			if (gestorVentanasFormCD[4] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[4] = new CondicionesEjecucionForm(this,TipoDocumento.MENOR);
				gestorVentanasFormCD[4].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[4].setVisible(true);
			}
		}	
		
		
		} catch (ModelException e1){
			e1.printStackTrace();
		}

	}
	
	
	private JComboBox<String> getJComboBoxPais() {
	      if (jComboBoxPais == null) {
	    	  jComboBoxPais = new JComboBox<String>();
	    		jComboBoxPais.setBounds(253, 334, 193, 18);
	      }
	      return jComboBoxPais;
	  }
	  private JComboBox<String> getJComboBoxNuts() {
	      if (jComboBoxNuts == null) {
	    	  jComboBoxNuts = new JComboBox<String>();
	    		jComboBoxNuts.setBounds(253, 361, 193, 18);
	      }
	      return jComboBoxNuts;
	  }

}
