/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.windows.GeneracionCODICEForm;

public class DocumentoGeneralForm extends ThemeJFrame {

	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;

	private JLabel jLabelExpediente = null;

	private JTextField jTextFieldExpediente = null;

	private JLabel jLabelIdBP = null;

	private JLabel jLabelTipoDocumento = null;

	private JComboBox jComboBoxTipoDocumento = null;

	private JTextField jTextFieldIdBP = null;

	private JLabel jLabelAnuncioPrevio = null; 
	
 
	
	JFrame gestorVentanasFormDOCGEN[] = new JFrame[2];
	
	ExpedienteBean expediente=new ExpedienteBean();  //  @jve:decl-index=0:
	
	private JLabel jLabeNombreDoc = null;

	private JTextField jTextFieldNombreDoc = null;

	private JLabel jLabeURLDoc = null;

	private JTextField jTextFieldURLDoc = null;

	private JButton jButtonURLDoc = null;
	
	final JFileChooser fc = new JFileChooser();
	
	public ExpedienteBean getDocumentoGeneral() {
		if (expediente==null){
			expediente = new ExpedienteBean();
		}
		expediente.setNumExpediente(jTextFieldExpediente.getText());
		expediente.setBuyerProfileId(jTextFieldIdBP.getText());
		expediente.setNameDocument(jTextFieldNombreDoc.getText());
		expediente.setTypeDoc((String)jComboBoxTipoDocumento.getSelectedItem());
		expediente.setIdTypeDoc(jComboBoxTipoDocumento.getSelectedIndex());
		expediente.setUrlDocument(jTextFieldURLDoc.getText());
		SessionDataManager.getInstance().setExpediente(expediente);
		return expediente;
	}

	public void setDocumentoGeneral(ExpedienteBean exp) { 
		
		this.expediente = exp;
	}

	public void cargarDatosComboBoxs() { 
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTipoDocumento, ConstantsGC.GENERALCONTRACTDOCCODE);
	}

	public DocumentoGeneralForm(JFrame ventanaPadre) throws ModelException {
		super();
		initialize();
		cargarDatosComboBoxs();
		gestorVentanasFormDOCGEN[0] =ventanaPadre;
		gestorVentanasFormDOCGEN[1] =null;
 
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		jButtonURLDoc.addActionListener(this);
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosExpediente();
		}
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosExpediente();
			}
		});
		
	}
	
	/**
	 * La funcin rellena los datos del formulario a partir de los indicados en el objeto expediente.
	 * Los valores del objeto expediente son los que se han almacenado con anterioridad en session
	 */
	private void escribeDatosExpediente(){
	
		jTextFieldExpediente.setText(expediente.getNumExpediente());
		jTextFieldURLDoc.setText(expediente.getUrlDocument());
		jComboBoxTipoDocumento.setSelectedIndex(expediente.getIdTypeDoc());
		jTextFieldNombreDoc.setText(expediente.getNameDocument());
			
	}
	
	

	private void initialize() {
		getJPanelContenido();
		this.setTitle("Servicio de Publicacin - Documento General");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabeURLDoc = new JLabel();
			jLabeURLDoc.setText("Documento:");
			jLabeURLDoc.setLocation(new Point(62, 182));
			jLabeURLDoc.setSize(new Dimension(250, 18));
			jLabeNombreDoc = new JLabel();
			jLabeNombreDoc.setText("Nombre documento:");
			jLabeNombreDoc.setLocation(new Point(62, 242));
			jLabeNombreDoc.setPreferredSize(new Dimension(246, 16));
			jLabeNombreDoc.setSize(new Dimension(250, 18));
			
			jLabelAnuncioPrevio = new JLabel();
			jLabelAnuncioPrevio.setFont(new Font("Dialog", Font.BOLD, 18));
			jLabelAnuncioPrevio.setLocation(new Point(21, 79));
			jLabelAnuncioPrevio.setSize(new Dimension(250, 18));
			jLabelAnuncioPrevio.setText("Documento General");
			jLabelTipoDocumento = new JLabel();
			jLabelTipoDocumento.setText("Tipo de documento:");
			jLabelTipoDocumento.setSize(new Dimension(250, 18));
			jLabelTipoDocumento.setLocation(new Point(62, 212));
			jLabelIdBP = new JLabel();
			jLabelIdBP.setText("Id del rgano de Contratacin:");
			jLabelIdBP.setLocation(new Point(62, 152));
			jLabelIdBP.setSize(new Dimension(250, 18));
			jLabelExpediente = new JLabel();
			jLabelExpediente.setText("Expediente:");
			jLabelExpediente.setLocation(new Point(62, 122));
			jLabelExpediente.setSize(new Dimension(250, 18)); 
			
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.add(jLabelExpediente, null); 
			jPanelContenido.add(getJTextFieldExpediente(), null);
			jPanelContenido.add(jLabelIdBP, null);
			jPanelContenido.add(jLabelTipoDocumento, null);
			jPanelContenido.add(getJComboBoxTipoDocumento(), null);
			jPanelContenido.add(getJTextFieldIdBP(), null);
			jPanelContenido.add(jLabelAnuncioPrevio, null); 
			jPanelContenido.add(jLabeNombreDoc, null);
			jPanelContenido.add(getJTextFieldNombreDoc(), null);
			jPanelContenido.add(jLabeURLDoc, null);
			jPanelContenido.add(getJTextFieldURLDoc(), null);
			jPanelContenido.add(getJButtonURLDoc(), null);
			
			String idPlataforma=SessionDataManager.getInstance().getOrganoContratacion().getIdPlataforma();
			jTextFieldIdBP.setText(idPlataforma);
			
		}
		return jPanelContenido;
	}

	private JTextField getJTextFieldExpediente() {
		if (jTextFieldExpediente == null) {
			jTextFieldExpediente = new JTextField();
			jTextFieldExpediente.setSize(new Dimension(210, 18));
			jTextFieldExpediente.setLocation(new Point(332, 123));
		}
		return jTextFieldExpediente;
	}

	private JComboBox getJComboBoxTipoDocumento() {
		if (jComboBoxTipoDocumento == null) {
			jComboBoxTipoDocumento = new JComboBox();
			jComboBoxTipoDocumento.setLocation(new Point(332, 212));
			jComboBoxTipoDocumento.setSize(new Dimension(441, 18));
		}
		return jComboBoxTipoDocumento;
	}

	private JTextField getJTextFieldIdBP() {
		if (jTextFieldIdBP == null) {
			jTextFieldIdBP = new JTextField();
			jTextFieldIdBP.setLocation(new Point(332, 152));
			jTextFieldIdBP.setSize(new Dimension(210, 18));
		}
		return jTextFieldIdBP;
	}
 

	/**
	 * This method initializes jTextFieldNombreDoc	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldNombreDoc() {
		if (jTextFieldNombreDoc == null) {
			jTextFieldNombreDoc = new JTextField();
			jTextFieldNombreDoc.setLocation(new Point(332, 242));
			jTextFieldNombreDoc.setPreferredSize(new Dimension(210, 18));
			jTextFieldNombreDoc.setSize(new Dimension(210, 18));
		}
		return jTextFieldNombreDoc;
	}
	
	public void actionPerformed(ActionEvent e) {

		try{
			SessionDataManager.getInstance().setExpediente(getDocumentoGeneral());
		if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {
			if (gestorVentanasFormDOCGEN[1] == null) {				
				this.setVisible(false);
				gestorVentanasFormDOCGEN[1] = new GeneracionCODICEForm(this,TipoDocumento.DOC_GEN);
				gestorVentanasFormDOCGEN[1].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormDOCGEN[1].setVisible(true);
			}
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			gestorVentanasFormDOCGEN[0].setVisible(true);
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.LOAD_DOCGEN)) {
			 
			int returnVal = fc.showOpenDialog(jButtonURLDoc);
			 if (returnVal == JFileChooser.APPROVE_OPTION) {
				 File file = fc.getSelectedFile();
                 jTextFieldURLDoc.setText(file.getAbsolutePath());
                 getDocumentoGeneral();
			 }


		}
		} catch (ModelException e1){
			e1.printStackTrace();
		}
	}

	/**
	 * This method initializes jTextFieldURLDoc	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldURLDoc() {
		if (jTextFieldURLDoc == null) {
			jTextFieldURLDoc = new JTextField();
			jTextFieldURLDoc.setSize(new Dimension(210, 18));
			jTextFieldURLDoc.setLocation(new Point(332, 182));
		}
		return jTextFieldURLDoc;
	}

	/**
	 * This method initializes jButtonURLDoc	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonURLDoc() {
		if (jButtonURLDoc == null) {
			jButtonURLDoc = new JButton();
			jButtonURLDoc.setText("Examinar...");
			jButtonURLDoc.setSize(new Dimension(98, 18));
			jButtonURLDoc.setLocation(new Point(550, 182));
			jButtonURLDoc.setPreferredSize(new Dimension(98, 18));
			jButtonURLDoc.setActionCommand(Acciones.LOAD_DOCGEN);
		}
		return jButtonURLDoc;
	}
	
	

}
