/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import es.contrataciondelestado.b2b.serviciosconsulta.ExpedientStateData;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ComboListener;
import es.dgpe.place.client.components.ComboListenerCountry;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.windows.GeneracionCODICEForm;
import es.dgpe.place.client.windows.publication.service.commons.CondicionesEjecucionForm;
import es.dgpe.place.client.windows.publication.service.commons.CriteriosAdjudicacionForm;
import es.dgpe.place.client.windows.publication.service.commons.EventosAperturaForm;
import es.dgpe.place.client.windows.publication.service.commons.LotesForm;
import es.dgpe.place.client.windows.publication.service.commons.ProcedimientoForm;
import es.dgpe.place.client.windows.publication.service.commons.ReceptorRecurosForm;
import es.dgpe.place.client.windows.publication.service.commons.RequisitosParticipacionForm;

public class PliegoForm extends ThemeJFrame {


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;

	private JLabel jLabelExpediente = null;

	private JTextField jTextFieldExpediente = null;

	private JLabel jLabelTipoContrato = null;

	private JLabel jLabelSubTipoContrato = null;

	private JLabel jLabelObjetoContrato = null;

	private JLabel jLabelProcContratacion = null;

	private JLabel jLabelTipoTramitacin = null;

	private JLabel jLabelTramitacionGasto = null;

	private JLabel jLabelFechaPrevAdj = null;

	private JLabel jLabelSelCPV = null;

	private JLabel jLabelCodigoCPV = null;

	private JComboBox jComboBoxTipoContrato = null;

	private JComboBox jComboBoxSubtipoContrato = null;
	
	private JTextField jTextFieldObjetoContrato = null;

	private JComboBox jComboBoxCPV = null;
	
	private JComboBox<String> jComboBoxPais;
    private JComboBox<String> jComboBoxNuts;
    private JLabel lblLugarDeEjecucin;

	private JLabel jLabelAnuncioLicitacion = null;
	
	JFrame gestorVentanasFormCD[] = new JFrame[9];
	
	ExpedienteBean expediente=new ExpedienteBean();

	private JLabel jLabelImporteSin = null;

	private JLabel jLabelImporteCon = null;

	private JTextField jTextFieldImporteSin = null;

	private JTextField jTextFieldImporteCon = null;

	private JLabel jLabelClasificacion = null;

	private JLabel jLabelDescripcion = null;

	private JTextArea jTextAreaDescripcionSolvencias = null;

	private JLabel jLabelPPT = null;

	private JTextField jTextFieldPPT = null;

	private JLabel jLabelPCAP = null;

	private JTextField jTextFieldPCAP = null;

	private JButton jButtonEvento = null;

	private JButton jButtonSelPPT = null;

	private JButton jButtonSelPCAP = null;
	
	private JButton jButtonDuracionContrato = null;
	
	final JFileChooser fc = new JFileChooser();
	
	private JLabel lblValorEstimadoDel;
	
	private JTextField jTextFieldValorEstimado;
	
	private Date fechaFinOfertas=null;
	
	private Date fechaFinSolicitudes=null;
	
	private JComboBox<String> jComboBoxDirectiva=null;
	
	private JButton jButtonProcedimiento = null;
	private JButton jButtonRequisitosParticipacion;
	private JButton jButtonLotes;
    private JButton jButtonCriteriosAdjudicacion;
    private JButton jButtonReceptorRecursos = null;
    private JComboBox<String> jComboBoxAcuerdoCP = new JComboBox<String>();
    private JLabel lblSujetoAlAcuerdo;

	
	
	public ExpedienteBean getExpediente() {
		
		if (expediente==null){
			expediente = new ExpedienteBean();
		}
		
		expediente.setDirectivaAplicacion((String) jComboBoxDirectiva.getSelectedItem()); 
		expediente.setIdDirectivaAplicacion(jComboBoxDirectiva.getSelectedIndex());
		
		expediente.setNumExpediente(jTextFieldExpediente.getText());

		expediente.setTipoContrato((String) jComboBoxTipoContrato.getSelectedItem());
		expediente.setIdTipoContrato(jComboBoxTipoContrato.getSelectedIndex());

		expediente.setSubtipoContrato((String) jComboBoxSubtipoContrato.getSelectedItem());
		expediente.setIdSubtipoContrato(jComboBoxSubtipoContrato.getSelectedIndex());

		expediente.setObjetoContrato(jTextFieldObjetoContrato.getText());

		expediente.setPais((String) jComboBoxPais.getSelectedItem());
        expediente.setIdPais(jComboBoxPais.getSelectedIndex());
        
        if (jComboBoxNuts.getSelectedIndex()>0){
        	String nutsSeleccionado = (String)jComboBoxNuts.getSelectedItem();
        	expediente.setNuts(nutsSeleccionado.substring(0, nutsSeleccionado.lastIndexOf("(")-1));
        	expediente.setIdNuts(nutsSeleccionado.substring(nutsSeleccionado.lastIndexOf("(")+1, nutsSeleccionado.length()-1));
        	}

		expediente.setCpv((String) jComboBoxCPV.getSelectedItem());
		expediente.setIdCpv(jComboBoxCPV.getSelectedIndex());

		expediente.setImporteSinImpuestos(jTextFieldImporteSin.getText());
		expediente.setImporteConImpuestos(jTextFieldImporteCon.getText());
		expediente.setValorEstimado(jTextFieldValorEstimado.getText());
		
		expediente.setDescSolvencia(jTextAreaDescripcionSolvencias.getText());
		
		expediente.setUrlPCAP(jTextFieldPCAP.getText());
		expediente.setUrlPPT(jTextFieldPPT.getText());
		expediente.setAcuerdoCP(jComboBoxAcuerdoCP.getSelectedIndex());

		
		SessionDataManager.getInstance().setExpediente(expediente);
		
		return expediente;
	}

	public void setPliego(ExpedienteBean expediente) { 
		
		this.expediente = expediente;
	}

	public void cargarDatosComboBoxs() {
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTipoContrato, ConstantsGC.TENDERING_CONTRACT);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxCPV, ConstantsGC.CPV);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxPais, ConstantsGC.COUNTRY_CODE);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxAcuerdoCP, ConstantsGC.SI_NO);
		//Cargo el primer valor de Directiva como no sujeto a regulacion armonizada
		jComboBoxDirectiva.addItem(ConstantsGC.NO_SARA);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxDirectiva, ConstantsGC.DIRECTIVA);
	}

	public PliegoForm(JFrame ventanaPadre) throws ModelException {
		super();
		initialize();
		cargarDatosComboBoxs();
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null;
		
		jButtonSelPPT.addActionListener(this);  
		jButtonSelPCAP.addActionListener(this);
		jButtonEvento.addActionListener(this);  
		jComboBoxTipoContrato.addItemListener(new ComboListener(jComboBoxTipoContrato,jComboBoxSubtipoContrato));
		getPanel().add(getLblSujetoAlAcuerdo());
		jButtonRequisitosParticipacion.addActionListener(this); 	
		jButtonProcedimiento.addActionListener(this);
		jButtonDuracionContrato.addActionListener(this);
		jButtonLotes.addActionListener(this); 
		jButtonCriteriosAdjudicacion.addActionListener(this); 
		jButtonReceptorRecursos.addActionListener(this);
		
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosExpediente();
		}
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosExpediente();
			}
		});
		 
	}
	
	
	
	/**
	 * La funcin rellena los datos del formulario a partir de los indicados en el objeto expediente.
	 * Los valores del objeto expediente son los que se han almacenado con anterioridad en session
	 */
	private void escribeDatosExpediente(){
		
		
		DateFormat df = new SimpleDateFormat("MM-dd-yyyy HH:mm");
		
		jComboBoxDirectiva.setSelectedIndex(expediente.getIdDirectivaAplicacion());
		jTextFieldExpediente.setText(expediente.getNumExpediente());
		jComboBoxTipoContrato.setSelectedIndex(expediente.getIdTipoContrato());
		jComboBoxSubtipoContrato.setSelectedIndex(expediente.getIdSubtipoContrato());
		jTextFieldObjetoContrato.setText(expediente.getObjetoContrato());
		jTextFieldValorEstimado.setText(expediente.getValorEstimado());
		jTextFieldImporteSin.setText(expediente.getImporteSinImpuestos());
		jTextFieldImporteCon.setText(expediente.getImporteConImpuestos());
		
		jComboBoxCPV.setSelectedIndex(expediente.getIdCpv());
				
		jComboBoxPais.setSelectedIndex(expediente.getIdPais());
		jComboBoxNuts.setSelectedItem(expediente.getNuts() + " (" + expediente.getIdNuts() + ")");

		
		jTextAreaDescripcionSolvencias.setText(expediente.getDescSolvencia());
		
		jTextFieldPPT.setText(expediente.getUrlPPT());
		jTextFieldPCAP.setText(expediente.getUrlPCAP());
		jComboBoxAcuerdoCP.setSelectedIndex(expediente.getAcuerdoCP());
	
	}
	
	

	private void initialize() {
		 
		getJPanelContenido();
		
		this.setTitle("Servicio de Publicacin - Pliego");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	 
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			
			
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			getPanel().add(getJButtonDuracionContrato());
			
			
			jLabelSelCPV = new JLabel();
			jLabelSelCPV.setBounds(61, 344, 250, 18);
			getPanel().add(jLabelSelCPV);
			jLabelSelCPV.setText("Seleccin del CPV");
			jLabelCodigoCPV = new JLabel();
			jLabelCodigoCPV.setBounds(91, 364, 220, 18);
			getPanel().add(jLabelCodigoCPV);
			jLabelCodigoCPV.setText("Cdigo CPV");
			getPanel().add(getJComboBoxCPV());
			jLabelImporteSin = new JLabel();
			jLabelImporteSin.setBounds(61, 256, 250, 18);
			getPanel().add(jLabelImporteSin);
			jLabelImporteSin.setText("Importe Base (Sin impuestos)");
			jLabelImporteCon = new JLabel();
			jLabelImporteCon.setBounds(61, 281, 250, 18);
			getPanel().add(jLabelImporteCon);
			jLabelImporteCon.setText("Importe Base (Con impuestos)");
			getPanel().add(getJTextFieldImporteSin());
			getPanel().add(getJTextFieldImporteCon());
			jLabelDescripcion = new JLabel();
			jLabelDescripcion.setBounds(61, 463, 250, 18);
			getPanel().add(jLabelDescripcion);
			jLabelDescripcion.setText("Descripcin de solvencias:");
			getPanel().add(getJTextAreaDescripcionSolvencias());
			jLabelPPT = new JLabel();
			jLabelPPT.setBounds(61, 509, 250, 18);
			getPanel().add(jLabelPPT);
			jLabelPPT.setText("Pliego de prescripcin tcnica:");
			getPanel().add(getJTextFieldPPT());
			jLabelPCAP = new JLabel();
			jLabelPCAP.setBounds(61, 538, 250, 18);
			getPanel().add(jLabelPCAP);
			jLabelPCAP.setText("PCAP");
			getPanel().add(getJTextFieldPCAP());
			getPanel().add(getJButtonEvento());
			getPanel().add(getJButtonSelPPT());
			getPanel().add(getJButtonSelPCAP());
			getPanel().add(getLblValorEstimadoDel());
			getPanel().add(getJTextFieldValorEstimado());
			getPanel().add(getJButtonProcedimiento());
			getPanel().add(getJTextFieldObjetoContrato());
			getPanel().add(getjComboBoxFasesSucesivas());
			
			getPanel().add(getJComboBoxNuts());
            getPanel().add(getJComboBoxPais());
            getPanel().add(getLblLugarDeEjecucin());
			
			JLabel lblDirectivaDeAplicacin = new JLabel("Directiva de aplicaci\u00F3n");
			lblDirectivaDeAplicacin.setBounds(61, 109, 178, 14);
			getPanel().add(lblDirectivaDeAplicacin);
			getPanel().add(getJTextFieldExpediente());
			getPanel().add(getJComboBoxTipoContrato());
            
			getPanel().add(getJComboBoxSubtipoContrato());
			jLabelAnuncioLicitacion = new JLabel();
			jLabelAnuncioLicitacion.setBounds(10, 73, 250, 25);
			getPanel().add(jLabelAnuncioLicitacion);
			jLabelAnuncioLicitacion.setFont(new Font("Dialog", Font.BOLD, 18));
			jLabelAnuncioLicitacion.setText("Pliego");
			getPanel().add(getJComboBoxDirectiva());
			getPanel().add(getJButtonCriteriosAdjudicacion());
			getPanel().add(getJButtonLotes());
			getPanel().add(getJButtonRequisitosParticipacion());
			
			getPanel().add(getJButtonReceptorRecuros());          
			
			jComboBoxTipoContrato.addItemListener(new ComboListener(jComboBoxTipoContrato,jComboBoxSubtipoContrato));
			jComboBoxPais.addItemListener(new ComboListenerCountry(jComboBoxPais,jComboBoxNuts));
			jLabelObjetoContrato = new JLabel();
			jLabelObjetoContrato.setBounds(61, 202, 250, 18);
			getPanel().add(jLabelObjetoContrato);
			jLabelObjetoContrato.setText("Objeto del contrato:");
			jLabelSubTipoContrato = new JLabel();
			jLabelSubTipoContrato.setBounds(61, 180, 250, 18);
			getPanel().add(jLabelSubTipoContrato);
			jLabelSubTipoContrato.setText("Subtipo de contrato:");
			jLabelTipoContrato = new JLabel();
			jLabelTipoContrato.setBounds(61, 158, 250, 18);
			getPanel().add(jLabelTipoContrato);
			jLabelTipoContrato.setText("Tipo de contrato:");
			jLabelExpediente = new JLabel();
			jLabelExpediente.setBounds(61, 135, 250, 18);
			getPanel().add(jLabelExpediente);
			jLabelExpediente.setText("Expediente:");
		}
		return jPanelContenido;
	}
	
	private JComboBox getJComboBoxDirectiva(){
		if (jComboBoxDirectiva==null){
		jComboBoxDirectiva = new JComboBox();
		jComboBoxDirectiva.setBounds(267, 106, 378, 20);
		}
		return jComboBoxDirectiva;		
	}

	private JTextField getJTextFieldExpediente() {
		if (jTextFieldExpediente == null) {
			jTextFieldExpediente = new JTextField();
			jTextFieldExpediente.setBounds(268, 135, 378, 18);
		}
		return jTextFieldExpediente;
	}
	
	private JButton getJButtonDuracionContrato() {
		if (jButtonDuracionContrato == null) {
			jButtonDuracionContrato = new JButton();
			jButtonDuracionContrato.setText("Condiciones de ejecuci\u00F3n");
			jButtonDuracionContrato.setActionCommand(Acciones.EDIT_DURACION);
			jButtonDuracionContrato.setBounds(453, 658, 193, 18);
					}
		return jButtonDuracionContrato;
	}

	private JComboBox getJComboBoxTipoContrato() {
		if (jComboBoxTipoContrato == null) {
			jComboBoxTipoContrato = new JComboBox();
			jComboBoxTipoContrato.setBounds(267, 158, 378, 18);
		}
		return jComboBoxTipoContrato;
	}

	private JComboBox getJComboBoxSubtipoContrato() {
		if (jComboBoxSubtipoContrato == null) {
			jComboBoxSubtipoContrato = new JComboBox();
			jComboBoxSubtipoContrato.setBounds(267, 180, 378, 18);
		}
		return jComboBoxSubtipoContrato;
	}
	
	private JTextField getJTextFieldObjetoContrato() {
		if (jTextFieldObjetoContrato == null) {
			jTextFieldObjetoContrato = new JTextField();
			jTextFieldObjetoContrato.setBounds(267, 202, 625, 18);
		}
		return jTextFieldObjetoContrato;
	}

	private JComboBox getJComboBoxCPV() {
		if (jComboBoxCPV == null) {
			jComboBoxCPV = new JComboBox();
			jComboBoxCPV.setBounds(268, 364, 493, 18);
		}
		return jComboBoxCPV;
	}
	
	/**
	 * This method initializes jTextFieldImporteSin	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteSin() {
		if (jTextFieldImporteSin == null) {
			jTextFieldImporteSin = new JTextField();
			jTextFieldImporteSin.setBounds(267, 256, 210, 18);
		}
		return jTextFieldImporteSin;
	}

	/**
	 * This method initializes jTextFieldImporteCon	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteCon() {
		if (jTextFieldImporteCon == null) {
			jTextFieldImporteCon = new JTextField();
			jTextFieldImporteCon.setBounds(267, 281, 210, 18);
		}
		return jTextFieldImporteCon;
	}

	/**
	 * This method initializes jTextAreaDescripcionSolvencias	
	 * 	
	 * @return javax.swing.JTextArea	
	 */
	private JTextArea getJTextAreaDescripcionSolvencias() {
		if (jTextAreaDescripcionSolvencias == null) {
			jTextAreaDescripcionSolvencias = new JTextArea();
			jTextAreaDescripcionSolvencias.setBounds(268, 448, 493, 50);
			jTextAreaDescripcionSolvencias.setBackground(SystemColor.control);
		}
		return jTextAreaDescripcionSolvencias;
	}

	/**
	 * This method initializes jTextFieldPPT	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldPPT() {
		if (jTextFieldPPT == null) {
			jTextFieldPPT = new JTextField();
			jTextFieldPPT.setBounds(267, 509, 210, 18);
		}
		return jTextFieldPPT;
	}

	/**
	 * This method initializes jTextFieldPCAP	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldPCAP() {
		if (jTextFieldPCAP == null) {
			jTextFieldPCAP = new JTextField();
			jTextFieldPCAP.setBounds(268, 538, 210, 18);
		}
		return jTextFieldPCAP;
	}

	/**
	 * This method initializes jButtonEvento	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonEvento() {
		if (jButtonEvento == null) {
			jButtonEvento = new JButton();
			jButtonEvento.setBounds(655, 622, 193, 18);
			jButtonEvento.setText("Evento de apertura");
			jButtonEvento.setActionCommand(Acciones.INIT_EVENT);
		}
		return jButtonEvento;
	}

	/**
	 * This method initializes jButtonSelPPT	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonSelPPT() {
		if (jButtonSelPPT == null) {
			jButtonSelPPT = new JButton();
			jButtonSelPPT.setBounds(511, 509, 98, 18);
			jButtonSelPPT.setText("Examinar...");
			jButtonSelPPT.setActionCommand(Acciones.LOAD_PPT);
		}
		return jButtonSelPPT;
	}

	/**
	 * This method initializes jButtonSelPCAP	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonSelPCAP() {
		if (jButtonSelPCAP == null) {
			jButtonSelPCAP = new JButton();
			jButtonSelPCAP.setBounds(511, 538, 98, 18);
			jButtonSelPCAP.setText("Examinar...");
			jButtonSelPCAP.setActionCommand(Acciones.LOAD_PCAP);
		}
		return jButtonSelPCAP;
	}

	public void actionPerformed(ActionEvent e) {
		try{
			SessionDataManager.getInstance().setExpediente(getExpediente());
		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			gestorVentanasFormCD[0].setVisible(true);
		} else 	if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {
			
			if (gestorVentanasFormCD[1] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[1] = new GeneracionCODICEForm(this,TipoDocumento.CD); 
				gestorVentanasFormCD[1].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[1].setVisible(true);
			}
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.INIT_EVENT)) {
			
			if (gestorVentanasFormCD[2] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[2] = new EventosAperturaForm(this,TipoDocumento.CD); 
				gestorVentanasFormCD[2].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[2].setVisible(true);
			}
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.LOAD_PPT)) {
			
			int returnVal = fc.showOpenDialog(jButtonSelPPT);
			 if (returnVal == JFileChooser.APPROVE_OPTION) {
				 File file = fc.getSelectedFile();
                 jTextFieldPPT.setText(file.getAbsolutePath());
			 }


		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.LOAD_PCAP)) {
			
			int returnVal = fc.showOpenDialog(jButtonSelPCAP);
			 if (returnVal == JFileChooser.APPROVE_OPTION) {
				 File file = fc.getSelectedFile();
                jTextFieldPCAP.setText(file.getAbsolutePath());
			 } 
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_DURACION)) {
			
			if (gestorVentanasFormCD[3] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[3] = new CondicionesEjecucionForm(this,TipoDocumento.CD);
				gestorVentanasFormCD[3].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[3].setVisible(true);
			}
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_PROCEDIMIENTO)) {
			if (gestorVentanasFormCD[4] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[4] = new ProcedimientoForm(this,TipoDocumento.CD);
				gestorVentanasFormCD[4].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[4].setVisible(true);
			}
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_LOTES)) {
			if (gestorVentanasFormCD[5] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[5] = new LotesForm(this,TipoDocumento.CD);
				gestorVentanasFormCD[5].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[5].setVisible(true);
			}
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_REQUISITOS)) {
			if (gestorVentanasFormCD[6] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[6] = new RequisitosParticipacionForm(this,TipoDocumento.CD);
				gestorVentanasFormCD[6].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[6].setVisible(true);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.EDIT_CRITERIOS_ADJUDICACION)) {
			if (gestorVentanasFormCD[7] == null) {
				getExpediente();
				this.setVisible(false);
				gestorVentanasFormCD[7] = new CriteriosAdjudicacionForm(this,TipoDocumento.CD);
				gestorVentanasFormCD[7].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[7].setVisible(true);
			}
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.RECEPTOR_RECURSOS)) {
			if (gestorVentanasFormCD[8] == null) {
				this.setVisible(false);
				gestorVentanasFormCD[8] = new ReceptorRecurosForm(this, TipoDocumento.CD);
				gestorVentanasFormCD[8].setVisible(true);
			} else {
				this.setVisible(false);
				gestorVentanasFormCD[8].setVisible(true);
			}
		}
		
		} catch (ModelException e1){
			e1.printStackTrace();
		} 
	}
	
	private JLabel getLblValorEstimadoDel() {
		if (lblValorEstimadoDel == null) {
			lblValorEstimadoDel = new JLabel("Valor estimado del contrato");
			lblValorEstimadoDel.setBounds(61, 234, 230, 14);
		}
		return lblValorEstimadoDel;
	}
	
	private JTextField getJTextFieldValorEstimado() {
		if (jTextFieldValorEstimado == null) {
			jTextFieldValorEstimado = new JTextField();
			jTextFieldValorEstimado.setBounds(267, 231, 210, 20);
			jTextFieldValorEstimado.setColumns(10);
		}
		return jTextFieldValorEstimado;
	}
	
	private JComboBox getJComboBoxPais() {
      if (jComboBoxPais == null) {
          jComboBoxPais = new JComboBox();
          jComboBoxPais.setBounds(268, 422, 205, 18);
      }
      return jComboBoxPais;
	}
	private JComboBox getJComboBoxNuts() {
      if (jComboBoxNuts == null) {
          jComboBoxNuts = new JComboBox();
          jComboBoxNuts.setBounds(504, 422, 205, 18);
      }
      return jComboBoxNuts;
	}
	
	private JLabel getLblLugarDeEjecucin() {
      if (lblLugarDeEjecucin == null) {
          lblLugarDeEjecucin = new JLabel("Lugar de ejecuci\u00F3n");
          lblLugarDeEjecucin.setBounds(61, 422, 230, 14);
      }
      return lblLugarDeEjecucin;
  }
	
  private JButton getJButtonProcedimiento() {
		if (jButtonProcedimiento == null) {
			jButtonProcedimiento = new JButton();
			jButtonProcedimiento.setText("Procedimiento");
			jButtonProcedimiento.setActionCommand(Acciones.EDIT_PROCEDIMIENTO);
			jButtonProcedimiento.setBounds(46, 622, 193, 18);
		}
		return jButtonProcedimiento;
	}
  
  private JButton getJButtonRequisitosParticipacion() {
		if (jButtonRequisitosParticipacion == null) {
			jButtonRequisitosParticipacion = new JButton();
			jButtonRequisitosParticipacion.setText("Requisitos de participaci\u00F3n");
			jButtonRequisitosParticipacion.setActionCommand(Acciones.EDIT_REQUISITOS);
			jButtonRequisitosParticipacion.setBounds(249, 658, 193, 18);
		}
		return jButtonRequisitosParticipacion;
	}
  
  private JButton getJButtonLotes() {
		if (jButtonLotes == null) {
			jButtonLotes = new JButton();
			jButtonLotes.setText("Lotes");
			jButtonLotes.setActionCommand(Acciones.EDIT_LOTES);
			jButtonLotes.setBounds(529, 229, 180, 25);
		}
		return jButtonLotes;
	}
	private JButton getJButtonCriteriosAdjudicacion() {
		if (jButtonCriteriosAdjudicacion == null) {
			jButtonCriteriosAdjudicacion = new JButton();
			jButtonCriteriosAdjudicacion.setText("Criterios de adjudicaci\u00F3n");
			jButtonCriteriosAdjudicacion.setFont(new Font("Tahoma", Font.PLAIN, 11));
			jButtonCriteriosAdjudicacion.setActionCommand(Acciones.EDIT_CRITERIOS_ADJUDICACION);
			jButtonCriteriosAdjudicacion.setBounds(452, 622, 193, 18);
		}
		return jButtonCriteriosAdjudicacion;
	}
	
	  private JButton getJButtonReceptorRecuros() {
			if (jButtonReceptorRecursos == null) {
				jButtonReceptorRecursos = new JButton();
				jButtonReceptorRecursos.setBounds(249, 622, 193, 18);
				jButtonReceptorRecursos.setText("Receptor de recursos");
				jButtonReceptorRecursos.setActionCommand(Acciones.RECEPTOR_RECURSOS);
			}
			return jButtonReceptorRecursos;
		}
	  
		public JComboBox getjComboBoxFasesSucesivas() {
			jComboBoxAcuerdoCP = new JComboBox();
			jComboBoxAcuerdoCP.setBounds(378, 310, 92, 18);
			return jComboBoxAcuerdoCP;
		}
	
	private JLabel getLblSujetoAlAcuerdo() {
		if (lblSujetoAlAcuerdo == null) {
			lblSujetoAlAcuerdo = new JLabel();
			lblSujetoAlAcuerdo.setText("Sujeto al Acuerdo de Contrataci\u00F3n P\u00FAblica de la OMC");
			lblSujetoAlAcuerdo.setBounds(61, 310, 336, 18);
		}
		return lblSujetoAlAcuerdo;
	}
}
