/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ModelException;

public class ServicioPublicacionForm extends ThemeJFrame {
	

	private static String pagina=Acciones.INIT_PUB;
	
	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;
	
	private JLabel jLabelTitulo = null;

	private JPanel jPanelSeleccion = null;
	
	private ButtonGroup selectorMenuServicioPublicacion = new ButtonGroup();
	
	private JRadioButton jRadioButton1 = null;

	private JRadioButton jRadioButton2 = null;

	private JRadioButton jRadioButton3 = null;
	
	private JRadioButton jRadioButton4 = null;	
	
	private JRadioButton jRadioButton5 = null;
	
	private JRadioButton jRadioButton6 = null;
	
	private JRadioButton jRadioButton7 = null;
	
	private JRadioButton jRadioButton8 = null;
	
	private JRadioButton jRadioButton9 = null;
	
	
	JFrame gestorVentanasPub[] = new JFrame[10];	
	
	
	public static String getPagina() {
		return pagina;
	}

	public static void setPagina(String pagina) {
		ServicioPublicacionForm.pagina = pagina;
	}
	
	public ServicioPublicacionForm(JFrame ventanaPadre) throws ModelException {
		super();
		initialize();
		
		gestorVentanasPub[0] = ventanaPadre;//Ventana principal
		gestorVentanasPub[1] = null;//Anuncio de informacion previa
		gestorVentanasPub[2] = null;//Anuncio de licitacion
		gestorVentanasPub[3] = null;//Pliegos
		gestorVentanasPub[4] = null;//Adjudicacion
		gestorVentanasPub[5] = null;//Desiertos, renuncias, desistimientos
		gestorVentanasPub[6] = null;//Formalizacion
		gestorVentanasPub[6] = null;//Documentos generales
		
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
 
	}

	private void initialize() {

		getJPanelContenido();
		this.setTitle("Servicio de Publicacin");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
		

	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {

			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.add(getLabelTitulo(), null);
			jPanelContenido.add(getJPanelSeleccion(), null);
			
			selectorMenuServicioPublicacion.add(jRadioButton1);
			selectorMenuServicioPublicacion.add(jRadioButton2);
			selectorMenuServicioPublicacion.add(jRadioButton3);
			selectorMenuServicioPublicacion.add(jRadioButton4);
			selectorMenuServicioPublicacion.add(jRadioButton5);
			selectorMenuServicioPublicacion.add(jRadioButton6);
			selectorMenuServicioPublicacion.add(jRadioButton7);
			selectorMenuServicioPublicacion.add(jRadioButton8);
			selectorMenuServicioPublicacion.add(jRadioButton9);
		}
		return jPanelContenido;
	}

	private JLabel getLabelTitulo() {
		if (jLabelTitulo == null) {
			jLabelTitulo = new JLabel(); 
			jLabelTitulo.setBounds(new Rectangle(100, 165, this.getWidth(), 50));
			jLabelTitulo.setFont(new Font("Dialog", Font.BOLD, 18));
			jLabelTitulo.setText("Servicio de Publicacin");
		}
		return jLabelTitulo;
	}
	
	private JPanel getJPanelSeleccion() {
		if (jPanelSeleccion == null) {
			jPanelSeleccion = new JPanel(); 
			
			jPanelSeleccion.setLayout(new BoxLayout(jPanelSeleccion, BoxLayout.Y_AXIS));
			jPanelSeleccion.setBounds(new Rectangle(250, 230, 385, 226));
			jPanelSeleccion.setBackground(Color.WHITE);
			jPanelSeleccion.setAlignmentX(50.0F);
			
			
			jPanelSeleccion.add(getJRadioButton1(), null);
			jPanelSeleccion.add(getJRadioButton2(), null);
			jPanelSeleccion.add(getJRadioButton3(), null);
			jPanelSeleccion.add(getJRadioButton4(), null);
			jPanelSeleccion.add(getJRadioButton6(), null);
			jPanelSeleccion.add(getJRadioButton7(), null);
			jPanelSeleccion.add(getJRadioButton5(), null);
			jPanelSeleccion.add(getJRadioButton8(), null);
			jPanelSeleccion.add(getJRadioButton9(), null);
		}
		return jPanelSeleccion;
	}

	private JRadioButton getJRadioButton1() {
		if (jRadioButton1 == null) {
			jRadioButton1 = new JRadioButton();
			jRadioButton1.setText("Anuncio Previo");
			jRadioButton1.setBackground(Color.white);
			jRadioButton1.setActionCommand(Acciones.INIT_PUB_PIN);
		}
		return jRadioButton1;
	}

	private JRadioButton getJRadioButton2() {
		if (jRadioButton2 == null) {
			jRadioButton2 = new JRadioButton();
			jRadioButton2.setText("Anuncio de Licitacin");
			jRadioButton2.setBackground(Color.white);
			jRadioButton1.setActionCommand(Acciones.INIT_PUB_CN);
		}
		return jRadioButton2;
	}

	private JRadioButton getJRadioButton3() {
		if (jRadioButton3 == null) {
			jRadioButton3 = new JRadioButton();
			jRadioButton3.setText("Pliego");
			jRadioButton3.setBackground(Color.white);
			jRadioButton1.setActionCommand(Acciones.INIT_PUB_PLIEGO);
		}
		return jRadioButton3;
	}

	private JRadioButton getJRadioButton4() {
		if (jRadioButton4 == null) {
			jRadioButton4 = new JRadioButton();
			jRadioButton4.setText("Anuncio de Adjudicacin");
			jRadioButton4.setActionCommand(Acciones.INIT_PUB_ADJ);
			jRadioButton4.setBackground(Color.white);
		}
		return jRadioButton4;
	}
	
	private JRadioButton getJRadioButton5() {
		if (jRadioButton5 == null) {
			jRadioButton5 = new JRadioButton();
			jRadioButton5.setBounds(252, 391, 135, 233);
			jRadioButton5.setText("Documentos Generales");
			jRadioButton5.setActionCommand(Acciones.INIT_PUB_DOCGEN);
			jRadioButton5.setBackground(Color.white);
		}
		return jRadioButton5;
	}
	
	private JRadioButton getJRadioButton6() {
		if (jRadioButton6 == null) {
			jRadioButton6 = new JRadioButton();
			jRadioButton6.setText("Anuncio de Renuncia, Desistimiento, Desierto");
			jRadioButton6.setBackground(Color.WHITE);
			jRadioButton6.setActionCommand(Acciones.INIT_PUB_DESI);
			jRadioButton6.setBounds(252, 324, 243, 2);
		}
		return jRadioButton6;
	}
	
	
	private JRadioButton getJRadioButton7() {
		if (jRadioButton7 == null) {
			
			jRadioButton7 = new JRadioButton();
			jRadioButton7.setText("Anuncio de Formalizaci\u00F3n");
			jRadioButton7.setBackground(Color.WHITE);
			jRadioButton7.setActionCommand(Acciones.INIT_PUB_FORM);
			jRadioButton7.setBounds(252, 347, 145, 23);
			
		}
		return jRadioButton7;
	}
	
	
	private JRadioButton getJRadioButton8() {
		if (jRadioButton8 == null) {
			
			jRadioButton8 = new JRadioButton();
			jRadioButton8.setText("Contratos Menores");
			jRadioButton8.setBackground(Color.WHITE);
			jRadioButton8.setActionCommand(Acciones.INIT_CONT_MENORES);
		}
		return jRadioButton8;
	}
	
	
	private JRadioButton getJRadioButton9() {
		if (jRadioButton9 == null) {
			
			jRadioButton9 = new JRadioButton();
			jRadioButton9.setText("Publicacin de Anuncio de Modificacin");
			jRadioButton9.setBackground(Color.WHITE);
			jRadioButton9.setActionCommand(Acciones.INIT_PUB_MODIFICACION);
		}
		return jRadioButton9;
	}
	
	
	public void actionPerformed(ActionEvent e) {

		try{			
		
			if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)){
				this.setVisible(false);
				gestorVentanasPub[0].setVisible(true);
			}else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT) && jRadioButton1.isSelected()) {
				if (gestorVentanasPub[1] == null) {
					this.setVisible(false);
					gestorVentanasPub[1] = new AnuncioPrevioForm(this);
				} else {
					this.setVisible(false);
					gestorVentanasPub[1].setVisible(true);
				}
			} else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT) && jRadioButton2.isSelected()) {
				if (gestorVentanasPub[2] == null) {
					this.setVisible(false);
					gestorVentanasPub[2] = new AnuncioLicitacionForm(this);
				} else {
					this.setVisible(false);
					gestorVentanasPub[2].setVisible(true);
				}
			} else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT) && jRadioButton3.isSelected()) {
				if (gestorVentanasPub[3] == null) {
					this.setVisible(false);
					gestorVentanasPub[3] = new PliegoForm(this);
				} else {
					this.setVisible(false);
					gestorVentanasPub[3].setVisible(true);
				}
			} else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT) && jRadioButton4.isSelected()) {
				if (gestorVentanasPub[4] == null) {
					this.setVisible(false);
					gestorVentanasPub[4] = new AnuncioAdjudicacionForm(this);
				} else {
					this.setVisible(false);
					gestorVentanasPub[4].setVisible(true);
				}
			} else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT) && jRadioButton5.isSelected()) {
				if (gestorVentanasPub[5] == null) {
					this.setVisible(false);
					gestorVentanasPub[5] = new DocumentoGeneralForm(this);
				} else {
					this.setVisible(false);
					gestorVentanasPub[5].setVisible(true);
				} 
			}  else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT) && jRadioButton6.isSelected()) {
				if (gestorVentanasPub[6] == null) {
					this.setVisible(false);
					gestorVentanasPub[6] = new AnuncioRenunciaForm(this);
				} else {
					this.setVisible(false);
					gestorVentanasPub[6].setVisible(true);
				} 
			} else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT) && jRadioButton7.isSelected()) {
				if (gestorVentanasPub[7] == null) {
					this.setVisible(false);
					gestorVentanasPub[7] = new AnuncioFormalizacionForm(this);
				} else {
					this.setVisible(false);
					gestorVentanasPub[7].setVisible(true);
				} 
			} else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT) && jRadioButton8.isSelected()) {
				if (gestorVentanasPub[8] == null) {
					this.setVisible(false);
					gestorVentanasPub[8] = new ContratoMenorForm(this);
				} else {
					this.setVisible(false);
					gestorVentanasPub[8].setVisible(true);
				} 
			} else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT) && jRadioButton9.isSelected()) {
				if (gestorVentanasPub[9] == null) {
					this.setVisible(false);
					gestorVentanasPub[9] = new AnuncioModificacionForm(this);
				} else {
					this.setVisible(false);
					gestorVentanasPub[9].setVisible(true);
				} 
			}
		
		}catch (ModelException e1){
			e1.printStackTrace();
		}
	}
}
