/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.LicitadorBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;



public class AdjudicatarioForm extends ThemeJFrame{


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;  //  @jve:decl-index=0:visual-constraint="17,624"

	private JLabel jLabelDatosLic = null;

 
  
	
	JFrame gestorVentanasFormCD[] = new JFrame[2];

	private JLabel jLabelLicitador = null;

	private JLabel jLabelNombreLic = null;

	private JLabel jLabeIdentificador = null;

	private JLabel jLabelLugarDatosAdj = null;

	private JTextField jTextFieldNombre = null;

	private String tipoDocumento=null;

	private JLabel jLabeFechaAdjudicacion = null;

	private JLabel jLabeImporteSin = null;

	private JLabel jLabeImporteCon = null;

	private JTextField jTextFieldImporteSin = null;

	private JTextField jTextFieldImporteCon = null;

	private JTextField jTextFieldFechaAdj=null;
	
	private LicitadorBean licitador;

	private JComboBox jComboBoxTipoIdentificador = null;

	private JTextField jTextFieldIdentificador = null;
	private JTextField textFieldNumOfertasRecibidas;
	
	private ExpedienteBean expediente;

	public AdjudicatarioForm(JFrame ventanaPadre,String tipoDocumento) throws ModelException {
		super();
		initialize();		
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null;

		 
		setHasButtonPrev(true);
		
		 
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosExpediente();
		}
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosExpediente();
			}
		});
		
		this.tipoDocumento=tipoDocumento;
		
	}

	private void initialize() {

		 getJPanelContenido();
		
		this.setTitle("Licitador - Configuracin");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	 
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelLugarDatosAdj = new JLabel();
			jLabelLugarDatosAdj.setText("Datos de la adjudicacin:");
			jLabelLugarDatosAdj.setLocation(new Point(61, 223));
			jLabelLugarDatosAdj.setSize(new Dimension(230, 16));
			jLabeIdentificador = new JLabel();
			jLabeIdentificador.setText("Identificador:");
			jLabeIdentificador.setSize(new Dimension(215, 18));
			jLabeIdentificador.setLocation(new Point(97, 179));
			jLabelNombreLic = new JLabel();
			jLabelNombreLic.setText("Nombre:");
			jLabelNombreLic.setSize(new Dimension(215, 18));
			jLabelNombreLic.setLocation(new Point(97, 149));
			jLabelLicitador = new JLabel();
			jLabelLicitador.setText("Adjudicatario");
			jLabelLicitador.setSize(new Dimension(288, 35));
			jLabelLicitador.setLocation(new Point(25, 79));
			jLabelLicitador.setFont(new Font("Dialog", Font.BOLD, 18));
			jLabelDatosLic = new JLabel();
			jLabelDatosLic.setText("Datos del licitador:");
			jLabelDatosLic.setLocation(new Point(61, 121));
			jLabelDatosLic.setSize(new Dimension(250, 18));
		 
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.setSize(new Dimension(800, 600));
			jPanelContenido.add(jLabelDatosLic, null); 
			
			jPanelContenido.add(jLabelLicitador, null);
			jPanelContenido.add(jLabelNombreLic, null);
			jPanelContenido.add(jLabeIdentificador, null);
			jPanelContenido.add(jLabelLugarDatosAdj, null);
			
			getPanel().add(getJTextFieldNombre());
			getPanel().add(getJTextFieldImporteSin());
			getPanel().add(getJTextFieldImporteCon());
			getPanel().add(getJComboBoxTipoIdentificador());
			getPanel().add(getJTextFieldIdentificador());
			getPanel().add(getJTextFieldFechaAdj());
			
			ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTipoIdentificador, ConstantsGC.DOCUMENT_TYPE);
			
			JLabel lblNmeroDeOfertas = new JLabel("N\u00FAmero de ofertas recibidas");
			lblNmeroDeOfertas.setBounds(99, 367, 285, 14);
			getPanel().add(lblNmeroDeOfertas);
			
			textFieldNumOfertasRecibidas = new JTextField();
			textFieldNumOfertasRecibidas.setBounds(422, 364, 86, 20);
			getPanel().add(textFieldNumOfertasRecibidas);
			textFieldNumOfertasRecibidas.setColumns(10);
			jLabeFechaAdjudicacion = new JLabel();
			jLabeFechaAdjudicacion.setBounds(99, 264, 238, 18);
			getPanel().add(jLabeFechaAdjudicacion);
			jLabeFechaAdjudicacion.setText("Fecha adjudicaci\u00F3n (dd-mm-aaaa):");
			jLabeImporteSin = new JLabel();
			jLabeImporteSin.setBounds(99, 293, 215, 18);
			getPanel().add(jLabeImporteSin);
			jLabeImporteSin.setText("Importe Adjudicacion (Sin impuestos)");
			jLabeImporteCon = new JLabel();
			jLabeImporteCon.setBounds(99, 328, 220, 18);
			getPanel().add(jLabeImporteCon);
			jLabeImporteCon.setText("Importe Adjudicacion (Con impuestos)");
		}
		return jPanelContenido;
	}

 
		
 
	/**
	 * This method initializes jTextFieldNombre	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldNombre() {
		if (jTextFieldNombre == null) {
			jTextFieldNombre = new JTextField();
			jTextFieldNombre.setBounds(422, 148, 250, 18);
		}
		return jTextFieldNombre;
	}

	/**
	 * This method initializes jTextFieldImporteSin	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteSin() {
		if (jTextFieldImporteSin == null) {
			jTextFieldImporteSin = new JTextField();
			jTextFieldImporteSin.setBounds(422, 293, 250, 18);
		}
		return jTextFieldImporteSin;
	}

	/**
	 * This method initializes jTextFieldImporteCon	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteCon() {
		if (jTextFieldImporteCon == null) {
			jTextFieldImporteCon = new JTextField();
			jTextFieldImporteCon.setBounds(422, 328, 250, 18);
		}
		return jTextFieldImporteCon;
	}
 

	/**
	 * This method initializes jTextFechaAdj	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldFechaAdj() {
		if (jTextFieldFechaAdj == null) {
			jTextFieldFechaAdj = new JTextField();
			jTextFieldFechaAdj.setBounds(422, 264, 250, 18);
			SimpleDateFormat dateFormat;
			dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			jTextFieldFechaAdj.setText(dateFormat.format(new Date()));
					}
		return jTextFieldFechaAdj;
	}
 
	 

	/**
	 * This method initializes jComboBoxTipoIdentificador	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBoxTipoIdentificador() {
		if (jComboBoxTipoIdentificador == null) {
			jComboBoxTipoIdentificador = new JComboBox();
			jComboBoxTipoIdentificador.setBounds(422, 178, 100, 18);
		}
		return jComboBoxTipoIdentificador;
	}

	/**
	 * This method initializes jTextFieldIdentificador	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldIdentificador() {
		if (jTextFieldIdentificador == null) {
			jTextFieldIdentificador = new JTextField();
			jTextFieldIdentificador.setBounds(532, 178, 140, 18);
		}
		return jTextFieldIdentificador;
	}

	public LicitadorBean getLicitador(){
		if (licitador==null) licitador=new LicitadorBean();
			
			licitador.setNombre(jTextFieldNombre.getText());
			licitador.setTipoIdentificador((String)jComboBoxTipoIdentificador.getSelectedItem());;
			licitador.setIdentificador(jTextFieldIdentificador.getText());
			
			Date fechaAdj=null;
			if (jTextFieldFechaAdj.getText().length()>0)
			try {
				fechaAdj = new SimpleDateFormat("dd-MM-yyyy").parse(jTextFieldFechaAdj.getText());
			} catch (ParseException e) {
				e.printStackTrace();
				System.out.println("Error en el formato de la fecha de apertura de ofertas");	
			}
			licitador.setFechaAdjudicacion(fechaAdj);
			
			if (jTextFieldImporteSin.getText().length() > 0){
				licitador.setImporteSinImpuestos(jTextFieldImporteSin.getText());
			}
			
			if (jTextFieldImporteCon.getText().length() > 0){
				licitador.setImporteConImpuestos(jTextFieldImporteCon.getText());
			}
			
			if (textFieldNumOfertasRecibidas.getText().length() > 0){
				licitador.setNumOfertasRecibidas(Integer.parseInt(textFieldNumOfertasRecibidas.getText()));
			}
					
		return licitador;
	}
	
	public void actionPerformed(ActionEvent e) {

		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			getLicitador();
			gestorVentanasFormCD[0].setVisible(true);
			
			ExpedienteBean expediente=SessionDataManager.getInstance().getExpediente();
			expediente.setLicitador(getLicitador());
			SessionDataManager.getInstance().setExpediente(expediente);		
		}
 

	}
	
	
	/**
	 * La funcin rellena los datos del formulario a partir de los indicados en el objeto expediente.
	 * Los valores del objeto expediente son los que se han almacenado con anterioridad en session
	 */
	private void escribeDatosExpediente(){

		LicitadorBean licitador = expediente.getLicitador();

		if (licitador != null){
			DateFormat df = new SimpleDateFormat("MM-dd-yyyy");

			jTextFieldNombre.setText(licitador.getNombre());
			jComboBoxTipoIdentificador.setSelectedIndex(licitador.getIdtipoIdentificador());
			jTextFieldIdentificador.setText(licitador.getIdentificador());
						
			jTextFieldFechaAdj.setText(df.format(licitador.getFechaAdjudicacion()));
			jTextFieldImporteSin.setText(licitador.getImporteSinImpuestos());
			jTextFieldImporteCon.setText(licitador.getImporteConImpuestos());
		}
	}
	
}
