/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import es.dgpe.place.client.beans.CondicionesEjecucionBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;

public class CondicionesEjecucionForm extends ThemeJFrame {


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;   

	private JLabel jLabelEventoAperturaEconomica = null; 
	 

	JFrame gestorVentanasFormCD[] = new JFrame[2];

	private String tipoDocumento=null;
	
	private CondicionesEjecucionBean condicionesEjecucion=null;
	
	
	
	private JPanel panelSeleccion= null;
	
	private JLabel jLabelFechaInicio = null;
	private JLabel jLabelFechaFinal = null;
	private JLabel jLabelDuracion = null;
	private JLabel jLabelUnidad = null;
	
	private JTextField jTextFieldFechaInicio = null;
	private JTextField jTextFieldFechaFinal = null;
	private JTextField jTextFieldDuracion = null;
	private JComboBox jComboBoxUnidad = null;
	
	private final ButtonGroup buttonGroup = new ButtonGroup();
	private JRadioButton jRadioButtonFechaFinal= null;
	private JRadioButton jRadioButtonDuracion= null;
	private JLabel lblDuracinDelContrato;
	private JLabel lblPedidoElectronico;
	private JLabel lblFacturaElectronica;
	private JLabel lblSeUtilizarEl;
	private JLabel lblConsideracionesAmbientales;
	private JLabel lblConsideracionesSocial;
	private JLabel lblPromoverEmpleo;
	private JLabel lblEliminarDesigualdades;
	private JLabel lblCombatirParo;
	private JLabel lblFavorecerLaFormacin;
	private JLabel lblCumplimientoDeLas;
	private JLabel lblCondicionesEspecialesDe;
	private JTextField jTextFieldConsideracionesAmbientales;
	private JTextField jTextFieldConsideracionesSocial;
	private JTextField jTextFieldPromoverEmpleo;
	private JTextField jTextFieldEliminarDesigualdades;
	private JTextField jTextFieldCombatirParo;
	private JTextField jTextFieldFavorecerFormacion;
	private JTextField jTextFieldConvencionesOMT;
	
	private JComboBox jComboBoxPedidoElectronico = null;
	private JComboBox jComboBoxFacturaElectronica = null;
	private JComboBox jComboBoxPagoElectronico = null;
	private JLabel lblUsoDeHerramientas;

	
	//  @jve:decl-index=0:
	

	public CondicionesEjecucionBean getCondicionesEjecucion()  {
		CondicionesEjecucionBean condicionesEjecucion=new CondicionesEjecucionBean();
		
		//Fecha de inicio
		Date fechaInicio=null;
		if (jTextFieldFechaInicio.getText().length()>0)
			try {
				fechaInicio = new SimpleDateFormat("dd-MM-yyyy").parse(jTextFieldFechaInicio.getText());
			} catch (ParseException e) {

				e.printStackTrace();
				System.out.println("Error en el formato de la fecha de inicio del contrato");	
			}
		condicionesEjecucion.setFechaInicio(fechaInicio);
		

		//Duracion y fecha final
		Date fechaFinal=null;
				
		if (jRadioButtonDuracion.isSelected())
				{
					condicionesEjecucion.setFechaFinal(null);
					condicionesEjecucion.setDuracion(jTextFieldDuracion.getText());
					condicionesEjecucion.setUnidadDuracion(jComboBoxUnidad.getSelectedIndex());
				}
		else if (jRadioButtonFechaFinal.isSelected())
				{
					condicionesEjecucion.setDuracion(null);
					
					if (jTextFieldFechaFinal.getText().length()>0)
						try {
							fechaFinal = new SimpleDateFormat("dd-MM-yyyy").parse(jTextFieldFechaFinal.getText());
						} catch (ParseException e) {

							e.printStackTrace();
							System.out.println("Error en el formato de la fecha de finalizacin del contrato");	
						}
					condicionesEjecucion.setFechaFinal(fechaFinal);
				}
		
		//Uso de herraminetas electronicas

		condicionesEjecucion.setFacturaElectronica(jComboBoxFacturaElectronica.getSelectedIndex());
		condicionesEjecucion.setPedidoElectronico(jComboBoxPedidoElectronico.getSelectedIndex());
		condicionesEjecucion.setPagoElectronico(jComboBoxPagoElectronico.getSelectedIndex());


		//Condiciones especiales de ejecucion
		condicionesEjecucion.setCombatirParo(jTextFieldCombatirParo.getText());
		condicionesEjecucion.setConsideracionesAmbientales(jTextFieldConsideracionesAmbientales.getText());
		condicionesEjecucion.setConsideracionesSocial(jTextFieldConsideracionesSocial.getText());
		condicionesEjecucion.setConvencionesOMT(jTextFieldConvencionesOMT.getText());
		condicionesEjecucion.setEliminarDesigualdades(jTextFieldEliminarDesigualdades.getText());
		condicionesEjecucion.setFavorecerFormacion(jTextFieldFavorecerFormacion.getText());
		condicionesEjecucion.setPromoverEmpleo(jTextFieldPromoverEmpleo.getText());


		
		return condicionesEjecucion;
	}

	public void setCondicionesEjecucion(CondicionesEjecucionBean condicionesEjecucion) {
		this.condicionesEjecucion = condicionesEjecucion;
	}

	public CondicionesEjecucionForm(JFrame ventanaPadre,String tipoDocumento)  throws ModelException {
		super();
		initialize();		
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null; 
		this.tipoDocumento=tipoDocumento;
		cargarDatosComboBoxs();
		
		 
		setHasButtonPrev(true);//Copiar a partir de aqui a getJPanelContenido
		
		 
		//Copiar hasta aqui a getJPanelContenido
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		if (SessionDataManager.getExpediente() != null)
			if(SessionDataManager.getExpediente().getCondicionesEjecucion()!=null){
			condicionesEjecucion = SessionDataManager.getExpediente().getCondicionesEjecucion();
			escribeDatosCondicionesEjecucion();
		}
	}
	
    private void escribeDatosCondicionesEjecucion(){
		
		

	DateFormat df = new SimpleDateFormat("MM-dd-yyyy");
		
	if (condicionesEjecucion.getFechaInicio() != null){
		jTextFieldFechaInicio.setText(df.format(condicionesEjecucion.getFechaInicio()));
	}	

	if (condicionesEjecucion.getFechaFinal()!=null){
		jRadioButtonFechaFinal.setSelected(true);
		jRadioButtonDuracion.setSelected(false);
		jTextFieldFechaFinal.setText(df.format(condicionesEjecucion.getFechaFinal()));}


	if (condicionesEjecucion.getDuracion()!=null){
		jRadioButtonFechaFinal.setSelected(false);
		jRadioButtonDuracion.setSelected(true);
		jTextFieldDuracion.setText(condicionesEjecucion.getDuracion());
		jComboBoxUnidad.setSelectedIndex(condicionesEjecucion.getUnidadDuracion());
	}


	jComboBoxFacturaElectronica.setSelectedIndex(condicionesEjecucion.getFacturaElectronica());
	jComboBoxPedidoElectronico.setSelectedIndex(condicionesEjecucion.getPedidoElectronico());
	jComboBoxPagoElectronico.setSelectedIndex(condicionesEjecucion.getPagoElectronico());


	//Condiciones especiales de ejecucion
	jTextFieldCombatirParo.setText(condicionesEjecucion.getCombatirParo());
	jTextFieldConsideracionesAmbientales.setText(condicionesEjecucion.getConsideracionesAmbientales());
	jTextFieldConsideracionesSocial.setText(condicionesEjecucion.getConsideracionesSocial());
	jTextFieldConvencionesOMT.setText(condicionesEjecucion.getConvencionesOMT());
	jTextFieldEliminarDesigualdades.setText(condicionesEjecucion.getEliminarDesigualdades());
	jTextFieldFavorecerFormacion.setText(condicionesEjecucion.getFavorecerFormacion());
	jTextFieldPromoverEmpleo.setText(condicionesEjecucion.getPromoverEmpleo());

	}
	
	

	private void initialize() {

	
		getJPanelContenido();
		
		this.setTitle("Duraci\u00F3n del contrato");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	
	private JLabel getLblDuracinDelContrato() {
		if (lblDuracinDelContrato == null) {
			lblDuracinDelContrato = new JLabel("Duraci\u00F3n del contrato");
			lblDuracinDelContrato.setFont(new Font("Tahoma", Font.BOLD, 14));
			lblDuracinDelContrato.setBounds(50, 70, 270, 14);
		}
		return lblDuracinDelContrato;
	}
	 
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
		 
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.setSize(new Dimension(800, 600));
			

			jLabelDuracion=new JLabel();
			jLabelDuracion.setText("Condiciones de ejecuci\u00F3n del contrato");
			jLabelDuracion.setBounds(72, 87, 275, 14);
			
			jLabelFechaInicio= new JLabel();
			jLabelFechaInicio.setBounds(50, 114, 171, 14);
			getPanel().add(jLabelFechaInicio);
			jLabelFechaInicio.setText("Fecha de inicio (dd-mm-aaaa)");
			getPanel().add(getJTextFieldFechaInicio());
			getPanel().add(getLblDuracinDelContrato());
			getPanel().add(getPanelSeleccion());
			getPanel().add(getLblPedidoElectronico());
			getPanel().add(getLblFacturaElectronica());
			getPanel().add(getLblSeUtilizarEl());
			
			
			getPanel().add(getJComboBoxPedidoElectronico());
			getPanel().add(getJComboBoxFacturaElectronica());
			getPanel().add(getJComboBoxPagoElectronico());
			
			
			getPanel().add(getLblConsideracionesAmbientales());
			getPanel().add(getLblConsideracionesSocial());
			getPanel().add(getLblPromoverEmpleo());
			getPanel().add(getLblEliminarDesigualdades());
			getPanel().add(getLblCombatirParo());
			getPanel().add(getLblFavorecerLaFormacin());
			getPanel().add(getLblCumplimientoDeLas());
			getPanel().add(getLblCondicionesEspecialesDe());
			
			
			
			jTextFieldConsideracionesAmbientales = new JTextField();
			jTextFieldConsideracionesAmbientales.setBounds(451, 403, 436, 31);
			getPanel().add(jTextFieldConsideracionesAmbientales);
			jTextFieldConsideracionesAmbientales.setColumns(10);
			
			jTextFieldConsideracionesSocial = new JTextField();
			jTextFieldConsideracionesSocial.setColumns(10);
			jTextFieldConsideracionesSocial.setBounds(451, 443, 436, 31);
			getPanel().add(jTextFieldConsideracionesSocial);
			
			jTextFieldPromoverEmpleo = new JTextField();
			jTextFieldPromoverEmpleo.setColumns(10);
			jTextFieldPromoverEmpleo.setBounds(451, 480, 436, 31);
			getPanel().add(jTextFieldPromoverEmpleo);
			
			jTextFieldEliminarDesigualdades = new JTextField();
			jTextFieldEliminarDesigualdades.setColumns(10);
			jTextFieldEliminarDesigualdades.setBounds(451, 517, 436, 31);
			getPanel().add(jTextFieldEliminarDesigualdades);
			
			jTextFieldCombatirParo = new JTextField();
			jTextFieldCombatirParo.setColumns(10);
			jTextFieldCombatirParo.setBounds(451, 552, 436, 31);
			getPanel().add(jTextFieldCombatirParo);
			
			jTextFieldFavorecerFormacion = new JTextField();
			jTextFieldFavorecerFormacion.setColumns(10);
			jTextFieldFavorecerFormacion.setBounds(451, 589, 436, 31);
			getPanel().add(jTextFieldFavorecerFormacion);
			
			jTextFieldConvencionesOMT = new JTextField();
			jTextFieldConvencionesOMT.setColumns(10);
			jTextFieldConvencionesOMT.setBounds(451, 625, 436, 31);
			getPanel().add(jTextFieldConvencionesOMT);
			getPanel().add(getLblUsoDeHerramientas());
			
			
		}
		return jPanelContenido;
	}
	
	/**
	 * This method initializes jTextFieldNombre	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldFechaInicio() {
		if (jTextFieldFechaInicio == null) {
			jTextFieldFechaInicio = new JTextField();
			jTextFieldFechaInicio.setBounds(231, 112, 89, 18);
		}
		return jTextFieldFechaInicio;
	}
	
	/**
	 * This method initializes jTextFieldNombre	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldFechaFinal() {
		if (jTextFieldFechaFinal == null) {
			jTextFieldFechaFinal = new JTextField();
			jTextFieldFechaFinal.setBounds(232, 47, 89, 18);
		}
		return jTextFieldFechaFinal;
	}
	
	
	
	/**
	 * This method initializes jTextFieldNombre	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JComboBox getJComboBoxUnidad() {
		if (jComboBoxUnidad == null) {
			jComboBoxUnidad = new JComboBox();
			jComboBoxUnidad.setBounds(335, 92, 68, 18);
		}
		return jComboBoxUnidad;
	}
	
	private JRadioButton getJRadioButtonDuracion() {
		if (jRadioButtonDuracion == null) {
			jRadioButtonDuracion = new JRadioButton();
			jRadioButtonDuracion.setToolTipText("Duraci\u00F3n en d\u00EDas, meses o a\u00F1os");
			jRadioButtonDuracion.setBounds(30, 94, 26, 14);
			
		}
		return jRadioButtonDuracion;
	}
	
	private JRadioButton getJRadioButtonFechaFinal() {
		if (jRadioButtonFechaFinal == null) {
			jRadioButtonFechaFinal = new JRadioButton();
			jRadioButtonFechaFinal.setToolTipText("Fecha final");
			jRadioButtonFechaFinal.setBounds(30, 51, 21, 14);

		}
		return jRadioButtonFechaFinal;
	}
	
	private JTextField getJTextFieldDuracion(){
		if (jTextFieldDuracion == null){
		jTextFieldDuracion = new JTextField();
		jTextFieldDuracion.setBounds(232, 91, 68, 20);
		jTextFieldDuracion.setColumns(10);
		}
		return jTextFieldDuracion;
	}
	
	private JComboBox getJComboBoxPedidoElectronico() {
		if (jComboBoxPedidoElectronico == null) {
			jComboBoxPedidoElectronico = new JComboBox();
			jComboBoxPedidoElectronico.setBounds(359, 292, 116, 18);
		}
		
		return jComboBoxPedidoElectronico;
	}
	
	private JComboBox getJComboBoxFacturaElectronica() {
		if (jComboBoxFacturaElectronica == null) {
			jComboBoxFacturaElectronica = new JComboBox();
			jComboBoxFacturaElectronica.setBounds(359, 317, 116, 18);
		
		}
		return jComboBoxFacturaElectronica;
	}
	
	private JComboBox getJComboBoxPagoElectronico() {
		if (jComboBoxPagoElectronico == null) {			
			jComboBoxPagoElectronico = new JComboBox();
			jComboBoxPagoElectronico.setBounds(359, 342, 116, 18);
			
		}
		return jComboBoxPagoElectronico;
	}
	
	
	private JPanel getPanelSeleccion() {
		if (panelSeleccion == null) {
			panelSeleccion = new JPanel();
			panelSeleccion.setBounds(345, 114, 461, 132);
			panelSeleccion.setBorder(new TitledBorder(null, "Seleccione entre", TitledBorder.LEADING, TitledBorder.TOP, new Font("Tahoma", Font.BOLD, 11)));
			panelSeleccion.setLayout(null);
			
			JLabel jLabelDuracion= new JLabel();
			jLabelDuracion.setText("Duraci\u00F3n");
			jLabelDuracion.setBounds(63, 94, 96, 14);
					
			panelSeleccion.add(jLabelDuracion);
			panelSeleccion.add(getJTextFieldDuracion());
			
			buttonGroup.add(getJRadioButtonFechaFinal());
			panelSeleccion.add(getJRadioButtonFechaFinal());
			buttonGroup.add(getJRadioButtonDuracion());
			panelSeleccion.add(getJRadioButtonDuracion());
			
			panelSeleccion.add(getJComboBoxUnidad());
			
			
			JLabel jLabelFechaFinal_1= new JLabel();
			jLabelFechaFinal_1.setBounds(63, 51, 159, 14);
			panelSeleccion.add(jLabelFechaFinal_1);
			jLabelFechaFinal_1.setText("Fecha final (dd-mm-aaaa)");
			panelSeleccion.add(getJTextFieldFechaFinal());
			
			
			
			
		}
		return panelSeleccion;
	}
	
	public void cargarDatosComboBoxs() {
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxUnidad, ConstantsGC.PERIOD_UNIT);
		
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxPedidoElectronico, ConstantsGC.SI_NO);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxFacturaElectronica, ConstantsGC.SI_NO);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxPagoElectronico, ConstantsGC.SI_NO);
		
		//getCondicionesEjecucion();
		//setCondicionesEjecucion(condicionesEjecucion);
	}

	public void actionPerformed(ActionEvent e) {

		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			getCondicionesEjecucion();
			gestorVentanasFormCD[0].setVisible(true);
			
			ExpedienteBean expediente=SessionDataManager.getInstance().getExpediente();
			expediente.setCondicionesEjecucion(getCondicionesEjecucion());
			SessionDataManager.getInstance().setExpediente(expediente);
			
			
			//TODO: Eliminar estas lneas comentadas
			/**
			if (tipoDocumento.equalsIgnoreCase(TipoDocumento.CN)){
				ExpedienteBean cn=SessionDataManager.getInstance().getExpediente();
				cn.setDuracion(getDuracionContrato());
				SessionDataManager.getInstance().setExpediente(cn);
			}else if (tipoDocumento.equalsIgnoreCase(TipoDocumento.CD)){
				PliegoBean pliego=SessionDataManager.getInstance().getPliego();
				pliego.setDuracion(getDuracionContrato());
				SessionDataManager.getInstance().setPliego(pliego);
			}else if (tipoDocumento.equalsIgnoreCase(TipoDocumento.ADJ)){
				AnuncioAdjudicacionBean can=SessionDataManager.getInstance().getAnuncioAdjudicacion();
				can.setDuracion(getDuracionContrato());
				SessionDataManager.getInstance().setAnuncioAdjudicacion(can);
			}else if (tipoDocumento.equalsIgnoreCase(TipoDocumento.FORM)){
				AnuncioFormalizacionBean form=SessionDataManager.getInstance().getAnuncioFormalizacion();
				form.setDuracion(getDuracionContrato());
				SessionDataManager.getInstance().setAnuncioFormalizacion(form);
			} else if (tipoDocumento.equalsIgnoreCase(TipoDocumento.RENUNCIA)){
				AnuncioRenunciaBean renuncia=SessionDataManager.getInstance().getAnuncioRenuncia();
				renuncia.setDuracion(getDuracionContrato());
				SessionDataManager.getInstance().setAnuncioRenuncia(renuncia);
			} else if (tipoDocumento.equalsIgnoreCase(TipoDocumento.MENOR)){
				ContratoMenorBean menor=SessionDataManager.getInstance().getContratoMenor();
				menor.setDuracion(getDuracionContrato());
				SessionDataManager.getInstance().setContratoMenor(menor);
			} else if (tipoDocumento.equalsIgnoreCase(TipoDocumento.MODIF)){
				AnuncioModificacionBean modificacion=SessionDataManager.getInstance().getAnuncioModificacion();
				modificacion.setDuracion(getDuracionContrato());
				SessionDataManager.getInstance().setAnuncioModificacion(modificacion);
			}*/
		
		}
 

	}
	private JLabel getLblPedidoElectronico() {
		if (lblPedidoElectronico == null) {
			lblPedidoElectronico = new JLabel("Se utilizar\u00E1 el pedido electr\u00F3nico");
			lblPedidoElectronico.setBounds(50, 292, 246, 14);
		}
		return lblPedidoElectronico;
	}
	private JLabel getLblFacturaElectronica() {
		if (lblFacturaElectronica == null) {
			lblFacturaElectronica = new JLabel("Se utilizar\u00E1 la factura electr\u00F3nica");
			lblFacturaElectronica.setBounds(50, 317, 246, 14);
		}
		return lblFacturaElectronica;
	}
	private JLabel getLblSeUtilizarEl() {
		if (lblSeUtilizarEl == null) {
			lblSeUtilizarEl = new JLabel("Se utilizar\u00E1 el pago electr\u00F3nico");
			lblSeUtilizarEl.setBounds(50, 342, 246, 14);
		}
		return lblSeUtilizarEl;
	}
	private JLabel getLblConsideracionesAmbientales() {
		if (lblConsideracionesAmbientales == null) {
			lblConsideracionesAmbientales = new JLabel("Consideraciones de tipo ambiental");
			lblConsideracionesAmbientales.setBounds(61, 420, 329, 14);
		}
		return lblConsideracionesAmbientales;
	}
	private JLabel getLblConsideracionesSocial() {
		if (lblConsideracionesSocial == null) {
			lblConsideracionesSocial = new JLabel("Consideraciones de tipo social");
			lblConsideracionesSocial.setBounds(61, 458, 246, 14);
		}
		return lblConsideracionesSocial;
	}
	private JLabel getLblPromoverEmpleo() {
		if (lblPromoverEmpleo == null) {
			lblPromoverEmpleo = new JLabel("Promover el empleo de personas con dificultades especiales");
			lblPromoverEmpleo.setBounds(61, 493, 380, 14);
		}
		return lblPromoverEmpleo;
	}
	private JLabel getLblEliminarDesigualdades() {
		if (lblEliminarDesigualdades == null) {
			lblEliminarDesigualdades = new JLabel("Eliminar desigualdades entre el hombre y la mujer");
			lblEliminarDesigualdades.setBounds(61, 527, 380, 14);
		}
		return lblEliminarDesigualdades;
	}
	private JLabel getLblCombatirParo() {
		if (lblCombatirParo == null) {
			lblCombatirParo = new JLabel("Combatir el paro");
			lblCombatirParo.setBounds(61, 564, 246, 14);
		}
		return lblCombatirParo;
	}
	private JLabel getLblFavorecerLaFormacin() {
		if (lblFavorecerLaFormacin == null) {
			lblFavorecerLaFormacin = new JLabel("Favorecer la formaci\u00F3n en el lugar de trabajo");
			lblFavorecerLaFormacin.setBounds(61, 603, 361, 14);
		}
		return lblFavorecerLaFormacin;
	}
	private JLabel getLblCumplimientoDeLas() {
		if (lblCumplimientoDeLas == null) {
			lblCumplimientoDeLas = new JLabel("Cumplimiento de las convenciones fundamentales de la OMT");
			lblCumplimientoDeLas.setBounds(61, 642, 380, 14);
		}
		return lblCumplimientoDeLas;
	}
	private JLabel getLblCondicionesEspecialesDe() {
		if (lblCondicionesEspecialesDe == null) {
			lblCondicionesEspecialesDe = new JLabel("Condiciones especiales de ejecuci\u00F3n");
			lblCondicionesEspecialesDe.setFont(new Font("Tahoma", Font.BOLD, 12));
			lblCondicionesEspecialesDe.setBounds(50, 386, 295, 14);
		}
		return lblCondicionesEspecialesDe;
	}
	private JLabel getLblUsoDeHerramientas() {
		if (lblUsoDeHerramientas == null) {
			lblUsoDeHerramientas = new JLabel("Uso de herramientas electr\u00F3nicas");
			lblUsoDeHerramientas.setFont(new Font("Tahoma", Font.BOLD, 14));
			lblUsoDeHerramientas.setBounds(50, 257, 270, 14);
		}
		return lblUsoDeHerramientas;
	}
}
