/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import es.dgpe.place.client.beans.CondicionesEjecucionBean;
import es.dgpe.place.client.beans.CristeriosAdjudicacionBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.LotesBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import java.awt.Point;
import javax.swing.JTextArea;
import java.awt.ComponentOrientation;

public class CriteriosAdjudicacionForm extends ThemeJFrame {


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;   

	JFrame gestorVentanasFormCD[] = new JFrame[2];
	
	private ExpedienteBean expediente=null;
	private CristeriosAdjudicacionBean criteriosAdjudicacion = null;

	private JTextField textAutomaticoPrecioDescripcion;
	private JTextField textAutomaticoPrecioPonderacion;
	private JTextField textAutomaticoOtrosDescripcion;
	private JTextField textAutomaticoOtrosPonderacion;
	private JTextField textJuicioPrecioDescripcion;
	private JTextField textJuicioPrecioPonderacion;


	public CristeriosAdjudicacionBean getCriteriosAdjudicacion()  {
		
		if (criteriosAdjudicacion==null) criteriosAdjudicacion=new CristeriosAdjudicacionBean();
		
		criteriosAdjudicacion.setAutomaticoPrecioDescripcion(textAutomaticoPrecioDescripcion.getText());
		criteriosAdjudicacion.setAutomaticoOtrosDescripcion(textAutomaticoOtrosDescripcion.getText());
		if (textAutomaticoPrecioPonderacion.getText().length() > 0){
			criteriosAdjudicacion.setAutomaticoPrecioPonderacion(Integer.valueOf(textAutomaticoPrecioPonderacion.getText()));
		}
		if (textAutomaticoOtrosPonderacion.getText().length() > 0){
			criteriosAdjudicacion.setAutomaticoOtrosPonderacion(Integer.valueOf(textAutomaticoOtrosPonderacion.getText()));
		}
		
		criteriosAdjudicacion.setJuicioDescripcion(textJuicioPrecioDescripcion.getText());
		if (textJuicioPrecioPonderacion.getText().length() > 0){
			criteriosAdjudicacion.setJuicioPonderacion(Integer.valueOf(textJuicioPrecioPonderacion.getText()));
		}
			
		return criteriosAdjudicacion;
	}


	public CriteriosAdjudicacionForm(JFrame ventanaPadre,String tipoDocumento)  throws ModelException {
		super();
		initialize();		
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null; 
	 
		setHasButtonPrev(true);
		
		JLabel lblCriteriosDeAdjudicacin = new JLabel("Criterios de adjudicaci\u00F3n");
		lblCriteriosDeAdjudicacin.setFont(new Font("Tahoma", Font.BOLD, 12));
		lblCriteriosDeAdjudicacin.setBounds(45, 126, 232, 14);
		getPanel().add(lblCriteriosDeAdjudicacin);
		
		JPanel panel = new JPanel();
		panel.setBounds(68, 179, 571, 138);
		getPanel().add(panel);
		panel.setLayout(null);
		
		JLabel lblCriteriosEvaluablesMediante = new JLabel("Criterios cuantificables autom\u00E1ticamente");
		lblCriteriosEvaluablesMediante.setFont(new Font("Tahoma", Font.BOLD, 11));
		lblCriteriosEvaluablesMediante.setBounds(10, 11, 300, 14);
		panel.add(lblCriteriosEvaluablesMediante);
		
		JLabel lblPrecio = new JLabel("1) Precio");
		lblPrecio.setBounds(20, 36, 78, 14);
		panel.add(lblPrecio);
		
		JLabel lblOtros = new JLabel("2) Otros");
		lblOtros.setBounds(20, 74, 46, 14);
		panel.add(lblOtros);
		
		textAutomaticoPrecioDescripcion = new JTextField();
		textAutomaticoPrecioDescripcion.setBounds(108, 55, 270, 20);
		panel.add(textAutomaticoPrecioDescripcion);
		textAutomaticoPrecioDescripcion.setColumns(10);
		
		textAutomaticoPrecioPonderacion = new JTextField();
		textAutomaticoPrecioPonderacion.setColumns(10);
		textAutomaticoPrecioPonderacion.setBounds(450, 55, 51, 20);
		panel.add(textAutomaticoPrecioPonderacion);
		
		JLabel lblDescripcin = new JLabel("Descripci\u00F3n:");
		lblDescripcin.setBounds(108, 36, 92, 14);
		panel.add(lblDescripcin);
		
		JLabel lblPonderacin = new JLabel("Ponderaci\u00F3n:");
		lblPonderacin.setBounds(422, 36, 92, 14);
		panel.add(lblPonderacin);
		
		JLabel label_1 = new JLabel("Descripci\u00F3n:");
		label_1.setBounds(108, 86, 92, 14);
		panel.add(label_1);
		
		textAutomaticoOtrosDescripcion = new JTextField();
		textAutomaticoOtrosDescripcion.setColumns(10);
		textAutomaticoOtrosDescripcion.setBounds(108, 105, 270, 20);
		panel.add(textAutomaticoOtrosDescripcion);
		
		JLabel label_2 = new JLabel("Ponderaci\u00F3n:");
		label_2.setBounds(422, 86, 92, 14);
		panel.add(label_2);
		
		textAutomaticoOtrosPonderacion = new JTextField();
		textAutomaticoOtrosPonderacion.setColumns(10);
		textAutomaticoOtrosPonderacion.setBounds(450, 105, 51, 20);
		panel.add(textAutomaticoOtrosPonderacion);
		
		JPanel panel_1 = new JPanel();
		panel_1.setLayout(null);
		panel_1.setBounds(68, 344, 571, 90);
		getPanel().add(panel_1);
		
		JLabel lblCriteriosEvaluablesMediante_1 = new JLabel("Criterios evaluables mediante juicio de valor");
		lblCriteriosEvaluablesMediante_1.setFont(new Font("Tahoma", Font.BOLD, 11));
		lblCriteriosEvaluablesMediante_1.setBounds(10, 11, 368, 14);
		panel_1.add(lblCriteriosEvaluablesMediante_1);
		
		textJuicioPrecioDescripcion = new JTextField();
		textJuicioPrecioDescripcion.setColumns(10);
		textJuicioPrecioDescripcion.setBounds(108, 55, 270, 20);
		panel_1.add(textJuicioPrecioDescripcion);
		
		textJuicioPrecioPonderacion = new JTextField();
		textJuicioPrecioPonderacion.setColumns(10);
		textJuicioPrecioPonderacion.setBounds(450, 55, 51, 20);
		panel_1.add(textJuicioPrecioPonderacion);
		
		JLabel label_5 = new JLabel("Descripci\u00F3n:");
		label_5.setBounds(108, 36, 92, 14);
		panel_1.add(label_5);
		
		JLabel label_6 = new JLabel("Ponderaci\u00F3n:");
		label_6.setBounds(422, 36, 92, 14);
		panel_1.add(label_6);
			
		 
		//Copiar hasta aqui a getJPanelContenido
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosCriteriosAdjudicacion();
		}
		
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosCriteriosAdjudicacion();
			}
		});
	}
	
	
	private void initialize() {
		getJPanelContenido();	
		this.setTitle("Criterios de Adjudicacin");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.setSize(new Dimension(800, 600));
		}
		return jPanelContenido;
	}
	
	public void actionPerformed(ActionEvent e) {

		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			getCriteriosAdjudicacion();
			gestorVentanasFormCD[0].setVisible(true);	
			
			ExpedienteBean expediente=SessionDataManager.getInstance().getExpediente();
			expediente.setCriteriosAdjudicacion(criteriosAdjudicacion);
			SessionDataManager.getInstance().setExpediente(expediente);
		}
	}
	
	/**
	 * La funcin rellena los datos del formulario a partir de los indicados en el objeto expediente.
	 * Los valores del objeto lotes son los que se han almacenado con anterioridad en session
	 */
	private void escribeDatosCriteriosAdjudicacion(){
	
		CristeriosAdjudicacionBean criteriosAdjudicacion = expediente.getCriteriosAdjudicacion();
		
		if (criteriosAdjudicacion != null){
			textAutomaticoPrecioDescripcion.setText(criteriosAdjudicacion.getAutomaticoPrecioDescripcion());
			textAutomaticoOtrosDescripcion.setText(criteriosAdjudicacion.getAutomaticoOtrosDescripcion());
			if (criteriosAdjudicacion.getAutomaticoPrecioPonderacion() != null){
				textAutomaticoPrecioPonderacion.setText(criteriosAdjudicacion.getAutomaticoPrecioPonderacion().toString());
			}
			if (criteriosAdjudicacion.getAutomaticoOtrosPonderacion() != null){
				textAutomaticoOtrosPonderacion.setText(criteriosAdjudicacion.getAutomaticoOtrosPonderacion().toString());
			}
			
			textJuicioPrecioDescripcion.setText(criteriosAdjudicacion.getJuicioDescripcion());
			if (criteriosAdjudicacion.getJuicioPonderacion() != null){
				textJuicioPrecioPonderacion.setText(criteriosAdjudicacion.getJuicioPonderacion().toString());
			}
		}
		
	
	}
	



}
