/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;

import es.dgpe.place.client.beans.EventoAperturaBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.LotesBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;

public class EventosAperturaForm extends ThemeJFrame {


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;   

	private JLabel jLabelEventoAperturaEconomica = null; 
	 
 
	
	JFrame gestorVentanasFormCD[] = new JFrame[2];

	private JLabel jLabelEventoApertura = null;

	private JLabel jLabelNombreEvento = null;

	private JLabel jLabelFechaApertura = null;

	private JLabel jLabelDescripcion = null;

	private JLabel jLabelLugarAperturaEconomica = null;

	private JLabel jLabelLugar = null;

	private JLabel jLabelCalle = null;

	private JLabel jLabelCP = null;

	private JLabel jLabelPoblacion = null;

	private JLabel jLabelPais = null;

	private JTextField jTextFieldNombre = null;

	private JTextPane jTextPaneDescripcion = null;

	private JTextField jTextFieldLugar = null;

	private JTextField jTextFieldCalle = null;

	private JTextField jTextFieldCP = null;

	private JTextField jTextFieldPoblacion = null;

	private String tipoDocumento=null;

	private EventoAperturaBean eventoApertura=null;  //  @jve:decl-index=0:

	private JComboBox<String> jComboBoxPais = null;
	
	private JTextField jTextFieldFechaApertura;
	private JTextArea textFieldRequisitosAsistentes;
	
	private JComboBox<String> comboBoxTipoEventoApertura;
	
	private ExpedienteBean expediente;
	

	public EventoAperturaBean getEventoApertura()  {
		eventoApertura=new EventoAperturaBean();
		eventoApertura.setNombre(jTextFieldNombre.getText());

		Date fechaApertura=null;
		if (jTextFieldFechaApertura.getText().length()>0)
			try {
				fechaApertura = new SimpleDateFormat("dd-MM-yyyy HH:mm").parse(jTextFieldFechaApertura.getText());
			} catch (ParseException e) {

				e.printStackTrace();
				System.out.println("Error en el formato de la fecha de apertura de ofertas");	
			}
		eventoApertura.setFechaApertura(fechaApertura);


		eventoApertura.setDescripcion(jTextPaneDescripcion.getText());
		eventoApertura.setLugar(jTextFieldLugar.getText());
		eventoApertura.setCalle(jTextFieldCalle.getText());
		eventoApertura.setCp(jTextFieldCP.getText());
		eventoApertura.setPoblacion(jTextFieldPoblacion.getText());
		eventoApertura.setPais((String)jComboBoxPais.getSelectedItem());
		eventoApertura.setIdPais(jComboBoxPais.getSelectedIndex());

		if (tipoDocumento.equalsIgnoreCase(TipoDocumento.CN)){
			ExpedienteBean cn=SessionDataManager.getInstance().getExpediente();
			cn.setEventoApertura(eventoApertura);
			SessionDataManager.getInstance().setExpediente(cn);
		}
		
		eventoApertura.setTipoEventoApertura((String)comboBoxTipoEventoApertura.getSelectedItem());
		eventoApertura.setIdTipoEventoApertura(comboBoxTipoEventoApertura.getSelectedIndex());
		eventoApertura.setRequisitosAsistentes(textFieldRequisitosAsistentes.getText());
		
		//Si todos los elementos del evento de apertura son null menos el pais, se devuelve el evento a null
		if (eventoApertura.getDescripcion().isEmpty()
				&& eventoApertura.getLugar().isEmpty()
				&& eventoApertura.getCalle().isEmpty()
				&& eventoApertura.getCp().isEmpty()
				&& eventoApertura.getPoblacion().isEmpty()) eventoApertura=null;
		
		
		
		
		return eventoApertura;
	}

	public void setEventoApertura(EventoAperturaBean eventoApertura) {
		this.eventoApertura = eventoApertura;
	}

	public EventosAperturaForm(JFrame ventanaPadre,String tipoDocumento)  throws ModelException {
		super();
		initialize();		
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null; 
		this.tipoDocumento=tipoDocumento;
		
		 
		setHasButtonPrev(true);
		jLabelFechaApertura = new JLabel();
		jLabelFechaApertura.setBounds(101, 223, 335, 18);
		getPanel().add(jLabelFechaApertura);
		jLabelFechaApertura.setText("Fecha de apertura de ofertas (dd-mm-aaaa hh:mm):");
		getPanel().add(getJTextFieldFechaApertura());
		jLabelEventoApertura = new JLabel();
		jLabelEventoApertura.setBounds(27, 73, 288, 35);
		getPanel().add(jLabelEventoApertura);
		jLabelEventoApertura.setText("Evento de apertura de oferta");
		jLabelEventoApertura.setFont(new Font("Dialog", Font.BOLD, 18));
		
		JLabel lblTipoDeEvento = new JLabel();
		lblTipoDeEvento.setText("Tipo de evento de apertura");
		lblTipoDeEvento.setSize(new Dimension(215, 18));
		lblTipoDeEvento.setLocation(new Point(102, 510));
		lblTipoDeEvento.setBounds(101, 333, 215, 18);
		getPanel().add(lblTipoDeEvento);
		
		comboBoxTipoEventoApertura = new JComboBox();
		comboBoxTipoEventoApertura.setSize(new Dimension(250, 18));
		comboBoxTipoEventoApertura.setLocation(new Point(435, 510));
		comboBoxTipoEventoApertura.setBounds(435, 333, 250, 18);
		ComboBoxUtils.loadComboBoxFromConstant(comboBoxTipoEventoApertura, ConstantsGC.ATTENDANCERESTRICTIONCODE);
		getPanel().add(comboBoxTipoEventoApertura);
		
		JLabel lblCondicionesDeAcceso = new JLabel();
		lblCondicionesDeAcceso.setText("Condiciones de acceso al evento de apertura:");
		lblCondicionesDeAcceso.setSize(new Dimension(215, 18));
		lblCondicionesDeAcceso.setLocation(new Point(102, 510));
		lblCondicionesDeAcceso.setBounds(101, 352, 344, 18);
		getPanel().add(lblCondicionesDeAcceso);
		jLabelLugarAperturaEconomica = new JLabel();
		jLabelLugarAperturaEconomica.setBounds(59, 416, 230, 16);
		getPanel().add(jLabelLugarAperturaEconomica);
		jLabelLugarAperturaEconomica.setText("Lugar de apertura de oferta:");
		jLabelLugar = new JLabel();
		jLabelLugar.setBounds(102, 446, 215, 18);
		getPanel().add(jLabelLugar);
		jLabelLugar.setText("Lugar:");
		jLabelCalle = new JLabel();
		jLabelCalle.setBounds(102, 476, 215, 18);
		getPanel().add(jLabelCalle);
		jLabelCalle.setText("Calle:");
		jLabelCP = new JLabel();
		jLabelCP.setBounds(102, 506, 215, 18);
		getPanel().add(jLabelCP);
		jLabelCP.setText("CP:");
		jLabelPoblacion = new JLabel();
		jLabelPoblacion.setBounds(102, 536, 215, 18);
		getPanel().add(jLabelPoblacion);
		jLabelPoblacion.setText("Poblacin:");
		jLabelPais = new JLabel();
		jLabelPais.setBounds(102, 566, 215, 18);
		getPanel().add(jLabelPais);
		jLabelPais.setText("Pas:");
		getPanel().add(getJTextFieldLugar());
		getPanel().add(getJTextFieldCalle());
		getPanel().add(getJTextFieldCP());
		getPanel().add(getJTextFieldPoblacion());
		getPanel().add(getJComboBoxPais());
		
		textFieldRequisitosAsistentes = new JTextArea();
		textFieldRequisitosAsistentes.setBounds(101, 371, 584, 45);
		textFieldRequisitosAsistentes.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		getPanel().add(textFieldRequisitosAsistentes);
		
 
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosEventosApertura();
		}
		
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosEventosApertura();
			}
		});
		
	}

	private void initialize() {

		
		
		
		getJPanelContenido();
		
		this.setTitle("Eventos de Apertura - Configuracin");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	 
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelDescripcion = new JLabel();
			jLabelDescripcion.setText("Descripcin:");
			jLabelDescripcion.setLocation(new Point(102, 250));
			jLabelDescripcion.setSize(new Dimension(215, 18));
			jLabelNombreEvento = new JLabel();
			jLabelNombreEvento.setText("Nombre:");
			jLabelNombreEvento.setSize(new Dimension(215, 18));
			jLabelNombreEvento.setLocation(new Point(102, 190));
			jLabelEventoAperturaEconomica = new JLabel();
			jLabelEventoAperturaEconomica.setText("Evento de apertura de oferta econmica:");
			jLabelEventoAperturaEconomica.setLocation(new Point(59, 145));
			jLabelEventoAperturaEconomica.setSize(new Dimension(250, 18));
		 
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.setSize(new Dimension(800, 600));
			jPanelContenido.add(jLabelEventoAperturaEconomica, null);
			jPanelContenido.add(jLabelNombreEvento, null);
			jPanelContenido.add(jLabelDescripcion, null);
			jPanelContenido.add(getJTextFieldNombre(), null);
			jPanelContenido.add(getJTextPaneDescripcion(), null);
			
		}
		return jPanelContenido;
	}

 
		



	/**
	 * This method initializes jTextFieldNombre	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldNombre() {
		if (jTextFieldNombre == null) {
			jTextFieldNombre = new JTextField();
			jTextFieldNombre.setLocation(new Point(435, 190));
			jTextFieldNombre.setSize(new Dimension(250, 18));
		}
		return jTextFieldNombre;
	}

	/**
	 * This method initializes jTextFieldFechaApertura	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldFechaApertura() {
		if (jTextFieldFechaApertura == null) {
			jTextFieldFechaApertura = new JTextField();
			SimpleDateFormat dateFormat;
			dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm");
			jTextFieldFechaApertura.setText(dateFormat.format(new Date()));
			jTextFieldFechaApertura.setBounds(435, 223, 250, 18);
		}
		return jTextFieldFechaApertura;
	}

	/**
	 * This method initializes jTextPaneDescripcion	
	 * 	
	 * @return javax.swing.JTextPane	
	 */
	private JTextPane getJTextPaneDescripcion() {
		if (jTextPaneDescripcion == null) {
			jTextPaneDescripcion = new JTextPane();
			jTextPaneDescripcion.setBackground(SystemColor.control);
			jTextPaneDescripcion.setSize(new Dimension(250, 68));
			jTextPaneDescripcion.setLocation(new Point(435, 250));
		}
		return jTextPaneDescripcion;
	}

	/**
	 * This method initializes jTextFieldLugar	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldLugar() {
		if (jTextFieldLugar == null) {
			jTextFieldLugar = new JTextField();
			jTextFieldLugar.setBounds(435, 446, 250, 18);
		}
		return jTextFieldLugar;
	}

	/**
	 * This method initializes jTextFieldCalle	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldCalle() {
		if (jTextFieldCalle == null) {
			jTextFieldCalle = new JTextField();
			jTextFieldCalle.setBounds(435, 476, 250, 18);
		}
		return jTextFieldCalle;
	}

	/**
	 * This method initializes jTextFieldCP	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldCP() {
		if (jTextFieldCP == null) {
			jTextFieldCP = new JTextField();
			jTextFieldCP.setBounds(435, 506, 250, 18);
		}
		return jTextFieldCP;
	}

	/**
	 * This method initializes jTextFieldPoblacion	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldPoblacion() {
		if (jTextFieldPoblacion == null) {
			jTextFieldPoblacion = new JTextField();
			jTextFieldPoblacion.setBounds(435, 536, 250, 18);
		}
		return jTextFieldPoblacion;
	}

	/**
	 * This method initializes jComboBoxPais	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJComboBoxPais() {
		if (jComboBoxPais == null) {
			jComboBoxPais = new JComboBox();
			jComboBoxPais.setBounds(435, 566, 250, 18);
			ComboBoxUtils.loadComboBoxFromConstant(jComboBoxPais, ConstantsGC.COUNTRY_CODE);
			jComboBoxPais.setSelectedItem("Espaa");
		}
		return jComboBoxPais;
	}

	public void actionPerformed(ActionEvent e) {

		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			getEventoApertura();
			gestorVentanasFormCD[0].setVisible(true);
			
			ExpedienteBean cn=SessionDataManager.getInstance().getExpediente();
			cn.setEventoApertura(getEventoApertura());
			SessionDataManager.getInstance().setExpediente(cn);
		}
	}
	
	
	/**
	 * La funcin rellena los datos del formulario a partir de los indicados en el objeto expediente.
	 * Los valores del objeto lotes son los que se han almacenado con anterioridad en session
	 */
	private void escribeDatosEventosApertura(){

		EventoAperturaBean eventoApertura = expediente.getEventoApertura();
		
		DateFormat df = new SimpleDateFormat("MM-dd-yyyy HH:mm");
		
		if(eventoApertura != null){
			jTextFieldNombre.setText(eventoApertura.getNombre());

			if (eventoApertura.getFechaApertura() != null){
				jTextFieldFechaApertura.setText(df.format(eventoApertura.getFechaApertura()));
			}	

			jTextPaneDescripcion.setText(eventoApertura.getDescripcion());
			comboBoxTipoEventoApertura.setSelectedIndex(eventoApertura.getIdTipoEventoApertura());
			textFieldRequisitosAsistentes.setText(eventoApertura.getRequisitosAsistentes());
			jTextFieldLugar.setText(eventoApertura.getLugar());
			jTextFieldCalle.setText(eventoApertura.getCalle());
			jTextFieldCP.setText(eventoApertura.getCp());
			jTextFieldPoblacion.setText(eventoApertura.getPoblacion());
			jComboBoxPais.setSelectedIndex(eventoApertura.getIdPais());

		}

	}
	
}
