/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service.commons;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;

import org.jcp.xml.dsig.internal.dom.DOMXPathFilter2Transform;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.LicitadorBean;
import es.dgpe.place.client.components.ComboListenerCountry;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;



public class LicitadorForm extends ThemeJFrame{


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;  //  @jve:decl-index=0:visual-constraint="17,624"

	private JLabel jLabelDatosLic = null;

 
  
	
	JFrame gestorVentanasFormCD[] = new JFrame[2];

	private JLabel jLabelLicitador = null;

	private JLabel jLabelNombreLic = null;

	private JLabel jLabeIdentificador = null;

	private JLabel jLabeMotivacion = null;

	private JLabel jLabelLugarDatosAdj = null;

	private JTextField jTextFieldNombre = null;

	private JTextPane jTextAreaMotivacion = null;

	private String tipoDocumento=null;

	private JLabel jLabeFechaAdjudicacion = null;

	private JLabel jLabeImporteSin = null;

	private JLabel jLabeImporteCon = null;

	private JTextField jTextFieldImporteSin = null;

	private JTextField jTextFieldImporteCon = null;

	private JTextField jTextFieldFechaAdj=null;
	
	private JTextField jTextFieldFechaFinForm=null;
	
	private LicitadorBean licitador;

	private JLabel jLabelFinFormalizacion = null;
	
	private ExpedienteBean expediente;
	
	private JComboBox<String> jComboBoxPais;
    private JComboBox<String> jComboBoxNuts;
    private JLabel lblLugarDeEjecucin;


	private JComboBox<String> jComboBoxTipoIdentificador = null;
	JComboBox<String> jComboBoxEsPyme = new JComboBox<String>();
	JComboBox<String> jComboBoxOfertasBajas = new JComboBox<String>();

	private JTextField jTextFieldIdentificador = null;
	private JTextField jtextFieldNumOfertasRecibidas;
	private JTextField jtextFieldnumOfertasPymes;
	private JTextField jtextFieldnumOfertasExtranjerosUE;
	private JTextField jtextFieldnumOfertasExtranjerosNoUE;
	private JTextField jtextFieldnumOfertasElectronicas;
	private JLabel lblPasOrigenDel;
	private JComboBox<String> comboBoxPaisOrigen;
	private JTextField txtDescripcionLimiteFormalizacion;
	private JLabel lblDireccin;
	private JTextField jtextFieldDireccion;
	private JTextField jtextFieldCiudad;
	private JTextField jtextFieldCodigoPostal;

	public LicitadorForm(JFrame ventanaPadre,String tipoDocumento) throws ModelException {
		super();
		initialize();		
		cargarDatosComboBoxs();
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null;

		setHasButtonPrev(true);
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosLicitador();
		}
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosLicitador();
			}
		});
		
		this.tipoDocumento=tipoDocumento;
		
	}

	private void initialize() {

		 getJPanelContenido();
		
		this.setTitle("Licitador - Configuracin");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	 
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelFinFormalizacion = new JLabel();
			jLabelFinFormalizacion.setText("Plazo l\u00EDmite formalizaci\u00F3n (dd-mm-aaaa hh:mm):");
			jLabelFinFormalizacion.setSize(new Dimension(307, 18));
			jLabelFinFormalizacion.setLocation(new Point(101, 456));
			jLabeImporteCon = new JLabel();
			jLabeImporteCon.setText("Importe Adjudicacion (Con impuestos)");
			jLabeImporteCon.setLocation(new Point(101, 426));
			jLabeImporteCon.setSize(new Dimension(220, 18));
			jLabeImporteSin = new JLabel();
			jLabeImporteSin.setText("Importe Adjudicacion (Sin impuestos)");
			jLabeImporteSin.setSize(new Dimension(215, 18));
			jLabeImporteSin.setLocation(new Point(101, 396));
			jLabeFechaAdjudicacion = new JLabel();
			jLabeFechaAdjudicacion.setText("Fecha adjudicaci\u00F3n (dd-mm-aaaa):");
			jLabeFechaAdjudicacion.setSize(new Dimension(238, 18));
			jLabeFechaAdjudicacion.setLocation(new Point(101, 366));
			jLabelLicitador = new JLabel();
			jLabelLicitador.setText("Adjudicatario");
			jLabelLicitador.setSize(new Dimension(288, 35));
			jLabelLicitador.setLocation(new Point(25, 79));
			jLabelLicitador.setFont(new Font("Dialog", Font.BOLD, 18));
			jLabelDatosLic = new JLabel();
			jLabelDatosLic.setText("Datos del licitador:");
			jLabelDatosLic.setLocation(new Point(61, 121));
			jLabelDatosLic.setSize(new Dimension(250, 18));
		 
			getPanel().add(getJComboBoxNuts());
            getPanel().add(getJComboBoxPais());
            getPanel().add(getLblLugarDeEjecucin());
			jComboBoxPais.addItemListener(new ComboListenerCountry(jComboBoxPais,jComboBoxNuts));
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.setSize(new Dimension(800, 600));
			jPanelContenido.add(jLabelDatosLic, null); 
			
			jPanelContenido.add(jLabelLicitador, null);
			jPanelContenido.add(jLabeFechaAdjudicacion, null);
			jPanelContenido.add(jLabeImporteSin, null);
			jPanelContenido.add(jLabeImporteCon, null);
			
			jPanelContenido.add(jLabelFinFormalizacion, null);
			
			getPanel().add(getJTextFieldNombre());
			getPanel().add(getJTextAreaMotivacion());
			getPanel().add(getJTextFieldImporteSin());
			getPanel().add(getJTextFieldImporteCon());
			getPanel().add(getJComboBoxTipoIdentificador());
			getPanel().add(getJTextFieldIdentificador());
			getPanel().add(getJTextFieldFechaAdj());
			getPanel().add(getJTextFieldFechaFinForm());
			
			

			
			JLabel lblNmeroDeOfertas = new JLabel("Ofertas recibidas");
			lblNmeroDeOfertas.setBounds(97, 486, 285, 14);
			getPanel().add(lblNmeroDeOfertas);
			
			jtextFieldNumOfertasRecibidas = new JTextField();
			jtextFieldNumOfertasRecibidas.setBounds(429, 484, 86, 20);
			getPanel().add(jtextFieldNumOfertasRecibidas);
			jtextFieldNumOfertasRecibidas.setColumns(10);
			
			JLabel lblNumeroOfertasPymes = new JLabel("Ofertas recibidas de PYMEs");
			lblNumeroOfertasPymes.setBounds(97, 511, 285, 14);
			getPanel().add(lblNumeroOfertasPymes);
			
			jtextFieldnumOfertasPymes = new JTextField();
			jtextFieldnumOfertasPymes.setColumns(10);
			jtextFieldnumOfertasPymes.setBounds(429, 509, 86, 20);
			getPanel().add(jtextFieldnumOfertasPymes);
			
			JLabel lblnumOfertasExtranjerosUE = new JLabel("Ofertas recibidas extranjeros comunitarios (UE)");
			lblnumOfertasExtranjerosUE.setBounds(97, 534, 285, 14);
			getPanel().add(lblnumOfertasExtranjerosUE);
			
			JLabel lblnumOfertasExtranjerosNoUE = new JLabel("Ofertas recibidas extranjeros extracomunitarios (No UE)");
			lblnumOfertasExtranjerosNoUE.setBounds(97, 559, 285, 14);
			getPanel().add(lblnumOfertasExtranjerosNoUE);
			
			JLabel lblnumOfertasElectronicas = new JLabel("Ofertas electr\u00F3nicas recibidas");
			lblnumOfertasElectronicas.setBounds(97, 583, 285, 14);
			getPanel().add(lblnumOfertasElectronicas);
			
			jtextFieldnumOfertasExtranjerosUE = new JTextField();
			jtextFieldnumOfertasExtranjerosUE.setColumns(10);
			jtextFieldnumOfertasExtranjerosUE.setBounds(429, 532, 86, 20);
			getPanel().add(jtextFieldnumOfertasExtranjerosUE);
			
			jtextFieldnumOfertasExtranjerosNoUE = new JTextField();
			jtextFieldnumOfertasExtranjerosNoUE.setColumns(10);
			jtextFieldnumOfertasExtranjerosNoUE.setBounds(429, 557, 86, 20);
			getPanel().add(jtextFieldnumOfertasExtranjerosNoUE);
			
			jtextFieldnumOfertasElectronicas = new JTextField();
			jtextFieldnumOfertasElectronicas.setColumns(10);
			jtextFieldnumOfertasElectronicas.setBounds(429, 581, 86, 20);
			getPanel().add(jtextFieldnumOfertasElectronicas);
			jLabelLugarDatosAdj = new JLabel();
			jLabelLugarDatosAdj.setBounds(63, 308, 230, 16);
			getPanel().add(jLabelLugarDatosAdj);
			jLabelLugarDatosAdj.setText("Datos de la adjudicacin:");
			
			JLabel lblAdjudicatarioPyme = new JLabel();
			lblAdjudicatarioPyme.setText("El adjudicatario es una PYME");
			lblAdjudicatarioPyme.setSize(new Dimension(215, 18));
			lblAdjudicatarioPyme.setLocation(new Point(97, 149));
			lblAdjudicatarioPyme.setBounds(97, 187, 215, 18);
			getPanel().add(lblAdjudicatarioPyme);
			
			
			jComboBoxEsPyme.setBounds(422, 187, 100, 18);
			getPanel().add(jComboBoxEsPyme);	
			
			JLabel lblnumOfertasBajas = new JLabel("Se han recibido ofertas anormalmente bajas");
			lblnumOfertasBajas.setBounds(97, 611, 285, 14);
			getPanel().add(lblnumOfertasBajas);
			
			
			jComboBoxOfertasBajas.setBounds(429, 612, 86, 20);
			getPanel().add(jComboBoxOfertasBajas);
			getPanel().add(getLblPasOrigenDel());
			getPanel().add(getComboBoxPaisOrigen());
			
			txtDescripcionLimiteFormalizacion = new JTextField();
			txtDescripcionLimiteFormalizacion.setText("Descripci\u00F3n...");
			txtDescripcionLimiteFormalizacion.setBounds(564, 454, 349, 38);
			getPanel().add(txtDescripcionLimiteFormalizacion);
			jLabeMotivacion = new JLabel();
			jLabeMotivacion.setBounds(97, 335, 215, 18);
			getPanel().add(jLabeMotivacion);
			jLabeMotivacion.setText("Motivacin:");
			jLabelNombreLic = new JLabel();
			jLabelNombreLic.setBounds(97, 138, 215, 18);
			getPanel().add(jLabelNombreLic);
			jLabelNombreLic.setText("Nombre:");
			jLabeIdentificador = new JLabel();
			jLabeIdentificador.setBounds(97, 158, 215, 18);
			getPanel().add(jLabeIdentificador);
			jLabeIdentificador.setText("Identificador:");
			getPanel().add(getLblDireccin());
			
			jtextFieldDireccion = new JTextField();
			jtextFieldDireccion.setBounds(422, 215, 422, 18);
			getPanel().add(jtextFieldDireccion);
			
			JLabel lblCiudad = new JLabel();
			lblCiudad.setText("Ciudad");
			lblCiudad.setSize(new Dimension(215, 18));
			lblCiudad.setLocation(new Point(97, 149));
			lblCiudad.setBounds(97, 245, 215, 18);
			getPanel().add(lblCiudad);
			
			jtextFieldCiudad = new JTextField();
			jtextFieldCiudad.setBounds(422, 244, 173, 18);
			getPanel().add(jtextFieldCiudad);
			
			JLabel lblCdigoPostal = new JLabel();
			lblCdigoPostal.setText("C\u00F3digo Postal");
			lblCdigoPostal.setSize(new Dimension(215, 18));
			lblCdigoPostal.setLocation(new Point(97, 149));
			lblCdigoPostal.setBounds(637, 244, 79, 18);
			getPanel().add(lblCdigoPostal);
			
			jtextFieldCodigoPostal = new JTextField();
			jtextFieldCodigoPostal.setBounds(726, 245, 118, 18);
			getPanel().add(jtextFieldCodigoPostal);

		}
		return jPanelContenido;
	}

 
		
 
	/**
	 * This method initializes jTextFieldNombre	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldNombre() {
		if (jTextFieldNombre == null) {
			jTextFieldNombre = new JTextField();
			jTextFieldNombre.setBounds(422, 138, 422, 18);
		}
		return jTextFieldNombre;
	}

	/**
	 * This method initializes jTextAreaMotivacion	
	 * 	
	 * @return javax.swing.JTextPane	
	 */
	private JTextPane getJTextAreaMotivacion() {
		if (jTextAreaMotivacion == null) {
			jTextAreaMotivacion = new JTextPane();
			jTextAreaMotivacion.setBounds(429, 324, 484, 29);
			jTextAreaMotivacion.setBackground(SystemColor.control);
			jTextAreaMotivacion.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
		}
		return jTextAreaMotivacion;
	}

	/**
	 * This method initializes jTextFieldImporteSin	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteSin() {
		if (jTextFieldImporteSin == null) {
			jTextFieldImporteSin = new JTextField();
			jTextFieldImporteSin.setBounds(429, 395, 250, 18);
		}
		return jTextFieldImporteSin;
	}

	/**
	 * This method initializes jTextFieldImporteCon	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldImporteCon() {
		if (jTextFieldImporteCon == null) {
			jTextFieldImporteCon = new JTextField();
			jTextFieldImporteCon.setBounds(429, 425, 250, 18);
		}
		return jTextFieldImporteCon;
	}
 

	/**
	 * This method initializes jTextFechaAdj	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldFechaAdj() {
		if (jTextFieldFechaAdj == null) {
			jTextFieldFechaAdj = new JTextField();
			jTextFieldFechaAdj.setBounds(429, 365, 250, 18);
			SimpleDateFormat dateFormat;
			dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			jTextFieldFechaAdj.setText(dateFormat.format(new Date()));
					}
		return jTextFieldFechaAdj;
	}
 

	/**
	 * This method initializes jTextFieldImporteCon	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldFechaFinForm() {
		if (jTextFieldFechaFinForm == null) {
			jTextFieldFechaFinForm = new JTextField();
			jTextFieldFechaFinForm.setBounds(429, 455, 118, 18);
			SimpleDateFormat dateFormat;
			dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm");
			jTextFieldFechaFinForm.setText(dateFormat.format(new Date()));
		}
		return jTextFieldFechaFinForm;
	}
 
	 

	/**
	 * This method initializes jComboBoxTipoIdentificador	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox<String> getJComboBoxTipoIdentificador() {
		if (jComboBoxTipoIdentificador == null) {
			jComboBoxTipoIdentificador = new JComboBox<String>();
			jComboBoxTipoIdentificador.setBounds(422, 158, 100, 18);
		}
		return jComboBoxTipoIdentificador;
	}

	/**
	 * This method initializes jTextFieldIdentificador	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldIdentificador() {
		if (jTextFieldIdentificador == null) {
			jTextFieldIdentificador = new JTextField();
			jTextFieldIdentificador.setBounds(532, 158, 140, 18);
		}
		return jTextFieldIdentificador;
	}

	public LicitadorBean getLicitador(){
		if (licitador==null) licitador=new LicitadorBean();
			
			licitador.setNombre(jTextFieldNombre.getText());
			licitador.setTipoIdentificador((String)jComboBoxTipoIdentificador.getSelectedItem());;
			licitador.setIdtipoIdentificador(jComboBoxTipoIdentificador.getSelectedIndex());
			licitador.setIdentificador(jTextFieldIdentificador.getText());
			
			if (jComboBoxEsPyme.getSelectedItem().toString().length() > 0){
				licitador.setAdjudicatarioPyme(Boolean.valueOf(ComboBoxUtils.getComboBoxByConstant(ConstantsGC.SI_NO)[jComboBoxEsPyme.getSelectedIndex()-1][1]));
			}
		
			
			licitador.setMotivacion(jTextAreaMotivacion.getText());
			
			Date fechaAdj=null;
			if (jTextFieldFechaAdj.getText().length()>0)
			try {
				fechaAdj = new SimpleDateFormat("dd-MM-yyyy").parse(jTextFieldFechaAdj.getText());
			} catch (ParseException e) {
				e.printStackTrace();
				System.out.println("Error en el formato de la fecha de apertura de ofertas");	
			}
			licitador.setFechaAdjudicacion(fechaAdj);
			
			licitador.setImporteSinImpuestos(jTextFieldImporteSin.getText());
			licitador.setImporteConImpuestos(jTextFieldImporteCon.getText());
			
			if (jtextFieldNumOfertasRecibidas.getText().length() > 0){
				licitador.setNumOfertasRecibidas(Integer.parseInt(jtextFieldNumOfertasRecibidas.getText()));
			}
			
			Date fechaFinForm=null;
			if (jTextFieldFechaFinForm.getText().length()>0){
				try {
					fechaFinForm = new SimpleDateFormat("dd-MM-yyyy HH:mm").parse(jTextFieldFechaFinForm.getText());
				} catch (ParseException e) {
					
					e.printStackTrace();
					System.out.println("Error en el formato de la fecha de apertura de ofertas");	
				}
				licitador.setFechaFinFormalizacion(fechaFinForm);
			}
			 
			if (jtextFieldnumOfertasPymes.getText().length() > 0){
				licitador.setNumOfertasRecibidasPymes(Integer.parseInt(jtextFieldnumOfertasPymes.getText()));
			} 
			
			if (jtextFieldnumOfertasExtranjerosUE.getText().length() > 0){
				licitador.setNumOfertasExtranjerosUE(Integer.parseInt(jtextFieldnumOfertasExtranjerosUE.getText()));
			} 
			
			if (jtextFieldnumOfertasExtranjerosNoUE.getText().length() > 0){
				licitador.setNumOfertasExtranjerosNoUE(Integer.parseInt(jtextFieldnumOfertasExtranjerosNoUE.getText()));
			} 
			
			if (jtextFieldnumOfertasElectronicas.getText().length() > 0){
				licitador.setNumOfertasElectronicas(Integer.parseInt(jtextFieldnumOfertasElectronicas.getText()));
			} 
			
			
			if (jComboBoxOfertasBajas.getSelectedItem().toString().length() > 0){			
				licitador.setOfertasBajas(Boolean.valueOf(ComboBoxUtils.getComboBoxByConstant(ConstantsGC.SI_NO)[jComboBoxOfertasBajas.getSelectedIndex()-1][1]));
			}
			
			if (comboBoxPaisOrigen.getSelectedItem().toString().length() > 0){			
				licitador.setPaisOrigen((String)(ComboBoxUtils.getComboBoxByConstant(ConstantsGC.COUNTRY_CODE)[comboBoxPaisOrigen.getSelectedIndex()-1][1]));
			}
			licitador.setIdPaisOrigen(comboBoxPaisOrigen.getSelectedIndex()-1);
			
			licitador.setPais((String) jComboBoxPais.getSelectedItem());
			licitador.setIdPais(jComboBoxPais.getSelectedIndex());
	        
	        if (jComboBoxNuts.getSelectedIndex()>0){
	        	String nutsSeleccionado = (String)jComboBoxNuts.getSelectedItem();
	        	licitador.setNuts(nutsSeleccionado.substring(0, nutsSeleccionado.lastIndexOf("(")-1));
	        	licitador.setIdNuts(nutsSeleccionado.substring(nutsSeleccionado.lastIndexOf("(")+1, nutsSeleccionado.length()-1));
	        	}
	        
	        licitador.setDescripcionLimiteFormalizacion(txtDescripcionLimiteFormalizacion.getText());
	        
	        licitador.setDireccion(jtextFieldDireccion.getText());
	        licitador.setCiudad(jtextFieldCiudad.getText());
	        licitador.setCodigoPostal(jtextFieldCodigoPostal.getText());	 
		
		return licitador;
	}
	
	public void actionPerformed(ActionEvent e) {

		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			getLicitador();
			gestorVentanasFormCD[0].setVisible(true);
			
			ExpedienteBean expediente=SessionDataManager.getInstance().getExpediente();
			expediente.setLicitador(getLicitador());
			SessionDataManager.getInstance().setExpediente(expediente);		
		}
	}
	
	
	/**
	 * La funcin rellena los datos del formulario a partir de los indicados en el objeto expediente.
	 * Los valores del objeto expediente son los que se han almacenado con anterioridad en session
	 */
	private void escribeDatosLicitador(){

		LicitadorBean licitador = expediente.getLicitador();

		if (licitador != null){
			DateFormat df = new SimpleDateFormat("dd-MM-yyyy");
			DateFormat df2 = new SimpleDateFormat("dd-MM-yyyy HH:mm");

			jTextFieldNombre.setText(licitador.getNombre());
			jComboBoxTipoIdentificador.setSelectedIndex(licitador.getIdtipoIdentificador());
			jTextFieldIdentificador.setText(licitador.getIdentificador());

			jTextAreaMotivacion.setText(licitador.getMotivacion());
			if (licitador.getFechaAdjudicacion() != null){
				jTextFieldFechaAdj.setText(df.format(licitador.getFechaAdjudicacion()));
			}
			jTextFieldImporteSin.setText(licitador.getImporteSinImpuestos());
			jTextFieldImporteCon.setText(licitador.getImporteConImpuestos());
			
			if (licitador.getFechaFinFormalizacion() != null){
				jTextFieldFechaFinForm.setText(df2.format(licitador.getFechaFinFormalizacion()));
			}

			if (licitador.getNumOfertasRecibidas() != null){
				jtextFieldNumOfertasRecibidas.setText(licitador.getNumOfertasRecibidas().toString());
			}
			
			if (licitador.getNumOfertasRecibidasPymes() != null){
				jtextFieldnumOfertasPymes.setText(licitador.getNumOfertasRecibidasPymes().toString());
			}
			
			if (licitador.getNumOfertasExtranjerosUE() != null){
				jtextFieldnumOfertasExtranjerosUE.setText(licitador.getNumOfertasExtranjerosUE().toString());
			}
			
			if (licitador.getNumOfertasExtranjerosNoUE() != null){
				jtextFieldnumOfertasExtranjerosNoUE.setText(licitador.getNumOfertasExtranjerosNoUE().toString());
			}
			
			if (licitador.getNumOfertasElectronicas() != null){
				jtextFieldnumOfertasElectronicas.setText(licitador.getNumOfertasElectronicas().toString());
			}
			
			if (licitador.getOfertasBajas() != null){
				if (licitador.getOfertasBajas()){
					jComboBoxOfertasBajas.setSelectedIndex(1);
				}else{
					jComboBoxOfertasBajas.setSelectedIndex(2);
				}
			}
			
			comboBoxPaisOrigen.setSelectedIndex(licitador.getIdPaisOrigen()+1);
			
			jComboBoxPais.setSelectedIndex(licitador.getIdPais());
			jComboBoxNuts.setSelectedItem(licitador.getIdNuts());
			
			txtDescripcionLimiteFormalizacion.setText(licitador.getDescripcionLimiteFormalizacion());
			
	        jtextFieldDireccion.setText(licitador.getDireccion());
	        jtextFieldCiudad.setText(licitador.getCiudad());
	        jtextFieldCodigoPostal.setText(licitador.getCodigoPostal());
		}else{
			jComboBoxPais.setSelectedIndex(9);
			jComboBoxNuts.setSelectedItem("ES");
		}

	}
	
	public void cargarDatosComboBoxs() {
		ComboBoxUtils.loadComboBoxNoObligatorioFromConstant(jComboBoxEsPyme, ConstantsGC.SI_NO);
		ComboBoxUtils.loadComboBoxNoObligatorioFromConstant(jComboBoxOfertasBajas, ConstantsGC.SI_NO);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTipoIdentificador, ConstantsGC.DOCUMENT_TYPE);
		ComboBoxUtils.loadComboBoxNoObligatorioFromConstant(comboBoxPaisOrigen, ConstantsGC.COUNTRY_CODE);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxPais, ConstantsGC.COUNTRY_CODE);
		
	}
	
	private JLabel getLblPasOrigenDel() {
		if (lblPasOrigenDel == null) {
			lblPasOrigenDel = new JLabel("Pa\u00EDs origen del producto/servicio");
			lblPasOrigenDel.setBounds(97, 639, 285, 14);
		}
		return lblPasOrigenDel;
	}
	private JComboBox<String> getComboBoxPaisOrigen() {
		if (comboBoxPaisOrigen == null) {
			comboBoxPaisOrigen = new JComboBox<String>();
			comboBoxPaisOrigen.setBounds(429, 643, 201, 20);
		}
		return comboBoxPaisOrigen;
	}
	
	private JComboBox getJComboBoxPais() {
	      if (jComboBoxPais == null) {
	          jComboBoxPais = new JComboBox();
	          jComboBoxPais.setBounds(422, 272, 181, 18);
	      }
	      return jComboBoxPais;
		}
	private JComboBox getJComboBoxNuts() {
	      if (jComboBoxNuts == null) {
	          jComboBoxNuts = new JComboBox();
	          jComboBoxNuts.setBounds(639, 272, 205, 18);
	      }
	      return jComboBoxNuts;
		}
	
	private JLabel getLblLugarDeEjecucin() {
	      if (lblLugarDeEjecucin == null) {
	          lblLugarDeEjecucin = new JLabel("Pais / Nuts");
	          lblLugarDeEjecucin.setBounds(97, 274, 230, 14);
	      }
	      return lblLugarDeEjecucin;
	  }
	private JLabel getLblDireccin() {
		if (lblDireccin == null) {
			lblDireccin = new JLabel();
			lblDireccin.setText("Direcci\u00F3n");
			lblDireccin.setSize(new Dimension(215, 18));
			lblDireccin.setLocation(new Point(97, 149));
			lblDireccin.setBounds(97, 216, 215, 18);
		}
		return lblDireccin;
	}
}
