/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.LotesBean;
import es.dgpe.place.client.components.ComboListenerCountry;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;

public class LotesForm extends ThemeJFrame {


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;   

	
	JComboBox<String> jComboBoxCPVLote1 = null;
	JComboBox<String> jComboBoxCPVLote2 = null;
	
	private ButtonGroup buttonGroup = new ButtonGroup();;
	 

	JFrame gestorVentanasFormCD[] = new JFrame[2];


	private LotesBean lotes=null;
	private ExpedienteBean expediente;
	
	JComboBox<String>jComboBoxDebeOfertar = new JComboBox<String>();
	
	private JTextField jtextFieldLote1ImporteSinImpuestos;
	private JTextField jtextFieldLote1ImporteConImpuestos;
	private JTextField jtextFieldLote2ImporteSinImpuestos;
	private JTextField jtextFieldLote2ImporteConImpuestos;
	private JTextField jtextFieldNumeroMaximoPresentacion;
	private JTextField jtextFieldNumeroMaximoAdjudicacion;
	private JTextField jtextFieldDetallePosibilidadAdjudicacion;
	JRadioButton rdbtnLotesSi;
	JRadioButton rdbtnLotesNo;
	private JTextField jtextFieldLote1Descripcin;
	private JTextField jtextFieldLote2Descripcin;
	
	private JComboBox<String> jComboBoxLote1Pais;
    private JComboBox<String> jComboBoxLote1Nuts;
    
    private JComboBox<String> jComboBoxLote2Pais;
    private JComboBox<String> jComboBoxLote2Nuts;
	

	public LotesBean getLotes()  {
		if (lotes==null) lotes=new LotesBean();
		
		if (rdbtnLotesSi.isSelected()){
			lotes.setTieneLotes(true);
		}else{
			lotes.setTieneLotes(false);
		}
		
		if (jComboBoxDebeOfertar.getSelectedItem().toString().length() > 0){
			lotes.setDebeOfertar((String)jComboBoxDebeOfertar.getSelectedItem());
			lotes.setIdDebeOfertar(jComboBoxDebeOfertar.getSelectedIndex());
		}
		
		if (jComboBoxDebeOfertar.getSelectedItem().toString().length() > 0){
			lotes.setDebeOfertar((String)jComboBoxDebeOfertar.getSelectedItem());
			lotes.setIdDebeOfertar(jComboBoxDebeOfertar.getSelectedIndex());
		}
		
		if (jtextFieldNumeroMaximoPresentacion.getText().length() > 0){
			lotes.setNumeroMaximoPresentacion(Integer.valueOf(jtextFieldNumeroMaximoPresentacion.getText()));	
		}
		
		if (jtextFieldNumeroMaximoAdjudicacion.getText().length() > 0){
			lotes.setNumeroMaximoAdjudicacion(Integer.valueOf(jtextFieldNumeroMaximoAdjudicacion.getText()));
		}
		
		lotes.setDetallePosibilidadAdjudicacion(jtextFieldDetallePosibilidadAdjudicacion.getText());
		
		if (jtextFieldLote1ImporteSinImpuestos.getText().length() > 0){
			lotes.setLote1ImporteSinImpuestos(Double.valueOf(jtextFieldLote1ImporteSinImpuestos.getText()));
		}
		
		if (jtextFieldLote1ImporteConImpuestos.getText().length() > 0){
			lotes.setLote1ImporteConImpuestos(Double.valueOf(jtextFieldLote1ImporteConImpuestos.getText()));
		}
		
		if (jComboBoxCPVLote1.getSelectedItem().toString().length() > 0){
			lotes.setLote1Cpv((String)jComboBoxCPVLote1.getSelectedItem());
			lotes.setLote1IdCpv(jComboBoxCPVLote1.getSelectedIndex());
		}
		
		lotes.setLote1Descripcion(jtextFieldLote1Descripcin.getText());
		
		lotes.setLote1Pais((String) jComboBoxLote1Pais.getSelectedItem());
		lotes.setLote1IdPais(jComboBoxLote1Pais.getSelectedIndex());
		
		if (jComboBoxLote1Nuts.getSelectedIndex()>-1){
		String nutsSeleccionado = (String)jComboBoxLote1Nuts.getSelectedItem();
        lotes.setLote1Nuts(nutsSeleccionado.substring(0, nutsSeleccionado.lastIndexOf("(")-1));
        lotes.setLote1IdNuts(nutsSeleccionado.substring(nutsSeleccionado.lastIndexOf("(")+1, nutsSeleccionado.length()-1));}
		
		
		if (jtextFieldLote2ImporteSinImpuestos.getText().length() > 0){
			lotes.setLote2ImporteSinImpuestos(Double.valueOf(jtextFieldLote2ImporteSinImpuestos.getText()));
		}
		
		if (jtextFieldLote2ImporteConImpuestos.getText().length() > 0){
			lotes.setLote2ImporteConImpuestos(Double.valueOf(jtextFieldLote2ImporteConImpuestos.getText()));
		}
		
		if (jComboBoxCPVLote2.getSelectedItem().toString().length() > 0){
			lotes.setLote2Cpv((String)jComboBoxCPVLote2.getSelectedItem());
			lotes.setLote2IdCpv(jComboBoxCPVLote2.getSelectedIndex());
		}
		
				
		lotes.setLote2Descripcion(jtextFieldLote2Descripcin.getText());
		
		lotes.setLote2Pais((String) jComboBoxLote2Pais.getSelectedItem());
		lotes.setLote2IdPais(jComboBoxLote2Pais.getSelectedIndex());
		
		if (jComboBoxLote2Nuts.getSelectedIndex()>-1){
		String nutsSeleccionado = (String)jComboBoxLote2Nuts.getSelectedItem();
        lotes.setLote2Nuts(nutsSeleccionado.substring(0, nutsSeleccionado.lastIndexOf("(")-1));
        lotes.setLote2IdNuts(nutsSeleccionado.substring(nutsSeleccionado.lastIndexOf("(")+1, nutsSeleccionado.length()-1));}

		return lotes;
	}



	public LotesForm(JFrame ventanaPadre,String tipoDocumento)  throws ModelException {
		super();
		initialize();		
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null; 
		 
		setHasButtonPrev(true);
		
		JLabel lblElExpedienteTiene = new JLabel("El expediente tiene lotes");
		lblElExpedienteTiene.setBounds(70, 94, 183, 14);
		getPanel().add(lblElExpedienteTiene);
					
		JPanel panelLotes = new JPanel();
		panelLotes.setBorder(new LineBorder(new Color(0, 0, 0)));
		panelLotes.setBounds(67, 120, 810, 553);
		getPanel().add(panelLotes);
		panelLotes.setLayout(null);
		
		JLabel lblSeDebeOfertar = new JLabel("Se debe ofertar a ");
		lblSeDebeOfertar.setBounds(37, 38, 143, 14);
		panelLotes.add(lblSeDebeOfertar);
		
		
		jComboBoxDebeOfertar.setBounds(190, 35, 150, 20);
		panelLotes.add(jComboBoxDebeOfertar);
		
		JPanel panel = new JPanel();
		panel.setBackground(Color.WHITE);
		panel.setBounds(37, 208, 745, 155);
		panelLotes.add(panel);
		panel.setLayout(null);
		
		JLabel lblLoteN = new JLabel("Lote N\u00BA 1");
		lblLoteN.setBounds(10, 5, 51, 14);
		panel.add(lblLoteN);
		lblLoteN.setFont(new Font("Tahoma", Font.BOLD, 11));
		
		JLabel label = new JLabel();
		label.setText("Importe Base (Sin impuestos)");
		label.setBounds(20, 51, 246, 16);
		panel.add(label);
		
		JLabel label_1 = new JLabel();
		label_1.setText("Importe Base (Con impuestos)");
		label_1.setBounds(20, 76, 246, 16);
		panel.add(label_1);
		
		jtextFieldLote1ImporteSinImpuestos = new JTextField();
		jtextFieldLote1ImporteSinImpuestos.setBounds(391, 49, 210, 18);
		panel.add(jtextFieldLote1ImporteSinImpuestos);
		
		jtextFieldLote1ImporteConImpuestos = new JTextField();
		jtextFieldLote1ImporteConImpuestos.setBounds(391, 74, 210, 18);
		panel.add(jtextFieldLote1ImporteConImpuestos);
		
		JLabel label_3 = new JLabel();
		label_3.setText("C\u00F3digo CPV");
		label_3.setBounds(20, 103, 220, 18);
		panel.add(label_3);
		
		jComboBoxCPVLote1 = new JComboBox<String>();
		jComboBoxCPVLote1.setBounds(231, 103, 493, 18);
		panel.add(jComboBoxCPVLote1);
		
		JLabel lblDescripcin = new JLabel();
		lblDescripcin.setText("Descripci\u00F3n");
		lblDescripcin.setBounds(20, 24, 246, 16);
		panel.add(lblDescripcin);
		
		jtextFieldLote1Descripcin = new JTextField();
		jtextFieldLote1Descripcin.setBounds(391, 22, 210, 18);
		panel.add(jtextFieldLote1Descripcin);
		panel.add(getJComboBoxLote1Pais());
		panel.add(getJComboBoxLote1Nuts());
        jComboBoxLote1Pais.addItemListener(new ComboListenerCountry(jComboBoxLote1Pais,jComboBoxLote1Nuts));
		
		JLabel lblLugarDeEjecucin = new JLabel();
		lblLugarDeEjecucin.setText("Lugar de ejecuci\u00F3n");
		lblLugarDeEjecucin.setBounds(20, 126, 220, 18);
		panel.add(lblLugarDeEjecucin);
		
		JPanel panel_1 = new JPanel();
		panel_1.setLayout(null);
		panel_1.setBackground(Color.WHITE);
		panel_1.setBounds(37, 374, 745, 168);
		panelLotes.add(panel_1);
		
		JLabel lblLoteN_1 = new JLabel("Lote N\u00BA 2");
		lblLoteN_1.setFont(new Font("Tahoma", Font.BOLD, 11));
		lblLoteN_1.setBounds(10, 5, 51, 14);
		panel_1.add(lblLoteN_1);
		
		JLabel label_4 = new JLabel();
		label_4.setText("Importe Base (Sin impuestos)");
		label_4.setBounds(20, 53, 246, 16);
		panel_1.add(label_4);
		
		JLabel label_5 = new JLabel();
		label_5.setText("Importe Base (Con impuestos)");
		label_5.setBounds(20, 78, 246, 16);
		panel_1.add(label_5);
		
		jtextFieldLote2ImporteSinImpuestos = new JTextField();
		jtextFieldLote2ImporteSinImpuestos.setBounds(391, 51, 210, 18);
		panel_1.add(jtextFieldLote2ImporteSinImpuestos);
		
		jtextFieldLote2ImporteConImpuestos = new JTextField();
		jtextFieldLote2ImporteConImpuestos.setBounds(391, 76, 210, 18);
		panel_1.add(jtextFieldLote2ImporteConImpuestos);
		
		JLabel label_6 = new JLabel();
		label_6.setText("C\u00F3digo CPV");
		label_6.setBounds(20, 105, 220, 18);
		panel_1.add(label_6);
		
		jComboBoxCPVLote2 = new JComboBox<String>();
		jComboBoxCPVLote2.setBounds(231, 105, 493, 18);
		panel_1.add(jComboBoxCPVLote2);
		
		JLabel label_2 = new JLabel();
		label_2.setText("Descripci\u00F3n");
		label_2.setBounds(20, 26, 246, 16);
		panel_1.add(label_2);
		
		jtextFieldLote2Descripcin = new JTextField();
		jtextFieldLote2Descripcin.setBounds(391, 24, 210, 18);
		panel_1.add(jtextFieldLote2Descripcin);
		panel_1.add(getJComboBoxLote2Nuts());
		panel_1.add(getJComboBoxLote2Pais());
        jComboBoxLote2Pais.addItemListener(new ComboListenerCountry(jComboBoxLote2Pais,jComboBoxLote2Nuts));
		
		JLabel lblNMximoDe = new JLabel();
		lblNMximoDe.setText("N\u00BA m\u00E1ximo de lotes a los que se puede presentar");
		lblNMximoDe.setBounds(37, 69, 353, 16);
		panelLotes.add(lblNMximoDe);
		
		JLabel lblNMximoDe_1 = new JLabel();
		lblNMximoDe_1.setText("N\u00BA m\u00E1ximo de lotes que se pueden adjudicar al mismo licitador");
		lblNMximoDe_1.setBounds(37, 94, 377, 16);
		panelLotes.add(lblNMximoDe_1);
		
		jtextFieldNumeroMaximoPresentacion = new JTextField();
		jtextFieldNumeroMaximoPresentacion.setBounds(424, 68, 32, 18);
		panelLotes.add(jtextFieldNumeroMaximoPresentacion);
		
		jtextFieldNumeroMaximoAdjudicacion = new JTextField();
		jtextFieldNumeroMaximoAdjudicacion.setBounds(424, 92, 32, 18);
		panelLotes.add(jtextFieldNumeroMaximoAdjudicacion);
		
		JLabel lblElPoderAdjudicador = new JLabel();
		lblElPoderAdjudicador.setText("El poder adjudicador se reserva el derecho de adjudciar contrato que combinen los lotes o grupos de lotes siguientes:");
		lblElPoderAdjudicador.setBounds(37, 121, 745, 16);
		panelLotes.add(lblElPoderAdjudicador);
		
		jtextFieldDetallePosibilidadAdjudicacion = new JTextField();
		jtextFieldDetallePosibilidadAdjudicacion.setBounds(94, 150, 688, 47);
		panelLotes.add(jtextFieldDetallePosibilidadAdjudicacion);
		
		rdbtnLotesSi = new JRadioButton("S\u00ED");
		rdbtnLotesSi.setBackground(Color.WHITE);
		rdbtnLotesSi.setBounds(235, 90, 50, 23);
		getPanel().add(rdbtnLotesSi);
		buttonGroup.add(rdbtnLotesSi);
		
		rdbtnLotesNo = new JRadioButton("No");
		rdbtnLotesNo.setBackground(Color.WHITE);
		rdbtnLotesNo.setBounds(299, 90, 50, 23);
		rdbtnLotesNo.setSelected(true);
		getPanel().add(rdbtnLotesNo);
		buttonGroup.add(rdbtnLotesNo);
		
		cargarDatosComboBoxs();	
		 
		//Copiar hasta aqui a getJPanelContenido
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosLotes();
		}
		
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosLotes();
			}
		});

	}

	private void initialize() {
		getJPanelContenido();		
		this.setTitle("Lotes");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	 
	
	
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.setSize(new Dimension(800, 600));
		}
		return jPanelContenido;
	}
	
	public void cargarDatosComboBoxs() {
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxCPVLote1, ConstantsGC.CPV);  
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxCPVLote2, ConstantsGC.CPV);  
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxDebeOfertar, ConstantsGC.TENDER_PRESENTATION);  

		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxLote1Pais, ConstantsGC.COUNTRY_CODE);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxLote2Pais, ConstantsGC.COUNTRY_CODE);
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			getLotes();
			gestorVentanasFormCD[0].setVisible(true);
			
			ExpedienteBean expediente=SessionDataManager.getInstance().getExpediente();
			expediente.setLotes(getLotes());
			SessionDataManager.getInstance().setExpediente(expediente);
		}
	}
	
	
	/**
	 * La funcin rellena los datos del formulario a partir de los indicados en el objeto expediente.
	 * Los valores del objeto lotes son los que se han almacenado con anterioridad en session
	 */
	private void escribeDatosLotes(){

		LotesBean lotes = expediente.getLotes();

		if (lotes != null){
			if(lotes.isTieneLotes()){
				rdbtnLotesSi.setSelected(true);
			}else{
				rdbtnLotesNo.setSelected(true);
			}
			jComboBoxDebeOfertar.setSelectedIndex(lotes.getIdDebeOfertar());
			
			if (lotes.getNumeroMaximoPresentacion() != null){
				jtextFieldNumeroMaximoPresentacion.setText(lotes.getNumeroMaximoPresentacion().toString());	
			}
			
			if (lotes.getNumeroMaximoAdjudicacion() != null){
				jtextFieldNumeroMaximoAdjudicacion.setText(lotes.getNumeroMaximoAdjudicacion().toString());
			}
			
			jtextFieldDetallePosibilidadAdjudicacion.setText(lotes.getDetallePosibilidadAdjudicacion());
			
			if (lotes.getLote1ImporteSinImpuestos() != null){
				jtextFieldLote1ImporteSinImpuestos.setText(lotes.getLote1ImporteSinImpuestos().toString());
			}
			
			if(lotes.getLote1ImporteConImpuestos() != null){
				jtextFieldLote1ImporteConImpuestos.setText(lotes.getLote1ImporteConImpuestos().toString());
			}
			
			jComboBoxCPVLote1.setSelectedIndex(lotes.getLote1IdCpv());
			
			jtextFieldLote1Descripcin.setText(lotes.getLote1Descripcion());
			jComboBoxLote1Pais.setSelectedIndex(lotes.getLote1IdPais());
			jComboBoxLote1Nuts.setSelectedItem(lotes.getLote1Nuts() + " (" + lotes.getLote1IdNuts() + ")");
			
			
			
			if (lotes.getLote2ImporteSinImpuestos() != null){
				jtextFieldLote2ImporteSinImpuestos.setText(lotes.getLote2ImporteSinImpuestos().toString());
			}

			if (lotes.getLote2ImporteConImpuestos() != null){
				jtextFieldLote2ImporteConImpuestos.setText(lotes.getLote2ImporteConImpuestos().toString());
			}
			
			jComboBoxCPVLote2.setSelectedIndex(lotes.getLote2IdCpv());
			
			jtextFieldLote2Descripcin.setText(lotes.getLote2Descripcion());
			jComboBoxLote2Pais.setSelectedIndex(lotes.getLote2IdPais());
			jComboBoxLote2Nuts.setSelectedItem(lotes.getLote2Nuts() + " (" + lotes.getLote2IdNuts() + ")");
		}else{
			jComboBoxLote1Pais.setSelectedIndex(9);
			jComboBoxLote1Nuts.setSelectedItem("ES");
			jComboBoxLote2Pais.setSelectedIndex(9);
			jComboBoxLote2Nuts.setSelectedItem("ES");
		}
		
		

	}
	
	
	private JComboBox<String> getJComboBoxLote1Pais() {
	      if (jComboBoxLote1Pais == null) {
	    	  jComboBoxLote1Pais = new JComboBox<String>();
	    	  jComboBoxLote1Pais.setBounds(231, 126, 243, 18);
	      }
	      return jComboBoxLote1Pais;
	  }
	  private JComboBox<String> getJComboBoxLote1Nuts() {
	      if (jComboBoxLote1Nuts == null) {
	    	  jComboBoxLote1Nuts = new JComboBox<String>();
	    	  jComboBoxLote1Nuts.setBounds(484, 126, 243, 18);
	      }
	      return jComboBoxLote1Nuts;
	  }
	  
	  private JComboBox<String> getJComboBoxLote2Pais() {
	      if (jComboBoxLote2Pais == null) {
	    	  jComboBoxLote2Pais = new JComboBox<String>();
	    	  jComboBoxLote2Pais.setBounds(231, 134, 243, 18);
	      }
	      return jComboBoxLote2Pais;
	  }
	  private JComboBox<String> getJComboBoxLote2Nuts() {
	      if (jComboBoxLote2Nuts == null) {
	    	  jComboBoxLote2Nuts = new JComboBox<String>();
	    	  jComboBoxLote2Nuts.setBounds(484, 134, 243, 18);
	      }
	      return jComboBoxLote2Nuts;
	  }
	
	
}
