/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;

import es.dgpe.place.client.beans.DatosModificacionBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
//import com.michaelbaranov.microba.calendar.DatePicker;

public class ModificacionContratoForm extends ThemeJFrame {


	private static final long serialVersionUID = 1L;
	private JPanel jPanelContenido = null;   
		 

	JFrame gestorVentanasFormCD[] = new JFrame[2];

	private String tipoDocumento=null;
	//private DatosModificacionBean datosModificacion=null;
	
	private JLabel jLabelNumeroModificacion = null;
	private JLabel jLabelDuracion = null;
	
	private JTextField jTextFieldNumeroModificacion = null;
	private JTextField jTextFieldFechaModificacion;
	private JTextField jTextFieldIncSinImpuetos;
	private JTextField jTextFieldIncConImpuetos;
	private JTextField jTextFieldImporteFinalSinImpuestos;
	private JTextField jTextFieldImporteFinalConImpuestos;
	private JTextField jTextFieldDuracionFinal;
	private JTextField jTextFieldIncrementoDuracion;
	private JComboBox<String> jComboBoxUnidadDuracion;
	private JComboBox<String> jComboBoxUnidadIncremento;
	private JComboBox<String> comboBoxCodigoTipoModificacion;
	private JTextArea txtrAas;
	private JTextField textFieldJustificacion;
	


	public DatosModificacionBean getDatosModificacion()  {
		DatosModificacionBean datosModificacion = new DatosModificacionBean();
		
		
		//Nmero y fecha de modificacin
		datosModificacion.setNumeroModificiacion(jTextFieldNumeroModificacion.getText());
		
		if (jTextFieldFechaModificacion.getText().length() > 0){
			Date fechaModificacion=null;
			try {
				fechaModificacion = new SimpleDateFormat("dd-MM-yyyy").parse(jTextFieldFechaModificacion.getText());
			}catch (ParseException e) {
				e.printStackTrace();
				System.out.println("Error en el formato de la fecha de inicio del contrato");	
			}
			datosModificacion.setFechaModificacion(fechaModificacion);
		}
		
		
		//Importes de incremento
		if (jTextFieldIncSinImpuetos.getText().length() > 0){
			BigDecimal incrementoSinImpuestos = null;
			try{
				incrementoSinImpuestos = new BigDecimal(jTextFieldIncSinImpuetos.getText());
			}catch(NumberFormatException e){
				e.printStackTrace();
				System.out.println("Error en el formato del importe del incremento sin impuestos");	
			}
			datosModificacion.setIncrementoSinImpuestos(incrementoSinImpuestos);
		}
		if (jTextFieldIncConImpuetos.getText().length() > 0){
			BigDecimal incrementoConImpuestos = null;
			try{
				incrementoConImpuestos = new BigDecimal(jTextFieldIncConImpuetos.getText());
			}catch(NumberFormatException e){
				e.printStackTrace();
				System.out.println("Error en el formato del importe del incremento con impuestos");	
			}
			datosModificacion.setIncrementoConImpuestos(incrementoConImpuestos);
		}
		
		
		
		//Importes totales tras la modificacin
		if (jTextFieldImporteFinalSinImpuestos.getText().length() > 0){
			BigDecimal finalSinImpuestos = null;
			try{
				finalSinImpuestos = new BigDecimal(jTextFieldImporteFinalSinImpuestos.getText());
			}catch(NumberFormatException e){
				e.printStackTrace();
				System.out.println("Error en el formato del importe final sin impuestos");	
			}
			datosModificacion.setImporteTotalSinImpuestos(finalSinImpuestos);
		}
		if (jTextFieldImporteFinalConImpuestos.getText().length() > 0){
			BigDecimal finalConImpuestos = null;
			try{
				finalConImpuestos = new BigDecimal(jTextFieldImporteFinalConImpuestos.getText());
			}catch(NumberFormatException e){
				e.printStackTrace();
				System.out.println("Error en el formato del importe final con impuestos");	
			}
			datosModificacion.setImporteTotalConImpuestos(finalConImpuestos);
		}
		
		
		
		//Se indica el incremento de la duracin
		if (jTextFieldIncrementoDuracion.getText().length() > 0){
			BigDecimal incrementoDuracion = null;
			try{
				incrementoDuracion = new BigDecimal(jTextFieldIncrementoDuracion.getText());
			}catch(NumberFormatException e){
				e.printStackTrace();
				System.out.println("Error en el formato del incremento de la duracin");	
			}
			datosModificacion.setIncrementoDuracion(incrementoDuracion);
			datosModificacion.setUnidadDuracionIncremento(jComboBoxUnidadIncremento.getSelectedIndex());
		}

		//Se indica la duracin total
		if (jTextFieldDuracionFinal.getText().length() > 0){
			BigDecimal duracionFinal = null;
			try{
				duracionFinal = new BigDecimal(jTextFieldDuracionFinal.getText());
			}catch(NumberFormatException e){
				e.printStackTrace();
				System.out.println("Error en el formato de la duracin final");	
			}
			datosModificacion.setDuracionTotal(duracionFinal);
			datosModificacion.setUnidadDuracionTotal(jComboBoxUnidadDuracion.getSelectedIndex());
		}
		
	
		//Se indica la descripcin de la modificacin
		datosModificacion.setDescripcion(txtrAas.getText());

		datosModificacion.setCodigoMotivoModificacion(comboBoxCodigoTipoModificacion.getSelectedIndex());
		datosModificacion.setJustificacionModificacion(textFieldJustificacion.getText());
		
		
		return datosModificacion;
	}

	

	
	
	

	public ModificacionContratoForm(JFrame ventanaPadre,String tipoDocumento)  throws ModelException {
		super();
		initialize();		
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null; 
		this.tipoDocumento=tipoDocumento;
		cargarDatosComboBoxs();
		
		 
		setHasButtonPrev(true);//Copiar a partir de aqui a getJPanelContenido
	 
		//Copiar hasta aqui a getJPanelContenido
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
	}

	private void initialize() {

	
		getJPanelContenido();
		
		this.setTitle("Datos de Modificaci\u00F3n");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	
 
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
		 
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.setSize(new Dimension(800, 600));
			

			jLabelDuracion=new JLabel();
			jLabelDuracion.setText("Modifiacin de datos de Contrato");
			jLabelDuracion.setBounds(72, 87, 275, 14);
			
			jLabelNumeroModificacion= new JLabel();
			jLabelNumeroModificacion.setBounds(50, 114, 318, 14);
			getPanel().add(jLabelNumeroModificacion);
			jLabelNumeroModificacion.setText("Nmero de Modificacin(*)");
			
			JLabel jLabelFechaDeModificacin = new JLabel();
			jLabelFechaDeModificacin.setText("Fecha de Modificaci\u00F3n (dd-mm-aaaa)(*)");
			jLabelFechaDeModificacin.setBounds(50, 139, 318, 14);
			getPanel().add(jLabelFechaDeModificacin);
						
			jTextFieldNumeroModificacion = new JTextField();
			jTextFieldNumeroModificacion.setBounds(300, 112, 89, 18);
			getPanel().add(jTextFieldNumeroModificacion);
			
			jTextFieldFechaModificacion = new JTextField();
			jTextFieldFechaModificacion.setBounds(300, 139, 89, 18);
			getPanel().add(jTextFieldFechaModificacion);
			
			JPanel panel_1 = new JPanel();
			panel_1.setLayout(null);
			panel_1.setBorder(new TitledBorder(null, "Modificacin del importe", TitledBorder.LEADING, TitledBorder.TOP, new Font("Tahoma", Font.BOLD, 11)));
			panel_1.setBounds(50, 233, 666, 185);
			getPanel().add(panel_1);
			
			JLabel jLabelIncSinImpuetos = new JLabel();
			jLabelIncSinImpuetos.setText("Incremento/decremento del importe sin impuestos");
			jLabelIncSinImpuetos.setBounds(21, 49, 474, 14);
			panel_1.add(jLabelIncSinImpuetos);
			
			jTextFieldIncSinImpuetos = new JTextField();
			jTextFieldIncSinImpuetos.setBounds(340, 49, 122, 18);
			panel_1.add(jTextFieldIncSinImpuetos);
			
			JLabel jLabelIncConImpuetos = new JLabel();
			jLabelIncConImpuetos.setText("Incremento/decremento del importe con impuestos");
			jLabelIncConImpuetos.setBounds(21, 74, 474, 14);
			panel_1.add(jLabelIncConImpuetos);
			
			JLabel jLabelImporteFinalSinImpuestos = new JLabel();
			jLabelImporteFinalSinImpuestos.setText("Importe sin impuestos total tras la modificacion");
			jLabelImporteFinalSinImpuestos.setBounds(21, 120, 474, 14);
			panel_1.add(jLabelImporteFinalSinImpuestos);
			
			JLabel jLabelImporteFinalConImpuestos = new JLabel();
			jLabelImporteFinalConImpuestos.setText("Importe con impuestos total tras la modificacion");
			jLabelImporteFinalConImpuestos.setBounds(21, 145, 474, 14);
			panel_1.add(jLabelImporteFinalConImpuestos);
			
			jTextFieldIncConImpuetos = new JTextField();
			jTextFieldIncConImpuetos.setBounds(340, 73, 122, 18);
			panel_1.add(jTextFieldIncConImpuetos);
			
			jTextFieldImporteFinalSinImpuestos = new JTextField();
			jTextFieldImporteFinalSinImpuestos.setBounds(340, 119, 122, 18);
			panel_1.add(jTextFieldImporteFinalSinImpuestos);
			
			jTextFieldImporteFinalConImpuestos = new JTextField();
			jTextFieldImporteFinalConImpuestos.setBounds(340, 144, 122, 18);
			panel_1.add(jTextFieldImporteFinalConImpuestos);
			
			JPanel panel = new JPanel();
			panel.setLayout(null);
			panel.setBorder(new TitledBorder(null, "Modificacin de la duracin", TitledBorder.LEADING, TitledBorder.TOP, new Font("Tahoma", Font.BOLD, 11)));
			panel.setBounds(50, 429, 666, 98);
			getPanel().add(panel);
			
			JLabel jLabelDuracionFinal = new JLabel();
			jLabelDuracionFinal.setText("Duraci\u00F3n total del contrato tras la modificaci\u00F3n");
			jLabelDuracionFinal.setBounds(23, 66, 419, 14);
			panel.add(jLabelDuracionFinal);
			
			jTextFieldDuracionFinal = new JTextField();
			jTextFieldDuracionFinal.setColumns(10);
			jTextFieldDuracionFinal.setBounds(300, 66, 68, 20);
			panel.add(jTextFieldDuracionFinal);
			
			jComboBoxUnidadDuracion = new JComboBox<String>();
			jComboBoxUnidadDuracion.setBounds(380, 67, 68, 18);
			panel.add(jComboBoxUnidadDuracion);
			
			JLabel jLabelIncrementoDuracion = new JLabel();
			jLabelIncrementoDuracion.setText("Incremento/decremento duraci\u00F3n del contrato");
			jLabelIncrementoDuracion.setBounds(23, 35, 419, 14);
			panel.add(jLabelIncrementoDuracion);
			
			jTextFieldIncrementoDuracion = new JTextField();
			jTextFieldIncrementoDuracion.setColumns(10);
			jTextFieldIncrementoDuracion.setBounds(300, 35, 68, 20);
			panel.add(jTextFieldIncrementoDuracion);
			
			jComboBoxUnidadIncremento = new JComboBox<String>();
			jComboBoxUnidadIncremento.setBounds(380, 35, 68, 18);
			panel.add(jComboBoxUnidadIncremento);
			
			JLabel jLabelDescripcion = new JLabel();
			jLabelDescripcion.setText("Descripci\u00F3n");
			jLabelDescripcion.setBounds(50, 538, 171, 14);
			getPanel().add(jLabelDescripcion);
			
			JTextPane textPane_1 = new JTextPane();
			textPane_1.setBounds(50, 560, 6, 20);
			getPanel().add(textPane_1);
			
			
			txtrAas = new JTextArea();
			txtrAas.setBackground(SystemColor.activeCaptionBorder);
			txtrAas.setForeground(Color.BLACK);
			txtrAas.setBounds(60, 565, 656, 77);
			getPanel().add(txtrAas);
			
			comboBoxCodigoTipoModificacion = new JComboBox<String>();
			comboBoxCodigoTipoModificacion.setBounds(300, 162, 583, 18);
			getPanel().add(comboBoxCodigoTipoModificacion);
			
			textFieldJustificacion = new JTextField();
			textFieldJustificacion.setBounds(300, 191, 412, 18);
			getPanel().add(textFieldJustificacion);
			
			JLabel lblMotivoDeLa = new JLabel();
			lblMotivoDeLa.setText("Motivo de la modificaci\u00F3n");
			lblMotivoDeLa.setBounds(50, 164, 318, 14);
			getPanel().add(lblMotivoDeLa);
			
			JLabel lblJustificacion = new JLabel();
			lblJustificacion.setText("Justificacion");
			lblJustificacion.setBounds(50, 191, 318, 14);
			getPanel().add(lblJustificacion);
			
			
		}
		return jPanelContenido;
	}
	
	
	public void cargarDatosComboBoxs() {
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxUnidadDuracion, ConstantsGC.PERIOD_UNIT);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxUnidadIncremento, ConstantsGC.PERIOD_UNIT);
		ComboBoxUtils.loadComboBoxFromConstant(comboBoxCodigoTipoModificacion, ConstantsGC.MODIFICATION_REASON_CODE);
	}
	
	
	public void actionPerformed(ActionEvent e){
		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			getDatosModificacion();
			gestorVentanasFormCD[0].setVisible(true);
			if (tipoDocumento.equalsIgnoreCase(TipoDocumento.MODIF)) {
				SessionDataManager.getInstance();
				ExpedienteBean expediente = SessionDataManager.getExpediente();
				expediente.setDatosModificacion(getDatosModificacion());
				SessionDataManager.setExpediente(expediente);
			}
		}
	}
	
	
}
