/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import es.dgpe.place.client.beans.CondicionesEjecucionBean;
import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;
import java.awt.Point;

public class ProcedimientoForm extends ThemeJFrame {


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;   

	private JLabel jLabelEventoAperturaEconomica = null; 
	 

	JFrame gestorVentanasFormCD[] = new JFrame[2];

	private String tipoDocumento=null;
	
	private ExpedienteBean expediente=null;
	
	private JLabel jLabelFechaInicio = null;
	private JLabel jLabelFechaFinal = null;
	private JLabel jLabelDuracion = null;
	private JLabel jLabelUnidad = null;
	
	private final ButtonGroup buttonGroup = new ButtonGroup();
	private JTextField jTextFieldFechaPresentacionOfertas;
	private JTextField jTextFieldFechaPresentacionSolicitudes;
	private JTextField jTextFieldFechaEnvioInvitaciones;
	
	JComboBox<String> jComboBoxTipoProcedimiento=null;
	JComboBox<String> jComboBoxTipoTramitacion=null;
	JComboBox<String> jComboBoxTramitacionGasto=null;
	JComboBox<String> jComboBoxFormaPresentacion=null;
	JComboBox<String> jComboBoxFasesSucesivas=null;
    JComboBox<String> jComboBoxCatalogoElectronico=null;
	JComboBox<String> jComboBoxSubastaElectronica=null;

	private JLabel lblSeDebernPresentar;
	private JLabel lblSeUtilizarLa;
	private JTextArea jtextFieldJustificacionAcelerado;
	private JTextArea jtextFieldTerminosSubasta;


	public ExpedienteBean getProcedimiento()  {
		
		ExpedienteBean expediente=SessionDataManager.getInstance().getExpediente();
		
		//Fecha fin de presentacion de ofertas
		Date fechaFinOfertas=null;
		if (jTextFieldFechaPresentacionOfertas.getText().length()>0)
			try {
				fechaFinOfertas = new SimpleDateFormat("dd-MM-yyyy").parse(jTextFieldFechaPresentacionOfertas.getText());
			} catch (ParseException e) {

				e.printStackTrace();
				System.out.println("Error en el formato de la fecha fin de presentacin de ofertas");	
			}
		expediente.setFechaFinOfertas(fechaFinOfertas); 

		//Fecha fin de presentacion de solicitudes
		Date fechaFinSolicitudes=null;
		if (jTextFieldFechaPresentacionSolicitudes.getText().length()>0)
			try {
				fechaFinSolicitudes = new SimpleDateFormat("dd-MM-yyyy").parse(jTextFieldFechaPresentacionSolicitudes.getText());
			} catch (ParseException e) {

				e.printStackTrace();
				System.out.println("Error en el formato de la fecha fin de presentacin de solicitudes");	
			}
		expediente.setFechaFinSolicitudes(fechaFinSolicitudes);

		//Fecha estimada de envo de invitaciones
		Date fechaEnvioInvitaciones=null;
		if (jTextFieldFechaEnvioInvitaciones.getText().length()>0)
			try {
				fechaEnvioInvitaciones = new SimpleDateFormat("dd-MM-yyyy").parse(jTextFieldFechaEnvioInvitaciones.getText());
			} catch (ParseException e) {

				e.printStackTrace();
				System.out.println("Error en el formato de la fecha estimada de envo de invitaciones");	
			}
		expediente.setFechaEnvioInvitaciones(fechaEnvioInvitaciones);

			
	//Combos
			// Tipo de procedimiento
		expediente.setIdProcContratacion(jComboBoxTipoProcedimiento.getSelectedIndex());
			// Tipo de tramitacion
		expediente.setIdTipoTramitacion(jComboBoxTipoTramitacion.getSelectedIndex());
			//Tramitacion del gasto
		expediente.setIdTipoTramitacionGasto(jComboBoxTramitacionGasto.getSelectedIndex());
		// Forma de presentacin
				expediente.setIdFormaPresentacion(jComboBoxFormaPresentacion.getSelectedIndex());
			// Reduccion en fases sucesivas
		expediente.setIndicadorFasesSucesivas(jComboBoxFasesSucesivas.getSelectedIndex()-1);
		
		expediente.setIndicadorCatalogoElectronico(jComboBoxCatalogoElectronico.getSelectedIndex());
		expediente.setIndicadorSubastaElectronica(jComboBoxSubastaElectronica.getSelectedIndex());
		
		expediente.setJustifProcAcelerado(jtextFieldJustificacionAcelerado.getText());
		expediente.setTerminosSubastaElectronica(jtextFieldTerminosSubasta.getText());
	
		return expediente;
	}

	public void setExpediente(ExpedienteBean expediente) {
		this.expediente = expediente;
	}

	public ProcedimientoForm(JFrame ventanaPadre,String tipoDocumento)  throws ModelException {
		super();
		initialize();
		
		DateFormat df = new SimpleDateFormat("dd-MM-yyyy HH:mm");
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null; 
		this.tipoDocumento=tipoDocumento;
		cargarDatosComboBoxs();
		
		 
		setHasButtonPrev(true);
		
		
		
		JLabel label = new JLabel();
		label.setText("Tipo  Tramitaci\u00F3n:");
		label.setSize(new Dimension(250, 18));
		label.setLocation(new Point(60, 270));
		label.setBounds(35, 200, 250, 18);
		getPanel().add(label);
		
		JLabel label_1 = new JLabel();
		label_1.setText("Tramitaci\u00F3n Gasto:");
		label_1.setSize(new Dimension(250, 18));
		label_1.setLocation(new Point(60, 295));
		label_1.setBounds(35, 325, 250, 18);
		getPanel().add(label_1);
		
		JLabel label_2 = new JLabel();
		label_2.setText("Forma de presentaci\u00F3n:");
		label_2.setSize(new Dimension(250, 18));
		label_2.setLocation(new Point(60, 295));
		label_2.setBounds(35, 353, 250, 18);
		getPanel().add(label_2);
		
		JLabel label_4 = new JLabel();
		label_4.setText("Procedimiento Contrataci\u00F3n:");
		label_4.setBounds(33, 171, 250, 18);
		getPanel().add(label_4);
		
		JLabel label_5 = new JLabel();
		label_5.setText("Fecha Fin de Presentaci\u00F3n de Ofertas (dd-mm-aaaa hh:mm):");
		label_5.setBounds(35, 438, 388, 18);
		getPanel().add(label_5);
		
		jTextFieldFechaPresentacionOfertas = new JTextField();
		
	
		jTextFieldFechaPresentacionOfertas.setText(df.format(new Date()));
		jTextFieldFechaPresentacionOfertas.setColumns(10);
		jTextFieldFechaPresentacionOfertas.setBounds(393, 436, 176, 20);
		getPanel().add(jTextFieldFechaPresentacionOfertas);
		
		JLabel label_6 = new JLabel("Fecha Fin de Presentaci\u00F3n de Solicitudes (dd-mm-aaaa hh:mm):");
		label_6.setBounds(35, 382, 421, 14);
		getPanel().add(label_6);
		
		jTextFieldFechaPresentacionSolicitudes = new JTextField();
		jTextFieldFechaPresentacionSolicitudes.setText(df.format(new Date()));
		jTextFieldFechaPresentacionSolicitudes.setColumns(10);
		jTextFieldFechaPresentacionSolicitudes.setBounds(393, 379, 176, 20);
		getPanel().add(jTextFieldFechaPresentacionSolicitudes);
		
		JLabel lblFechaEstimadaEnv = new JLabel();
		lblFechaEstimadaEnv.setText("Fecha estimada env\u00EDo de invitaciones(dd-mm-aaaa hh:mm):");
		lblFechaEstimadaEnv.setBounds(35, 408, 388, 18);
		getPanel().add(lblFechaEstimadaEnv);
		
		jTextFieldFechaEnvioInvitaciones = new JTextField();
		jTextFieldFechaEnvioInvitaciones.setText(df.format(new Date()));
		jTextFieldFechaEnvioInvitaciones.setColumns(10);
		jTextFieldFechaEnvioInvitaciones.setBounds(393, 407, 176, 20);
		getPanel().add(jTextFieldFechaEnvioInvitaciones);
		
		
		
		JLabel lblReduccinDeCandidatos = new JLabel("Reducci\u00F3n de candidatos en fases sucesivas");
		lblReduccinDeCandidatos.setBounds(35, 482, 299, 14);
		getPanel().add(lblReduccinDeCandidatos);
		
		JLabel lblNewLabel = new JLabel("Procedimiento de adjudicaci\u00F3n");
		lblNewLabel.setFont(new Font("Tahoma", Font.BOLD, 14));
		lblNewLabel.setBounds(22, 107, 269, 14);
		getPanel().add(lblNewLabel);
		
		getPanel().add(getLblSeDebernPresentar());
		getPanel().add(getLblSeUtilizarLa());
		
		JLabel lblJustificacinDeProcedimiento = new JLabel();
		lblJustificacinDeProcedimiento.setText("Justificaci\u00F3n de procedimiento acelerado");
		lblJustificacinDeProcedimiento.setSize(new Dimension(250, 18));
		lblJustificacinDeProcedimiento.setLocation(new Point(60, 270));
		lblJustificacinDeProcedimiento.setBounds(60, 229, 250, 18);
		getPanel().add(lblJustificacinDeProcedimiento);
		
		jtextFieldJustificacionAcelerado = new JTextArea();
		jtextFieldJustificacionAcelerado.setColumns(10);
		jtextFieldJustificacionAcelerado.setBounds(393, 228, 393, 64);
		jtextFieldJustificacionAcelerado.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		getPanel().add(jtextFieldJustificacionAcelerado);
		
		JLabel lblTerminosDeSubasta = new JLabel();
		lblTerminosDeSubasta.setText("Terminos de subasta electr\u00F3nica");
		lblTerminosDeSubasta.setBounds(60, 569, 250, 18);
		getPanel().add(lblTerminosDeSubasta);
		
		jtextFieldTerminosSubasta = new JTextArea();
		jtextFieldTerminosSubasta.setColumns(10);
		jtextFieldTerminosSubasta.setBorder(BorderFactory.createLineBorder(Color.BLACK));
		jtextFieldTerminosSubasta.setBounds(393, 568, 393, 56);
		getPanel().add(jtextFieldTerminosSubasta);
		
		 
		//Copiar hasta aqui a getJPanelContenido
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosProcedimiento();
		}
	}
	
private void escribeDatosProcedimiento(){
		
		
	ExpedienteBean expediente=SessionDataManager.getInstance().getExpediente();
	
	DateFormat df = new SimpleDateFormat("dd-MM-yyyy HH:mm");
	//Fecha fin de presentacion de ofertas
	if (expediente.getFechaFinOfertas() != null){
		jTextFieldFechaPresentacionOfertas.setText(df.format(expediente.getFechaFinOfertas()));
	}	

	//Fecha fin de presentacion de solicitudes
	if (expediente.getFechaFinSolicitudes() != null){
		jTextFieldFechaPresentacionSolicitudes.setText(df.format(expediente.getFechaFinSolicitudes()));
	}	
	
	
	//Fecha estimada de envo de invitaciones
	if (expediente.getFechaEnvioInvitaciones() != null){
		jTextFieldFechaEnvioInvitaciones.setText(df.format(expediente.getFechaEnvioInvitaciones()));
	}
						
		
//Combos
		// Tipo de procedimiento
	jComboBoxTipoProcedimiento.setSelectedIndex(expediente.getIdProcContratacion());
	
		// Tipo de tramitacion
	jComboBoxTipoTramitacion.setSelectedIndex(expediente.getIdTipoTramitacion());
	
		//Tramitacion del gasto
	jComboBoxTramitacionGasto.setSelectedIndex(expediente.getIdTipoTramitacionGasto());
	// Forma de presentacion
		jComboBoxFormaPresentacion.setSelectedIndex(expediente.getIdFormaPresentacion());
		// Reduccion en fases sucesivas
	jComboBoxFasesSucesivas.setSelectedIndex(expediente.getIndicadorFasesSucesivas()+1);
	
	jComboBoxCatalogoElectronico.setSelectedIndex(expediente.getIndicadorCatalogoElectronico());
	jComboBoxSubastaElectronica.setSelectedIndex(expediente.getIndicadorSubastaElectronica());
	
	jtextFieldJustificacionAcelerado.setText(expediente.getJustifProcAcelerado());
	jtextFieldTerminosSubasta.setText(expediente.getTerminosSubastaElectronica());		
	
	}
	
	

	private void initialize() {

	
		getJPanelContenido();
		
		this.setTitle("Procedimiento de adjudicaci\u00F3n");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	 
	public JComboBox getjComboBoxTipoProcedimiento() {
		jComboBoxTipoProcedimiento = new JComboBox();
		jComboBoxTipoProcedimiento.setBounds(393, 167, 393, 18);
		return jComboBoxTipoProcedimiento;
	}

	public void setjComboBoxTipoProcedimiento(JComboBox jComboBoxTipoProcedimiento) {
		this.jComboBoxTipoProcedimiento = jComboBoxTipoProcedimiento;
	}

	public JComboBox getjComboBoxTipoTramitacion() {
		jComboBoxTipoTramitacion = new JComboBox();
		jComboBoxTipoTramitacion.setBounds(393, 196, 393, 18);
		
		
		return jComboBoxTipoTramitacion;
	}

	public void setjComboBoxTipoTramitacion(JComboBox jComboBoxTipoTramitacion) {
		this.jComboBoxTipoTramitacion = jComboBoxTipoTramitacion;
	}

	public JComboBox getjComboBoxTramitacionGasto() {
		jComboBoxTramitacionGasto = new JComboBox();
		jComboBoxTramitacionGasto.setBounds(393, 321, 393, 18);
		
		
		return jComboBoxTramitacionGasto;
	}

	public void setjComboBoxTramitacionGasto(JComboBox jComboBoxTramitacionGasto) {
		this.jComboBoxTramitacionGasto = jComboBoxTramitacionGasto;
	}

	public JComboBox getjComboBoxFormaPresentacion() {
		
		jComboBoxFormaPresentacion = new JComboBox();
		jComboBoxFormaPresentacion.setBounds(393, 350, 393, 18);
		
		return jComboBoxFormaPresentacion;
	}

	public void setjComboBoxFormaPresentacion(JComboBox jComboBoxFormaPresentacion) {
		this.jComboBoxFormaPresentacion = jComboBoxFormaPresentacion;
	}

	public JComboBox getjComboBoxFasesSucesivas() {
		jComboBoxFasesSucesivas = new JComboBox();
		jComboBoxFasesSucesivas.setBounds(393, 482, 62, 18);
				
		return jComboBoxFasesSucesivas;
	}

	public void setjComboBoxFasesSucesivas(JComboBox jComboBoxFasesSucesivas) {
		this.jComboBoxFasesSucesivas = jComboBoxFasesSucesivas;
	}



	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
		 
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.setSize(new Dimension(800, 600));
			

			jLabelDuracion=new JLabel();
			jLabelDuracion.setText("Procedimiento de adjudicaci\u00F3n");
			jLabelDuracion.setBounds(72, 87, 275, 14);
			
			getPanel().add(getjComboBoxTipoProcedimiento());
			getPanel().add(getjComboBoxTipoTramitacion());
			getPanel().add(getjComboBoxTramitacionGasto());
			getPanel().add(getjComboBoxFormaPresentacion());
			getPanel().add(getjComboBoxFasesSucesivas());
			getPanel().add(getjComboBoxCatalogoElectronico());
			getPanel().add(getjComboBoxSubastaElectronica());
			
			
		}
		return jPanelContenido;
	}
	
	public void cargarDatosComboBoxs() {
		
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTipoProcedimiento, ConstantsGC.TENDERING_PROCESS);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTipoTramitacion, ConstantsGC.DILIGENCE);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxTramitacionGasto, ConstantsGC.EXPENSE);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxFormaPresentacion, ConstantsGC.TENDER_DELIVERY);
		ComboBoxUtils.loadComboBoxNoObligatorioFromConstant(jComboBoxFasesSucesivas, ConstantsGC.SI_NO);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxCatalogoElectronico, ConstantsGC.SI_NO);
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxSubastaElectronica, ConstantsGC.SI_NO);
	}

	public void actionPerformed(ActionEvent e) {

		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			getProcedimiento();
			gestorVentanasFormCD[0].setVisible(true);
			
			ExpedienteBean expediente=SessionDataManager.getInstance().getExpediente();
			SessionDataManager.getInstance().setExpediente(expediente);
				
		}
	}
	
	
	public JComboBox getjComboBoxCatalogoElectronico() {
		jComboBoxCatalogoElectronico = new JComboBox();
		jComboBoxCatalogoElectronico.setBounds(393, 511, 62, 18);
		
		return jComboBoxCatalogoElectronico;
	}


	public JComboBox getjComboBoxSubastaElectronica() {
		
		jComboBoxSubastaElectronica = new JComboBox();
		jComboBoxSubastaElectronica.setBounds(393, 540, 62, 18);
		
		return jComboBoxSubastaElectronica;
	}
	
	private JLabel getLblSeDebernPresentar() {
		if (lblSeDebernPresentar == null) {
			lblSeDebernPresentar = new JLabel();
			lblSeDebernPresentar.setText("Se deber\u00E1n presentar cat\u00E1logos electr\u00F3nicos");
			lblSeDebernPresentar.setBounds(35, 513, 318, 18);
		}
		return lblSeDebernPresentar;
	}
	private JLabel getLblSeUtilizarLa() {
		if (lblSeUtilizarLa == null) {
			lblSeUtilizarLa = new JLabel();
			lblSeUtilizarLa.setText("Se utilizar\u00E1 la subasta electr\u00F3nica");
			lblSeUtilizarLa.setBounds(35, 540, 250, 18);
		}
		return lblSeUtilizarLa;
	}
}
