/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.PublicacionesOficialesBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.SessionDataManager;

public class PublicacionesOficialesForm extends ThemeJFrame{


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;  //  @jve:decl-index=0:visual-constraint="17,624"

	private JLabel jLabelBOE = null;

 
  
	
	JFrame gestorVentanasFormCD[] = new JFrame[2];

	private JLabel jLabelLicitador = null;

	private JLabel jLabelFechaBOE = null;

	private JLabel jLabelYaEnviadoBOE = null;

	private JLabel jLabelEnviarDOUE = null;

	private JLabel jLabeDOUE = null;

	private String tipoDocumento=null;

	private JLabel jLabelYaEnviadoDOUE = null;

	private JLabel jLabelFechaPubDOUE = null;

	private JLabel jLabelFechaPubBoe = null;

	private JTextField jTextFieldFechaPubOtrosDiarios = null;

	private JTextField jTextFieldNombreOtrosDiarios = null;

	
private PublicacionesOficialesBean diarios=null;  //  @jve:decl-index=0:

	private JLabel jLabelOtros = null;

	private JLabel jLabelOtrosDiariosID = null;

	private JLabel jLabelFechaPubOtrosDiarios = null;

	private JTextField jTextFieldFechaPubDOUE = null;

	private JCheckBox jCheckBoxYaEnviadoDOUE = null;

	private JCheckBox jCheckBoxEnviarDOUE = null;

	private JCheckBox jCheckBoxYaEnviadoBOE = null;

	private JCheckBox jCheckBoxEnviarBOE = null;

	private JTextField jTextFieldFechaPubBOE = null;

	
	private ButtonGroup selectorBOE = new ButtonGroup();  //  @jve:decl-index=0:
	
	private ButtonGroup selectorDOUE = new ButtonGroup();  //  @jve:decl-index=0:
	
	private JLabel lblFechaDeEnvioDOUE;
	
	private JTextField jTextFieldFechaEnvioDOUE;
	

	public PublicacionesOficialesForm(JFrame ventanaPadre,String tipoDocumento) throws ModelException {
		super();
		initialize();		
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null;

		 
		setHasButtonPrev(true);
		
		 
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		this.tipoDocumento=tipoDocumento;
		
	}

	private void initialize() {

		 getJPanelContenido();
		
		this.setTitle("Licitador - Configuracin");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	 
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelFechaPubBoe = new JLabel();
			jLabelFechaPubBoe.setText("Fecha de Publicacin:");
			jLabelFechaPubBoe.setLocation(new Point(101, 209));
			jLabelFechaPubBoe.setSize(new Dimension(215, 18));
			jLabelYaEnviadoDOUE = new JLabel();
			jLabelYaEnviadoDOUE.setText("Ya enviado:");
			jLabelYaEnviadoDOUE.setSize(new Dimension(215, 18));
			jLabelYaEnviadoDOUE.setLocation(new Point(101, 315));
			jLabeDOUE = new JLabel();
			jLabeDOUE.setText("DOUE");
			jLabeDOUE.setLocation(new Point(61, 252));
			jLabeDOUE.setSize(new Dimension(220, 18));
			jLabelEnviarDOUE = new JLabel();
			jLabelEnviarDOUE.setText("Enviar al DOUE:");
			jLabelEnviarDOUE.setLocation(new Point(101, 285));
			jLabelEnviarDOUE.setSize(new Dimension(215, 18));
			jLabelYaEnviadoBOE = new JLabel();
			jLabelYaEnviadoBOE.setText("Ya publicado:");
			jLabelYaEnviadoBOE.setSize(new Dimension(215, 18));
			jLabelYaEnviadoBOE.setLocation(new Point(101, 179));
			jLabelFechaBOE = new JLabel();
			jLabelFechaBOE.setText("Enviar al BOE:");
			jLabelFechaBOE.setSize(new Dimension(215, 18));
			jLabelFechaBOE.setLocation(new Point(101, 149));
			jLabelLicitador = new JLabel();
			jLabelLicitador.setText("Publicacin en Diarios Oficiales");
			jLabelLicitador.setSize(new Dimension(288, 35));
			jLabelLicitador.setLocation(new Point(25, 79));
			jLabelLicitador.setFont(new Font("Dialog", Font.BOLD, 18));
			jLabelBOE = new JLabel();
			jLabelBOE.setText("BOE");
			jLabelBOE.setLocation(new Point(61, 121));
			jLabelBOE.setSize(new Dimension(220, 18));
		 
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.setSize(new Dimension(800, 600));
			jPanelContenido.add(jLabelBOE, null); 
			
			jPanelContenido.add(jLabelLicitador, null);
			jPanelContenido.add(jLabelFechaBOE, null);
			jPanelContenido.add(jLabelYaEnviadoBOE, null);
			jPanelContenido.add(jLabelEnviarDOUE, null);
			jPanelContenido.add(jLabeDOUE, null);
			jPanelContenido.add(jLabelYaEnviadoDOUE, null);
			jPanelContenido.add(jLabelFechaPubBoe, null);
			jPanelContenido.add(getJCheckBoxYaEnviadoDOUE(), null);
			jPanelContenido.add(getJCheckBoxEnviarDOUE(), null);
			jPanelContenido.add(getJCheckBoxYaEnviadoBOE(), null);
			jPanelContenido.add(getJCheckBoxEnviarBOE(), null);
			jPanelContenido.add(getJTextFieldFechaPubBOE(), null);
			jPanelContenido.add(getJTextFieldFechaEnvioDOUE(), null);
			
			getPanel().add(getJTextFieldFechaPubOtrosDiarios());
			getPanel().add(getJTextFieldNombreOtrosDiarios());
			jLabelOtros = new JLabel();
			jLabelOtros.setBounds(60, 438, 220, 18);
			getPanel().add(jLabelOtros);
			jLabelOtros.setText("Otros Diarios");
			jLabelOtrosDiariosID = new JLabel();
			jLabelOtrosDiariosID.setBounds(100, 472, 215, 18);
			getPanel().add(jLabelOtrosDiariosID);
			jLabelOtrosDiariosID.setText("Nombre del Diario:");
			jLabelFechaPubOtrosDiarios = new JLabel();
			jLabelFechaPubOtrosDiarios.setBounds(100, 502, 215, 18);
			getPanel().add(jLabelFechaPubOtrosDiarios);
			jLabelFechaPubOtrosDiarios.setText("Fecha de Publicacin:");
			jLabelFechaPubDOUE = new JLabel();
			jLabelFechaPubDOUE.setBounds(100, 378, 215, 18);
			getPanel().add(jLabelFechaPubDOUE);
			jLabelFechaPubDOUE.setText("Fecha de Publicacin:");
			getPanel().add(getJTextFieldFechaPubDOUE());
			getPanel().add(getLblFechaDeEnvioDOUE());
			
			selectorBOE.add(getJCheckBoxYaEnviadoBOE());
			selectorBOE.add(getJCheckBoxEnviarBOE());
			
			selectorDOUE.add(getJCheckBoxYaEnviadoDOUE());
			selectorDOUE.add(getJCheckBoxEnviarDOUE());
			
		}
		return jPanelContenido;
	}

 
		
 
	

	/**
	 * This method initializes jTextFieldNombreOtrosDiarios	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldNombreOtrosDiarios() {
		if (jTextFieldNombreOtrosDiarios == null) {
			jTextFieldNombreOtrosDiarios = new JTextField();
			jTextFieldNombreOtrosDiarios.setBounds(349, 472, 250, 18);
		}
		return jTextFieldNombreOtrosDiarios;
	}
 
	 
	public void setDiariosOficiales(PublicacionesOficialesBean diarios) {
		this.diarios=diarios;
	}
	
	public PublicacionesOficialesBean getDiariosOficiales() {

			diarios = new PublicacionesOficialesBean();

			
			diarios.setEnviarBOE(jCheckBoxEnviarBOE.isSelected());
			diarios.setYaPublicadoBOE(jCheckBoxYaEnviadoBOE.isSelected());
			
			Date fechaPubBOE=null;
			if (jTextFieldFechaPubBOE.getText().length()>0)
				try {
					fechaPubBOE = new SimpleDateFormat("dd-MM-yyyy").parse(jTextFieldFechaPubBOE.getText());
				} catch (ParseException e) {

					e.printStackTrace();
					System.out.println("Error en el formato de la fecha de publicacin en el BOE");	
				}
			diarios.setFechaPubBOE(fechaPubBOE);
			
			diarios.setEnviarDOUE(jCheckBoxEnviarDOUE.isSelected());
			diarios.setYaEnviadoDOUE(jCheckBoxYaEnviadoDOUE.isSelected());
			
			Date fechaPubDOUE=null;
			if (jTextFieldFechaPubDOUE.getText().length()>0)
				try {
					fechaPubDOUE = new SimpleDateFormat("dd-MM-yyyy").parse(jTextFieldFechaPubDOUE.getText());
				} catch (ParseException e) {

					e.printStackTrace();
					System.out.println("Error en el formato de la fecha de publicacin en el DOUE");	
				}
			diarios.setFechaPubDOUE(fechaPubDOUE);
			
			
			Date fechaEnvioDOUE=null;
			if (jTextFieldFechaEnvioDOUE.getText().length()>0)
				try {
					fechaEnvioDOUE = new SimpleDateFormat("dd-MM-yyyy").parse(jTextFieldFechaEnvioDOUE.getText());
				} catch (ParseException e) {

					e.printStackTrace();
					System.out.println("Error en el formato de la fecha de envo al DOUE");	
				}
			diarios.setFechaEnvioDOUE(fechaEnvioDOUE);
			
			
			
			diarios.setNombreOtrosDiarios(jTextFieldNombreOtrosDiarios.getText());
			
			Date fechaPubOtrosDiarios=null;
			if (jTextFieldFechaPubOtrosDiarios.getText().length()>0)
				try {
					fechaPubOtrosDiarios = new SimpleDateFormat("dd-MM-yyyy").parse(jTextFieldFechaPubOtrosDiarios.getText());
				} catch (ParseException e) {

					e.printStackTrace();
					System.out.println("Error en el formato de la fecha de publicacin en otros diarios");	
				}
			diarios.setFechaPubOtrosDiarios(fechaPubOtrosDiarios);
			
			
			
		
		return diarios;
	}
	
	public void actionPerformed(ActionEvent e) {

		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			getDiariosOficiales();
			gestorVentanasFormCD[0].setVisible(true);
			
			ExpedienteBean expediente=SessionDataManager.getInstance().getExpediente();
			expediente.setDiarios(getDiariosOficiales());
			SessionDataManager.getInstance().setExpediente(expediente);
		}
 

	}
	/**
	 * This method initializes jTextFieldFechaPubDOUE	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldFechaEnvioDOUE() {
		if (jTextFieldFechaEnvioDOUE == null) {
			jTextFieldFechaEnvioDOUE = new JTextField();
			SimpleDateFormat dateFormat;
			dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			jTextFieldFechaEnvioDOUE.setText(dateFormat.format(new Date()));
			jTextFieldFechaEnvioDOUE.setBounds(349, 349, 150, 18);
		}
		return jTextFieldFechaEnvioDOUE;
	}
	/**
	 * This method initializes jTextFieldFechaPubDOUE	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldFechaPubDOUE() {
		if (jTextFieldFechaPubDOUE == null) {
			jTextFieldFechaPubDOUE = new JTextField();
			SimpleDateFormat dateFormat;
			dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			jTextFieldFechaPubDOUE.setText(dateFormat.format(new Date()));
			jTextFieldFechaPubDOUE.setBounds(349, 378, 150, 18);
		}
		return jTextFieldFechaPubDOUE;
	}

	/**
	 * This method initializes jTextFieldYaEnviadoDOUE	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JCheckBox getJCheckBoxYaEnviadoDOUE() {
		if (jCheckBoxYaEnviadoDOUE == null) {
			jCheckBoxYaEnviadoDOUE = new JCheckBox();
			jCheckBoxYaEnviadoDOUE.setSize(new Dimension(22, 20));
			jCheckBoxYaEnviadoDOUE.setLocation(new Point(350, 315));
		}
		return jCheckBoxYaEnviadoDOUE;
	}

	/**
	 * This method initializes jTextFieldEnviarDOUE	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JCheckBox getJCheckBoxEnviarDOUE() {
		if (jCheckBoxEnviarDOUE == null) {
			jCheckBoxEnviarDOUE = new JCheckBox();
			jCheckBoxEnviarDOUE.setSize(new Dimension(22, 20));
			jCheckBoxEnviarDOUE.setLocation(new Point(350, 285));
		}
		return jCheckBoxEnviarDOUE;
	}

	/**
	 * This method initializes jCheckBoxYaEnviadoBOE	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JCheckBox getJCheckBoxYaEnviadoBOE() {
		if (jCheckBoxYaEnviadoBOE == null) {
			jCheckBoxYaEnviadoBOE = new JCheckBox();
			jCheckBoxYaEnviadoBOE.setSize(new Dimension(20, 20));
			jCheckBoxYaEnviadoBOE.setLocation(new Point(350, 179));
		}
		return jCheckBoxYaEnviadoBOE;
	}

	/**
	 * This method initializes jCheckBoxEnviarBOE	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JCheckBox getJCheckBoxEnviarBOE() {
		if (jCheckBoxEnviarBOE == null) {
			jCheckBoxEnviarBOE = new JCheckBox();
			jCheckBoxEnviarBOE.setSize(new Dimension(20, 20));
			jCheckBoxEnviarBOE.setLocation(new Point(350, 149));
		}
		return jCheckBoxEnviarBOE;
	}

	/**
	 * This method initializes jTextFieldFechaPubBOE	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldFechaPubBOE() {
		if (jTextFieldFechaPubBOE == null) {
			jTextFieldFechaPubBOE = new JTextField();
			SimpleDateFormat dateFormat;
			dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			jTextFieldFechaPubBOE.setText(dateFormat.format(new Date()));
			jTextFieldFechaPubBOE.setLocation(new Point(350, 209));
			jTextFieldFechaPubBOE.setSize(new Dimension(150, 18));
		}
		return jTextFieldFechaPubBOE;
	}
	
	private JLabel getLblFechaDeEnvioDOUE() {
		if (lblFechaDeEnvioDOUE == null) {
			lblFechaDeEnvioDOUE = new JLabel();
			lblFechaDeEnvioDOUE.setText("Fecha de Env\u00EDo:");
			lblFechaDeEnvioDOUE.setBounds(100, 349, 215, 18);
		}
		return lblFechaDeEnvioDOUE;
	}

	private JTextField getJTextFieldFechaPubOtrosDiarios() {
		if (jTextFieldFechaPubOtrosDiarios == null) {
			jTextFieldFechaPubOtrosDiarios = new JTextField();
			SimpleDateFormat dateFormat;
			dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			jTextFieldFechaPubOtrosDiarios.setText(dateFormat.format(new Date()));
			jTextFieldFechaPubOtrosDiarios.setBounds(349, 502, 150, 18);
		}
		return jTextFieldFechaPubOtrosDiarios;
	}
}
