/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service.commons;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;

import org.jcp.xml.dsig.internal.dom.DOMXPathFilter2Transform;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.ReceptorRecursosBean;
import es.dgpe.place.client.components.ComboListenerCountry;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;



public class ReceptorRecurosForm extends ThemeJFrame{


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;  //  @jve:decl-index=0:visual-constraint="17,624"

	private JLabel jLabelDatosLic = null;

 
  
	
	JFrame gestorVentanasFormCD[] = new JFrame[2];

	private JLabel jLabelLicitador = null;

	private JLabel jLabelNombreLic = null;
	private JLabel jLabelEntidad;

	private JLabel jLabeIdentificador = null;

	private JLabel jLabeMotivacion = null;

	private JLabel jLabelLugarDatosAdj = null;
	private JLabel jLabelDireccion;

	private JTextField jTextFieldEntidad = null;

	private String tipoDocumento=null;

	private JLabel jLabeFechaAdjudicacion = null;

	private JLabel jLabeImporteSin = null;

	private JLabel jLabeImporteCon = null;
	
	private ReceptorRecursosBean receptor;

	private JLabel jLabelFinFormalizacion = null;
	
	private ExpedienteBean expediente;
	
	private JComboBox<String> jComboBoxPais;
    private JLabel lblPais;
	private JTextField jtextFieldUrl;
	private JTextField jtextFieldCalle;
	private JTextField jtextFieldCP;
	private JTextField jtextFieldPoblacion;

	public ReceptorRecurosForm(JFrame ventanaPadre,String tipoDocumento) throws ModelException {
		super();
		initialize();		
		cargarDatosComboBoxs();
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null;

		setHasButtonPrev(true);
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosReceptor();
		}
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosReceptor();
			}
		});
		
		this.tipoDocumento=tipoDocumento;
		
	}

	private void initialize() {

		 getJPanelContenido();
		
		this.setTitle("Licitador - Configuracin");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	 
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelLicitador = new JLabel();
			jLabelLicitador.setText("Receptor de Recursos");
			jLabelLicitador.setSize(new Dimension(288, 35));
			jLabelLicitador.setLocation(new Point(25, 79));
			jLabelLicitador.setFont(new Font("Dialog", Font.BOLD, 18));
            getPanel().add(getJComboBoxPais());
            getPanel().add(getLblPais());
			
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.setSize(new Dimension(800, 600));
			
			jPanelContenido.add(jLabelLicitador, null);
			
			getPanel().add(getJTextFieldEntidad());
			
			

			
			JLabel lblURL = new JLabel("URL");
			lblURL.setBounds(64, 181, 285, 14);
			getPanel().add(lblURL);
			
			jtextFieldUrl = new JTextField();
			jtextFieldUrl.setBounds(422, 178, 364, 20);
			getPanel().add(jtextFieldUrl);
			jtextFieldUrl.setColumns(10);
			
			JLabel lblCalle = new JLabel("Calle");
			lblCalle.setBounds(84, 256, 285, 14);
			getPanel().add(lblCalle);
			
			jtextFieldCalle = new JTextField();
			jtextFieldCalle.setColumns(10);
			jtextFieldCalle.setBounds(422, 253, 363, 20);
			getPanel().add(jtextFieldCalle);
			
			JLabel lblCP = new JLabel("CP");
			lblCP.setBounds(84, 293, 285, 14);
			getPanel().add(lblCP);
			
			JLabel lblPoblacion = new JLabel("Poblaci\u00F3n");
			lblPoblacion.setBounds(84, 335, 285, 14);
			getPanel().add(lblPoblacion);
			
			jtextFieldCP = new JTextField();
			jtextFieldCP.setColumns(10);
			jtextFieldCP.setBounds(422, 290, 364, 20);
			getPanel().add(jtextFieldCP);
			
			jtextFieldPoblacion = new JTextField();
			jtextFieldPoblacion.setColumns(10);
			jtextFieldPoblacion.setBounds(422, 332, 364, 20);
			getPanel().add(jtextFieldPoblacion);
			jLabelDireccion = new JLabel();
			jLabelDireccion.setBounds(64, 219, 230, 16);
			getPanel().add(jLabelDireccion);
			jLabelDireccion.setText("Direcci\u00F3n");
			jLabelEntidad = new JLabel();
			jLabelEntidad.setBounds(64, 149, 215, 18);
			getPanel().add(jLabelEntidad);
			jLabelEntidad.setText("Entidad");

		}
		return jPanelContenido;
	}

 
		
 
	/**
	 * This method initializes jTextFieldNombre	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldEntidad() {
		if (jTextFieldEntidad == null) {
			jTextFieldEntidad = new JTextField();
			jTextFieldEntidad.setBounds(422, 149, 364, 18);
		}
		return jTextFieldEntidad;
	}

	public ReceptorRecursosBean getReceptorRecuros(){
		if (receptor==null) receptor=new ReceptorRecursosBean();
		
		receptor.setEntidad(jTextFieldEntidad.getText());
		receptor.setUrl(jtextFieldUrl.getText());
		receptor.setDireccionCalle(jtextFieldCalle.getText());
		receptor.setDireccionCP(jtextFieldCP.getText());
		receptor.setDireccionPoblacion(jtextFieldPoblacion.getText());
		receptor.setPais((String) jComboBoxPais.getSelectedItem());
		receptor.setIdPais(jComboBoxPais.getSelectedIndex());
		
		return receptor;
	}
	
	public void actionPerformed(ActionEvent e) {

		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			getReceptorRecuros();
			gestorVentanasFormCD[0].setVisible(true);
			
			ExpedienteBean expediente=SessionDataManager.getInstance().getExpediente();
			expediente.setReceptor(getReceptorRecuros());
			SessionDataManager.getInstance().setExpediente(expediente);		
		}
	}
	
	
	/**
	 * La funcin rellena los datos del formulario a partir de los indicados en el objeto expediente.
	 * Los valores del objeto expediente son los que se han almacenado con anterioridad en session
	 */
	private void escribeDatosReceptor(){

		ReceptorRecursosBean receptor = expediente.getReceptor();
		
		if (receptor != null){
			jTextFieldEntidad.setText(receptor.getEntidad());
			jtextFieldUrl.setText(receptor.getUrl());
			jtextFieldCalle.setText(receptor.getDireccionCalle());
			jtextFieldCP.setText(receptor.getDireccionCP());
			jtextFieldPoblacion.setText(receptor.getDireccionPoblacion());
			jComboBoxPais.setSelectedIndex(receptor.getIdPais());
		} else{
			jComboBoxPais.setSelectedIndex(9);
		}

	}
	
	public void cargarDatosComboBoxs() {
		ComboBoxUtils.loadComboBoxFromConstant(jComboBoxPais, ConstantsGC.COUNTRY_CODE);
		
	}
	
	private JComboBox getJComboBoxPais() {
	      if (jComboBoxPais == null) {
	          jComboBoxPais = new JComboBox();
	          jComboBoxPais.setBounds(422, 370, 364, 18);
	      }
	      return jComboBoxPais;
		}
	
	private JLabel getLblPais() {
	      if (lblPais == null) {
	          lblPais = new JLabel("Pais");
	          lblPais.setBounds(84, 372, 230, 14);
	      }
	      return lblPais;
	  }
}
