/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.publication.service.commons;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

import es.dgpe.place.client.beans.ExpedienteBean;
import es.dgpe.place.client.beans.RequisitosParticipacionBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.ConstantsGC;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.ComboBoxUtils;
import es.dgpe.place.client.utils.SessionDataManager;

public class RequisitosParticipacionForm extends ThemeJFrame {


	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;   


	
	
	JComboBox<String> jcomboBoxSolvenciaTecnica1;
	JComboBox<String> jcomboBoxSolvenciaTecnica2;
	JComboBox<String> jcomboBoxSolvenciaEconomica1;
	JComboBox<String> jcomboBoxSolvenciaEconomica2;
	JTextArea descSolvenciaTecnica1 = new JTextArea();
	JTextArea descSolvenciaTecnica2 = new JTextArea();
	JTextArea descSolvenciaEconomica1 = new JTextArea();
	JTextArea descSolvenciaEconomica2 = new JTextArea();
	
	
	JCheckBox chckbxCapacidadObrar;
	JCheckBox chckbxNoProhibicinPara;
	JCheckBox chckbxCumplimientoConLas;
	JCheckBox chckbxCumplimientoConLas_1;
	JCheckBox chckbxNoEstarIncurso;
	JCheckBox chckbxNoHaberSido;
	JCheckBox chckbxReservadoACentros;
	JCheckBox chckbxReservadoAProgramas;
	JCheckBox chckbxDeclaracinSobreTabajadores;
	JCheckBox chckbxDeclaracinSobrePromocin;
	JCheckBox chckbxParaEmpresasExtranjeras;
	JCheckBox chckbxEstarPrerregistadoEn;
	JCheckBox chckbxContratosReservadosA;

	 

	JFrame gestorVentanasFormCD[] = new JFrame[2];

	private RequisitosParticipacionBean requisitosParticipacion = null;
	
	private ExpedienteBean expediente=null;

	JComboBox<String> jComboBoxClasificacion=null;
	JTextArea jTextAreaDescSolvencias=null;


	

	public RequisitosParticipacionBean getRequisitosParticipacion()  {
		
		requisitosParticipacion = new RequisitosParticipacionBean();
		
		if (jComboBoxClasificacion.getSelectedItem() != null && jComboBoxClasificacion.getSelectedItem().toString().length() > 0){
			expediente.setClasificacion(jComboBoxClasificacion.getSelectedIndex()-1);
			expediente.setDescSolvencia(jTextAreaDescSolvencias.getText());
		}

		
		if (jcomboBoxSolvenciaTecnica1.getSelectedItem() != null && jcomboBoxSolvenciaTecnica1.getSelectedItem().toString().length() > 0){
			requisitosParticipacion.setSolvenciaTecnica1((String)jcomboBoxSolvenciaTecnica1.getSelectedItem());
			requisitosParticipacion.setIdSolvenciaTecnica1(jcomboBoxSolvenciaTecnica1.getSelectedIndex()-1);
			requisitosParticipacion.setDescSolvenciaTecnica1(descSolvenciaTecnica1.getText());
		}
		
		if (jcomboBoxSolvenciaTecnica2.getSelectedItem() != null && jcomboBoxSolvenciaTecnica2.getSelectedItem().toString().length() > 0){
			requisitosParticipacion.setSolvenciaTecnica2((String)jcomboBoxSolvenciaTecnica2.getSelectedItem());
			requisitosParticipacion.setIdSolvenciaTecnica2(jcomboBoxSolvenciaTecnica2.getSelectedIndex()-1);
			requisitosParticipacion.setDescSolvenciaTecnica2(descSolvenciaTecnica2.getText());
		}
		
		if (jcomboBoxSolvenciaEconomica1.getSelectedItem() != null && jcomboBoxSolvenciaEconomica1.getSelectedItem().toString().length() > 0){
			requisitosParticipacion.setSolvenciaEconomica1((String)jcomboBoxSolvenciaEconomica1.getSelectedItem());
			requisitosParticipacion.setIdSolvenciaEconomica1(jcomboBoxSolvenciaEconomica1.getSelectedIndex()-1);
			requisitosParticipacion.setDescSolvenciaEconomica1(descSolvenciaEconomica1.getText());
		}
		
		if (jcomboBoxSolvenciaEconomica2.getSelectedItem() != null && jcomboBoxSolvenciaEconomica2.getSelectedItem().toString().length() > 0){
			requisitosParticipacion.setSolvenciaEconomica2((String)jcomboBoxSolvenciaEconomica2.getSelectedItem());
			requisitosParticipacion.setIdSolvenciaEconomica2(jcomboBoxSolvenciaEconomica2.getSelectedIndex()-1);
			requisitosParticipacion.setDescSolvenciaEconomica2(descSolvenciaEconomica2.getText());
		}
		
		requisitosParticipacion.setCapacidadObrar(chckbxCapacidadObrar.isSelected());
		requisitosParticipacion.setNoProhibicionContratar(chckbxNoProhibicinPara.isSelected());
		requisitosParticipacion.setCumplimientoObligacionesTributarias(chckbxCumplimientoConLas.isSelected());
		requisitosParticipacion.setCumplimientoObligacionesSS(chckbxCumplimientoConLas_1.isSelected());
		requisitosParticipacion.setNoIncompatibilidades(chckbxNoEstarIncurso.isSelected());
		requisitosParticipacion.setNoAdjudicatarioAnterioridad(chckbxNoHaberSido.isSelected());
		requisitosParticipacion.setReservadoCentrosEspeciales(chckbxReservadoACentros.isSelected());
		requisitosParticipacion.setReservadorProgramasEmpleo(chckbxReservadoAProgramas.isSelected());
		requisitosParticipacion.setDeclaracionTrabajadoresDiscapacidad(chckbxDeclaracinSobreTabajadores.isSelected());
		requisitosParticipacion.setDeclaracionPromocionLaboral(chckbxDeclaracinSobrePromocin.isSelected());
		requisitosParticipacion.setEmpresasExtranjeras(chckbxParaEmpresasExtranjeras.isSelected());
		requisitosParticipacion.setPreregistroROLECE(chckbxEstarPrerregistadoEn.isSelected());
		requisitosParticipacion.setReservadoProfesion(chckbxContratosReservadosA.isSelected());
				
		return requisitosParticipacion;
	}

	public void setExpediente(ExpedienteBean expediente) {
		this.expediente = expediente;
	}

	public RequisitosParticipacionForm(JFrame ventanaPadre,String tipoDocumento)  throws ModelException {
		super();
		initialize();		
		gestorVentanasFormCD[0] =ventanaPadre;
		gestorVentanasFormCD[1] =null; 

		cargarDatosComboBoxs();
		
		 
		setHasButtonPrev(true);
		
		JLabel label = new JLabel();
		label.setText("Clasificaci\u00F3n:");
		label.setBounds(42, 80, 249, 16);
		getPanel().add(label);
		
		
		
		
		JLabel label_1 = new JLabel();
		label_1.setText("Descripci\u00F3n de solvencias:");
		label_1.setBounds(42, 105, 249, 16);
		getPanel().add(label_1);
		
		jTextAreaDescSolvencias = new JTextArea();
		jTextAreaDescSolvencias.setWrapStyleWord(true);
		jTextAreaDescSolvencias.setRows(20);
		jTextAreaDescSolvencias.setName("TextAreaDescSolvencias");
		jTextAreaDescSolvencias.setLineWrap(false);
		jTextAreaDescSolvencias.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
		jTextAreaDescSolvencias.setColumns(20);
		jTextAreaDescSolvencias.setBackground(new Color(245, 243, 242));
		jTextAreaDescSolvencias.setBounds(373, 108, 493, 48);
		getPanel().add(jTextAreaDescSolvencias);
		
		JLabel lblCapacidadDeContratar = new JLabel("Capacidad de contratar");
		lblCapacidadDeContratar.setFont(new Font("Tahoma", Font.BOLD, 12));
		lblCapacidadDeContratar.setBounds(46, 362, 234, 14);
		getPanel().add(lblCapacidadDeContratar);
		
		JLabel lblRequisitosDeSolvencia = new JLabel();
		lblRequisitosDeSolvencia.setText("Requisito de solvencia t\u00E9cnica 1");
		lblRequisitosDeSolvencia.setBounds(42, 191, 249, 16);
		getPanel().add(lblRequisitosDeSolvencia);
		
		
		descSolvenciaTecnica1.setWrapStyleWord(true);
		descSolvenciaTecnica1.setRows(20);
		descSolvenciaTecnica1.setName("TextAreaDescSolvencias");
		descSolvenciaTecnica1.setLineWrap(false);
		descSolvenciaTecnica1.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
		descSolvenciaTecnica1.setColumns(20);
		descSolvenciaTecnica1.setBackground(new Color(245, 243, 242));
		descSolvenciaTecnica1.setBounds(124, 225, 375, 32);
		getPanel().add(descSolvenciaTecnica1);
		
		
		descSolvenciaTecnica2.setWrapStyleWord(true);
		descSolvenciaTecnica2.setRows(20);
		descSolvenciaTecnica2.setName("TextAreaDescSolvencias");
		descSolvenciaTecnica2.setLineWrap(false);
		descSolvenciaTecnica2.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
		descSolvenciaTecnica2.setColumns(20);
		descSolvenciaTecnica2.setBackground(new Color(245, 243, 242));
		descSolvenciaTecnica2.setBounds(598, 225, 315, 32);
		getPanel().add(descSolvenciaTecnica2);
		
		JLabel lblRequisitoDeSolvencia = new JLabel();
		lblRequisitoDeSolvencia.setText("Requisito de solvencia t\u00E9cnica 2");
		lblRequisitoDeSolvencia.setBounds(509, 192, 249, 16);
		getPanel().add(lblRequisitoDeSolvencia);
		
		JLabel lblRequisitoDeSolvencia_1 = new JLabel();
		lblRequisitoDeSolvencia_1.setText("Requisito de solvencia econ\u00F3mica 1");
		lblRequisitoDeSolvencia_1.setBounds(42, 273, 249, 16);
		getPanel().add(lblRequisitoDeSolvencia_1);
		
		
		descSolvenciaEconomica1.setWrapStyleWord(true);
		descSolvenciaEconomica1.setRows(20);
		descSolvenciaEconomica1.setName("TextAreaDescSolvencias");
		descSolvenciaEconomica1.setLineWrap(false);
		descSolvenciaEconomica1.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
		descSolvenciaEconomica1.setColumns(20);
		descSolvenciaEconomica1.setBackground(new Color(245, 243, 242));
		descSolvenciaEconomica1.setBounds(124, 307, 375, 32);
		getPanel().add(descSolvenciaEconomica1);
		
		JLabel lblRequisitoDeSolvencia_2 = new JLabel();
		lblRequisitoDeSolvencia_2.setText("Requisito de solvencia econ\u00F3mica 2");
		lblRequisitoDeSolvencia_2.setBounds(509, 274, 249, 16);
		getPanel().add(lblRequisitoDeSolvencia_2);

		
		descSolvenciaEconomica2.setWrapStyleWord(true);
		descSolvenciaEconomica2.setRows(20);
		descSolvenciaEconomica2.setName("TextAreaDescSolvencias");
		descSolvenciaEconomica2.setLineWrap(false);
		descSolvenciaEconomica2.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
		descSolvenciaEconomica2.setColumns(20);
		descSolvenciaEconomica2.setBackground(new Color(245, 243, 242));
		descSolvenciaEconomica2.setBounds(598, 307, 315, 32);
		getPanel().add(descSolvenciaEconomica2);
		
		chckbxCapacidadObrar = new JCheckBox("Capacidad de obrar");
		chckbxCapacidadObrar.setFont(new Font("Tahoma", Font.PLAIN, 10));
		chckbxCapacidadObrar.setBounds(73, 405, 375, 23);
		getPanel().add(chckbxCapacidadObrar);
		
		chckbxNoProhibicinPara = new JCheckBox("No prohibici\u00F3n para contratar");
		chckbxNoProhibicinPara.setFont(new Font("Tahoma", Font.PLAIN, 10));
		chckbxNoProhibicinPara.setBounds(73, 441, 375, 23);
		getPanel().add(chckbxNoProhibicinPara);
		
		chckbxCumplimientoConLas = new JCheckBox("Cumplimiento con las obligaciones tributarias");
		chckbxCumplimientoConLas.setFont(new Font("Tahoma", Font.PLAIN, 10));
		chckbxCumplimientoConLas.setBounds(73, 481, 375, 23);
		getPanel().add(chckbxCumplimientoConLas);
		
		chckbxCumplimientoConLas_1 = new JCheckBox("Cumplimiento con las obligaciones con la Seguridad Social");
		chckbxCumplimientoConLas_1.setFont(new Font("Tahoma", Font.PLAIN, 10));
		chckbxCumplimientoConLas_1.setBounds(73, 521, 375, 23);
		getPanel().add(chckbxCumplimientoConLas_1);
		
		chckbxNoEstarIncurso = new JCheckBox("No estar incurso en incompatibilidades");
		chckbxNoEstarIncurso.setFont(new Font("Tahoma", Font.PLAIN, 10));
		chckbxNoEstarIncurso.setBounds(73, 561, 375, 23);
		getPanel().add(chckbxNoEstarIncurso);
		
		chckbxNoHaberSido = new JCheckBox("No haber sido adjudicatario en contratos anteriores direcci\u00F3n y/o supervisi\u00F3n");
		chckbxNoHaberSido.setFont(new Font("Tahoma", Font.PLAIN, 10));
		chckbxNoHaberSido.setBounds(73, 602, 375, 23);
		getPanel().add(chckbxNoHaberSido);
		
		chckbxReservadoACentros = new JCheckBox("Reservado a Centros Especiales de Empelo, o talleres protegidos");
		chckbxReservadoACentros.setFont(new Font("Tahoma", Font.PLAIN, 10));
		chckbxReservadoACentros.setBounds(73, 644, 375, 23);
		getPanel().add(chckbxReservadoACentros);
		
		chckbxReservadoAProgramas = new JCheckBox("Reservado a programas de empleo protegido");
		chckbxReservadoAProgramas.setFont(new Font("Tahoma", Font.PLAIN, 10));
		chckbxReservadoAProgramas.setBounds(509, 405, 375, 23);
		getPanel().add(chckbxReservadoAProgramas);
		
		chckbxDeclaracinSobreTabajadores = new JCheckBox("Declaraci\u00F3n sobre tabajadores con discapacidad");
		chckbxDeclaracinSobreTabajadores.setFont(new Font("Tahoma", Font.PLAIN, 10));
		chckbxDeclaracinSobreTabajadores.setBounds(509, 441, 375, 23);
		getPanel().add(chckbxDeclaracinSobreTabajadores);
		
		chckbxDeclaracinSobrePromocin = new JCheckBox("Declaraci\u00F3n sobre promoci\u00F3n laboral sobre exclusi\u00F3n social");
		chckbxDeclaracinSobrePromocin.setFont(new Font("Tahoma", Font.PLAIN, 10));
		chckbxDeclaracinSobrePromocin.setBounds(509, 481, 375, 23);
		getPanel().add(chckbxDeclaracinSobrePromocin);
		
		chckbxParaEmpresasExtranjeras = new JCheckBox("Para empresas extranjeras, declaraci\u00F3n sometimiento ley espa\u00F1ola");
		chckbxParaEmpresasExtranjeras.setFont(new Font("Tahoma", Font.PLAIN, 10));
		chckbxParaEmpresasExtranjeras.setBounds(509, 521, 375, 23);
		getPanel().add(chckbxParaEmpresasExtranjeras);
		
		chckbxEstarPrerregistadoEn = new JCheckBox("Estar prerregistado en el ROLECE y declarar no sujeto a cambios");
		chckbxEstarPrerregistadoEn.setFont(new Font("Tahoma", Font.PLAIN, 10));
		chckbxEstarPrerregistadoEn.setBounds(509, 561, 375, 23);
		getPanel().add(chckbxEstarPrerregistadoEn);
		
		chckbxContratosReservadosA = new JCheckBox("Contratos reservados a una profesi\u00F3n determinada");
		chckbxContratosReservadosA.setFont(new Font("Tahoma", Font.PLAIN, 10));
		chckbxContratosReservadosA.setBounds(509, 602, 375, 23);
		getPanel().add(chckbxContratosReservadosA);
		
		JLabel lblDescripcin = new JLabel();
		lblDescripcin.setText("Descripci\u00F3n:");
		lblDescripcin.setBounds(42, 235, 83, 16);
		getPanel().add(lblDescripcin);
		
		JLabel label_2 = new JLabel();
		label_2.setText("Descripci\u00F3n:");
		label_2.setBounds(509, 235, 124, 16);
		getPanel().add(label_2);
		
		JLabel label_3 = new JLabel();
		label_3.setText("Descripci\u00F3n:");
		label_3.setBounds(509, 317, 116, 16);
		getPanel().add(label_3);
		
		JLabel label_4 = new JLabel();
		label_4.setText("Descripci\u00F3n:");
		label_4.setBounds(42, 312, 83, 16);
		getPanel().add(label_4);
		
		 
		//Copiar hasta aqui a getJPanelContenido
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
		if (SessionDataManager.getExpediente() != null){
			expediente = SessionDataManager.getExpediente();
			escribeDatosRequisitosParticipacion();
		}
		
		ventanaPadre.addComponentListener(new ComponentAdapter(){
			public void componentShown(ComponentEvent e) {
			    escribeDatosRequisitosParticipacion();
			}
		});
	}
	
	
	private void initialize() {
		getJPanelContenido();		
		this.setTitle("Requisitos de participaci\u00F3n");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}  
	
	
	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			jPanelContenido.setSize(new Dimension(800, 600));
			getPanel().add(getJComboBoxClasificacion());
			getPanel().add(getJcomboBoxSolvenciaTecnica1());
			getPanel().add(getJcomboBoxSolvenciaTecnica2());
			getPanel().add(getJcomboBoxSolvenciaEconomica1());
			getPanel().add(getJcomboBoxSolvenciaEconomica2());
		}
		return jPanelContenido;
	}
	
	
	public void cargarDatosComboBoxs() {
		ComboBoxUtils.loadComboBoxNoObligatorioFromConstant(jComboBoxClasificacion, ConstantsGC.BUSINESS_PROFILE_CODE);
		ComboBoxUtils.loadComboBoxNoObligatorioFromConstant(jcomboBoxSolvenciaTecnica1, ConstantsGC.TECHNICALCAPABILITYTYPECODE);
		ComboBoxUtils.loadComboBoxNoObligatorioFromConstant(jcomboBoxSolvenciaTecnica2, ConstantsGC.TECHNICALCAPABILITYTYPECODE);
		ComboBoxUtils.loadComboBoxNoObligatorioFromConstant(jcomboBoxSolvenciaEconomica1, ConstantsGC.FINANCIALCAPABILITYTYPECODE);
		ComboBoxUtils.loadComboBoxNoObligatorioFromConstant(jcomboBoxSolvenciaEconomica2, ConstantsGC.FINANCIALCAPABILITYTYPECODE);
	}
	
	
	public void actionPerformed(ActionEvent e) {
		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)) {
			this.setVisible(false);
			gestorVentanasFormCD[0].setVisible(true);
			
			ExpedienteBean expediente=SessionDataManager.getInstance().getExpediente();
			expediente.setRequisitosParticipacion(getRequisitosParticipacion());
			SessionDataManager.getInstance().setExpediente(expediente);
		}
	}
	
	
	private void escribeDatosRequisitosParticipacion(){
		
		RequisitosParticipacionBean requisitosParticipacion = expediente.getRequisitosParticipacion();
		
		if (requisitosParticipacion != null){
			
			if (expediente.getClasificacion() >= 0){
				jComboBoxClasificacion.setSelectedIndex(expediente.getClasificacion()+1);
			}
			
			jcomboBoxSolvenciaTecnica1.setSelectedIndex(requisitosParticipacion.getIdSolvenciaTecnica1()+1);
			jcomboBoxSolvenciaTecnica1.setSelectedIndex(requisitosParticipacion.getIdSolvenciaTecnica1()+1);
			jcomboBoxSolvenciaTecnica2.setSelectedIndex(requisitosParticipacion.getIdSolvenciaTecnica2()+1);
			jcomboBoxSolvenciaTecnica2.setSelectedIndex(requisitosParticipacion.getIdSolvenciaTecnica2()+1);
			
			descSolvenciaTecnica1.setText(requisitosParticipacion.getDescSolvenciaTecnica1());
			descSolvenciaTecnica2.setText(requisitosParticipacion.getDescSolvenciaTecnica2());
			descSolvenciaEconomica1.setText(requisitosParticipacion.getDescSolvenciaEconomica1());
			descSolvenciaEconomica2.setText(requisitosParticipacion.getDescSolvenciaEconomica2());
			
			
			
			
			chckbxCapacidadObrar.setSelected(requisitosParticipacion.isCapacidadObrar());
			chckbxNoProhibicinPara.setSelected(requisitosParticipacion.isNoProhibicionContratar());
			chckbxCumplimientoConLas.setSelected(requisitosParticipacion.isCumplimientoObligacionesTributarias());
			chckbxCumplimientoConLas_1.setSelected(requisitosParticipacion.isCumplimientoObligacionesSS());
			chckbxNoEstarIncurso.setSelected(requisitosParticipacion.isNoIncompatibilidades());
			chckbxNoHaberSido.setSelected(requisitosParticipacion.isNoAdjudicatarioAnterioridad());
			chckbxReservadoACentros.setSelected(requisitosParticipacion.isReservadoCentrosEspeciales());
			chckbxReservadoAProgramas.setSelected(requisitosParticipacion.isReservadorProgramasEmpleo());
			chckbxDeclaracinSobreTabajadores.setSelected(requisitosParticipacion.isDeclaracionTrabajadoresDiscapacidad());
			chckbxDeclaracinSobrePromocin.setSelected(requisitosParticipacion.isDeclaracionPromocionLaboral());
			chckbxParaEmpresasExtranjeras.setSelected(requisitosParticipacion.isEmpresasExtranjeras());
			chckbxEstarPrerregistadoEn.setSelected(requisitosParticipacion.isPreregistroROLECE());
			chckbxContratosReservadosA.setSelected(requisitosParticipacion.isReservadoProfesion());
		}
	}
	
	

	
	 
	
	private JComboBox<String> getJComboBoxClasificacion(){
		if (jComboBoxClasificacion==null){
		jComboBoxClasificacion = new JComboBox<String>();
		jComboBoxClasificacion.setPreferredSize(new Dimension(31, 25));
		jComboBoxClasificacion.setBounds(373, 79, 493, 18);
		}
		
		return jComboBoxClasificacion;
		}
	
	
	
	private JComboBox<String> getJcomboBoxSolvenciaTecnica1(){
		if(jcomboBoxSolvenciaTecnica1 == null){
			jcomboBoxSolvenciaTecnica1 = new JComboBox<String>();
			jcomboBoxSolvenciaTecnica1.setPreferredSize(new Dimension(31, 25));
			jcomboBoxSolvenciaTecnica1.setBounds(42, 206, 457, 18);
		}
		return jcomboBoxSolvenciaTecnica1;
	}
	
	private JComboBox<String> getJcomboBoxSolvenciaTecnica2(){
		if(jcomboBoxSolvenciaTecnica2 == null){
			jcomboBoxSolvenciaTecnica2 = new JComboBox<String>();
			jcomboBoxSolvenciaTecnica2.setPreferredSize(new Dimension(31, 25));
			jcomboBoxSolvenciaTecnica2.setBounds(509, 206, 404, 18);
		}
		return jcomboBoxSolvenciaTecnica2;
	}
	
	private JComboBox<String> getJcomboBoxSolvenciaEconomica1(){
		if( jcomboBoxSolvenciaEconomica1 == null){
			jcomboBoxSolvenciaEconomica1 = new JComboBox<String>();
			jcomboBoxSolvenciaEconomica1.setPreferredSize(new Dimension(31, 25));
			jcomboBoxSolvenciaEconomica1.setBounds(42, 288, 457, 18);
		}
		return jcomboBoxSolvenciaEconomica1;
	}
	
	private JComboBox<String> getJcomboBoxSolvenciaEconomica2(){
		if( jcomboBoxSolvenciaEconomica2 == null){
			jcomboBoxSolvenciaEconomica2 = new JComboBox<String>();
			jcomboBoxSolvenciaEconomica2.setPreferredSize(new Dimension(31, 25));
			jcomboBoxSolvenciaEconomica2.setBounds(509, 288, 404, 18);
		}
		return jcomboBoxSolvenciaEconomica2;
	}
}
