/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.query.service;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import es.dgpe.place.client.beans.ConsultaBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.windows.WebServiceCODICEForm;

public class ConsultaDatosLicitacionForm extends ThemeJFrame{

	private static String pagina=Acciones.INIT_GET_DATA_EXP;
	
	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null;

 
	
	JFrame gestorVentanasPub[] = new JFrame[2];

	private JLabel jLabelTitulo = null;

	private JLabel jLabelNumExp = null;

	private JLabel jLabelIdBP = null;

	private JTextField jTextFieldNumExpediente = null;

	private JTextField jTextFieldIdBuyerProfile = null;
	
	private ConsultaBean datosConsulta=null;
	
	private JLabel getTitulo(){
		if (jLabelTitulo==null){
		jLabelTitulo = new JLabel();
		jLabelTitulo.setText("Consulta del Estado del Expediente");
 
		jLabelTitulo.setBounds(new Rectangle(100, 165, this.getWidth(), 50));
		jLabelTitulo.setFont(new Font("Dialog", Font.BOLD, 18));
		 
		}
		return jLabelTitulo;
	}
	
	public ConsultaBean getDatosConsulta() {
		if (datosConsulta==null){
			datosConsulta=new ConsultaBean();			
		}
		datosConsulta.setBuyerProfileId(jTextFieldIdBuyerProfile.getText());
		datosConsulta.setExpedientNumber(jTextFieldNumExpediente.getText());
		SessionDataManager.getInstance().setDatosConsulta(datosConsulta);
		return datosConsulta;
	}

	public void setDatosConsulta(ConsultaBean datosConsulta) {
		this.datosConsulta = datosConsulta;
	}

	public static String getPagina() {
		return pagina;
	}

	public static void setPagina(String pagina) {
		ConsultaDatosLicitacionForm.pagina = pagina;
	}

	
	public ConsultaDatosLicitacionForm(JFrame ventanaPadre) throws ModelException {
		super();
		initialize();
		
		gestorVentanasPub[0] = ventanaPadre;//Ventana principal
		gestorVentanasPub[1] = null;//INIT_PUB 
		 
	 
	}

	private void initialize() {
		 
		this.setContentPane(getJContentPane());
		this.setTitle("Servicio de Consulta - Estado del Expediente");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		 
		
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
	}

	private JPanel getJContentPane() {
		if (jPanelContenido == null) {
			jLabelIdBP = new JLabel();
			jLabelIdBP.setText("Identificador del O. de Contratacin:");
			jLabelIdBP.setSize(new Dimension(250, 18));
			jLabelIdBP.setLocation(new Point(162, 297));
			jLabelNumExp = new JLabel();
			jLabelNumExp.setText("Nmero expediente:");
			jLabelNumExp.setSize(new Dimension(250, 18));
			jLabelNumExp.setLocation(new Point(162, 267));
		 
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
			 
			jPanelContenido.add(getTitulo(), null);
			jPanelContenido.add(jLabelNumExp, null);
			jPanelContenido.add(jLabelIdBP, null);
			jPanelContenido.add(getJTextFieldNumExpediente(), null);
			jPanelContenido.add(getJTextFieldIdBuyerProfile(), null);
			
			String idPlataforma=SessionDataManager.getInstance().getOrganoContratacion().getIdPlataforma();
			jTextFieldIdBuyerProfile.setText(idPlataforma);
			jTextFieldIdBuyerProfile.setEditable(false);
		}
		return jPanelContenido;
	}

 
	


	/**
	 * This method initializes jTextFieldNumExpediente	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldNumExpediente() {
		if (jTextFieldNumExpediente == null) {
			jTextFieldNumExpediente = new JTextField();
			jTextFieldNumExpediente.setLocation(new Point(443, 267));
			jTextFieldNumExpediente.setSize(new Dimension(175, 18));
		}
		return jTextFieldNumExpediente;
	}

	/**
	 * This method initializes jTextFieldIdBuyerProfile	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldIdBuyerProfile() {
		if (jTextFieldIdBuyerProfile == null) {
			jTextFieldIdBuyerProfile = new JTextField();
			jTextFieldIdBuyerProfile.setSize(new Dimension(175, 18));
			jTextFieldIdBuyerProfile.setLocation(new Point(443, 297));
		}
		return jTextFieldIdBuyerProfile;
	}
	
	public void actionPerformed(ActionEvent e) {
try{
		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)){
			this.setVisible(false);
			gestorVentanasPub[0].setVisible(true);
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {
			getDatosConsulta();
			
		this.setVisible(false);
		gestorVentanasPub[1] = new WebServiceCODICEForm(this,Acciones.INIT_GET_DATA_EXP);
			
		} 
} catch (ModelException e1){
	e1.printStackTrace();
}	
	}

}
