/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
*
*Licenciado bajo la EUPL, versin 1.1 o subsiguientes versiones - que eventualmente fueran aprobadas por la Comisin Europea - de la EUPL (la "Licencia"); 
* no se podr utilizar este aplicativo si no es en cumplimiento de los trminos establecidos en la Licencia.
* se pueden obtener copias de la Licencia en:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Sin perjuicio de lo establecido porlas leyes aplicables, el software se distribuye bajo la Licencia en el ESTADO EN EL QUE SE ENCUENTRA,
* SIN GARANTAS O CONDICIONES DE CUALQUIER TIPO, ni explcitas ni implcitas
* Vase la Licencia para los detalles especficos sobre los derechos y obligaciones establecidos por la misma
**/

/** Copyright 2011 Direccin General del Patrimonio del Estado - Ministerio de Economa y Hacienda
* Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission  subsequent versions of the EUPL (the "Licence");
* you may not use this work except in compliance with the Licence.
* You may obtain a copy of the Licence at:
*
* http://www.osor.eu/eupl/european-union-public-licence-eupl-v.1.1
*
* Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" BASIS, * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the Licence for the specific language governing permissions and limitations under the Licence.
*/


package es.dgpe.place.client.windows.util.service;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import es.dgpe.place.client.beans.ConsultaBean;
import es.dgpe.place.client.beans.UtilidadesBean;
import es.dgpe.place.client.components.ThemeJFrame;
import es.dgpe.place.client.constants.Acciones;
import es.dgpe.place.client.constants.TipoDocumento;
import es.dgpe.place.client.exceptions.ClientException;
import es.dgpe.place.client.exceptions.ModelException;
import es.dgpe.place.client.utils.SessionDataManager;
import es.dgpe.place.client.utils.documentsgenerator.DocumentsGenerator;
import es.dgpe.place.client.windows.WebServiceCODICEForm;

import java.awt.Rectangle;
import java.io.File;

import javax.swing.JCheckBox;

public class UtilidadesValidacionForm extends ThemeJFrame{

	private static String pagina=Acciones.INIT_VALIDATION;
	
	private static final long serialVersionUID = 1L;

	private JPanel jPanelContenido = null; 
	
	JFrame gestorVentanasPub[] = new JFrame[2];

	private JLabel jLabelTitulo = null;

	private JLabel jLabelDoc = null;

	private JTextField jTextFieldUrlDoc = null;
	
	private UtilidadesBean datosUtilidades; 

	private JButton jButtonExaminar = null;

	private JCheckBox jCheckBoxPIN = null;
	
	private ButtonGroup selectorDoc = new ButtonGroup(); 
	
	final JFileChooser fc = new JFileChooser();
	
	private JCheckBox jCheckBoxCN = null;
	private JCheckBox jCheckBoxCFT = null;
	private JCheckBox jCheckBoxADJ = null;
	private JCheckBox jCheckBoxMODIF = null;
	
	public UtilidadesBean getDatosUtilidades() {
		if (datosUtilidades == null) {
			datosUtilidades = new UtilidadesBean();
		}

		if (jCheckBoxPIN.isSelected()) {
			datosUtilidades.setTipoDoc(TipoDocumento.PIN);
		} else if (jCheckBoxCN.isSelected()) {
			datosUtilidades.setTipoDoc(TipoDocumento.CN);
		} else if (jCheckBoxCFT.isSelected()) {
			datosUtilidades.setTipoDoc(TipoDocumento.CD);
		} else if (jCheckBoxADJ.isSelected()) {
			datosUtilidades.setTipoDoc(TipoDocumento.ADJ);
		} else if (jCheckBoxMODIF.isSelected()){
		    datosUtilidades.setTipoDoc(TipoDocumento.MODIF);
		}
		datosUtilidades.setUrlDoc(jTextFieldUrlDoc.getText());
		
		SessionDataManager.getInstance().setDatosUtilidades(datosUtilidades);
		return datosUtilidades;
	}

	public void setDatosUtilidades(UtilidadesBean datosUtilidades) {
		this.datosUtilidades = datosUtilidades;
	}
	 

	public static String getPagina() {
		return pagina;
	}

	public static void setPagina(String pagina) {
		UtilidadesValidacionForm.pagina = pagina;
	}

	
	public UtilidadesValidacionForm(JFrame ventanaPadre) throws ModelException {
		super();
		initialize();
		
		gestorVentanasPub[0] = ventanaPadre;//Ventana principal
		gestorVentanasPub[1] = null;//INIT_PUB 
 
		jButtonExaminar.addActionListener(this); 
		
		selectorDoc.add(jCheckBoxPIN);
		selectorDoc.add(jCheckBoxCN);
		selectorDoc.add(jCheckBoxCFT);
		selectorDoc.add(jCheckBoxADJ);
		selectorDoc.add(jCheckBoxMODIF);
		
		
		setHasButtonNext(true);
		setHasButtonPrev(true);
		
		
		
		
		if (isHasButtonNext()){
			jPanelContenido.add(getJButtonSiguiente(), null);
			getJButtonSiguiente().addActionListener(this);
		}
		
		if (isHasButtonPrev()){
			jPanelContenido.add(getJButtonAnterior(), null);
			getJButtonAnterior().addActionListener(this);
		}
		
	}

	
	private JLabel getTitulo(){
		if (jLabelTitulo==null){
		jLabelTitulo = new JLabel();
		jLabelTitulo.setText("Validacin de un anuncio");
		jLabelTitulo.setBounds(new Rectangle(100, 165, this.getWidth(), 50));
		jLabelTitulo.setFont(new Font("Dialog", Font.BOLD, 18));
		}
		return jLabelTitulo;
	}
	
	private void initialize() {
	 
	 getJPanelContenido();
		this.setTitle("Servicio de Utilidades - Validacin de un anuncio");
		this.setVisible(true);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	private JPanel getJPanelContenido() {
		if (jPanelContenido == null) {
			jLabelDoc = new JLabel();
			jLabelDoc.setText("Documento:");
			jLabelDoc.setSize(new Dimension(137, 18));
			jLabelDoc.setLocation(new Point(117, 445));
		 
			jPanelContenido = super.getPanel();
			jPanelContenido.setLayout(null);
			jPanelContenido.setBackground(Color.white);
 
			jPanelContenido.add(getTitulo(), null);
			jPanelContenido.add(jLabelDoc, null);
			jPanelContenido.add(getJTextFieldUrlDoc(), null);
			jPanelContenido.add(getJButtonExaminar(), null);
			jPanelContenido.add(getJCheckBoxPIN(), null);
			jPanelContenido.add(getJCheckBoxCN(), null);
			jPanelContenido.add(getJCheckBoxCFT(), null);
			jPanelContenido.add(getJCheckBoxADJ(), null);
			jPanelContenido.add(getJCheckBoxMODIF(), null);
			
		}
		return jPanelContenido;
	}

  

	/**
	 * This method initializes jTextFieldUrlDoc	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJTextFieldUrlDoc() {
		if (jTextFieldUrlDoc == null) {
			jTextFieldUrlDoc = new JTextField();
			jTextFieldUrlDoc.setSize(new Dimension(364, 18));
			jTextFieldUrlDoc.setLocation(new Point(257, 445));
		}
		return jTextFieldUrlDoc;
	}
	


	/**
	 * This method initializes jButtonExaminar	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJButtonExaminar() {
		if (jButtonExaminar == null) {
			jButtonExaminar = new JButton();
			jButtonExaminar.setText("Examinar...");
			jButtonExaminar.setActionCommand(Acciones.LOAD_FILE);
			jButtonExaminar.setSize(new Dimension(98, 18));
			jButtonExaminar.setLocation(new Point(635, 445));
		}
		return jButtonExaminar;
	}

	/**
	 * This method initializes jCheckBoxPIN	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJCheckBoxPIN() {
		if (jCheckBoxPIN == null) {
			jCheckBoxPIN = new JCheckBox();
			jCheckBoxPIN.setBackground(null);
			jCheckBoxPIN.setSize(new Dimension(134, 21));
			jCheckBoxPIN.setLocation(new Point(117, 243));
			jCheckBoxPIN.setText("Anuncio Previo");
		}
		return jCheckBoxPIN;
	}

	/**
	 * This method initializes jCheckBoxCN	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJCheckBoxCN() {
		if (jCheckBoxCN == null) {
			jCheckBoxCN = new JCheckBox();
			jCheckBoxCN.setText("Anuncio de Licitacin");
			jCheckBoxCN.setSize(new Dimension(189, 24));
			jCheckBoxCN.setLocation(new Point(117, 273));
			jCheckBoxCN.setBackground(null);
		}
		return jCheckBoxCN;
	}

	/**
	 * This method initializes jCheckBoxCFT	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJCheckBoxCFT() {
		if (jCheckBoxCFT == null) {
			jCheckBoxCFT = new JCheckBox();
			jCheckBoxCFT.setText("Pliego");
			jCheckBoxCFT.setSize(new Dimension(146, 24));
			jCheckBoxCFT.setLocation(new Point(117, 303));
			jCheckBoxCFT.setBackground(null);
		}
		return jCheckBoxCFT;
	}

	/**
	 * This method initializes jCheckBoxADJ	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */
	private JCheckBox getJCheckBoxADJ() {
		if (jCheckBoxADJ == null) {
			jCheckBoxADJ = new JCheckBox();
			jCheckBoxADJ.setText("Anuncio de Adjudicacin");
			jCheckBoxADJ.setSize(new Dimension(201, 24));
			jCheckBoxADJ.setLocation(new Point(117, 333));
			jCheckBoxADJ.setBackground(null);
		}
		return jCheckBoxADJ;
	}

	
	private JCheckBox getJCheckBoxMODIF(){
	  if (jCheckBoxMODIF == null){
	    jCheckBoxMODIF = new JCheckBox();
	    jCheckBoxMODIF.setText("Modificacin de contrato");
	    jCheckBoxMODIF.setSize(new Dimension(201, 24));
	    jCheckBoxMODIF.setLocation(new Point(117, 363));
	    jCheckBoxMODIF.setBackground((Color) null);
	  }
	  return jCheckBoxMODIF;
	}
	

	public void actionPerformed(ActionEvent e) {
try{
		if (e.getActionCommand().equalsIgnoreCase(Acciones.PREV)){
			this.setVisible(false);
			gestorVentanasPub[0].setVisible(true);
		}else if (e.getActionCommand().equalsIgnoreCase(Acciones.NEXT)) {
			getDatosUtilidades();			
			if (datosUtilidades.getTipoDoc().equalsIgnoreCase(TipoDocumento.PIN)){
				String documentoGenerado=DocumentsGenerator.generarCODICE(TipoDocumento.PIN);  
			}else if (datosUtilidades.getTipoDoc().equalsIgnoreCase(TipoDocumento.CN)){
				String documentoGenerado=DocumentsGenerator.generarCODICE(TipoDocumento.CN);  
			}else if (datosUtilidades.getTipoDoc().equalsIgnoreCase(TipoDocumento.CD)){
				String documentoGenerado=DocumentsGenerator.generarCODICE(TipoDocumento.CD);  
			}else if (datosUtilidades.getTipoDoc().equalsIgnoreCase(TipoDocumento.ADJ)){
					String documentoGenerado=DocumentsGenerator.generarCODICE(TipoDocumento.ADJ);  
			}else if (datosUtilidades.getTipoDoc().equalsIgnoreCase(TipoDocumento.DOC_GEN)){
				String documentoGenerado=DocumentsGenerator.generarCODICE(TipoDocumento.DOC_GEN); 
			}else if (datosUtilidades.getTipoDoc().equalsIgnoreCase(TipoDocumento.MODIF)){
              String documentoGenerado=DocumentsGenerator.generarCODICE(TipoDocumento.MODIF); 
			}
			this.setVisible(false);
			gestorVentanasPub[1] = new WebServiceCODICEForm(this,Acciones.INIT_VALIDATION);
			
		} else if (e.getActionCommand().equalsIgnoreCase(Acciones.LOAD_FILE)) {
			int returnVal = fc.showOpenDialog(jButtonExaminar);
			 if (returnVal == JFileChooser.APPROVE_OPTION) {
				 File file = fc.getSelectedFile();
              jTextFieldUrlDoc.setText(file.getAbsolutePath());
			 } 
		}
} catch (ClientException ex)
{
	try {
	this.setVisible(false);
	gestorVentanasPub[1] = new WebServiceCODICEForm(this,Acciones.INIT_PREVIEW, ex);
	} catch (ModelException e1){
	e1.printStackTrace();
	} 
} catch (ModelException e1){
	e1.printStackTrace();
	}
}
	}

