
package ext.place.codice.common.caclib;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ext.place.codice.common.cbclib.CancelledIndicatorType;
import ext.place.codice.common.cbclib.NoticeStatusCodeType;
import ext.place.codice.common.cbclib.NoticeTimestampBinaryObjectType;
import ext.place.codice.common.cbclib.NoticeTypeCodeType;
import org.dgpe.codice.common.caclib.DocumentReferenceType;
import org.dgpe.codice.common.caclib.ExternalReferenceType;
import org.dgpe.codice.common.caclib.PeriodType;
import org.dgpe.codice.common.cbclib.ContractIDType;
import org.dgpe.codice.common.cbclib.IDType;
import org.dgpe.codice.common.cbclib.IssueDateType;
import org.dgpe.codice.common.cbclib.IssueTimeType;
import org.dgpe.codice.common.cbclib.NoteType;
import org.dgpe.codice.common.cbclib.ProcurementProjectLotIDType;
import org.dgpe.codice.common.cbclib.UUIDType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Informacin sobre un anuncio publicado&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:AlternativeBusinessTerms&gt;Informacin del anuncio&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * 
 * <p>Clase Java para NoticeInfoType complex type.
 * 
 * <p>El siguiente fragmento de esquema especifica el contenido que se espera que haya en esta clase.
 * 
 * <pre>
 * &lt;complexType name="NoticeInfoType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2}NoticeID" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2}NoticeUUID" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2}NoticeIssueDate" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2}NoticeIssueTime" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2}NoticeTypeCode"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2}NoticeStatusCode" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2}CancelledIndicator" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2}NoticeTimestampBinaryObject" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2}PreviousNoticeID" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2}PreviousNoticeUUID" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2}NextNoticeID" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2}NextNoticeUUID" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2}Note" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2}ProcurementProjectLotID" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2}ContractID" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2}ContractModificationID" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2}NoticeExternalReference" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2}ValidityPeriod" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2}AdditionalPublicationStatus" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2}NoticeAttachmentDocumentReference" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "NoticeInfoType", propOrder = {
    "noticeID",
    "noticeUUID",
    "noticeIssueDate",
    "noticeIssueTime",
    "noticeTypeCode",
    "noticeStatusCode",
    "cancelledIndicator",
    "noticeTimestampBinaryObject",
    "previousNoticeID",
    "previousNoticeUUID",
    "nextNoticeID",
    "nextNoticeUUID",
    "note",
    "procurementProjectLotID",
    "contractID",
    "contractModificationID",
    "noticeExternalReference",
    "validityPeriod",
    "additionalPublicationStatus",
    "noticeAttachmentDocumentReference"
})
public class NoticeInfoType {

    @XmlElement(name = "NoticeID", namespace = "urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2")
    protected IDType noticeID;
    @XmlElement(name = "NoticeUUID", namespace = "urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2")
    protected UUIDType noticeUUID;
    @XmlElement(name = "NoticeIssueDate", namespace = "urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2")
    protected IssueDateType noticeIssueDate;
    @XmlElement(name = "NoticeIssueTime", namespace = "urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2")
    protected IssueTimeType noticeIssueTime;
    @XmlElement(name = "NoticeTypeCode", namespace = "urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2", required = true)
    protected NoticeTypeCodeType noticeTypeCode;
    @XmlElement(name = "NoticeStatusCode", namespace = "urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2")
    protected NoticeStatusCodeType noticeStatusCode;
    @XmlElement(name = "CancelledIndicator", namespace = "urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2")
    protected CancelledIndicatorType cancelledIndicator;
    @XmlElement(name = "NoticeTimestampBinaryObject", namespace = "urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2")
    protected NoticeTimestampBinaryObjectType noticeTimestampBinaryObject;
    @XmlElement(name = "PreviousNoticeID", namespace = "urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2")
    protected IDType previousNoticeID;
    @XmlElement(name = "PreviousNoticeUUID", namespace = "urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2")
    protected UUIDType previousNoticeUUID;
    @XmlElement(name = "NextNoticeID", namespace = "urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2")
    protected IDType nextNoticeID;
    @XmlElement(name = "NextNoticeUUID", namespace = "urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2")
    protected UUIDType nextNoticeUUID;
    @XmlElement(name = "Note", namespace = "urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2")
    protected NoteType note;
    @XmlElement(name = "ProcurementProjectLotID", namespace = "urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2")
    protected List<ProcurementProjectLotIDType> procurementProjectLotID;
    @XmlElement(name = "ContractID", namespace = "urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2")
    protected List<ContractIDType> contractID;
    @XmlElement(name = "ContractModificationID", namespace = "urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2")
    protected IDType contractModificationID;
    @XmlElement(name = "NoticeExternalReference")
    protected List<ExternalReferenceType> noticeExternalReference;
    @XmlElement(name = "ValidityPeriod", namespace = "urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2")
    protected PeriodType validityPeriod;
    @XmlElement(name = "AdditionalPublicationStatus")
    protected List<AdditionalPublicationStatusType> additionalPublicationStatus;
    @XmlElement(name = "NoticeAttachmentDocumentReference")
    protected List<DocumentReferenceType> noticeAttachmentDocumentReference;

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Notice ID. ID&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;ID del anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Notice ID&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;ID&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;ID. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;ID del anuncio&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    public IDType getNoticeID() {
        return noticeID;
    }

    /**
     * Define el valor de la propiedad noticeID.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setNoticeID(IDType value) {
        this.noticeID = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Notice UUID. ID&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;UUID del anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Notice UUID&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;UUID&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;UUID. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;UUID del anuncio&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link UUIDType }
     *     
     */
    public UUIDType getNoticeUUID() {
        return noticeUUID;
    }

    /**
     * Define el valor de la propiedad noticeUUID.
     * 
     * @param value
     *     allowed object is
     *     {@link UUIDType }
     *     
     */
    public void setNoticeUUID(UUIDType value) {
        this.noticeUUID = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Issue Date. Date&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Fecha de creacin del anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Notice IssueDate&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;IssueDate&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;IssueDate. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;Fecha de creacin&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link IssueDateType }
     *     
     */
    public IssueDateType getNoticeIssueDate() {
        return noticeIssueDate;
    }

    /**
     * Define el valor de la propiedad noticeIssueDate.
     * 
     * @param value
     *     allowed object is
     *     {@link IssueDateType }
     *     
     */
    public void setNoticeIssueDate(IssueDateType value) {
        this.noticeIssueDate = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Issue Time. Time&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Hora de creacin del anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Notice IssueTime&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;IssueTime&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;IssueTime. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;Hora de creacin&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link IssueTimeType }
     *     
     */
    public IssueTimeType getNoticeIssueTime() {
        return noticeIssueTime;
    }

    /**
     * Define el valor de la propiedad noticeIssueTime.
     * 
     * @param value
     *     allowed object is
     *     {@link IssueTimeType }
     *     
     */
    public void setNoticeIssueTime(IssueTimeType value) {
        this.noticeIssueTime = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Notice Type Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Cdigo que indica el tipo de anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Notice&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Type Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;Tipo de anuncio&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link NoticeTypeCodeType }
     *     
     */
    public NoticeTypeCodeType getNoticeTypeCode() {
        return noticeTypeCode;
    }

    /**
     * Define el valor de la propiedad noticeTypeCode.
     * 
     * @param value
     *     allowed object is
     *     {@link NoticeTypeCodeType }
     *     
     */
    public void setNoticeTypeCode(NoticeTypeCodeType value) {
        this.noticeTypeCode = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Notice Status Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Estado del anuncio (publicado, anulado, rectificado,etc.)&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Notice&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Status Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;Estado del anuncio&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link NoticeStatusCodeType }
     *     
     */
    public NoticeStatusCodeType getNoticeStatusCode() {
        return noticeStatusCode;
    }

    /**
     * Define el valor de la propiedad noticeStatusCode.
     * 
     * @param value
     *     allowed object is
     *     {@link NoticeStatusCodeType }
     *     
     */
    public void setNoticeStatusCode(NoticeStatusCodeType value) {
        this.noticeStatusCode = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Cancelled Indicator. Indicator&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Indicador sobre la anulacin del anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Cancelled Indicator&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Indicator&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Indicator. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;Indicador de anulacin&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link CancelledIndicatorType }
     *     
     */
    public CancelledIndicatorType getCancelledIndicator() {
        return cancelledIndicator;
    }

    /**
     * Define el valor de la propiedad cancelledIndicator.
     * 
     * @param value
     *     allowed object is
     *     {@link CancelledIndicatorType }
     *     
     */
    public void setCancelledIndicator(CancelledIndicatorType value) {
        this.cancelledIndicator = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Notice Timestamp Binary Object. Binary Object&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Sellado de tiempo asociado a la publicacin del documento&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Notice Timestamp&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;BinaryObject&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;BinaryObject. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;Sellado de tiempo&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link NoticeTimestampBinaryObjectType }
     *     
     */
    public NoticeTimestampBinaryObjectType getNoticeTimestampBinaryObject() {
        return noticeTimestampBinaryObject;
    }

    /**
     * Define el valor de la propiedad noticeTimestampBinaryObject.
     * 
     * @param value
     *     allowed object is
     *     {@link NoticeTimestampBinaryObjectType }
     *     
     */
    public void setNoticeTimestampBinaryObject(NoticeTimestampBinaryObjectType value) {
        this.noticeTimestampBinaryObject = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Previous Notice ID. ID&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;ID del anuncio anterior al que rectifica o anula el presente anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Previous&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Notice ID&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;ID&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;ID. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;ID del anuncio anterior&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    public IDType getPreviousNoticeID() {
        return previousNoticeID;
    }

    /**
     * Define el valor de la propiedad previousNoticeID.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setPreviousNoticeID(IDType value) {
        this.previousNoticeID = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Previous Notice UUID. ID&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;UUID del anuncio anterior al que rectifica o anula el presente anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Previous&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Notice UUID&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;UUID&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;UUID. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;UUID del anuncio anterior&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link UUIDType }
     *     
     */
    public UUIDType getPreviousNoticeUUID() {
        return previousNoticeUUID;
    }

    /**
     * Define el valor de la propiedad previousNoticeUUID.
     * 
     * @param value
     *     allowed object is
     *     {@link UUIDType }
     *     
     */
    public void setPreviousNoticeUUID(UUIDType value) {
        this.previousNoticeUUID = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Next Notice ID. ID&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;ID del anuncio siguiente al que rectifica o anula el presente anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Next&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Notice ID&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;ID&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;ID. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;ID del anuncio siguiente&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    public IDType getNextNoticeID() {
        return nextNoticeID;
    }

    /**
     * Define el valor de la propiedad nextNoticeID.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setNextNoticeID(IDType value) {
        this.nextNoticeID = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Next Notice UUID. ID&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;UUID del anuncio siguiente al que rectifica o anula el presente anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Next&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Notice UUID&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;UUID&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;UUID. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;UUID del anuncio siguiente&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link UUIDType }
     *     
     */
    public UUIDType getNextNoticeUUID() {
        return nextNoticeUUID;
    }

    /**
     * Define el valor de la propiedad nextNoticeUUID.
     * 
     * @param value
     *     allowed object is
     *     {@link UUIDType }
     *     
     */
    public void setNextNoticeUUID(UUIDType value) {
        this.nextNoticeUUID = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Note. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Texto incluido en el anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Note&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;Texto del anuncio&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link NoteType }
     *     
     */
    public NoteType getNote() {
        return note;
    }

    /**
     * Define el valor de la propiedad note.
     * 
     * @param value
     *     allowed object is
     *     {@link NoteType }
     *     
     */
    public void setNote(NoteType value) {
        this.note = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Procurement Project Lot ID. ID&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Indentificador de lote cuya informacin se incluye en el anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Procurement Project&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Lot ID&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;ID&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;ID. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;Identificador de lote&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the procurementProjectLotID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the procurementProjectLotID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getProcurementProjectLotID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ProcurementProjectLotIDType }
     * 
     * 
     */
    public List<ProcurementProjectLotIDType> getProcurementProjectLotID() {
        if (procurementProjectLotID == null) {
            procurementProjectLotID = new ArrayList<ProcurementProjectLotIDType>();
        }
        return this.procurementProjectLotID;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Contract ID. ID&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Indentificador de contrato cuya informacin se incluye en el anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Contract&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;ID&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;ID&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;ID. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;Identificador de contrato&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the contractID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the contractID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getContractID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ContractIDType }
     * 
     * 
     */
    public List<ContractIDType> getContractID() {
        if (contractID == null) {
            contractID = new ArrayList<ContractIDType>();
        }
        return this.contractID;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Contract Modiciation ID. ID&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Nmero de modificacin de contrato cuya informacin se incluye en el anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Contract&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Modification ID&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;ID&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;ID. Type&lt;/ccts:DataType&gt;&lt;ccts:AlternativeBusinessTerms&gt;Nmero de modificacin de contrato&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    public IDType getContractModificationID() {
        return contractModificationID;
    }

    /**
     * Define el valor de la propiedad contractModificationID.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setContractModificationID(IDType value) {
        this.contractModificationID = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Notice External Reference. External Reference&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Referencia al anuncio, conteniendo informacin como su URL, formato, etc.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:AssociatedObjectClass&gt;External Reference&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:AlternativeBusinessTerms&gt;Referencia al anuncio&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the noticeExternalReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the noticeExternalReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNoticeExternalReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ExternalReferenceType }
     * 
     * 
     */
    public List<ExternalReferenceType> getNoticeExternalReference() {
        if (noticeExternalReference == null) {
            noticeExternalReference = new ArrayList<ExternalReferenceType>();
        }
        return this.noticeExternalReference;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Validity Period. Period&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Periodo durante el cual el anuncio ha sido vlido&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Validity Period&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Validity Period&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:AlternativeBusinessTerms&gt;Periodo de validez&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    public PeriodType getValidityPeriod() {
        return validityPeriod;
    }

    /**
     * Define el valor de la propiedad validityPeriod.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setValidityPeriod(PeriodType value) {
        this.validityPeriod = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Additional Publication Status. Additional Publication Status&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Estado de las publicaciones del mismo anuncio en otros medios de publicacin&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Additional Publication Status&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Additional Publication Status&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:AlternativeBusinessTerms&gt;Estado de publicaciones en otros medios&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the additionalPublicationStatus property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalPublicationStatus property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAdditionalPublicationStatus().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AdditionalPublicationStatusType }
     * 
     * 
     */
    public List<AdditionalPublicationStatusType> getAdditionalPublicationStatus() {
        if (additionalPublicationStatus == null) {
            additionalPublicationStatus = new ArrayList<AdditionalPublicationStatusType>();
        }
        return this.additionalPublicationStatus;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:dgpe:names:draft:codice:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:dgpe:names:draft:codice:schema:xsd:CommonBasicComponents-2" xmlns:cbc-place-ext="urn:dgpe:names:draft:codice-place-ext:schema:xsd:CommonBasicComponents-2" xmlns:p509195_="http://java.sun.com/xml/ns/jaxb" xmlns:p608956_="http://jaxb2-commons.dev.java.net/namespace-prefix" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Notice Info. Notice Attachment Document Reference. Document Reference&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Referencia a documento anexo al anuncio&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Notice Info&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Notice&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Document Reference&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Document Reference&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:AlternativeBusinessTerms&gt;Anexo al anuncio&lt;/ccts:AlternativeBusinessTerms&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the noticeAttachmentDocumentReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the noticeAttachmentDocumentReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNoticeAttachmentDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * 
     * 
     */
    public List<DocumentReferenceType> getNoticeAttachmentDocumentReference() {
        if (noticeAttachmentDocumentReference == null) {
            noticeAttachmentDocumentReference = new ArrayList<DocumentReferenceType>();
        }
        return this.noticeAttachmentDocumentReference;
    }

}
